"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EnumsV2 = void 0;
var EnumsV2;
(function (EnumsV2) {
    let CameraActionType;
    (function (CameraActionType) {
        CameraActionType[CameraActionType["Auth"] = 1] = "Auth";
        CameraActionType[CameraActionType["Sensor"] = 2] = "Sensor";
        CameraActionType[CameraActionType["RemoteAccess"] = 3] = "RemoteAccess";
        CameraActionType[CameraActionType["View"] = 4] = "View";
    })(CameraActionType = EnumsV2.CameraActionType || (EnumsV2.CameraActionType = {}));
    let ResultStatus;
    (function (ResultStatus) {
        ResultStatus[ResultStatus["All"] = 1] = "All";
        ResultStatus[ResultStatus["Success"] = 2] = "Success";
        ResultStatus[ResultStatus["Fail"] = 3] = "Fail";
    })(ResultStatus = EnumsV2.ResultStatus || (EnumsV2.ResultStatus = {}));
    let ReaderOutputType;
    (function (ReaderOutputType) {
        ReaderOutputType[ReaderOutputType["OnBoard"] = 1] = "OnBoard";
        ReaderOutputType[ReaderOutputType["Wiegand"] = 2] = "Wiegand";
        ReaderOutputType[ReaderOutputType["RS485"] = 3] = "RS485";
        ReaderOutputType[ReaderOutputType["TCPIP"] = 4] = "TCPIP";
        ReaderOutputType[ReaderOutputType["Mobile"] = 5] = "Mobile";
    })(ReaderOutputType = EnumsV2.ReaderOutputType || (EnumsV2.ReaderOutputType = {}));
    let AuthenticationFactor;
    (function (AuthenticationFactor) {
        AuthenticationFactor[AuthenticationFactor["ProximityCard"] = 0] = "ProximityCard";
        AuthenticationFactor[AuthenticationFactor["Bluetooth"] = 2] = "Bluetooth";
        AuthenticationFactor[AuthenticationFactor["MiFare"] = 3] = "MiFare";
        AuthenticationFactor[AuthenticationFactor["AccessToken"] = 4] = "AccessToken";
        AuthenticationFactor[AuthenticationFactor["UHFRfid"] = 5] = "UHFRfid";
        AuthenticationFactor[AuthenticationFactor["VehiclePlate"] = 6] = "VehiclePlate";
        AuthenticationFactor[AuthenticationFactor["NFC"] = 8] = "NFC";
        AuthenticationFactor[AuthenticationFactor["FingerPrint"] = 9] = "FingerPrint";
        AuthenticationFactor[AuthenticationFactor["QR_BarCode"] = 14] = "QR_BarCode";
        AuthenticationFactor[AuthenticationFactor["MRZ"] = 16] = "MRZ";
    })(AuthenticationFactor = EnumsV2.AuthenticationFactor || (EnumsV2.AuthenticationFactor = {}));
    let AccessDirection;
    (function (AccessDirection) {
        AccessDirection[AccessDirection["All"] = 0] = "All";
        AccessDirection[AccessDirection["Entrance"] = 1] = "Entrance";
        AccessDirection[AccessDirection["Exit"] = 2] = "Exit";
    })(AccessDirection = EnumsV2.AccessDirection || (EnumsV2.AccessDirection = {}));
    let AntiPassbackState;
    (function (AntiPassbackState) {
        AntiPassbackState[AntiPassbackState["Unknown"] = 0] = "Unknown";
        AntiPassbackState[AntiPassbackState["In"] = 1] = "In";
        AntiPassbackState[AntiPassbackState["Out"] = 2] = "Out";
    })(AntiPassbackState = EnumsV2.AntiPassbackState || (EnumsV2.AntiPassbackState = {}));
    let OfflineLogType;
    (function (OfflineLogType) {
        OfflineLogType[OfflineLogType["AccessLog"] = 1] = "AccessLog";
        OfflineLogType[OfflineLogType["StatusSensorLog"] = 2] = "StatusSensorLog";
        OfflineLogType[OfflineLogType["TamperSwitchLog"] = 3] = "TamperSwitchLog";
        OfflineLogType[OfflineLogType["EmergencyLog"] = 4] = "EmergencyLog";
        OfflineLogType[OfflineLogType["SystemStatusLog"] = 5] = "SystemStatusLog";
        OfflineLogType[OfflineLogType["CounterLog"] = 6] = "CounterLog";
        OfflineLogType[OfflineLogType["SystemHealthLog"] = 7] = "SystemHealthLog";
        OfflineLogType[OfflineLogType["FingerPrintAddLog"] = 8] = "FingerPrintAddLog";
        OfflineLogType[OfflineLogType["FingerprintRemoveLog"] = 9] = "FingerprintRemoveLog";
        OfflineLogType[OfflineLogType["FaceRecogniseAddLog"] = 10] = "FaceRecogniseAddLog";
        OfflineLogType[OfflineLogType["FaceRecogniseRemoveLog"] = 11] = "FaceRecogniseRemoveLog";
        OfflineLogType[OfflineLogType["InsertNewCredentialLog"] = 12] = "InsertNewCredentialLog";
    })(OfflineLogType = EnumsV2.OfflineLogType || (EnumsV2.OfflineLogType = {}));
    let DeviceToServerMessageTypes;
    (function (DeviceToServerMessageTypes) {
        DeviceToServerMessageTypes[DeviceToServerMessageTypes["AccessLog"] = 1] = "AccessLog";
        DeviceToServerMessageTypes[DeviceToServerMessageTypes["SystemStatus"] = 2] = "SystemStatus";
        DeviceToServerMessageTypes[DeviceToServerMessageTypes["EmergencyStateChanged"] = 3] = "EmergencyStateChanged";
        DeviceToServerMessageTypes[DeviceToServerMessageTypes["StatusSensorStateChanged"] = 4] = "StatusSensorStateChanged";
        DeviceToServerMessageTypes[DeviceToServerMessageTypes["CounterSensorEvent"] = 5] = "CounterSensorEvent";
        DeviceToServerMessageTypes[DeviceToServerMessageTypes["TamperEvent"] = 6] = "TamperEvent";
        DeviceToServerMessageTypes[DeviceToServerMessageTypes["AccessLogControlPanel"] = 7] = "AccessLogControlPanel";
        DeviceToServerMessageTypes[DeviceToServerMessageTypes["SystemHealth"] = 8] = "SystemHealth";
        DeviceToServerMessageTypes[DeviceToServerMessageTypes["DeviceOfAdapterConnectionState"] = 9] = "DeviceOfAdapterConnectionState";
        DeviceToServerMessageTypes[DeviceToServerMessageTypes["WebRTC"] = 10] = "WebRTC";
    })(DeviceToServerMessageTypes = EnumsV2.DeviceToServerMessageTypes || (EnumsV2.DeviceToServerMessageTypes = {}));
    let ServerToDeviceMessageType;
    (function (ServerToDeviceMessageType) {
        ServerToDeviceMessageType[ServerToDeviceMessageType["GetChangesRequired"] = 1] = "GetChangesRequired";
        ServerToDeviceMessageType[ServerToDeviceMessageType["ConfigOrSettingsChanged"] = 2] = "ConfigOrSettingsChanged";
        ServerToDeviceMessageType[ServerToDeviceMessageType["WebRTC"] = 3] = "WebRTC";
    })(ServerToDeviceMessageType = EnumsV2.ServerToDeviceMessageType || (EnumsV2.ServerToDeviceMessageType = {}));
    let EmergencyState;
    (function (EmergencyState) {
        EmergencyState[EmergencyState["Normal"] = 0] = "Normal";
        EmergencyState[EmergencyState["Emergency"] = 1] = "Emergency";
    })(EmergencyState = EnumsV2.EmergencyState || (EnumsV2.EmergencyState = {}));
    let AccessLogReason;
    (function (AccessLogReason) {
        AccessLogReason[AccessLogReason["Success"] = 0] = "Success";
        AccessLogReason[AccessLogReason["HasNotRight"] = 1] = "HasNotRight";
        AccessLogReason[AccessLogReason["UnknownCredentialOwner"] = 2] = "UnknownCredentialOwner";
        AccessLogReason[AccessLogReason["UnknownAccessPoint"] = 3] = "UnknownAccessPoint";
        AccessLogReason[AccessLogReason["UnhandledFailure"] = 4] = "UnhandledFailure";
        AccessLogReason[AccessLogReason["AntiPassbackReject"] = 5] = "AntiPassbackReject";
        AccessLogReason[AccessLogReason["AntiPassbackTimeOutReject"] = 6] = "AntiPassbackTimeOutReject";
        AccessLogReason[AccessLogReason["CredentialExpired"] = 8] = "CredentialExpired";
        AccessLogReason[AccessLogReason["InsufficientFund"] = 9] = "InsufficientFund";
        AccessLogReason[AccessLogReason["RuleReject"] = 10] = "RuleReject";
        AccessLogReason[AccessLogReason["Manual"] = 11] = "Manual";
        AccessLogReason[AccessLogReason["StateOpened"] = 12] = "StateOpened";
        AccessLogReason[AccessLogReason["StateDisabled"] = 13] = "StateDisabled";
        AccessLogReason[AccessLogReason["IncompleteMultiFactor"] = 14] = "IncompleteMultiFactor";
        AccessLogReason[AccessLogReason["Forbidden"] = 15] = "Forbidden";
        AccessLogReason[AccessLogReason["UserDisabled"] = 16] = "UserDisabled";
        AccessLogReason[AccessLogReason["RelayNotAvailable"] = 17] = "RelayNotAvailable";
        AccessLogReason[AccessLogReason["ChallengeFail"] = 18] = "ChallengeFail";
        AccessLogReason[AccessLogReason["InvalidChallenge"] = 19] = "InvalidChallenge";
        AccessLogReason[AccessLogReason["MifareFingerPrintNotMatch"] = 20] = "MifareFingerPrintNotMatch";
        AccessLogReason[AccessLogReason["MifareFingerPrintTimeout"] = 21] = "MifareFingerPrintTimeout";
        AccessLogReason[AccessLogReason["RegionCapacityFull"] = 22] = "RegionCapacityFull";
        AccessLogReason[AccessLogReason["CapacityBasedRuleReject"] = 23] = "CapacityBasedRuleReject";
        AccessLogReason[AccessLogReason["HesCodeNoRecord"] = 24] = "HesCodeNoRecord";
        AccessLogReason[AccessLogReason["HesCodeRiskly"] = 25] = "HesCodeRiskly";
        AccessLogReason[AccessLogReason["HesCodeError"] = 26] = "HesCodeError";
        AccessLogReason[AccessLogReason["Reserved"] = 99] = "Reserved";
    })(AccessLogReason = EnumsV2.AccessLogReason || (EnumsV2.AccessLogReason = {}));
    let StatusSensorState;
    (function (StatusSensorState) {
        StatusSensorState[StatusSensorState["Closed"] = 0] = "Closed";
        StatusSensorState[StatusSensorState["Open"] = 1] = "Open";
        StatusSensorState[StatusSensorState["TimeOut"] = 2] = "TimeOut";
    })(StatusSensorState = EnumsV2.StatusSensorState || (EnumsV2.StatusSensorState = {}));
    let RemoteRelayStatus;
    (function (RemoteRelayStatus) {
        RemoteRelayStatus[RemoteRelayStatus["Success"] = 1] = "Success";
        RemoteRelayStatus[RemoteRelayStatus["Timeout"] = 2] = "Timeout";
        RemoteRelayStatus[RemoteRelayStatus["Fail"] = 3] = "Fail";
        RemoteRelayStatus[RemoteRelayStatus["OnProgress"] = 4] = "OnProgress";
    })(RemoteRelayStatus = EnumsV2.RemoteRelayStatus || (EnumsV2.RemoteRelayStatus = {}));
    let ServerToDeviceRPCMessageType;
    (function (ServerToDeviceRPCMessageType) {
        ServerToDeviceRPCMessageType[ServerToDeviceRPCMessageType["RemoteAccess"] = 1] = "RemoteAccess";
        ServerToDeviceRPCMessageType[ServerToDeviceRPCMessageType["ChangeAccessControlPointState"] = 2] = "ChangeAccessControlPointState";
        ServerToDeviceRPCMessageType[ServerToDeviceRPCMessageType["EmergencyStart"] = 3] = "EmergencyStart";
        ServerToDeviceRPCMessageType[ServerToDeviceRPCMessageType["EmergencyEnd"] = 4] = "EmergencyEnd";
        ServerToDeviceRPCMessageType[ServerToDeviceRPCMessageType["RegionStateChanged"] = 5] = "RegionStateChanged";
        ServerToDeviceRPCMessageType[ServerToDeviceRPCMessageType["DateTimeChanged"] = 6] = "DateTimeChanged";
        ServerToDeviceRPCMessageType[ServerToDeviceRPCMessageType["CoinBalanceChanged"] = 7] = "CoinBalanceChanged";
        ServerToDeviceRPCMessageType[ServerToDeviceRPCMessageType["AccessRuleApplied"] = 8] = "AccessRuleApplied";
        ServerToDeviceRPCMessageType[ServerToDeviceRPCMessageType["AskSystemStatus"] = 9] = "AskSystemStatus";
        ServerToDeviceRPCMessageType[ServerToDeviceRPCMessageType["Reboot"] = 10] = "Reboot";
        ServerToDeviceRPCMessageType[ServerToDeviceRPCMessageType["SyncError"] = 11] = "SyncError";
        ServerToDeviceRPCMessageType[ServerToDeviceRPCMessageType["NotificationPattern"] = 12] = "NotificationPattern";
        ServerToDeviceRPCMessageType[ServerToDeviceRPCMessageType["CredentialRegisterMode"] = 13] = "CredentialRegisterMode";
        ServerToDeviceRPCMessageType[ServerToDeviceRPCMessageType["TakeSnapshot"] = 14] = "TakeSnapshot";
        ServerToDeviceRPCMessageType[ServerToDeviceRPCMessageType["AskCertificate"] = 15] = "AskCertificate";
        ServerToDeviceRPCMessageType[ServerToDeviceRPCMessageType["RemoteRelay"] = 16] = "RemoteRelay";
        ServerToDeviceRPCMessageType[ServerToDeviceRPCMessageType["AccessCapacityBasedRuleApplied"] = 17] = "AccessCapacityBasedRuleApplied";
        ServerToDeviceRPCMessageType[ServerToDeviceRPCMessageType["SoftwareUpdateInterfaceCommand"] = 18] = "SoftwareUpdateInterfaceCommand";
        ServerToDeviceRPCMessageType[ServerToDeviceRPCMessageType["OpenVPNConnectCommand"] = 19] = "OpenVPNConnectCommand";
    })(ServerToDeviceRPCMessageType = EnumsV2.ServerToDeviceRPCMessageType || (EnumsV2.ServerToDeviceRPCMessageType = {}));
    let AccessControlPointState;
    (function (AccessControlPointState) {
        AccessControlPointState[AccessControlPointState["Normal"] = 1] = "Normal";
        AccessControlPointState[AccessControlPointState["StayOpened"] = 2] = "StayOpened";
        AccessControlPointState[AccessControlPointState["Disabled"] = 3] = "Disabled";
    })(AccessControlPointState = EnumsV2.AccessControlPointState || (EnumsV2.AccessControlPointState = {}));
    let NotificationPatternActionType;
    (function (NotificationPatternActionType) {
        NotificationPatternActionType[NotificationPatternActionType["Add"] = 1] = "Add";
        NotificationPatternActionType[NotificationPatternActionType["Update"] = 2] = "Update";
        NotificationPatternActionType[NotificationPatternActionType["Remove"] = 3] = "Remove";
    })(NotificationPatternActionType = EnumsV2.NotificationPatternActionType || (EnumsV2.NotificationPatternActionType = {}));
    let NotificationPatternType;
    (function (NotificationPatternType) {
        NotificationPatternType[NotificationPatternType["Identity"] = 1] = "Identity";
        NotificationPatternType[NotificationPatternType["StatusSensor"] = 2] = "StatusSensor";
        NotificationPatternType[NotificationPatternType["CounterSensor"] = 3] = "CounterSensor";
    })(NotificationPatternType = EnumsV2.NotificationPatternType || (EnumsV2.NotificationPatternType = {}));
    let CounterSensorEventReason;
    (function (CounterSensorEventReason) {
        CounterSensorEventReason[CounterSensorEventReason["WiegandReaderTriggeredRelayDrive"] = 1] = "WiegandReaderTriggeredRelayDrive";
        CounterSensorEventReason[CounterSensorEventReason["ExitButtonTriggeredRelayDrive"] = 2] = "ExitButtonTriggeredRelayDrive";
        CounterSensorEventReason[CounterSensorEventReason["RemoteAccessTriggeredRelayDrive"] = 3] = "RemoteAccessTriggeredRelayDrive";
        CounterSensorEventReason[CounterSensorEventReason["UnknownReasonCounterAlthoughRelayIsMapped"] = 4] = "UnknownReasonCounterAlthoughRelayIsMapped";
        CounterSensorEventReason[CounterSensorEventReason["UnknownReasonCounterRelayIsNotMapped"] = 5] = "UnknownReasonCounterRelayIsNotMapped";
        CounterSensorEventReason[CounterSensorEventReason["MoreAccessThanGranted"] = 6] = "MoreAccessThanGranted";
        CounterSensorEventReason[CounterSensorEventReason["LessAccessThanGranted"] = 7] = "LessAccessThanGranted";
    })(CounterSensorEventReason = EnumsV2.CounterSensorEventReason || (EnumsV2.CounterSensorEventReason = {}));
    let TamperSwitchState;
    (function (TamperSwitchState) {
        TamperSwitchState[TamperSwitchState["Secure"] = 0] = "Secure";
        TamperSwitchState[TamperSwitchState["Tampered"] = 1] = "Tampered";
    })(TamperSwitchState = EnumsV2.TamperSwitchState || (EnumsV2.TamperSwitchState = {}));
    let SystemStatusNotificationReason;
    (function (SystemStatusNotificationReason) {
        SystemStatusNotificationReason[SystemStatusNotificationReason["TimerInterval"] = 0] = "TimerInterval";
        SystemStatusNotificationReason[SystemStatusNotificationReason["AcOk"] = 1] = "AcOk";
        SystemStatusNotificationReason[SystemStatusNotificationReason["RtcOk"] = 2] = "RtcOk";
        SystemStatusNotificationReason[SystemStatusNotificationReason["TemperatureLevel"] = 3] = "TemperatureLevel";
        SystemStatusNotificationReason[SystemStatusNotificationReason["TemperatureInCelsius"] = 4] = "TemperatureInCelsius";
        SystemStatusNotificationReason[SystemStatusNotificationReason["BatteryValue"] = 5] = "BatteryValue";
        SystemStatusNotificationReason[SystemStatusNotificationReason["EmergencyState"] = 6] = "EmergencyState";
    })(SystemStatusNotificationReason = EnumsV2.SystemStatusNotificationReason || (EnumsV2.SystemStatusNotificationReason = {}));
    let DeviceChangeItemType;
    (function (DeviceChangeItemType) {
        DeviceChangeItemType[DeviceChangeItemType["AddCredential"] = 1] = "AddCredential";
        DeviceChangeItemType[DeviceChangeItemType["RemoveCredential"] = 2] = "RemoveCredential";
        DeviceChangeItemType[DeviceChangeItemType["ConfigChanged"] = 3] = "ConfigChanged";
        DeviceChangeItemType[DeviceChangeItemType["SettingChanged"] = 4] = "SettingChanged";
        DeviceChangeItemType[DeviceChangeItemType["AddUser"] = 5] = "AddUser";
        DeviceChangeItemType[DeviceChangeItemType["RemoveUser"] = 6] = "RemoveUser";
        DeviceChangeItemType[DeviceChangeItemType["AddAccessRight"] = 7] = "AddAccessRight";
        DeviceChangeItemType[DeviceChangeItemType["RemoveAccessRight"] = 8] = "RemoveAccessRight";
        DeviceChangeItemType[DeviceChangeItemType["UserInfo"] = 9] = "UserInfo";
        DeviceChangeItemType[DeviceChangeItemType["RegionState"] = 10] = "RegionState";
        DeviceChangeItemType[DeviceChangeItemType["UserGroupUsers"] = 11] = "UserGroupUsers";
        DeviceChangeItemType[DeviceChangeItemType["RegionTicketBalance"] = 12] = "RegionTicketBalance";
        DeviceChangeItemType[DeviceChangeItemType["RegionTicketUsed"] = 13] = "RegionTicketUsed";
        DeviceChangeItemType[DeviceChangeItemType["RegionMaxEntranceCountRuleState"] = 14] = "RegionMaxEntranceCountRuleState";
        DeviceChangeItemType[DeviceChangeItemType["EmergencyState"] = 15] = "EmergencyState";
        DeviceChangeItemType[DeviceChangeItemType["SyncError"] = 16] = "SyncError";
        DeviceChangeItemType[DeviceChangeItemType["UserForbiddenAdd"] = 17] = "UserForbiddenAdd";
        DeviceChangeItemType[DeviceChangeItemType["UserForbiddenRemoved"] = 18] = "UserForbiddenRemoved";
        DeviceChangeItemType[DeviceChangeItemType["UpdateRequired"] = 19] = "UpdateRequired";
        DeviceChangeItemType[DeviceChangeItemType["UpsertAccessNotification"] = 20] = "UpsertAccessNotification";
        DeviceChangeItemType[DeviceChangeItemType["RemoveAccessNotification"] = 21] = "RemoveAccessNotification";
        DeviceChangeItemType[DeviceChangeItemType["UpdateCredential"] = 22] = "UpdateCredential";
        DeviceChangeItemType[DeviceChangeItemType["AccessCapacityBasedRuleApplied"] = 23] = "AccessCapacityBasedRuleApplied";
    })(DeviceChangeItemType = EnumsV2.DeviceChangeItemType || (EnumsV2.DeviceChangeItemType = {}));
    let FingerIndex;
    (function (FingerIndex) {
        FingerIndex[FingerIndex["LeftPinky"] = 1] = "LeftPinky";
        FingerIndex[FingerIndex["LeftRing"] = 2] = "LeftRing";
        FingerIndex[FingerIndex["LeftMiddle"] = 3] = "LeftMiddle";
        FingerIndex[FingerIndex["LeftIndex"] = 4] = "LeftIndex";
        FingerIndex[FingerIndex["LeftThumb"] = 5] = "LeftThumb";
        FingerIndex[FingerIndex["RightThumb"] = 6] = "RightThumb";
        FingerIndex[FingerIndex["RightIndex"] = 7] = "RightIndex";
        FingerIndex[FingerIndex["RightMiddle"] = 8] = "RightMiddle";
        FingerIndex[FingerIndex["RightRing"] = 9] = "RightRing";
        FingerIndex[FingerIndex["RightPinky"] = 10] = "RightPinky";
    })(FingerIndex = EnumsV2.FingerIndex || (EnumsV2.FingerIndex = {}));
    let CredentialIndex;
    (function (CredentialIndex) {
        CredentialIndex[CredentialIndex["Face"] = 0] = "Face";
        CredentialIndex[CredentialIndex["LeftPinky"] = 1] = "LeftPinky";
        CredentialIndex[CredentialIndex["LeftRing"] = 2] = "LeftRing";
        CredentialIndex[CredentialIndex["LeftMiddle"] = 3] = "LeftMiddle";
        CredentialIndex[CredentialIndex["LeftIndex"] = 4] = "LeftIndex";
        CredentialIndex[CredentialIndex["LeftThumb"] = 5] = "LeftThumb";
        CredentialIndex[CredentialIndex["RightThumb"] = 6] = "RightThumb";
        CredentialIndex[CredentialIndex["RightIndex"] = 7] = "RightIndex";
        CredentialIndex[CredentialIndex["RightMiddle"] = 8] = "RightMiddle";
        CredentialIndex[CredentialIndex["RightRing"] = 9] = "RightRing";
        CredentialIndex[CredentialIndex["RightPinky"] = 10] = "RightPinky";
    })(CredentialIndex = EnumsV2.CredentialIndex || (EnumsV2.CredentialIndex = {}));
    let CredentialType;
    (function (CredentialType) {
        CredentialType[CredentialType["ProximityCard"] = 0] = "ProximityCard";
        CredentialType[CredentialType["BLE"] = 2] = "BLE";
        CredentialType[CredentialType["MiFare"] = 3] = "MiFare";
        CredentialType[CredentialType["AccessToken"] = 4] = "AccessToken";
        CredentialType[CredentialType["UHFRfid"] = 5] = "UHFRfid";
        CredentialType[CredentialType["VehiclePlate"] = 6] = "VehiclePlate";
        CredentialType[CredentialType["NFC"] = 8] = "NFC";
        CredentialType[CredentialType["FingerPrintISO19794"] = 9] = "FingerPrintISO19794";
        CredentialType[CredentialType["QrCode"] = 12] = "QrCode";
        CredentialType[CredentialType["MRZ"] = 16] = "MRZ";
    })(CredentialType = EnumsV2.CredentialType || (EnumsV2.CredentialType = {}));
    let StatusSensorReason;
    (function (StatusSensorReason) {
        StatusSensorReason[StatusSensorReason["WiegandReaderTriggeredRelayDrive"] = 1] = "WiegandReaderTriggeredRelayDrive";
        StatusSensorReason[StatusSensorReason["ExitButtonTriggeredRelayDrive"] = 2] = "ExitButtonTriggeredRelayDrive";
        StatusSensorReason[StatusSensorReason["RemoteAccessTriggeredRelayDrive"] = 3] = "RemoteAccessTriggeredRelayDrive";
        StatusSensorReason[StatusSensorReason["UnknownReasonOpenAlthoughRelayIsMapped"] = 4] = "UnknownReasonOpenAlthoughRelayIsMapped";
        StatusSensorReason[StatusSensorReason["UnknownReasonOpenRelayIsNotMapped"] = 5] = "UnknownReasonOpenRelayIsNotMapped";
        StatusSensorReason[StatusSensorReason["LeavedOpenned"] = 6] = "LeavedOpenned";
        StatusSensorReason[StatusSensorReason["Closed"] = 7] = "Closed";
        StatusSensorReason[StatusSensorReason["ClosedAfterLeavedOpennedTimeout"] = 8] = "ClosedAfterLeavedOpennedTimeout";
    })(StatusSensorReason = EnumsV2.StatusSensorReason || (EnumsV2.StatusSensorReason = {}));
    let CounterSensorReason;
    (function (CounterSensorReason) {
        CounterSensorReason[CounterSensorReason["WiegandReaderTriggeredRelayDrive"] = 1] = "WiegandReaderTriggeredRelayDrive";
        CounterSensorReason[CounterSensorReason["ExitButtonTriggeredRelayDrive"] = 2] = "ExitButtonTriggeredRelayDrive";
        CounterSensorReason[CounterSensorReason["RemoteAccessTriggeredRelayDrive"] = 3] = "RemoteAccessTriggeredRelayDrive";
        CounterSensorReason[CounterSensorReason["UnknownReasonCounterAlthoughRelayIsMapped"] = 4] = "UnknownReasonCounterAlthoughRelayIsMapped";
        CounterSensorReason[CounterSensorReason["UnknownReasonCounterRelayIsNotMapped"] = 5] = "UnknownReasonCounterRelayIsNotMapped";
        CounterSensorReason[CounterSensorReason["MoreAccessThanGranted"] = 6] = "MoreAccessThanGranted";
        CounterSensorReason[CounterSensorReason["LessAccessThanGranted"] = 7] = "LessAccessThanGranted";
    })(CounterSensorReason = EnumsV2.CounterSensorReason || (EnumsV2.CounterSensorReason = {}));
    let AuthenticatorType;
    (function (AuthenticatorType) {
        AuthenticatorType[AuthenticatorType["User"] = 1] = "User";
        AuthenticatorType[AuthenticatorType["Visitor"] = 2] = "Visitor";
    })(AuthenticatorType = EnumsV2.AuthenticatorType || (EnumsV2.AuthenticatorType = {}));
    let DayOfWeek;
    (function (DayOfWeek) {
        DayOfWeek[DayOfWeek["Sunday"] = 0] = "Sunday";
        DayOfWeek[DayOfWeek["Monday"] = 1] = "Monday";
        DayOfWeek[DayOfWeek["Tuesday"] = 2] = "Tuesday";
        DayOfWeek[DayOfWeek["Wednesday"] = 3] = "Wednesday";
        DayOfWeek[DayOfWeek["Thursday"] = 4] = "Thursday";
        DayOfWeek[DayOfWeek["Friday"] = 5] = "Friday";
        DayOfWeek[DayOfWeek["Saturday"] = 6] = "Saturday";
    })(DayOfWeek = EnumsV2.DayOfWeek || (EnumsV2.DayOfWeek = {}));
    let DayOfWeekForWorking;
    (function (DayOfWeekForWorking) {
        DayOfWeekForWorking[DayOfWeekForWorking["Monday"] = 1] = "Monday";
        DayOfWeekForWorking[DayOfWeekForWorking["Tuesday"] = 2] = "Tuesday";
        DayOfWeekForWorking[DayOfWeekForWorking["Wednesday"] = 3] = "Wednesday";
        DayOfWeekForWorking[DayOfWeekForWorking["Thursday"] = 4] = "Thursday";
        DayOfWeekForWorking[DayOfWeekForWorking["Friday"] = 5] = "Friday";
        DayOfWeekForWorking[DayOfWeekForWorking["Saturday"] = 6] = "Saturday";
        DayOfWeekForWorking[DayOfWeekForWorking["Sunday"] = 7] = "Sunday";
    })(DayOfWeekForWorking = EnumsV2.DayOfWeekForWorking || (EnumsV2.DayOfWeekForWorking = {}));
    let DeviceBrand;
    (function (DeviceBrand) {
        DeviceBrand[DeviceBrand["Armon"] = 1] = "Armon";
        DeviceBrand[DeviceBrand["Zkt"] = 2] = "Zkt";
        DeviceBrand[DeviceBrand["Virdi"] = 3] = "Virdi";
        DeviceBrand[DeviceBrand["AndroidHuawei"] = 4] = "AndroidHuawei";
        DeviceBrand[DeviceBrand["AssaAbloy"] = 5] = "AssaAbloy";
        DeviceBrand[DeviceBrand["HikVision"] = 6] = "HikVision";
        DeviceBrand[DeviceBrand["Impinj"] = 7] = "Impinj";
        DeviceBrand[DeviceBrand["Axis"] = 8] = "Axis";
    })(DeviceBrand = EnumsV2.DeviceBrand || (EnumsV2.DeviceBrand = {}));
    let ArmonControlPanelIntegrationType;
    (function (ArmonControlPanelIntegrationType) {
        ArmonControlPanelIntegrationType[ArmonControlPanelIntegrationType["HikVisionLicencePlateReader"] = 1] = "HikVisionLicencePlateReader";
        ArmonControlPanelIntegrationType[ArmonControlPanelIntegrationType["ImpinjSpeedWayRs485"] = 2] = "ImpinjSpeedWayRs485";
        ArmonControlPanelIntegrationType[ArmonControlPanelIntegrationType["HikVisionPeopleCounting"] = 3] = "HikVisionPeopleCounting";
        ArmonControlPanelIntegrationType[ArmonControlPanelIntegrationType["AxisLicencePlateReader"] = 4] = "AxisLicencePlateReader";
    })(ArmonControlPanelIntegrationType = EnumsV2.ArmonControlPanelIntegrationType || (EnumsV2.ArmonControlPanelIntegrationType = {}));
    let CardDataFormat;
    (function (CardDataFormat) {
        CardDataFormat[CardDataFormat["Raw"] = 0] = "Raw";
        CardDataFormat[CardDataFormat["ThreeByteWholeData"] = 1] = "ThreeByteWholeData";
        CardDataFormat[CardDataFormat["TwoByteCardNumber"] = 2] = "TwoByteCardNumber";
        CardDataFormat[CardDataFormat["Wiegand34NoParity"] = 3] = "Wiegand34NoParity";
        CardDataFormat[CardDataFormat["Wiegand34WithParity"] = 4] = "Wiegand34WithParity";
        CardDataFormat[CardDataFormat["Wiegand26NoParity"] = 5] = "Wiegand26NoParity";
        CardDataFormat[CardDataFormat["Wiegand26WithParity"] = 6] = "Wiegand26WithParity";
    })(CardDataFormat = EnumsV2.CardDataFormat || (EnumsV2.CardDataFormat = {}));
    let DryContactType;
    (function (DryContactType) {
        DryContactType[DryContactType["GenericSensor"] = 0] = "GenericSensor";
        DryContactType[DryContactType["StatusSensor"] = 5] = "StatusSensor";
        DryContactType[DryContactType["ExitButton"] = 4] = "ExitButton";
        DryContactType[DryContactType["ACOK"] = 1] = "ACOK";
        DryContactType[DryContactType["DCOK"] = 3] = "DCOK";
        DryContactType[DryContactType["BatteryLow"] = 2] = "BatteryLow";
        DryContactType[DryContactType["TamperSwitch"] = 6] = "TamperSwitch";
        DryContactType[DryContactType["CounterSensor"] = 7] = "CounterSensor";
        DryContactType[DryContactType["Emergency"] = 8] = "Emergency";
    })(DryContactType = EnumsV2.DryContactType || (EnumsV2.DryContactType = {}));
    let NotificationSensorType;
    (function (NotificationSensorType) {
        NotificationSensorType[NotificationSensorType["Status"] = 1] = "Status";
        NotificationSensorType[NotificationSensorType["Counter"] = 2] = "Counter";
    })(NotificationSensorType = EnumsV2.NotificationSensorType || (EnumsV2.NotificationSensorType = {}));
    let AccessRuleAcceptStatus;
    (function (AccessRuleAcceptStatus) {
        AccessRuleAcceptStatus[AccessRuleAcceptStatus["Accept"] = 1] = "Accept";
        AccessRuleAcceptStatus[AccessRuleAcceptStatus["Reject"] = 2] = "Reject";
    })(AccessRuleAcceptStatus = EnumsV2.AccessRuleAcceptStatus || (EnumsV2.AccessRuleAcceptStatus = {}));
    let AccessRuleType;
    (function (AccessRuleType) {
        AccessRuleType[AccessRuleType["TimeBased"] = 1] = "TimeBased";
        AccessRuleType[AccessRuleType["CountBased"] = 2] = "CountBased";
        AccessRuleType[AccessRuleType["CapacityBased"] = 3] = "CapacityBased";
        AccessRuleType[AccessRuleType["TimeCountBased"] = 4] = "TimeCountBased";
    })(AccessRuleType = EnumsV2.AccessRuleType || (EnumsV2.AccessRuleType = {}));
    let CredentialRegisterModeFailureReasonType;
    (function (CredentialRegisterModeFailureReasonType) {
        CredentialRegisterModeFailureReasonType[CredentialRegisterModeFailureReasonType["CannotConnectToDevice"] = 1] = "CannotConnectToDevice";
        CredentialRegisterModeFailureReasonType[CredentialRegisterModeFailureReasonType["CannotStartCaptureOperation"] = 2] = "CannotStartCaptureOperation";
        CredentialRegisterModeFailureReasonType[CredentialRegisterModeFailureReasonType["FingerPrintRegisterFailed"] = 6] = "FingerPrintRegisterFailed";
        CredentialRegisterModeFailureReasonType[CredentialRegisterModeFailureReasonType["CredentialRegisterAlreadyUsing"] = 7] = "CredentialRegisterAlreadyUsing";
        CredentialRegisterModeFailureReasonType[CredentialRegisterModeFailureReasonType["FingerPrintRegisterTimeout"] = 8] = "FingerPrintRegisterTimeout";
    })(CredentialRegisterModeFailureReasonType = EnumsV2.CredentialRegisterModeFailureReasonType || (EnumsV2.CredentialRegisterModeFailureReasonType = {}));
    let SoftwareUpdateInterfaceCommand;
    (function (SoftwareUpdateInterfaceCommand) {
        SoftwareUpdateInterfaceCommand[SoftwareUpdateInterfaceCommand["Enable"] = 1] = "Enable";
        SoftwareUpdateInterfaceCommand[SoftwareUpdateInterfaceCommand["Disable"] = 2] = "Disable";
    })(SoftwareUpdateInterfaceCommand = EnumsV2.SoftwareUpdateInterfaceCommand || (EnumsV2.SoftwareUpdateInterfaceCommand = {}));
    let OpenVPNCommand;
    (function (OpenVPNCommand) {
        OpenVPNCommand[OpenVPNCommand["Connect"] = 1] = "Connect";
        OpenVPNCommand[OpenVPNCommand["Disconnect"] = 2] = "Disconnect";
    })(OpenVPNCommand = EnumsV2.OpenVPNCommand || (EnumsV2.OpenVPNCommand = {}));
})(EnumsV2 = exports.EnumsV2 || (exports.EnumsV2 = {}));
