"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UtilsV1 = void 0;
const enums_1 = require("./enums");
var UtilsV1;
(function (UtilsV1) {
    function generateHashForAccessNotification(regionId, direction, success, targetUserId) {
        let key = "";
        key = regionId;
        if (targetUserId) {
            key += targetUserId;
        }
        if (success) {
            key += success;
        }
        key += direction;
        return generateHash(key);
    }
    UtilsV1.generateHashForAccessNotification = generateHashForAccessNotification;
    function generateHashForNotification(notification, type) {
        let key = "";
        switch (type) {
            case enums_1.EnumsV1.NotificationPatternType.StatusSensor:
                {
                    let sensorNotification = notification;
                    let states = [];
                    if (sensorNotification.statusSensorInfo.closed) {
                        states.push(enums_1.EnumsV1.StatusSensorReason.Closed);
                    }
                    if (sensorNotification.statusSensorInfo.closedAfterLeavedOpennedTimeout) {
                        states.push(enums_1.EnumsV1.StatusSensorReason.ClosedAfterLeavedOpennedTimeout);
                    }
                    if (sensorNotification.statusSensorInfo.exitButtonTriggeredRelayDrive) {
                        states.push(enums_1.EnumsV1.StatusSensorReason.ExitButtonTriggeredRelayDrive);
                    }
                    if (sensorNotification.statusSensorInfo.leavedOpened) {
                        states.push(enums_1.EnumsV1.StatusSensorReason.LeavedOpenned);
                    }
                    if (sensorNotification.statusSensorInfo.remoteAccessTriggeredRelayDrive) {
                        states.push(enums_1.EnumsV1.StatusSensorReason.RemoteAccessTriggeredRelayDrive);
                    }
                    if (sensorNotification.statusSensorInfo.unknownReasonOpenAlthoughRelayIsMapped) {
                        states.push(enums_1.EnumsV1.StatusSensorReason.UnknownReasonOpenAlthoughRelayIsMapped);
                    }
                    if (sensorNotification.statusSensorInfo.unknownReasonOpenRelayIsNotMapped) {
                        states.push(enums_1.EnumsV1.StatusSensorReason.UnknownReasonOpenRelayIsNotMapped);
                    }
                    if (sensorNotification.statusSensorInfo.wiegandReaderTriggeredRelayDrive) {
                        states.push(enums_1.EnumsV1.StatusSensorReason.WiegandReaderTriggeredRelayDrive);
                    }
                    key = states.join(",")
                        + sensorNotification.accessControlPointId + sensorNotification.statusSensorInfo.statusSensorId;
                }
                break;
            case enums_1.EnumsV1.NotificationPatternType.CounterSensor:
                {
                    let sensorNotification = notification;
                    let states = [];
                    if (sensorNotification.counterSensorInfo.exitButtonTriggeredRelayDrive) {
                        states.push(enums_1.EnumsV1.CounterSensorEventReason.ExitButtonTriggeredRelayDrive);
                    }
                    if (sensorNotification.counterSensorInfo.remoteAccessTriggeredRelayDrive) {
                        states.push(enums_1.EnumsV1.CounterSensorEventReason.RemoteAccessTriggeredRelayDrive);
                    }
                    if (sensorNotification.counterSensorInfo.unknownReasonCounterAlthoughRelayIsMapped) {
                        states.push(enums_1.EnumsV1.CounterSensorEventReason.UnknownReasonCounterAlthoughRelayIsMapped);
                    }
                    if (sensorNotification.counterSensorInfo.unknownReasonCounterRelayIsNotMapped) {
                        states.push(enums_1.EnumsV1.CounterSensorEventReason.UnknownReasonCounterRelayIsNotMapped);
                    }
                    if (sensorNotification.counterSensorInfo.wiegandReaderTriggeredRelayDrive) {
                        states.push(enums_1.EnumsV1.CounterSensorEventReason.WiegandReaderTriggeredRelayDrive);
                    }
                    key = states.join() + sensorNotification.accessControlPointId + sensorNotification.counterSensorInfo.counterSensorId;
                }
                break;
            default:
                break;
        }
        return generateHash(key);
    }
    UtilsV1.generateHashForNotification = generateHashForNotification;
    function generateHash(value) {
        let h = 5831 << 2;
        let i = 0;
        for (i = 0; i < value.length; i++) {
            let ascii = value.charCodeAt(i);
            h = ((h << 3) ^ h) ^ ascii;
        }
        return (h & 0xffffffffff).toString(16);
    }
})(UtilsV1 = exports.UtilsV1 || (exports.UtilsV1 = {}));
