"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EnumsV1 = void 0;
var EnumsV1;
(function (EnumsV1) {
    let ReaderType;
    (function (ReaderType) {
        ReaderType[ReaderType["Wiegand"] = 1] = "Wiegand";
        ReaderType[ReaderType["NFC"] = 2] = "NFC";
        ReaderType[ReaderType["Bluetooth"] = 3] = "Bluetooth";
        ReaderType[ReaderType["HikVision"] = 4] = "HikVision";
        ReaderType[ReaderType["Impinj"] = 5] = "Impinj";
    })(ReaderType = EnumsV1.ReaderType || (EnumsV1.ReaderType = {}));
    let AuthenticationFactor;
    (function (AuthenticationFactor) {
        AuthenticationFactor[AuthenticationFactor["ProximityCard"] = 0] = "ProximityCard";
        AuthenticationFactor[AuthenticationFactor["Bluetooth"] = 2] = "Bluetooth";
        AuthenticationFactor[AuthenticationFactor["MiFare"] = 3] = "MiFare";
        AuthenticationFactor[AuthenticationFactor["AccessToken"] = 4] = "AccessToken";
        AuthenticationFactor[AuthenticationFactor["UHFRfid"] = 5] = "UHFRfid";
        AuthenticationFactor[AuthenticationFactor["VehiclePlate"] = 6] = "VehiclePlate";
        AuthenticationFactor[AuthenticationFactor["NFC"] = 8] = "NFC";
        AuthenticationFactor[AuthenticationFactor["FingerPrint"] = 9] = "FingerPrint";
        AuthenticationFactor[AuthenticationFactor["QR_BarCode"] = 14] = "QR_BarCode";
        AuthenticationFactor[AuthenticationFactor["MRZ"] = 16] = "MRZ";
    })(AuthenticationFactor = EnumsV1.AuthenticationFactor || (EnumsV1.AuthenticationFactor = {}));
    let AccessDirection;
    (function (AccessDirection) {
        AccessDirection[AccessDirection["All"] = 0] = "All";
        AccessDirection[AccessDirection["Entrance"] = 1] = "Entrance";
        AccessDirection[AccessDirection["Exit"] = 2] = "Exit";
    })(AccessDirection = EnumsV1.AccessDirection || (EnumsV1.AccessDirection = {}));
    let AntiPassbackState;
    (function (AntiPassbackState) {
        AntiPassbackState[AntiPassbackState["Unknown"] = 0] = "Unknown";
        AntiPassbackState[AntiPassbackState["In"] = 1] = "In";
        AntiPassbackState[AntiPassbackState["Out"] = 2] = "Out";
    })(AntiPassbackState = EnumsV1.AntiPassbackState || (EnumsV1.AntiPassbackState = {}));
    let OfflineLogType;
    (function (OfflineLogType) {
        OfflineLogType[OfflineLogType["AccessLog"] = 1] = "AccessLog";
        OfflineLogType[OfflineLogType["StatusSensorLog"] = 2] = "StatusSensorLog";
        OfflineLogType[OfflineLogType["TamperSwitchLog"] = 3] = "TamperSwitchLog";
        OfflineLogType[OfflineLogType["EmergencyLog"] = 4] = "EmergencyLog";
        OfflineLogType[OfflineLogType["SystemStatusLog"] = 5] = "SystemStatusLog";
        OfflineLogType[OfflineLogType["CounterLog"] = 6] = "CounterLog";
        OfflineLogType[OfflineLogType["SystemHealthLog"] = 7] = "SystemHealthLog";
        OfflineLogType[OfflineLogType["FingerPrintAddLog"] = 8] = "FingerPrintAddLog";
        OfflineLogType[OfflineLogType["FingerprintRemoveLog"] = 9] = "FingerprintRemoveLog";
    })(OfflineLogType = EnumsV1.OfflineLogType || (EnumsV1.OfflineLogType = {}));
    let DeviceToServerMessageTypes;
    (function (DeviceToServerMessageTypes) {
        DeviceToServerMessageTypes[DeviceToServerMessageTypes["AccessLog"] = 1] = "AccessLog";
        DeviceToServerMessageTypes[DeviceToServerMessageTypes["SystemStatus"] = 2] = "SystemStatus";
        DeviceToServerMessageTypes[DeviceToServerMessageTypes["EmergencyStateChanged"] = 3] = "EmergencyStateChanged";
        DeviceToServerMessageTypes[DeviceToServerMessageTypes["StatusSensorStateChanged"] = 4] = "StatusSensorStateChanged";
        DeviceToServerMessageTypes[DeviceToServerMessageTypes["CounterSensorEvent"] = 5] = "CounterSensorEvent";
        DeviceToServerMessageTypes[DeviceToServerMessageTypes["TamperEvent"] = 6] = "TamperEvent";
        DeviceToServerMessageTypes[DeviceToServerMessageTypes["AccessLogControlPanel"] = 7] = "AccessLogControlPanel";
        DeviceToServerMessageTypes[DeviceToServerMessageTypes["SystemHealth"] = 8] = "SystemHealth";
        DeviceToServerMessageTypes[DeviceToServerMessageTypes["DeviceOfAdapterConnectionState"] = 9] = "DeviceOfAdapterConnectionState";
    })(DeviceToServerMessageTypes = EnumsV1.DeviceToServerMessageTypes || (EnumsV1.DeviceToServerMessageTypes = {}));
    let ServerToDeviceMessageType;
    (function (ServerToDeviceMessageType) {
        ServerToDeviceMessageType[ServerToDeviceMessageType["GetChangesRequired"] = 1] = "GetChangesRequired";
        ServerToDeviceMessageType[ServerToDeviceMessageType["ConfigOrSettingsChanged"] = 2] = "ConfigOrSettingsChanged";
    })(ServerToDeviceMessageType = EnumsV1.ServerToDeviceMessageType || (EnumsV1.ServerToDeviceMessageType = {}));
    let EmergencyState;
    (function (EmergencyState) {
        EmergencyState[EmergencyState["Normal"] = 0] = "Normal";
        EmergencyState[EmergencyState["Emergency"] = 1] = "Emergency";
    })(EmergencyState = EnumsV1.EmergencyState || (EnumsV1.EmergencyState = {}));
    let AccessLogReason;
    (function (AccessLogReason) {
        AccessLogReason[AccessLogReason["Success"] = 0] = "Success";
        AccessLogReason[AccessLogReason["HasNotRight"] = 1] = "HasNotRight";
        AccessLogReason[AccessLogReason["UnknownCredentialOwner"] = 2] = "UnknownCredentialOwner";
        AccessLogReason[AccessLogReason["UnknownAccessPoint"] = 3] = "UnknownAccessPoint";
        AccessLogReason[AccessLogReason["UnhandledFailure"] = 4] = "UnhandledFailure";
        AccessLogReason[AccessLogReason["AntiPassbackReject"] = 5] = "AntiPassbackReject";
        AccessLogReason[AccessLogReason["AntiPassbackTimeOutReject"] = 6] = "AntiPassbackTimeOutReject";
        AccessLogReason[AccessLogReason["CredentialExpired"] = 8] = "CredentialExpired";
        AccessLogReason[AccessLogReason["InsufficientFund"] = 9] = "InsufficientFund";
        AccessLogReason[AccessLogReason["RuleReject"] = 10] = "RuleReject";
        AccessLogReason[AccessLogReason["Manual"] = 11] = "Manual";
        AccessLogReason[AccessLogReason["StateOpened"] = 12] = "StateOpened";
        AccessLogReason[AccessLogReason["StateDisabled"] = 13] = "StateDisabled";
        AccessLogReason[AccessLogReason["IncompleteMultiFactor"] = 14] = "IncompleteMultiFactor";
        AccessLogReason[AccessLogReason["Forbidden"] = 15] = "Forbidden";
        AccessLogReason[AccessLogReason["UserDisabled"] = 16] = "UserDisabled";
    })(AccessLogReason = EnumsV1.AccessLogReason || (EnumsV1.AccessLogReason = {}));
    let StatusSensorState;
    (function (StatusSensorState) {
        StatusSensorState[StatusSensorState["Closed"] = 0] = "Closed";
        StatusSensorState[StatusSensorState["Open"] = 1] = "Open";
        StatusSensorState[StatusSensorState["TimeOut"] = 2] = "TimeOut";
    })(StatusSensorState = EnumsV1.StatusSensorState || (EnumsV1.StatusSensorState = {}));
    let ServerToDeviceRPCMessageType;
    (function (ServerToDeviceRPCMessageType) {
        ServerToDeviceRPCMessageType[ServerToDeviceRPCMessageType["RemoteAccess"] = 1] = "RemoteAccess";
        ServerToDeviceRPCMessageType[ServerToDeviceRPCMessageType["ChangeAccessControlPointState"] = 2] = "ChangeAccessControlPointState";
        ServerToDeviceRPCMessageType[ServerToDeviceRPCMessageType["EmergencyStart"] = 3] = "EmergencyStart";
        ServerToDeviceRPCMessageType[ServerToDeviceRPCMessageType["EmergencyEnd"] = 4] = "EmergencyEnd";
        ServerToDeviceRPCMessageType[ServerToDeviceRPCMessageType["RegionStateChanged"] = 5] = "RegionStateChanged";
        ServerToDeviceRPCMessageType[ServerToDeviceRPCMessageType["DateTimeChanged"] = 6] = "DateTimeChanged";
        ServerToDeviceRPCMessageType[ServerToDeviceRPCMessageType["CoinBalanceChanged"] = 7] = "CoinBalanceChanged";
        ServerToDeviceRPCMessageType[ServerToDeviceRPCMessageType["AccessRuleApplied"] = 8] = "AccessRuleApplied";
        ServerToDeviceRPCMessageType[ServerToDeviceRPCMessageType["AskSystemStatus"] = 9] = "AskSystemStatus";
        ServerToDeviceRPCMessageType[ServerToDeviceRPCMessageType["Reboot"] = 10] = "Reboot";
        ServerToDeviceRPCMessageType[ServerToDeviceRPCMessageType["SyncError"] = 11] = "SyncError";
        ServerToDeviceRPCMessageType[ServerToDeviceRPCMessageType["NotificationPattern"] = 12] = "NotificationPattern";
    })(ServerToDeviceRPCMessageType = EnumsV1.ServerToDeviceRPCMessageType || (EnumsV1.ServerToDeviceRPCMessageType = {}));
    let AccessControlPointState;
    (function (AccessControlPointState) {
        AccessControlPointState[AccessControlPointState["Normal"] = 1] = "Normal";
        AccessControlPointState[AccessControlPointState["StayOpened"] = 2] = "StayOpened";
        AccessControlPointState[AccessControlPointState["Disabled"] = 3] = "Disabled";
    })(AccessControlPointState = EnumsV1.AccessControlPointState || (EnumsV1.AccessControlPointState = {}));
    let NotificationPatternActionType;
    (function (NotificationPatternActionType) {
        NotificationPatternActionType[NotificationPatternActionType["Add"] = 1] = "Add";
        NotificationPatternActionType[NotificationPatternActionType["Update"] = 2] = "Update";
        NotificationPatternActionType[NotificationPatternActionType["Remove"] = 3] = "Remove";
    })(NotificationPatternActionType = EnumsV1.NotificationPatternActionType || (EnumsV1.NotificationPatternActionType = {}));
    let NotificationPatternType;
    (function (NotificationPatternType) {
        NotificationPatternType[NotificationPatternType["Identity"] = 1] = "Identity";
        NotificationPatternType[NotificationPatternType["StatusSensor"] = 2] = "StatusSensor";
        NotificationPatternType[NotificationPatternType["CounterSensor"] = 3] = "CounterSensor";
    })(NotificationPatternType = EnumsV1.NotificationPatternType || (EnumsV1.NotificationPatternType = {}));
    let CounterSensorEventReason;
    (function (CounterSensorEventReason) {
        CounterSensorEventReason[CounterSensorEventReason["WiegandReaderTriggeredRelayDrive"] = 1] = "WiegandReaderTriggeredRelayDrive";
        CounterSensorEventReason[CounterSensorEventReason["ExitButtonTriggeredRelayDrive"] = 2] = "ExitButtonTriggeredRelayDrive";
        CounterSensorEventReason[CounterSensorEventReason["RemoteAccessTriggeredRelayDrive"] = 3] = "RemoteAccessTriggeredRelayDrive";
        CounterSensorEventReason[CounterSensorEventReason["UnknownReasonCounterAlthoughRelayIsMapped"] = 4] = "UnknownReasonCounterAlthoughRelayIsMapped";
        CounterSensorEventReason[CounterSensorEventReason["UnknownReasonCounterRelayIsNotMapped"] = 5] = "UnknownReasonCounterRelayIsNotMapped";
    })(CounterSensorEventReason = EnumsV1.CounterSensorEventReason || (EnumsV1.CounterSensorEventReason = {}));
    let TamperSwitchState;
    (function (TamperSwitchState) {
        TamperSwitchState[TamperSwitchState["Secure"] = 0] = "Secure";
        TamperSwitchState[TamperSwitchState["Tampered"] = 1] = "Tampered";
    })(TamperSwitchState = EnumsV1.TamperSwitchState || (EnumsV1.TamperSwitchState = {}));
    let SystemStatusNotificationReason;
    (function (SystemStatusNotificationReason) {
        SystemStatusNotificationReason[SystemStatusNotificationReason["TimerInterval"] = 0] = "TimerInterval";
        SystemStatusNotificationReason[SystemStatusNotificationReason["AcOk"] = 1] = "AcOk";
        SystemStatusNotificationReason[SystemStatusNotificationReason["RtcOk"] = 2] = "RtcOk";
        SystemStatusNotificationReason[SystemStatusNotificationReason["TemperatureLevel"] = 3] = "TemperatureLevel";
        SystemStatusNotificationReason[SystemStatusNotificationReason["TemperatureInCelsius"] = 4] = "TemperatureInCelsius";
        SystemStatusNotificationReason[SystemStatusNotificationReason["BatteryValue"] = 5] = "BatteryValue";
        SystemStatusNotificationReason[SystemStatusNotificationReason["EmergencyState"] = 6] = "EmergencyState";
    })(SystemStatusNotificationReason = EnumsV1.SystemStatusNotificationReason || (EnumsV1.SystemStatusNotificationReason = {}));
    let DeviceChangeItemType;
    (function (DeviceChangeItemType) {
        DeviceChangeItemType[DeviceChangeItemType["AddCredential"] = 1] = "AddCredential";
        DeviceChangeItemType[DeviceChangeItemType["RemoveCredential"] = 2] = "RemoveCredential";
        DeviceChangeItemType[DeviceChangeItemType["ConfigChanged"] = 3] = "ConfigChanged";
        DeviceChangeItemType[DeviceChangeItemType["SettingChanged"] = 4] = "SettingChanged";
        DeviceChangeItemType[DeviceChangeItemType["AddUser"] = 5] = "AddUser";
        DeviceChangeItemType[DeviceChangeItemType["RemoveUser"] = 6] = "RemoveUser";
        DeviceChangeItemType[DeviceChangeItemType["AddAccessRight"] = 7] = "AddAccessRight";
        DeviceChangeItemType[DeviceChangeItemType["RemoveAccessRight"] = 8] = "RemoveAccessRight";
        DeviceChangeItemType[DeviceChangeItemType["UserInfo"] = 9] = "UserInfo";
        DeviceChangeItemType[DeviceChangeItemType["RegionState"] = 10] = "RegionState";
        DeviceChangeItemType[DeviceChangeItemType["UserGroupUsers"] = 11] = "UserGroupUsers";
        DeviceChangeItemType[DeviceChangeItemType["RegionTicketBalance"] = 12] = "RegionTicketBalance";
        DeviceChangeItemType[DeviceChangeItemType["RegionTicketUsed"] = 13] = "RegionTicketUsed";
        DeviceChangeItemType[DeviceChangeItemType["RegionMaxEntranceCountRuleState"] = 14] = "RegionMaxEntranceCountRuleState";
        DeviceChangeItemType[DeviceChangeItemType["EmergencyState"] = 15] = "EmergencyState";
        DeviceChangeItemType[DeviceChangeItemType["SyncError"] = 16] = "SyncError";
        DeviceChangeItemType[DeviceChangeItemType["UserForbiddenAdd"] = 17] = "UserForbiddenAdd";
        DeviceChangeItemType[DeviceChangeItemType["UserForbiddenRemoved"] = 18] = "UserForbiddenRemoved";
        DeviceChangeItemType[DeviceChangeItemType["UpdateRequired"] = 19] = "UpdateRequired";
        DeviceChangeItemType[DeviceChangeItemType["UpsertAccessNotification"] = 20] = "UpsertAccessNotification";
        DeviceChangeItemType[DeviceChangeItemType["RemoveAccessNotification"] = 21] = "RemoveAccessNotification";
        DeviceChangeItemType[DeviceChangeItemType["UpdateCredential"] = 22] = "UpdateCredential";
    })(DeviceChangeItemType = EnumsV1.DeviceChangeItemType || (EnumsV1.DeviceChangeItemType = {}));
    let FingerIndex;
    (function (FingerIndex) {
        FingerIndex[FingerIndex["LeftPinky"] = 1] = "LeftPinky";
        FingerIndex[FingerIndex["LeftRing"] = 2] = "LeftRing";
        FingerIndex[FingerIndex["LeftMiddle"] = 3] = "LeftMiddle";
        FingerIndex[FingerIndex["LeftIndex"] = 4] = "LeftIndex";
        FingerIndex[FingerIndex["LeftThumb"] = 5] = "LeftThumb";
        FingerIndex[FingerIndex["RightThumb"] = 6] = "RightThumb";
        FingerIndex[FingerIndex["RightIndex"] = 7] = "RightIndex";
        FingerIndex[FingerIndex["RightMiddle"] = 8] = "RightMiddle";
        FingerIndex[FingerIndex["RightRing"] = 9] = "RightRing";
        FingerIndex[FingerIndex["RightPinky"] = 10] = "RightPinky";
    })(FingerIndex = EnumsV1.FingerIndex || (EnumsV1.FingerIndex = {}));
    let CredentialType;
    (function (CredentialType) {
        CredentialType[CredentialType["ProximityCard"] = 0] = "ProximityCard";
        CredentialType[CredentialType["BLE"] = 2] = "BLE";
        CredentialType[CredentialType["MiFare"] = 3] = "MiFare";
        CredentialType[CredentialType["AccessToken"] = 4] = "AccessToken";
        CredentialType[CredentialType["UHFRfid"] = 5] = "UHFRfid";
        CredentialType[CredentialType["VehiclePlate"] = 6] = "VehiclePlate";
        CredentialType[CredentialType["NFC"] = 8] = "NFC";
        CredentialType[CredentialType["FingerPrintISO19794"] = 9] = "FingerPrintISO19794";
        CredentialType[CredentialType["QrCode"] = 12] = "QrCode";
        CredentialType[CredentialType["MRZ"] = 16] = "MRZ";
    })(CredentialType = EnumsV1.CredentialType || (EnumsV1.CredentialType = {}));
    let StatusSensorReason;
    (function (StatusSensorReason) {
        StatusSensorReason[StatusSensorReason["WiegandReaderTriggeredRelayDrive"] = 1] = "WiegandReaderTriggeredRelayDrive";
        StatusSensorReason[StatusSensorReason["ExitButtonTriggeredRelayDrive"] = 2] = "ExitButtonTriggeredRelayDrive";
        StatusSensorReason[StatusSensorReason["RemoteAccessTriggeredRelayDrive"] = 3] = "RemoteAccessTriggeredRelayDrive";
        StatusSensorReason[StatusSensorReason["UnknownReasonOpenAlthoughRelayIsMapped"] = 4] = "UnknownReasonOpenAlthoughRelayIsMapped";
        StatusSensorReason[StatusSensorReason["UnknownReasonOpenRelayIsNotMapped"] = 5] = "UnknownReasonOpenRelayIsNotMapped";
        StatusSensorReason[StatusSensorReason["LeavedOpenned"] = 6] = "LeavedOpenned";
        StatusSensorReason[StatusSensorReason["Closed"] = 7] = "Closed";
        StatusSensorReason[StatusSensorReason["ClosedAfterLeavedOpennedTimeout"] = 8] = "ClosedAfterLeavedOpennedTimeout";
    })(StatusSensorReason = EnumsV1.StatusSensorReason || (EnumsV1.StatusSensorReason = {}));
    let CounterSensorReason;
    (function (CounterSensorReason) {
        CounterSensorReason[CounterSensorReason["WiegandReaderTriggeredRelayDrive"] = 1] = "WiegandReaderTriggeredRelayDrive";
        CounterSensorReason[CounterSensorReason["ExitButtonTriggeredRelayDrive"] = 2] = "ExitButtonTriggeredRelayDrive";
        CounterSensorReason[CounterSensorReason["RemoteAccessTriggeredRelayDrive"] = 3] = "RemoteAccessTriggeredRelayDrive";
        CounterSensorReason[CounterSensorReason["UnknownReasonCounterAlthoughRelayIsMapped"] = 4] = "UnknownReasonCounterAlthoughRelayIsMapped";
        CounterSensorReason[CounterSensorReason["UnknownReasonCounterRelayIsNotMapped"] = 5] = "UnknownReasonCounterRelayIsNotMapped";
    })(CounterSensorReason = EnumsV1.CounterSensorReason || (EnumsV1.CounterSensorReason = {}));
    let AuthenticatorType;
    (function (AuthenticatorType) {
        AuthenticatorType[AuthenticatorType["User"] = 1] = "User";
        AuthenticatorType[AuthenticatorType["Visitor"] = 2] = "Visitor";
    })(AuthenticatorType = EnumsV1.AuthenticatorType || (EnumsV1.AuthenticatorType = {}));
    let DayOfWeek;
    (function (DayOfWeek) {
        DayOfWeek[DayOfWeek["Sunday"] = 0] = "Sunday";
        DayOfWeek[DayOfWeek["Monday"] = 1] = "Monday";
        DayOfWeek[DayOfWeek["Tuesday"] = 2] = "Tuesday";
        DayOfWeek[DayOfWeek["Wednesday"] = 3] = "Wednesday";
        DayOfWeek[DayOfWeek["Thursday"] = 4] = "Thursday";
        DayOfWeek[DayOfWeek["Friday"] = 5] = "Friday";
        DayOfWeek[DayOfWeek["Saturday"] = 6] = "Saturday";
    })(DayOfWeek = EnumsV1.DayOfWeek || (EnumsV1.DayOfWeek = {}));
    let DeviceBrand;
    (function (DeviceBrand) {
        DeviceBrand[DeviceBrand["Armon"] = 1] = "Armon";
        DeviceBrand[DeviceBrand["Zkt"] = 2] = "Zkt";
        DeviceBrand[DeviceBrand["Virdi"] = 3] = "Virdi";
        DeviceBrand[DeviceBrand["AndroidHuawei"] = 4] = "AndroidHuawei";
        DeviceBrand[DeviceBrand["AssaAbloy"] = 5] = "AssaAbloy";
        DeviceBrand[DeviceBrand["HikVision"] = 6] = "HikVision";
        DeviceBrand[DeviceBrand["Impinj"] = 7] = "Impinj";
    })(DeviceBrand = EnumsV1.DeviceBrand || (EnumsV1.DeviceBrand = {}));
    let ArmonControlPanelIntegrationType;
    (function (ArmonControlPanelIntegrationType) {
        ArmonControlPanelIntegrationType[ArmonControlPanelIntegrationType["HikVisionLicencePlateReader"] = 1] = "HikVisionLicencePlateReader";
        ArmonControlPanelIntegrationType[ArmonControlPanelIntegrationType["ImpinjSpeedWayRs485"] = 2] = "ImpinjSpeedWayRs485";
    })(ArmonControlPanelIntegrationType = EnumsV1.ArmonControlPanelIntegrationType || (EnumsV1.ArmonControlPanelIntegrationType = {}));
    let CardDataFormat;
    (function (CardDataFormat) {
        CardDataFormat[CardDataFormat["Raw"] = 0] = "Raw";
        CardDataFormat[CardDataFormat["ThreeByteWholeData"] = 1] = "ThreeByteWholeData";
        CardDataFormat[CardDataFormat["TwoByteCardNumber"] = 2] = "TwoByteCardNumber";
    })(CardDataFormat = EnumsV1.CardDataFormat || (EnumsV1.CardDataFormat = {}));
    let DryContactType;
    (function (DryContactType) {
        DryContactType[DryContactType["Generic"] = 0] = "Generic";
        DryContactType[DryContactType["StatusSensor"] = 5] = "StatusSensor";
        DryContactType[DryContactType["ExitButton"] = 4] = "ExitButton";
        DryContactType[DryContactType["ACOK"] = 1] = "ACOK";
        DryContactType[DryContactType["DCOK"] = 3] = "DCOK";
        DryContactType[DryContactType["BatteryLow"] = 2] = "BatteryLow";
        DryContactType[DryContactType["TamperSwitch"] = 6] = "TamperSwitch";
        DryContactType[DryContactType["Counter"] = 7] = "Counter";
    })(DryContactType = EnumsV1.DryContactType || (EnumsV1.DryContactType = {}));
    let NotificationSensorType;
    (function (NotificationSensorType) {
        NotificationSensorType[NotificationSensorType["Status"] = 1] = "Status";
        NotificationSensorType[NotificationSensorType["Counter"] = 2] = "Counter";
    })(NotificationSensorType = EnumsV1.NotificationSensorType || (EnumsV1.NotificationSensorType = {}));
    let AccessRuleAcceptStatus;
    (function (AccessRuleAcceptStatus) {
        AccessRuleAcceptStatus[AccessRuleAcceptStatus["Accept"] = 1] = "Accept";
        AccessRuleAcceptStatus[AccessRuleAcceptStatus["Reject"] = 2] = "Reject";
    })(AccessRuleAcceptStatus = EnumsV1.AccessRuleAcceptStatus || (EnumsV1.AccessRuleAcceptStatus = {}));
    let AccessRuleType;
    (function (AccessRuleType) {
        AccessRuleType[AccessRuleType["TimeBased"] = 1] = "TimeBased";
        AccessRuleType[AccessRuleType["CountBased"] = 2] = "CountBased";
    })(AccessRuleType = EnumsV1.AccessRuleType || (EnumsV1.AccessRuleType = {}));
})(EnumsV1 = exports.EnumsV1 || (exports.EnumsV1 = {}));
