"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getAccessAndSensorLogs = void 0;
const app_enums_1 = require("../../app.enums");
const app_logs_1 = require("../../app.logs");
const dal_manager_1 = require("../../dal/dal.manager");
const dal_db_armon_schema_1 = require("../../dal/db/armon/dal.db.armon.schema");
async function getAccessAndSensorLogs(params) {
    const organizationId = params.organizationId;
    const data = await dal_manager_1.dbManager.systemTransaction(async (trx) => {
        try {
            let logsAndSnapshots = [];
            let query = `
                SELECT T.* FROM 
                    (SELECT 1 AS type, al."actionUtc", al.log`;
            if (params.withSnapshots) {
                query += `
                , COALESCE(JSONB_AGG (ass.log->'s') FILTER (WHERE ass.log->'s' IS NOT NULL), '[]') AS snapshots
                    FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.AccessLogs}" AS al
                LEFT JOIN "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.AccessSnapshots}" AS ass
                    ON ass.id::text = ANY (ARRAY(SELECT JSONB_ARRAY_ELEMENTS_TEXT(al.log->'sid')))
                    AND ass.log->>'s' != 'null'
                WHERE al."actionUtc" >= $1 AND al."actionUtc" <= $2
                GROUP BY al.log, al."actionUtc"

                UNION ALL

                SELECT 2 AS type, ssl."actionUtc", ssl.log, COALESCE(JSONB_AGG (ass.log->'s') FILTER (WHERE ass.log->'s' IS NOT NULL), '[]') AS snapshots
                    FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.StatusSensorLogs}" AS ssl
                LEFT JOIN "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.AccessSnapshots}" AS ass
                    ON ass.id::text = ANY (ARRAY(SELECT JSONB_ARRAY_ELEMENTS_TEXT(ssl.log->'sid')))
                    AND ass.log->>'s' != 'null'
                WHERE ssl."actionUtc" >= $1 AND ssl."actionUtc" <= $2
                    AND (ssl.log->>'r')::INTEGER = $3
                GROUP BY ssl.log, ssl."actionUtc"
                ) AS T
                ORDER BY T."actionUtc" DESC;
                    `;
                logsAndSnapshots.push(...(await trx.query(query, [params.startUtc, params.endUtc, app_enums_1.enums.StatusSensorReason.UnknownReasonOpenAlthoughRelayIsMapped])).rows);
            }
            else {
                query += `
                FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.AccessLogs}" AS al
                    WHERE al."actionUtc" >= $1 AND al."actionUtc" <= $2
                        GROUP BY al.log, al."actionUtc"

                    UNION ALL

                    SELECT 2 AS type, ssl."actionUtc", ssl.log
                        FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.StatusSensorLogs}" AS ssl
                    WHERE ssl."actionUtc" >= $1 AND ssl."actionUtc" <= $2
                        AND (ssl.log->>'r')::INTEGER = $3
                        GROUP BY ssl.log, ssl."actionUtc"
                    ) AS T
                ORDER BY T."actionUtc" DESC;
                `;
                logsAndSnapshots.push(...(await trx.query(query, [params.startUtc, params.endUtc, app_enums_1.enums.StatusSensorReason.UnknownReasonOpenAlthoughRelayIsMapped])).rows);
            }
            const accessControlPoints = (await trx.query(`
                SELECT id, name 
                    FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.accessControlPoints}"
                WHERE id = ANY ($1::UUID[]) AND
                    "deletedAt" IS NULL
            `, [[...new Set(logsAndSnapshots.map((al) => al.log.a))]])).rows.map((elem) => (elem = { id: elem.id, name: elem.name.split("/")[0] }));
            const userCaptions = [];
            await dal_manager_1.dbManager.accessUser.getAllUserOrganizationBadgeRedisPersistentData({
                organizationId: organizationId,
                onData: (rows) => {
                    userCaptions.push(...rows);
                },
                trx,
            });
            const organizationInfo = await dal_manager_1.dbManager.accessOrganization.getOrganizationRedisPersistentData({ organizationId: organizationId, trx });
            return {
                accessControlPoints,
                accessAndStatusSensorLogs: logsAndSnapshots,
                organizationInfo,
                userCaptions,
            };
        }
        catch (err) {
            app_logs_1.logger.error(err);
        }
    });
    return data;
}
exports.getAccessAndSensorLogs = getAccessAndSensorLogs;
