"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.beforeUpsertVisitorImp = exports.CreateHook = void 0;
const strong_soap_1 = require("strong-soap");
const app_logs_1 = require("../../../app.logs");
const business_hooks_1 = require("../../../business/business.hooks");
const restapi_1 = require("../../../lib/es/models/restapi");
const dal_manager_1 = require("../../../dal/dal.manager");
const dal_access_psql_organization_1 = require("../../../dal/access/psql/dal.access.psql.organization");
const luxon_1 = require("luxon");
const organizationId = "b859ce78-9464-4b23-a922-63458825f56e";
const mernisSecretId = "11b0d47d-1006-44f4-8d75-4df0d5c831d2";
function CreateHook() {
    return new UlastirmaHook();
}
exports.CreateHook = CreateHook;
class UlastirmaHook extends business_hooks_1.OrganizationHookModels.IArmonHook {
    constructor() {
        super();
        this.afterSearchVisitorProfileForm = afterSearchVisitorProfileForm;
        this.beforeUpsertVisitor = exports.beforeUpsertVisitorImp;
    }
}
const getUserDataFromMernis = async (tcKimlikNo, dateOfBirth) => {
    const mernisSecret = await dal_manager_1.dbManager.systemTransaction(async (trx) => {
        return await (0, dal_access_psql_organization_1.getOrganizationSecretById)(organizationId, mernisSecretId, trx);
    });
    return new Promise((resolve, reject) => {
        strong_soap_1.soap.createClient(mernisSecret.address, {}, (err, client) => {
            if (err) {
                app_logs_1.logger.error("error while creating soap client for ulastirma: " + err.message);
                app_logs_1.logger.error(err);
                throw err;
            }
            const security = new strong_soap_1.soap.BasicAuthSecurity(mernisSecret.username, mernisSecret.password);
            client.setSecurity(security);
            client.Sorgula({
                kriterListesi: {
                    BilesikKutukSorgulaKimlikNoSorguKriteri: {
                        KimlikNo: tcKimlikNo,
                        DogumAy: dateOfBirth.month,
                        DogumGun: dateOfBirth.day,
                        DogumYil: dateOfBirth.year,
                    },
                },
            }, async (err, result, envelope) => {
                if (err) {
                    app_logs_1.logger.error("Mernis SOAP isteği sırasında hata oluştu: " + err.message);
                    app_logs_1.logger.error(err);
                    resolve(null);
                    return;
                }
                if (result.SorgulaResult.HataBilgisi) {
                    app_logs_1.logger.error("Mernis hata döndü: " + result.SorgulaResult.HataBilgisi);
                    resolve(null);
                }
                else {
                    try {
                        resolve(`${result.SorgulaResult.SorguSonucu.BilesikKutukBilgileri[0].TCVatandasiKisiKutukleri.TCKKBilgisi.Ad} ${result.SorgulaResult.SorguSonucu.BilesikKutukBilgileri[0].TCVatandasiKisiKutukleri.TCKKBilgisi.Soyad}`);
                    }
                    catch (error) {
                        app_logs_1.logger.error("Mernisten alınan veri işlenemdi: ");
                        app_logs_1.logger.error(error);
                        resolve(null);
                    }
                }
            }, null, { connection: "keep-alive" });
        });
    });
};
const afterSearchVisitorProfileForm = async (params) => {
    if ((!params.request.fields.find((field) => field.fieldName === "uniqueId" && field.filter.length === 11) ||
        !params.request.fields.find((field) => field.fieldName === "dateOfBirth" && field.filter.length === 10)) &&
        params.dbResult.items.length === 0) {
        return null;
    }
    try {
        const uniqueId = params.request.fields.find((field) => field.fieldName === "uniqueId").filter;
        const dateOfBirth = luxon_1.DateTime.fromFormat(params.request.fields.find((field) => field.fieldName === "dateOfBirth").filter.replace(new RegExp("\\/", "g"), "."), "dd.MM.yyyy");
        const userData = await getUserDataFromMernis(uniqueId, dateOfBirth);
        return userData
            ? [
                {
                    id: null,
                    captionLines: [],
                    isUniqueMatch: true,
                    states: [],
                    searchFields: [],
                    suggestionType: restapi_1.SuggestionType.MERNIS,
                    autoFillFields: [
                        { name: "uniqueId", value: uniqueId },
                        { name: "name", value: userData },
                    ],
                },
            ]
            : null;
    }
    catch (error) {
        app_logs_1.logger.error("error while getting userData from mernis " + error.message);
        return null;
    }
};
const beforeUpsertVisitorImp = (request, settings) => {
    const uniqueId = request.fields.find((field) => field.name === "uniqueId").value;
    const uniqueIdMask = "***********".substring(0, 11 - settings.uniqueIdSettings.showNumberOfInitial - settings.uniqueIdSettings.showNumberOfLast);
    if (uniqueId.includes(uniqueIdMask)) {
        request.fields = request.fields.filter((field) => field.name !== "uniqueId");
    }
    return request;
};
exports.beforeUpsertVisitorImp = beforeUpsertVisitorImp;
