"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TemsanPPermissionManagementCustomReport = exports.generateReport = void 0;
const path_1 = __importDefault(require("path"));
const exceljs_1 = __importDefault(require("exceljs"));
const moment_1 = __importDefault(require("moment"));
const app_config_1 = require("../../../app.config");
const dal_manager_1 = require("../../../dal/dal.manager");
const uuid = require("uuid");
const i18n_1 = __importDefault(require("i18n"));
const app_logs_1 = require("../../../app.logs");
const app_enums_1 = require("../../../app.enums");
const generator_1 = require("../../../business/report/generator");
const business_report_export_1 = require("../../../business/report/business.report.export");
var Constants;
(function (Constants) {
    Constants.TimeFormat = "HH:mm";
    Constants.DateFormat = "dd.mm.yyyy";
    Constants.DateTimeFormat = "dd.mm.yyyy HH:mm";
    let Styling;
    (function (Styling) {
        Styling.AllThin = {
            right: {
                style: "thin",
            },
            left: {
                style: "thin",
            },
            bottom: {
                style: "thin",
            },
            top: {
                style: "thin",
            },
        };
        Styling.Dotted = {
            right: {
                style: "dotted",
            },
            left: {
                style: "dotted",
            },
            bottom: {
                style: "dotted",
            },
        };
        Styling.AllThinButRightThick = {
            right: {
                style: "thick",
            },
            left: {
                style: "thin",
            },
            bottom: {
                style: "thin",
            },
            top: {
                style: "thin",
            },
        };
    })(Styling = Constants.Styling || (Constants.Styling = {}));
    Constants.ColorCodes = {
        ON_TIME: "7C9923",
        TOLERATED: "D56626",
        NOT_TOLERATED: "A11913",
        PERMISSION: "4C2AA8",
    };
})(Constants || (Constants = {}));
async function generateReport(request, locale) {
    const report = new TemsanPPermissionManagementCustomReport(request, locale);
    return report.generateReport();
}
exports.generateReport = generateReport;
class TemsanPPermissionManagementCustomReport extends generator_1.CustomReportGenerator {
    constructor(request, locale) {
        super(request, locale);
        this._wb = new exceljs_1.default.Workbook();
        this._requestFilter = request.filter;
        this._options = {
            startDateTime: (0, moment_1.default)(this._requestFilter.filters.find((i) => i.type === app_enums_1.enums.CustomOrganizationReportFilterType.DateRange).value.startDay)
                .startOf("day")
                .toDate(),
            endDateTime: (0, moment_1.default)(this._requestFilter.filters.find((i) => i.type === app_enums_1.enums.CustomOrganizationReportFilterType.DateRange).value.endDay)
                .endOf("day")
                .toDate(),
            userIds: null,
            sortOrder: "DESC",
            sortType: app_enums_1.enums.PPermissionFilterSortType.PPermissionStart,
        };
    }
    async generateReport() {
        app_logs_1.logger.debug("Generating ppermission management custom report");
        this._organizationUnitsWithUsers = await dal_manager_1.dbManager.accessOrganizationUnit.listUsersWithOrganizationUnits(this._request.organizationId);
        this._data = await (0, business_report_export_1.generateListPPermissionsData)(this._request.organizationId, this._request.requesterUserId, this._options);
        this._organizationUnitsDetailed = [];
        this._filePath = await this.generatePPermissionManagementCustomReport();
        return {
            format: app_enums_1.enums.ReportFormat.Excel,
            preparedReportId: this._fileId,
            filePath: this._filePath,
            notificationType: undefined,
            reportType: app_enums_1.enums.ReportCode.PacsDailyWorkingHours,
            sendFileInAttachments: undefined,
            reportContainsEmptyData: this._request.reportTemplateId ? this._data.ppermissions.length === 0 : undefined,
        };
    }
    async generatePPermissionManagementCustomReport() {
        this._organizationBasic = await dal_manager_1.dbManager.accessOrganization.getOrganizationBasic(this._request.organizationId);
        this._wsGeneral = this._wb.addWorksheet(i18n_1.default.__({ phrase: "EXCEL-REPORT.GENERAL", locale: this._locale }), {
            pageSetup: { fitToPage: true, fitToWidth: 1, fitToHeight: 0, paperSize: 9, orientation: "landscape" },
        });
        this._wsGeneral.properties.defaultRowHeight = 15;
        this._generalRowIndex = 6;
        this._wsGeneral.headerFooter.oddHeader =
            "&L" +
                this._organizationBasic.name +
                " Mesai Tablo Değişiklikleri" +
                "\n" +
                "&C" +
                "Rapor Kapsamı : " +
                (0, moment_1.default)(this._options.startDateTime).format("DD.MM.YYYY") +
                " - " +
                (0, moment_1.default)(this._options.endDateTime).format("DD.MM.YYYY") +
                "&R" +
                i18n_1.default.__({ phrase: "EXCEL-REPORT.FILE_CREATION_DATE", locale: this._locale }) +
                " : " +
                (0, moment_1.default)().locale(this._locale).format("DD.MM.YYYY") +
                "\n";
        this._wsGeneral.headerFooter.oddFooter = i18n_1.default.__({ phrase: "EXCEL-REPORT.PAGE", locale: this._locale }) + " &P / &N" + "&R" + "&D  &T";
        this.initGeneralSheet(this._wsGeneral, 5, 1);
        let requestedUserCaption = await dal_manager_1.dbManager.accessUser.getUserOrganizationCaptionLines(this._request.organizationId, [this._request.requesterUserId]);
        if (requestedUserCaption.length < 1) {
            throw new Error("Not found");
        }
        if (requestedUserCaption[0].captionLines && requestedUserCaption[0].captionLines[0] && requestedUserCaption[0].captionLines[0].text !== null) {
            this._requestedUserCaption = requestedUserCaption[0].captionLines[0].text[0];
        }
        else {
            this._requestedUserCaption = "";
        }
        this._wb.creator = this._requestedUserCaption;
        app_logs_1.logger.debug("Generating report...");
        for (const item of this._data.ppermissions) {
            await this.addGeneralRow(item);
        }
        this.addFilterToSheet(this._wsGeneral, 1, 1);
        this._wsGeneral.pageSetup.printArea = "A6:" + this._wsGeneral.getColumn(this._wsGeneral.columns.length).letter + this._generalRowIndex;
        this._wsGeneral.pageSetup.printTitlesRow = "5:5";
        this._fileId = uuid.v4();
        this._filePath = path_1.default.join(app_config_1.appConfig.tmpDirectory, this._fileId + ".xlsx");
        await this._wb.xlsx.writeFile(this._filePath);
        app_logs_1.logger.debug("File is ready");
        return this._filePath;
    }
    initGeneralSheet(wsRaw, startRowIndex, startColIndex) {
        let columns = [];
        this.addInitCell(wsRaw, startRowIndex, startColIndex++, "Böl.", Constants.Styling.AllThin);
        columns.push({ width: 15 });
        this.addInitCell(wsRaw, startRowIndex, startColIndex++, "Bölüm Adı", Constants.Styling.AllThin);
        columns.push({ width: 50 });
        this.addInitCell(wsRaw, startRowIndex, startColIndex++, "Sicil No", Constants.Styling.AllThin);
        columns.push({ width: 15 });
        this.addInitCell(wsRaw, startRowIndex, startColIndex++, "Adı Soyadı", Constants.Styling.AllThin);
        columns.push({ width: 35 });
        this.addInitCell(wsRaw, startRowIndex, startColIndex++, "Baş. Tar.", Constants.Styling.AllThin);
        columns.push({ width: 20 });
        this.addInitCell(wsRaw, startRowIndex, startColIndex++, "Bit. Tar.", Constants.Styling.AllThin);
        columns.push({ width: 20 });
        this.addInitCell(wsRaw, startRowIndex, startColIndex++, "PG Tanım", Constants.Styling.AllThin);
        columns.push({ width: 40 });
        wsRaw.autoFilter = {
            from: "A" + startRowIndex,
            to: wsRaw.getColumn(columns.length).letter + startRowIndex,
        };
        wsRaw.columns = columns;
        wsRaw.views = [{ state: "frozen", ySplit: startRowIndex, activeCell: "A1", showGridLines: false }];
    }
    async addGeneralRow(row) {
        const users = row.userPPermissionInfo.map((up) => up.userAndDeputyInfo.user);
        for (const user of users) {
            const orgUnitIdAndUsers = this._organizationUnitsWithUsers.find((ou) => ou.userIds.includes(user.id));
            let orgUnitDetails = this._organizationUnitsDetailed.find((ou) => ou.id === orgUnitIdAndUsers?.organizationUnitId);
            if (!orgUnitDetails) {
                orgUnitDetails = await dal_manager_1.dbManager.accessOrganizationUnit.getOrganizationUnitBasic({
                    organizationId: this._request.organizationId,
                    organizationUnitId: orgUnitIdAndUsers.organizationUnitId,
                });
                this._organizationUnitsDetailed.push(orgUnitDetails);
            }
            let colIndex = 1;
            this.setDataCell({
                rowIndex: this._generalRowIndex,
                colIndex: colIndex++,
                value: (orgUnitDetails?.shortCode ?? ""),
                ws: this._wsGeneral,
                border: Constants.Styling.Dotted,
            });
            this.setDataCell({
                rowIndex: this._generalRowIndex,
                colIndex: colIndex++,
                value: (orgUnitDetails?.name ?? ""),
                ws: this._wsGeneral,
                border: Constants.Styling.Dotted,
            });
            this.setDataCell({
                rowIndex: this._generalRowIndex,
                colIndex: colIndex++,
                value: user.uniqueId,
                ws: this._wsGeneral,
                border: Constants.Styling.Dotted,
            });
            this.setDataCell({
                rowIndex: this._generalRowIndex,
                colIndex: colIndex++,
                value: user.fullname,
                ws: this._wsGeneral,
                border: Constants.Styling.Dotted,
            });
            this.setDataCell({
                rowIndex: this._generalRowIndex,
                colIndex: colIndex++,
                value: (0, moment_1.default)(row.dateRange.startDateTime).format("DD.MM.YYYY"),
                ws: this._wsGeneral,
                border: Constants.Styling.Dotted,
            });
            this.setDataCell({
                rowIndex: this._generalRowIndex,
                colIndex: colIndex++,
                value: (0, moment_1.default)(row.dateRange.endDateTime).format("DD.MM.YYYY"),
                ws: this._wsGeneral,
                border: Constants.Styling.Dotted,
            });
            this.setDataCell({
                rowIndex: this._generalRowIndex,
                colIndex: colIndex++,
                value: row.ppermissionType.name,
                ws: this._wsGeneral,
                border: Constants.Styling.Dotted,
            });
            this._generalRowIndex++;
        }
    }
    addInitCell(ws, row, col, value, border) {
        const c = ws.getCell(row, col);
        c.value = value;
        c.alignment = {
            horizontal: "center",
            vertical: "middle",
            wrapText: true,
        };
        c.font = {
            bold: true,
        };
        c.border = border;
    }
    setDataCell(params) {
        const c = params.ws.getCell(params.rowIndex, params.colIndex);
        c.value = params.value;
        c.alignment = {
            horizontal: "left",
            vertical: "middle",
            wrapText: true,
        };
        if (params.border) {
            c.border = params.border;
        }
        if (params.numFmt)
            c.numFmt = params.numFmt;
        if (params.backgroundColorCode)
            c.fill = {
                type: "pattern",
                pattern: "solid",
                fgColor: { argb: params.backgroundColorCode },
            };
        if (params.isTextWhite)
            c.font = {
                color: { argb: "FFFFFF" },
                bold: true,
            };
    }
    addFilterToSheet(ws, startRowIndex, startColIndex) {
        const border = {
            left: {
                style: "thin",
            },
            top: {
                style: "thin",
            },
            right: {
                style: "thin",
            },
            bottom: {
                style: "thin",
            },
        };
        this.addFilterCell(ws, startRowIndex, startColIndex, this._organizationBasic.name + " Mesai Tablo Değişiklikleri", border, { bold: true });
        this.addFilterCell(ws, startRowIndex + 1, startColIndex, "Raporun Alındığı Tarih", border);
        this.addFilterCell(ws, startRowIndex + 1, startColIndex + 1, {
            formula: "DATE(" + (0, moment_1.default)().year() + "," + ((0, moment_1.default)().month() + 1) + "," + (0, moment_1.default)().date() + ")",
        }, border, { italic: true }, Constants.DateFormat);
        ws.mergeCells(startRowIndex, startColIndex, startRowIndex, startColIndex + 2);
        ws.mergeCells(startRowIndex + 1, startColIndex + 1, startRowIndex + 1, startColIndex + 2);
        ws.mergeCells(startRowIndex + 2, startColIndex + 1, startRowIndex + 2, startColIndex + 2);
        this.addFilterCell(ws, startRowIndex + 2, startColIndex, "Rapor Kapsamı", border);
        this.addFilterCell(ws, startRowIndex + 2, startColIndex + 1, (0, moment_1.default)(this._options.startDateTime).format("DD.MM.YYYY") + " - " + (0, moment_1.default)(this._options.endDateTime).format("DD.MM.YYYY"), border);
    }
    addFilterCell(ws, row, col, value, border, font, numFmt) {
        const c = ws.getCell(row, col);
        c.value = value;
        c.alignment = {
            horizontal: "left",
            vertical: "middle",
            wrapText: true,
        };
        c.border = border;
        c.font = font;
        c.numFmt = numFmt;
    }
}
exports.TemsanPPermissionManagementCustomReport = TemsanPPermissionManagementCustomReport;
