"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.generateReport = exports.DailyFirstEntranceLastExitSummaryTARNETCustomReport = void 0;
const path_1 = __importDefault(require("path"));
const exceljs_1 = __importDefault(require("exceljs"));
const moment_1 = __importDefault(require("moment"));
const app_config_1 = require("../../../app.config");
const dal_manager_1 = require("../../../dal/dal.manager");
const dal_constants_1 = require("../../../dal/dal.constants");
const uuid = require("uuid");
const i18n_1 = __importDefault(require("i18n"));
const app_logs_1 = require("../../../app.logs");
const app_enums_1 = require("../../../app.enums");
const generator_1 = require("../../../business/report/generator");
var Constants;
(function (Constants) {
    Constants.TimeFormat = "HH:mm";
    Constants.DateFormat = "dd.mm.yyyy";
    Constants.DateTimeFormat = "dd.mm.yyyy HH:mm";
    let Styling;
    (function (Styling) {
        Styling.AllThin = {
            right: {
                style: "thin",
            },
            left: {
                style: "thin",
            },
            bottom: {
                style: "thin",
            },
            top: {
                style: "thin",
            },
        };
        Styling.Dotted = {
            right: {
                style: "dotted",
            },
            left: {
                style: "dotted",
            },
            bottom: {
                style: "dotted",
            },
            top: {
                style: "dotted",
            },
        };
        Styling.AllThinButRightThick = {
            right: {
                style: "thick",
            },
            left: {
                style: "thin",
            },
            bottom: {
                style: "thin",
            },
            top: {
                style: "thin",
            },
        };
        Styling.AllThick = {
            right: {
                style: "thick",
            },
            left: {
                style: "thick",
            },
            bottom: {
                style: "thick",
            },
            top: {
                style: "thick",
            },
        };
    })(Styling = Constants.Styling || (Constants.Styling = {}));
    Constants.ColorCodes = {
        ON_TIME: "62A325",
        PER_0_25: "B8C802",
        PER_25_50: "C8AE02",
        PER_50_75: "C87F02",
        PER_75_100: "C84B02",
        NOT_TOLERATED: "C80202",
    };
})(Constants || (Constants = {}));
class DailyFirstEntranceLastExitSummaryTARNETCustomReport extends generator_1.CustomReportGenerator {
    constructor(request, locale) {
        super(request, locale);
        this._wb = new exceljs_1.default.Workbook();
        this._request = request;
        this._filter = request.filter;
        this._options = {
            dateRange: {
                startDateTime: (0, moment_1.default)(this._filter.filters.find((i) => i.type === app_enums_1.enums.CustomOrganizationReportFilterType.DateRange).value.startDay)
                    .startOf("day")
                    .toDate(),
                endDateTime: (0, moment_1.default)(this._filter.filters.find((i) => i.type === app_enums_1.enums.CustomOrganizationReportFilterType.DateRange).value.endDay)
                    .endOf("day")
                    .toDate(),
            },
            userFilter: {
                organizationUnitIds: this._filter.filters.find((i) => i.type === app_enums_1.enums.CustomOrganizationReportFilterType.OrganizationUnit).value,
                applyOrganizationUnitFilterHierarchically: this._filter.filters.find((i) => i.type === app_enums_1.enums.CustomOrganizationReportFilterType.OrganizationUnitHierarchically).value,
                userGroupIds: this._filter.filters.find((i) => i.type === app_enums_1.enums.CustomOrganizationReportFilterType.UserGroup).value,
                userIds: this._filter.filters.find((i) => i.type === app_enums_1.enums.CustomOrganizationReportFilterType.UserIdFromFreeSearch).value,
                workPlanIds: this._filter.filters.find((i) => i.type === app_enums_1.enums.CustomOrganizationReportFilterType.WorkPlan).value,
                userOrganizationStatus: app_enums_1.enums.IdentityStatusType.All,
            },
            sortType: app_enums_1.enums.WorkSummarySortType.Name,
            sortOrder: "DESC",
        };
        this._userIdsWithCaptions = [];
        this._organizationUnitsOrdered = [];
    }
    async generateReport() {
        let dataSummary = await dal_manager_1.dbManager.accessPacs2.getFirstInLastOutSummaryForUsers(this._request.organizationId, this._request.requesterUserId, {
            startDate: this._options.dateRange.startDateTime,
            endDate: this._options.dateRange.endDateTime,
            organizationUnitIds: this._options.userFilter.organizationUnitIds,
            organizationUnitHierarchically: this._options.userFilter.applyOrganizationUnitFilterHierarchically,
            userGroupIds: this._options.userFilter.userGroupIds,
            userIds: this._options.userFilter.userIds,
            workPlanIds: this._options.userFilter.workPlanIds,
            status: this._options.userFilter.userOrganizationStatus,
            sortType: this._options.sortType,
            workStatusFilter: this._options.userFilter.workStatusFilter,
            take: null,
            skip: null,
            sortOrder: ["ASC", "DESC"].includes(this._options.sortOrder) ? this._options.sortOrder : "DESC",
        });
        this._itemsSummary = dataSummary.items;
        let organizationUnitIds = [];
        if (this._itemsSummary && this._itemsSummary.length > 0) {
            for (const element of this._itemsSummary) {
                if (element.organizationUnitIds && element.organizationUnitIds.length > 0) {
                    for (const orgUnit of element.organizationUnitIds) {
                        if (!organizationUnitIds.includes(orgUnit) && orgUnit) {
                            organizationUnitIds.push(orgUnit);
                        }
                    }
                }
            }
        }
        this._organizationUnits = await dal_manager_1.dbManager.accessOrganizationUnit.listOrganizationUnits(this._request.organizationId, {
            take: null,
            skip: null,
            organizationUnitIds: organizationUnitIds,
        });
        await this.getOrderedOrganizationUnits();
        this._filePath = await this.generateDailyFirstInLastOutReport();
        return {
            format: app_enums_1.enums.ReportFormat.Excel,
            preparedReportId: this._fileId,
            filePath: this._filePath,
            notificationType: undefined,
            reportType: app_enums_1.enums.ReportCode.CustomReport,
            sendFileInAttachments: undefined,
            customReportName: "Gübretaş Günlük Giriş Çıkış Raporu",
        };
    }
    async getOrderedOrganizationUnits() {
        this._organizationUnitsAtRootLevel = await dal_manager_1.dbManager.accessOrganizationUnit.getOrganizationUnitsAtRootLevel({ organizationId: this._request.organizationId });
        for (const root of this._organizationUnitsAtRootLevel) {
            await this.getChildrenRecursively(root);
        }
    }
    async getChildrenRecursively(organizationUnit) {
        const organizationUnitsOrdered = await dal_manager_1.dbManager.accessOrganizationUnit.getChildrenOfOrganizationUnit({
            organizationId: this._request.organizationId,
            organizationUnitId: organizationUnit.id,
        });
        if (organizationUnitsOrdered && organizationUnitsOrdered.length > 0) {
            this._organizationUnitsOrdered.push(organizationUnit);
            for (const unit of organizationUnitsOrdered) {
                await this.getChildrenRecursively(unit);
            }
        }
        else {
            this._organizationUnitsOrdered.push(organizationUnit);
        }
    }
    async generateDailyFirstInLastOutReport() {
        this._organizationBasic = await dal_manager_1.dbManager.accessOrganization.getOrganizationBasic(this._request.organizationId);
        this._wsGeneral = this._wb.addWorksheet(i18n_1.default.__({ phrase: "EXCEL-REPORT.GENERAL", locale: this._locale }), {
            pageSetup: { fitToPage: true, fitToWidth: 1, fitToHeight: 0, paperSize: 9, orientation: "landscape" },
        });
        this._wsGeneral.properties.defaultRowHeight = 15;
        this._generalRowIndex = 6;
        this._wsGeneral.headerFooter.oddHeader =
            "&L" +
                this._organizationBasic.name +
                " " +
                i18n_1.default.__({ phrase: "EXCEL-REPORT.DAILY_FIRST_IN_LAST_OUT_SUMMARY", locale: this._locale }) +
                "\n" +
                "&R" +
                i18n_1.default.__({ phrase: "EXCEL-REPORT.DATE", locale: this._locale }) +
                " : " +
                (0, moment_1.default)(this._options.dateRange.endDateTime).locale(this._locale).format("LL") +
                " - " +
                (0, moment_1.default)(this._options.dateRange.endDateTime).locale(this._locale).format("LL") +
                "\n";
        this._wsGeneral.headerFooter.oddFooter = i18n_1.default.__({ phrase: "EXCEL-REPORT.PAGE", locale: this._locale }) + " &P / &N" + "&R" + "&D  &T";
        this.initGeneralSheet(this._wsGeneral, 5, 1);
        let requestedUserCaption = await dal_manager_1.dbManager.accessUser.getUserOrganizationCaptionLines(this._request.organizationId, [this._request.requesterUserId]);
        if (requestedUserCaption.length < 1) {
            throw new Error("Not found");
        }
        if (requestedUserCaption[0].captionLines && requestedUserCaption[0].captionLines[0] && requestedUserCaption[0].captionLines[0].text !== null) {
            this._requestedUserCaption = requestedUserCaption[0].captionLines[0].text[0];
        }
        else {
            this._requestedUserCaption = "";
        }
        this._wb.creator = this._requestedUserCaption;
        app_logs_1.logger.debug("Generating TARNET first in last out custom report");
        app_logs_1.logger.debug("Fetching data of %s rows", this._itemsSummary.length);
        const userIds = this._itemsSummary.map((item) => item.userId);
        if (this._organizationUnits.items?.length > 0 && this._organizationUnitsOrdered?.length > 0) {
            const filter = {
                dateRange: {
                    startDateTime: this._options.dateRange.startDateTime,
                    endDateTime: this._options.dateRange.endDateTime,
                },
                userIds,
            };
            const userDatas = await dal_manager_1.dbManager.accessPacs2.getDailySummaryReportForMultipleUser(this._request.organizationId, filter);
            for (const orgUnit of this._organizationUnitsOrdered) {
                const unit = this._organizationUnits.items.find((ou) => ou.id === orgUnit.id);
                if (!unit)
                    continue;
                this._generalRowIndex += 5;
                this.addOrganizationUnitCell(this._wsGeneral, unit.captionLines[0]);
                this._generalRowIndex += 2;
                for (const item of this._itemsSummary) {
                    if (item.organizationUnitIds.includes(orgUnit.id)) {
                        const userData = userDatas.find((userData) => userData.userId === item.userId);
                        this._userIdsWithCaptions.push({
                            userId: item.userId,
                            userCaptions: item.userCaptions,
                        });
                        for (let dayInfo of userData.items) {
                            this.addGeneralRow(dayInfo, userData.userCaptions);
                        }
                        this._generalRowIndex += 3;
                    }
                }
            }
        }
        let checkNullOrgUnit = false;
        for (const item of this._itemsSummary) {
            if (!item.organizationUnitIds) {
                checkNullOrgUnit = true;
                break;
            }
        }
        if (checkNullOrgUnit) {
            this._generalRowIndex += 5;
            this.addOrganizationUnitCell(this._wsGeneral, i18n_1.default.__({ phrase: "EXCEL-REPORT.USERS_WITHOUT_ORGANIZATION_UNIT", locale: this._locale }));
            this._generalRowIndex += 2;
            const filter = {
                dateRange: {
                    startDateTime: this._options.dateRange.startDateTime,
                    endDateTime: this._options.dateRange.endDateTime,
                },
                userIds,
            };
            const userDatas = await dal_manager_1.dbManager.accessPacs2.getDailySummaryReportForMultipleUser(this._request.organizationId, filter);
            for (const item of this._itemsSummary) {
                if (!item.organizationUnitIds) {
                    const userData = userDatas.find((userData) => userData.userId === item.userId);
                    this._userIdsWithCaptions.push({
                        userId: item.userId,
                        userCaptions: item.userCaptions,
                    });
                    for (let dayInfo of userData.items) {
                        this.addGeneralRow(dayInfo, userData.userCaptions);
                    }
                    this._generalRowIndex += 3;
                }
            }
        }
        let filters = [];
        if (this._options.userFilter.userOrganizationStatus) {
            filters.push(i18n_1.default.__({ phrase: "EXCEL-REPORT.USER_STATUS", locale: this._locale }) +
                " : " +
                i18n_1.default.__({ phrase: "EXCEL-REPORT." + dal_constants_1.DalConstants.IdentityStatusType[this._options.userFilter.userOrganizationStatus].toUpperCase(), locale: this._locale }));
        }
        if (this._options.userFilter.workStatusFilter) {
            this._options.userFilter.workStatusFilter.forEach((workStatusFilter) => {
                filters.push(i18n_1.default.__({ phrase: "EXCEL-REPORT.WORK_STATUS", locale: this._locale }) +
                    " : " +
                    i18n_1.default.__({ phrase: "EXCEL-REPORT." + dal_constants_1.DalConstants.WorkStatusFilter[workStatusFilter].toUpperCase(), locale: this._locale }));
            });
        }
        if (this._options.userFilter.organizationUnitIds && this._options.userFilter.organizationUnitIds.length > 0) {
            let organizationUnitNames = await dal_manager_1.dbManager.accessOrganizationUnit.getIdNamePairsOfOrganizationUnits(this._request.organizationId, this._options.userFilter.organizationUnitIds);
            filters.push(i18n_1.default.__({ phrase: "EXCEL-REPORT.ORGANIZATION_UNITS", locale: this._locale }) + " : " + organizationUnitNames.map((oun) => oun.name).join(", "));
            if (this._options.userFilter.applyOrganizationUnitFilterHierarchically) {
                filters.push(i18n_1.default.__({ phrase: "EXCEL-REPORT.INCLUDE_DESCENDANTS", locale: this._locale }) + " : " + i18n_1.default.__({ phrase: "EXCEL-REPORT.YES", locale: this._locale }));
            }
        }
        if (this._options.userFilter.userGroupIds && this._options.userFilter.userGroupIds.length > 0) {
            let userGroupNames = await dal_manager_1.dbManager.accessUserGroup.listUserGroupsByIds(this._request.organizationId, this._options.userFilter.userGroupIds);
            filters.push(i18n_1.default.__({ phrase: "EXCEL-REPORT.USER_GROUPS", locale: this._locale }) + " : " + userGroupNames.map((ugn) => ugn.name).join(", "));
        }
        if (this._options.userFilter.workPlanIds && this._options.userFilter.workPlanIds.length > 0) {
            this._workplans = await dal_manager_1.dbManager.accessPacs.listWorkPlanByIds(this._request.organizationId, this._options.userFilter.workPlanIds);
            let workplanNames = this._workplans.items.filter((wp) => this._options.userFilter.workPlanIds.includes(wp.id)).map((wp) => wp.name);
            filters.push(i18n_1.default.__({ phrase: "REPORT.WORKPLANS", locale: this._locale }) + " : " + workplanNames.join(", "));
        }
        if (this._options.userFilter.userIds && this._options.userFilter.userIds.length > 0) {
            let userNames = this._userIdsWithCaptions.filter((i) => this._options.userFilter.userIds.includes(i.userId)).map((i) => i.userCaptions[0].text[0]);
            filters.push(i18n_1.default.__({ phrase: "PDF-REPORT.IDENTITES", locale: this._locale }) + " : " + userNames.join(", "));
        }
        app_logs_1.logger.debug("\n\nApplied Filters:\n");
        app_logs_1.logger.debug(filters.join("\r\n"));
        app_logs_1.logger.debug("\n\n");
        this.addFilterToSheet(this._wsGeneral, 1, 1, filters.join("\r\n"), filters.length);
        this._wsGeneral.pageSetup.printArea = "A1:" + this._wsGeneral.getColumn(this._wsGeneral.columns.length).letter + this._generalRowIndex;
        this._wsGeneral.pageSetup.printTitlesRow = "5:5";
        this._fileId = uuid.v4();
        this._filePath = path_1.default.join(app_config_1.appConfig.tmpDirectory, this._fileId + ".xlsx");
        await this._wb.xlsx.writeFile(this._filePath);
        app_logs_1.logger.debug("File is ready -> " + this._filePath);
        return this._filePath;
    }
    initGeneralSheet(wsRaw, startRowIndex, startColIndex) {
        let columns = [];
        this.addInitCell(wsRaw, startRowIndex, startColIndex++, i18n_1.default.__({ phrase: "EXCEL-REPORT.DATE", locale: this._locale }), Constants.Styling.AllThin);
        columns.push({ width: 35 });
        this.addInitCell(wsRaw, startRowIndex, startColIndex++, i18n_1.default.__({ phrase: "EXCEL-REPORT.name_surname", locale: this._locale }), Constants.Styling.AllThin);
        columns.push({ width: 35 });
        this.addInitCell(wsRaw, startRowIndex, startColIndex++, i18n_1.default.__({ phrase: "EXCEL-REPORT.UNIQUE_ID", locale: this._locale }), Constants.Styling.AllThin);
        columns.push({ width: 20 });
        this.addInitCell(wsRaw, startRowIndex, startColIndex++, i18n_1.default.__({ phrase: "EXCEL-REPORT.FIRST_START", locale: this._locale }), Constants.Styling.AllThin);
        columns.push({ width: 20 });
        this.addInitCell(wsRaw, startRowIndex, startColIndex++, i18n_1.default.__({ phrase: "EXCEL-REPORT.LAST_LEAVE", locale: this._locale }), Constants.Styling.AllThin);
        columns.push({ width: 20 });
        this.addInitCell(wsRaw, startRowIndex, startColIndex++, i18n_1.default.__({ phrase: "EXCEL-REPORT.STATUS", locale: this._locale }), Constants.Styling.AllThin);
        columns.push({ width: 20 });
        this.addInitCell(wsRaw, startRowIndex, startColIndex++, i18n_1.default.__({ phrase: "EXCEL-REPORT.EXPECTED_ENTRANCE", locale: this._locale }), Constants.Styling.AllThin);
        columns.push({ width: 20 });
        this.addInitCell(wsRaw, startRowIndex, startColIndex++, i18n_1.default.__({ phrase: "EXCEL-REPORT.EXPECTED_EXIT", locale: this._locale }), Constants.Styling.AllThin);
        columns.push({ width: 20 });
        this.addInitCell(wsRaw, startRowIndex, startColIndex++, i18n_1.default.__({ phrase: "EXCEL-REPORT.ENTRANCE_PENALTY_TIME", locale: this._locale }), Constants.Styling.AllThin);
        columns.push({ width: 20 });
        this.addInitCell(wsRaw, startRowIndex, startColIndex++, i18n_1.default.__({ phrase: "EXCEL-REPORT.MISSING_WORK", locale: this._locale }), Constants.Styling.AllThin);
        columns.push({ width: 20 });
        this.addInitCell(wsRaw, startRowIndex, startColIndex++, i18n_1.default.__({ phrase: "EXCEL-REPORT.OVERTIME", locale: this._locale }), Constants.Styling.AllThin);
        columns.push({ width: 20 });
        this.addInitCell(wsRaw, startRowIndex, startColIndex++, i18n_1.default.__({ phrase: "EXCEL-REPORT.NET_EXTRA_WORKING", locale: this._locale }), Constants.Styling.AllThin);
        columns.push({ width: 20 });
        this.addInitCell(wsRaw, startRowIndex, startColIndex++, i18n_1.default.__({ phrase: "EXCEL-REPORT.TOTAL_WORKING", locale: this._locale }), Constants.Styling.AllThin);
        columns.push({ width: 20 });
        wsRaw.autoFilter = {
            from: "A" + startRowIndex,
            to: wsRaw.getColumn(columns.length).letter + startRowIndex,
        };
        wsRaw.columns = columns;
        wsRaw.views = [{ state: "frozen", ySplit: startRowIndex, activeCell: "A1", showGridLines: false }];
    }
    addInitCell(ws, row, col, value, border) {
        let c = ws.getCell(row, col);
        c.value = value;
        c.alignment = {
            horizontal: "center",
            vertical: "middle",
            wrapText: true,
        };
        c.font = {
            bold: true,
        };
        c.border = border;
    }
    checkNull(item) {
        if (item) {
            return item;
        }
        else {
            return "";
        }
    }
    addGeneralRow(row, userCaptions) {
        let colIndex = 1;
        this.setDataCell({
            rowIndex: this._generalRowIndex,
            colIndex: colIndex++,
            value: (0, moment_1.default)(row.date).locale(this._locale).format("LL"),
            ws: this._wsGeneral,
            border: Constants.Styling.Dotted,
        });
        this.setDataCell({
            rowIndex: this._generalRowIndex,
            colIndex: colIndex++,
            value: userCaptions[0].text[0].toUpperCase(),
            ws: this._wsGeneral,
            border: Constants.Styling.Dotted,
        });
        this.setDataCell({
            rowIndex: this._generalRowIndex,
            colIndex: colIndex++,
            value: userCaptions[1].text[0],
            ws: this._wsGeneral,
            border: Constants.Styling.Dotted,
        });
        this.setDataCell({
            rowIndex: this._generalRowIndex,
            colIndex: colIndex++,
            value: row.firstIn && row.firstIn.actionUtc ? (0, moment_1.default)(row.firstIn.actionUtc).format("HH:mm") : "",
            ws: this._wsGeneral,
            border: Constants.Styling.Dotted,
            numFmt: row.firstIn && row.firstIn.actionUtc ? Constants.TimeFormat : null,
        });
        this.setDataCell({
            rowIndex: this._generalRowIndex,
            colIndex: colIndex++,
            value: row.lastOut && row.lastOut.actionUtc ? (0, moment_1.default)(row.lastOut.actionUtc).format("HH:mm") : "",
            ws: this._wsGeneral,
            border: Constants.Styling.Dotted,
            numFmt: row.lastOut && row.lastOut.actionUtc ? Constants.TimeFormat : null,
        });
        this.setDataCell({
            rowIndex: this._generalRowIndex,
            colIndex: colIndex++,
            value: row.firstIn && row.firstIn.actionUtc
                ? i18n_1.default.__({ phrase: "EXCEL-REPORT.ARRIVED", locale: this._locale })
                : i18n_1.default.__({ phrase: "EXCEL-REPORT.NOT_ARRIVED", locale: this._locale }),
            ws: this._wsGeneral,
            border: Constants.Styling.Dotted,
            numFmt: null,
            backgroundColorCode: this.findColorCodeByPerformance(row),
            isTextWhite: true,
        });
        this.setDataCell({
            rowIndex: this._generalRowIndex,
            colIndex: colIndex++,
            value: row.workPlan.startOfWorkUtc ? (0, moment_1.default)(row.workPlan.startOfWorkUtc).format("HH:mm") : "",
            ws: this._wsGeneral,
            border: Constants.Styling.Dotted,
            numFmt: row.workPlan.startOfWorkUtc ? Constants.TimeFormat : null,
        });
        this.setDataCell({
            rowIndex: this._generalRowIndex,
            colIndex: colIndex++,
            value: row.workPlan.endOfWorkUtc ? (0, moment_1.default)(row.workPlan.endOfWorkUtc).format("HH:mm") : "",
            ws: this._wsGeneral,
            border: Constants.Styling.Dotted,
            numFmt: row.workPlan.endOfWorkUtc ? Constants.TimeFormat : null,
        });
        this.setDataCell({
            rowIndex: this._generalRowIndex,
            colIndex: colIndex++,
            value: row.entrancePenaltyTimeInSeconds ? (Math.round(row.entrancePenaltyTimeInSeconds / 60) / (24 * 60)) : null,
            ws: this._wsGeneral,
            border: Constants.Styling.Dotted,
            numFmt: row.entrancePenaltyTimeInSeconds
                ? '[<0.000694444]"";[<0.0415][m]" ' +
                    i18n_1.default.__({ phrase: "EXCEL-REPORT.MINUTE_ABBREVATION", locale: this._locale }) +
                    '";[h] "' +
                    i18n_1.default.__({ phrase: "EXCEL-REPORT.HOUR_ABBREVATION", locale: this._locale }) +
                    ' " m "' +
                    i18n_1.default.__({ phrase: "EXCEL-REPORT.MINUTE_ABBREVATION", locale: this._locale }) +
                    '"'
                : null,
        });
        this.setDataCell({
            rowIndex: this._generalRowIndex,
            colIndex: colIndex++,
            value: row.missingWorkInMinutes ? (row.missingWorkInMinutes / (24 * 60)) : null,
            ws: this._wsGeneral,
            border: Constants.Styling.Dotted,
            numFmt: row.missingWorkInMinutes
                ? '[<0.000694444]"";[<0.0415][m]" ' +
                    i18n_1.default.__({ phrase: "EXCEL-REPORT.MINUTE_ABBREVATION", locale: this._locale }) +
                    '";[h] "' +
                    i18n_1.default.__({ phrase: "EXCEL-REPORT.HOUR_ABBREVATION", locale: this._locale }) +
                    ' " m "' +
                    i18n_1.default.__({ phrase: "EXCEL-REPORT.MINUTE_ABBREVATION", locale: this._locale }) +
                    '"'
                : null,
        });
        this.setDataCell({
            rowIndex: this._generalRowIndex,
            colIndex: colIndex++,
            value: row.extraWorkInMinutes ? (row.extraWorkInMinutes / (24 * 60)) : null,
            ws: this._wsGeneral,
            border: Constants.Styling.Dotted,
            numFmt: row.extraWorkInMinutes
                ? '[<0.000694444]"";[<0.0415][m]" ' +
                    i18n_1.default.__({ phrase: "EXCEL-REPORT.MINUTE_ABBREVATION", locale: this._locale }) +
                    '";[h] "' +
                    i18n_1.default.__({ phrase: "EXCEL-REPORT.HOUR_ABBREVATION", locale: this._locale }) +
                    ' " m "' +
                    i18n_1.default.__({ phrase: "EXCEL-REPORT.MINUTE_ABBREVATION", locale: this._locale }) +
                    '"'
                : null,
        });
        this.setDataCell({
            rowIndex: this._generalRowIndex,
            colIndex: colIndex++,
            value: row.extraWorkInMinutes && row.missingWorkInMinutes && row.extraWorkInMinutes > row.missingWorkInMinutes
                ? ((row.extraWorkInMinutes - row.missingWorkInMinutes) / (24 * 60))
                : null,
            ws: this._wsGeneral,
            border: Constants.Styling.Dotted,
            numFmt: row.extraWorkInMinutes
                ? '[<0.000694444]"";[<0.0415][m]" ' +
                    i18n_1.default.__({ phrase: "EXCEL-REPORT.MINUTE_ABBREVATION", locale: this._locale }) +
                    '";[h] "' +
                    i18n_1.default.__({ phrase: "EXCEL-REPORT.HOUR_ABBREVATION", locale: this._locale }) +
                    ' " m "' +
                    i18n_1.default.__({ phrase: "EXCEL-REPORT.MINUTE_ABBREVATION", locale: this._locale }) +
                    '"'
                : null,
        });
        this.setDataCell({
            rowIndex: this._generalRowIndex,
            colIndex: colIndex++,
            value: row.normalWork && row.extraWorkInMinutes ? ((row.normalWork + row.extraWorkInMinutes) / (24 * 60)) : null,
            ws: this._wsGeneral,
            border: Constants.Styling.Dotted,
            numFmt: row.extraWorkInMinutes
                ? '[<0.000694444]"";[<0.0415][m]" ' +
                    i18n_1.default.__({ phrase: "EXCEL-REPORT.MINUTE_ABBREVATION", locale: this._locale }) +
                    '";[h] "' +
                    i18n_1.default.__({ phrase: "EXCEL-REPORT.HOUR_ABBREVATION", locale: this._locale }) +
                    ' " m "' +
                    i18n_1.default.__({ phrase: "EXCEL-REPORT.MINUTE_ABBREVATION", locale: this._locale }) +
                    '"'
                : null,
        });
        this._generalRowIndex++;
    }
    setDataCell(params) {
        let c = params.ws.getCell(params.rowIndex, params.colIndex);
        c.value = params.value;
        c.alignment = {
            horizontal: "left",
            vertical: "middle",
            wrapText: true,
        };
        if (params.border) {
            c.border = params.border;
        }
        if (params.numFmt)
            c.numFmt = params.numFmt;
        if (params.backgroundColorCode)
            c.fill = {
                type: "pattern",
                pattern: "solid",
                fgColor: { argb: params.backgroundColorCode },
            };
        if (params.isTextWhite)
            c.font = {
                color: { argb: "FFFFFF" },
                bold: true,
            };
    }
    findColorCodeByPerformance(employeeData) {
        let colorCode = null;
        if (employeeData.firstIn && employeeData.firstIn.actionUtc) {
            if (employeeData.entrancePenaltyTimeInSeconds > 0) {
                let percentage = employeeData.entrancePenaltyTimeInSeconds / 60 / employeeData.entranceTolerance;
                if (percentage > 1) {
                    colorCode = Constants.ColorCodes.NOT_TOLERATED;
                }
                else if (percentage > 0.75) {
                    colorCode = Constants.ColorCodes.PER_75_100;
                }
                else if (percentage > 0.5) {
                    colorCode = Constants.ColorCodes.PER_50_75;
                }
                else if (percentage > 0.25) {
                    colorCode = Constants.ColorCodes.PER_25_50;
                }
                else if (percentage > 0) {
                    colorCode = Constants.ColorCodes.PER_0_25;
                }
            }
            else {
                colorCode = Constants.ColorCodes.ON_TIME;
            }
        }
        else {
            if (employeeData.workPlan.startOfWorkUtc) {
                colorCode = Constants.ColorCodes.NOT_TOLERATED;
            }
        }
        return colorCode;
    }
    addFilterToSheet(ws, startRowIndex, startColIndex, filter, filterlength) {
        let border = {
            left: {
                style: "thin",
            },
            top: {
                style: "thin",
            },
            right: {
                style: "thin",
            },
            bottom: {
                style: "thin",
            },
        };
        this.addFilterCell(ws, startRowIndex, startColIndex, this._organizationBasic.name + " " + i18n_1.default.__({ phrase: "EXCEL-REPORT.DAILY_FIRST_IN_LAST_OUT_SUMMARY", locale: this._locale }), border, { bold: true });
        this.addFilterCell(ws, startRowIndex + 1, startColIndex, i18n_1.default.__({ phrase: "EXCEL-REPORT.DATE", locale: this._locale }), border);
        this.addFilterCell(ws, startRowIndex + 1, startColIndex + 1, (0, moment_1.default)(this._options.dateRange.startDateTime).locale(this._locale).format("LL") + " - " + (0, moment_1.default)(this._options.dateRange.endDateTime).locale(this._locale).format("LL"), border, { italic: true }, Constants.DateFormat);
        ws.mergeCells(startRowIndex, startColIndex, startRowIndex, startColIndex + 2);
        ws.mergeCells(startRowIndex + 1, startColIndex + 1, startRowIndex + 1, startColIndex + 2);
        ws.mergeCells(startRowIndex + 2, startColIndex + 1, startRowIndex + 2, startColIndex + 2);
        this.addFilterCell(ws, startRowIndex + 2, startColIndex, i18n_1.default.__({ phrase: "EXCEL-REPORT.APPLIED_FILTERS", locale: this._locale }), border);
        this.addFilterCell(ws, startRowIndex + 2, startColIndex + 1, filter, border);
        if (filterlength) {
            let row = ws.getRow(startRowIndex + 2);
            row.height = filterlength * 20;
        }
    }
    addFilterCell(ws, row, col, value, border, font, numFmt) {
        let c = ws.getCell(row, col);
        c.value = value;
        c.alignment = {
            horizontal: "left",
            vertical: "middle",
            wrapText: true,
        };
        c.border = border;
        c.font = font;
        c.numFmt = numFmt;
    }
    addOrganizationUnitCell(ws, value) {
        let colIndex = 1;
        ws.mergeCells(this._generalRowIndex, colIndex, this._generalRowIndex, colIndex + 12);
        let c = ws.getCell(this._generalRowIndex, colIndex);
        c.value = value;
        c.alignment = {
            horizontal: "center",
            vertical: "middle",
            wrapText: true,
        };
        c.border = Constants.Styling.AllThick;
    }
    addOrganizationUnitRootCell(ws, value) {
        let colIndex = 1;
        ws.mergeCells(this._generalRowIndex, colIndex, this._generalRowIndex, colIndex + 12);
        let c = ws.getCell(this._generalRowIndex, colIndex);
        c.value = value;
        c.alignment = {
            horizontal: "center",
            vertical: "middle",
            wrapText: true,
        };
        c.border = Constants.Styling.Dotted;
    }
}
exports.DailyFirstEntranceLastExitSummaryTARNETCustomReport = DailyFirstEntranceLastExitSummaryTARNETCustomReport;
async function generateReport(request, locale) {
    let report = new DailyFirstEntranceLastExitSummaryTARNETCustomReport(request, locale);
    return report.generateReport();
}
exports.generateReport = generateReport;
