"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.generateReport = exports.TKMarketJHRCustomReport = void 0;
const path_1 = __importDefault(require("path"));
const exceljs_1 = __importDefault(require("exceljs"));
const moment_1 = __importDefault(require("moment"));
const luxon_1 = require("luxon");
const app_config_1 = require("../../../app.config");
const dal_manager_1 = require("../../../dal/dal.manager");
const uuid = require("uuid");
const app_logs_1 = require("../../../app.logs");
const app_enums_1 = require("../../../app.enums");
const generator_1 = require("../../../business/report/generator");
const dal_constants_1 = require("../../../dal/dal.constants");
const dal_access_psql_common_1 = require("../../../dal/access/psql/dal.access.psql.common");
const fs_1 = __importDefault(require("fs"));
const dal_db_armon_schema_1 = require("../../../dal/db/armon/dal.db.armon.schema");
const controller_report_1 = require("../../../api/pacs/v2/controllers/controller.report");
var Constants;
(function (Constants) {
    Constants.HeadersStyling = {
        v1: {
            alignment: {
                horizontal: "center",
                vertical: "bottom",
                wrapText: true,
            },
            font: {
                bold: false,
                size: 10,
                name: "Arial",
                color: { argb: "006100" },
            },
            border: {
                right: {
                    style: "thin",
                    color: { argb: "000000" },
                },
                left: {
                    style: "thin",
                    color: { argb: "000000" },
                },
                bottom: {
                    style: "thin",
                    color: { argb: "000000" },
                },
                top: {
                    style: "thin",
                    color: { argb: "000000" },
                },
            },
            fill: {
                type: "pattern",
                pattern: "solid",
                fgColor: { argb: "FFFF00" },
            },
        },
        v2: {
            alignment: {
                horizontal: "center",
                vertical: "bottom",
                wrapText: true,
            },
            font: {
                bold: false,
                size: 10,
                name: "Arial",
                color: { argb: "006100" },
            },
            border: {
                right: {
                    style: "thin",
                    color: { argb: "000000" },
                },
                left: {
                    style: "thin",
                    color: { argb: "000000" },
                },
                bottom: {
                    style: "thin",
                    color: { argb: "000000" },
                },
                top: {
                    style: "thin",
                    color: { argb: "000000" },
                },
            },
            fill: {
                type: "pattern",
                pattern: "solid",
                fgColor: { argb: "F1CEEE" },
            },
        },
        v3: {
            alignment: {
                horizontal: "center",
                vertical: "bottom",
                wrapText: true,
            },
            font: {
                bold: false,
                size: 10,
                name: "Arial",
                color: { argb: "006100" },
            },
            border: {
                right: {
                    style: "thin",
                    color: { argb: "000000" },
                },
                left: {
                    style: "thin",
                    color: { argb: "000000" },
                },
                bottom: {
                    style: "thin",
                    color: { argb: "000000" },
                },
                top: {
                    style: "thin",
                    color: { argb: "000000" },
                },
            },
            fill: {
                type: "pattern",
                pattern: "solid",
                fgColor: { argb: "F1A983" },
            },
        },
        v4: {
            alignment: {
                horizontal: "center",
                vertical: "bottom",
                wrapText: true,
            },
            font: {
                bold: false,
                size: 10,
                name: "Arial",
                color: { argb: "006100" },
            },
            border: {
                right: {
                    style: "thin",
                    color: { argb: "000000" },
                },
                left: {
                    style: "thin",
                    color: { argb: "000000" },
                },
                bottom: {
                    style: "thin",
                    color: { argb: "000000" },
                },
                top: {
                    style: "thin",
                    color: { argb: "000000" },
                },
            },
            fill: {
                type: "pattern",
                pattern: "solid",
                fgColor: { argb: "47D45A" },
            },
        },
        v5: {
            alignment: {
                horizontal: "center",
                vertical: "bottom",
                wrapText: true,
            },
            font: {
                bold: false,
                size: 10,
                name: "Arial",
                color: { argb: "006100" },
            },
            border: {
                right: {
                    style: "thin",
                    color: { argb: "000000" },
                },
                left: {
                    style: "thin",
                    color: { argb: "000000" },
                },
                bottom: {
                    style: "thin",
                    color: { argb: "000000" },
                },
                top: {
                    style: "thin",
                    color: { argb: "000000" },
                },
            },
            fill: {
                type: "pattern",
                pattern: "solid",
                fgColor: { argb: "FFFFFF" },
            },
        },
    };
    let PermissionTypeIds;
    (function (PermissionTypeIds) {
        PermissionTypeIds["PublicDay"] = "2d730102-23bd-47d1-91b1-8f331b5b6b7b";
        PermissionTypeIds["WeeklyDay"] = "f985d5df-c274-42f5-b92c-3788e2557b45";
        PermissionTypeIds["AbsentDay"] = "b959736b-c620-4dbe-ac6d-85979bb1a412";
    })(PermissionTypeIds = Constants.PermissionTypeIds || (Constants.PermissionTypeIds = {}));
    let Workstyle;
    (function (Workstyle) {
        Workstyle[Workstyle["PartTime"] = 2] = "PartTime";
        Workstyle[Workstyle["Flexible"] = 3] = "Flexible";
    })(Workstyle = Constants.Workstyle || (Constants.Workstyle = {}));
})(Constants || (Constants = {}));
class TKMarketJHRCustomReport extends generator_1.CustomReportGenerator {
    constructor(request, locale) {
        super(request, locale);
        this._fileId = uuid.v4();
        this._filePath = path_1.default.join(app_config_1.appConfig.tmpDirectory, this._fileId + ".xlsx");
        if (fs_1.default.existsSync(this._filePath)) {
            fs_1.default.unlinkSync(this._filePath);
        }
        this._wb = new exceljs_1.default.stream.xlsx.WorkbookWriter({
            filename: this._filePath,
            useStyles: true,
            useSharedStrings: true,
        });
        this._request = request;
        this._options = request.filter;
        this._filter = {
            dateRange: {
                startDateTime: luxon_1.DateTime.fromISO(this._options.filters.find((i) => i.type === app_enums_1.enums.CustomOrganizationReportFilterType.DateRange).value.startDay)
                    .startOf("day")
                    .toJSDate(),
                endDateTime: luxon_1.DateTime.fromISO(this._options.filters.find((i) => i.type === app_enums_1.enums.CustomOrganizationReportFilterType.DateRange).value.endDay)
                    .endOf("day")
                    .toJSDate(),
            },
            userFilter: {
                organizationUnitIds: this._options.filters.find((i) => i.type === app_enums_1.enums.CustomOrganizationReportFilterType.OrganizationUnit).value,
                organizationUnitHierachially: this._options.filters.find((f) => f.type === app_enums_1.enums.CustomOrganizationReportFilterType.OrganizationUnitHierarchically).value,
                userIds: this._options.filters.find((i) => i.type === app_enums_1.enums.CustomOrganizationReportFilterType.UserIdFromFreeSearch).value,
                userGroupIds: this._options.filters.find((i) => i.type === app_enums_1.enums.CustomOrganizationReportFilterType.UserGroup).value,
                status: this._options.filters.find((f) => f.type === app_enums_1.enums.CustomOrganizationReportFilterType.UserStatus)?.value,
            },
            organizationId: request.organizationId,
            requesterUserId: request.requesterUserId,
            locale: locale,
        };
        this._isGrey = false;
    }
    async generateReport() {
        this._organizationName = (await dal_manager_1.dbManager.accessOrganization.getOrganizationBasic(this._request.organizationId)).name;
        app_logs_1.logger.debug("Organization Name : " + this._organizationName);
        let { caption: requestedUserCaption } = await dal_manager_1.dbManager.accessRedisCache.getUserBadgeCache({ organizationId: this._request.organizationId, userId: this._request.requesterUserId });
        if (!requestedUserCaption) {
            throw new Error("Not found");
        }
        this._requestedUserCaption = requestedUserCaption[0].text[0];
        this._wb.creator = this._requestedUserCaption;
        app_logs_1.logger.debug("Generating TK Market employee working duration excel report...");
        app_logs_1.logger.debug("Requester User : " + this._requestedUserCaption);
        this._wsGeneral = this._wb.addWorksheet("Sayfa1", {
            pageSetup: { fitToPage: true, fitToWidth: 1, fitToHeight: 0, paperSize: 9, orientation: "landscape" },
        });
        this._wsGeneral.properties.defaultRowHeight = 15;
        this._generalRowIndex = 1;
        this._data = await this.getEmployeeJHRData(this._filter);
        this.initGeneralSheet(this._wsGeneral);
        if (this._data?.length > 0) {
            for (const item of this._data) {
                this.addGeneralRow(item);
            }
        }
        this._wsGeneral.pageSetup.orientation = "portrait";
        this._wsGeneral.commit();
        await this._wb.commit();
        app_logs_1.logger.debug("File is ready -> " + this._filePath);
        return {
            format: app_enums_1.enums.ReportFormat.Excel,
            preparedReportId: this._fileId,
            filePath: this._filePath,
            notificationType: undefined,
            reportType: app_enums_1.enums.ReportCode.CustomReport,
            sendFileInAttachments: undefined,
            customReportName: "JHR Aktarım Raporu",
        };
    }
    async getEmployeeJHRData(filter) {
        const now = luxon_1.DateTime.now();
        const start = luxon_1.DateTime.fromJSDate(filter.dateRange.startDateTime);
        const end = luxon_1.DateTime.fromJSDate(filter.dateRange.endDateTime);
        if (now >= start && now <= end) {
            await (0, controller_report_1.refreshUsersSummaryForToday)({
                requesterUserId: filter.requesterUserId,
                applyOrganizationUnitFilterHierarchically: filter.userFilter.organizationUnitHierachially,
                userGroupIds: filter.userFilter.userGroupIds,
                organizationId: filter.organizationId,
                organizationUnitIds: filter.userFilter.organizationUnitIds,
                userIds: filter.userFilter.userIds,
                requiredOrganizationWidePermissions: ["j:l", "e:u", "u:b", "g:r"],
                requiredOrganizationUnitWidePermissions: ["j:l", "e:u", "u:b", "g:r"],
                userOrganizationStatus: filter.userFilter.status,
            });
        }
        let rows = await dal_manager_1.dbManager.systemTransaction(async (trx) => {
            const userFilter = (0, dal_access_psql_common_1.getReportUserFilterForPgClient)({
                organizationId: filter.organizationId,
                requesterUserId: filter.requesterUserId,
                idBasedUserFilter: {
                    userIds: filter.userFilter.userIds,
                    userGroupIds: filter.userFilter.userGroupIds,
                    organizationUnitIds: filter.userFilter.organizationUnitIds,
                    userOrganizationStatus: filter.userFilter.status,
                    applyOrganizationUnitFilterHierarchically: filter.userFilter.organizationUnitHierachially,
                },
                requiredOrganizationUnitWidePermissions: ["j:l", "e:u", "u:b", "g:r"],
                requiredOrganizationWidePermissions: ["j:l", "e:u", "u:b", "g:r"],
                bindingKeys: [],
            });
            let queryParams = [...userFilter.bindingKeys, start.toFormat("yyyy-MM-dd"), end.toFormat("yyyy-MM-dd")];
            let query = `
				SELECT 
					uop."uniqueId",
					uop."name",
					uop."surname",
					uop."employmentStartUtc",
					NULLIF(uop."extensionFields"->>'workstyle', '')::integer AS workstyle,
					json_agg(json_build_object(
						'date', ed."date",
						'permissions', (ed.data->'p'),
						'holidays', (ed.data->'h'),
						'expectedWork', (ed.data->'s'->>'ew')::integer,
						'normalWork', (ed.data->'s'->>'n')::integer,
						'routineTypes',
							(
							SELECT json_agg((vw.details->>'routineType')::integer)
							FROM jsonb_array_elements_text(ed.data->'w') AS workplan_id(id)
							LEFT JOIN "${filter.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.viewNames.vW_WorkPlanPeriodTstzrange}" vw
								ON vw."workPlanId" = workplan_id.id::uuid
								AND vw.range && tstzrange($${userFilter.bindingKeys.length + 1}, $${userFilter.bindingKeys.length + 2})
							)
					) ORDER BY ed."date" DESC) AS items
				FROM "${filter.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userOrganizations}" AS uo
				INNER JOIN "${filter.organizationId}"."userOrganizationProfiles" AS uop
					ON uo.id = uop."userOrganizationId"
				LEFT JOIN "${filter.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.users}" AS u
					ON u.id = uop."userId"
				INNER JOIN 
				(
					SELECT "userId", "data", "date"  FROM "${filter.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.employeeDays}"
					UNION
					SELECT "userId", "data", "startAt"::date as date  FROM "${filter.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.employeeLiveDay}"
				) AS ed
				ON ed."userId" = uop."userId"
				INNER JOIN
					(${userFilter.query}) AS T3
					ON T3."userId" = ed."userId" AND ed."data" IS NOT NULL
				WHERE ed.date >= $${userFilter.bindingKeys.length + 1} AND ed.date <= $${userFilter.bindingKeys.length + 2}
				GROUP BY ed."userId", uop."uniqueId", uop."name", uop."surname", uop."employmentStartUtc", uop."extensionFields"->>'workstyle'
				ORDER BY uop."name", uop."surname";
			`;
            return (await trx.query(query, queryParams)).rows;
        });
        let currentDate = new Date(filter.dateRange.startDateTime);
        let endDate = new Date(filter.dateRange.endDateTime);
        rows.forEach((item) => {
            while (currentDate <= endDate) {
                const dateString = (0, moment_1.default)(currentDate).format("YYYY-MM-DD").toString();
                if (!item.items) {
                    item.items = [];
                    item.items.push({
                        date: dateString,
                        permissions: [],
                    });
                    currentDate.setDate(currentDate.getDate() + 1);
                    continue;
                }
                const index = item.items.map((e) => e.date.toString()).indexOf(dateString);
                if (index === -1) {
                    item.items.push({
                        date: dateString,
                        permissions: [],
                    });
                }
                currentDate.setDate(currentDate.getDate() + 1);
            }
            item.items.sort((a, b) => new Date(a.date).getTime() - new Date(b.date).getTime());
            currentDate = new Date(filter.dateRange.startDateTime);
        });
        return rows;
    }
    addInitGeneralCell(ws, row, col, value, key) {
        let c = ws.getCell(row, col);
        c.value = value;
        c.alignment = Constants.HeadersStyling[key]?.alignment;
        c.font = Constants.HeadersStyling[key]?.font;
        c.border = Constants.HeadersStyling[key]?.border;
        c.fill = Constants.HeadersStyling[key]?.fill;
    }
    initGeneralSheet(wsRaw) {
        let colIndex = 1;
        let columns = [];
        this.addInitGeneralCell(wsRaw, this._generalRowIndex, colIndex++, "SİCİL NO", "v1");
        columns.push({ width: 30 });
        this.addInitGeneralCell(wsRaw, this._generalRowIndex, colIndex++, "AD", "v1");
        columns.push({ width: 20 });
        this.addInitGeneralCell(wsRaw, this._generalRowIndex, colIndex++, "SOYAD", "v1");
        columns.push({ width: 20 });
        this.addInitGeneralCell(wsRaw, this._generalRowIndex, colIndex++, "SSK", "v2");
        columns.push({ width: 10 });
        this.addInitGeneralCell(wsRaw, this._generalRowIndex, colIndex++, "VERGİ ÖDEME GÜNÜ", "v2");
        columns.push({ width: 10 });
        this.addInitGeneralCell(wsRaw, this._generalRowIndex, colIndex++, "TOPLAM ÇALIŞMA GÜNÜ", "v2");
        columns.push({ width: 10 });
        this.addInitGeneralCell(wsRaw, this._generalRowIndex, colIndex++, "EKSİK ÇALIŞMA NEDENİ", "v2");
        columns.push({ width: 10 });
        this.addInitGeneralCell(wsRaw, this._generalRowIndex, colIndex++, "İLAVE EDİLECEK VERGİ MATRAHI", "v2");
        columns.push({ width: 10 });
        this.addInitGeneralCell(wsRaw, this._generalRowIndex, colIndex++, "DÖNEM SIRA NUMARASI", "v2");
        columns.push({ width: 10 });
        this.addInitGeneralCell(wsRaw, this._generalRowIndex, colIndex++, "AR-GE SGK GÜN SAYISI", "v2");
        columns.push({ width: 10 });
        this.addInitGeneralCell(wsRaw, this._generalRowIndex, colIndex++, "AR-GE GV GÜN SAYISI", "v2");
        columns.push({ width: 10 });
        this.addInitGeneralCell(wsRaw, this._generalRowIndex, colIndex++, "İŞYERİ KODU", "v2");
        columns.push({ width: 10 });
        this.addInitGeneralCell(wsRaw, this._generalRowIndex, colIndex++, "İLAVE EDİLECEK AÜ MATRAHI", "v2");
        columns.push({ width: 10 });
        this.addInitGeneralCell(wsRaw, this._generalRowIndex, colIndex++, "TYP - Mesai", "v3");
        columns.push({ width: 10 });
        this.addInitGeneralCell(wsRaw, this._generalRowIndex, colIndex++, "NR - Normal Mesai", "v4");
        columns.push({ width: 10 });
        this.addInitGeneralCell(wsRaw, this._generalRowIndex, colIndex++, "GÜN", "v1");
        columns.push({ width: 10 });
        this.addInitGeneralCell(wsRaw, this._generalRowIndex, colIndex++, "SAAT", "v5");
        columns.push({ width: 10 });
        this.addInitGeneralCell(wsRaw, this._generalRowIndex, colIndex++, "TUTAR", "v5");
        columns.push({ width: 10 });
        this.addInitGeneralCell(wsRaw, this._generalRowIndex, colIndex++, "TYP - Mesai", "v3");
        columns.push({ width: 10 });
        this.addInitGeneralCell(wsRaw, this._generalRowIndex, colIndex++, "NR - Hafta Tatili", "v4");
        columns.push({ width: 10 });
        this.addInitGeneralCell(wsRaw, this._generalRowIndex, colIndex++, "GÜN", "v1");
        columns.push({ width: 10 });
        this.addInitGeneralCell(wsRaw, this._generalRowIndex, colIndex++, "SAAT", "v5");
        columns.push({ width: 10 });
        this.addInitGeneralCell(wsRaw, this._generalRowIndex, colIndex++, "TUTAR", "v5");
        columns.push({ width: 10 });
        this.addInitGeneralCell(wsRaw, this._generalRowIndex, colIndex++, "TYP - Mesai", "v3");
        columns.push({ width: 10 });
        this.addInitGeneralCell(wsRaw, this._generalRowIndex, colIndex++, "NR - Resmi Tatil", "v4");
        columns.push({ width: 10 });
        this.addInitGeneralCell(wsRaw, this._generalRowIndex, colIndex++, "GÜN", "v1");
        columns.push({ width: 10 });
        this.addInitGeneralCell(wsRaw, this._generalRowIndex, colIndex++, "SAAT", "v5");
        columns.push({ width: 10 });
        this.addInitGeneralCell(wsRaw, this._generalRowIndex, colIndex++, "TUTAR", "v5");
        columns.push({ width: 10 });
        this.addInitGeneralCell(wsRaw, this._generalRowIndex, colIndex++, "TYP - Mesai", "v3");
        columns.push({ width: 10 });
        this.addInitGeneralCell(wsRaw, this._generalRowIndex, colIndex++, "NR - Devamsızlık", "v4");
        columns.push({ width: 10 });
        this.addInitGeneralCell(wsRaw, this._generalRowIndex, colIndex++, "GÜN", "v1");
        columns.push({ width: 10 });
        this.addInitGeneralCell(wsRaw, this._generalRowIndex, colIndex++, "SAAT", "v5");
        columns.push({ width: 10 });
        this.addInitGeneralCell(wsRaw, this._generalRowIndex, colIndex++, "TUTAR", "v5");
        columns.push({ width: 10 });
        wsRaw.columns = columns;
        wsRaw.getRow(this._generalRowIndex).height = 50;
        this._generalRowIndex++;
    }
    getIntersectionDuration(firstDateRange, secondDateRange) {
        const firstStart = luxon_1.DateTime.fromJSDate(firstDateRange.start);
        const firstEnd = luxon_1.DateTime.fromJSDate(firstDateRange.end);
        const secondStart = luxon_1.DateTime.fromJSDate(secondDateRange.start);
        const secondEnd = luxon_1.DateTime.fromJSDate(secondDateRange.end);
        const firstInterval = luxon_1.Interval.fromDateTimes(firstStart, firstEnd);
        const secondInterval = luxon_1.Interval.fromDateTimes(secondStart, secondEnd);
        const intersection = firstInterval.intersection(secondInterval);
        if (!intersection) {
            return 0;
        }
        const durationInDays = intersection.toDuration("days").days;
        return this.roundToNearestHalf(durationInDays);
    }
    roundToNearestHalf(num) {
        return Math.round(num * 2) / 2;
    }
    getRowData(record) {
        let normalDay = 0;
        let weeklyDay = 0;
        let publicDay = 0;
        let absentDay = 0;
        let absentWorkReason = "0";
        if (record?.workstyle === Constants.Workstyle.PartTime || record?.workstyle === Constants.Workstyle.Flexible) {
            let totalWorkInMinutes = 0;
            record.items.forEach((item) => {
                totalWorkInMinutes += item?.normalWork || 0;
            });
            normalDay = this.roundToNearestHalf(totalWorkInMinutes / 60 / 7.5);
            absentWorkReason = "06";
        }
        else {
            const employmentStartUtc = new Date(record.employmentStartUtc);
            let validItems = record.items.filter((item) => new Date(item.date) >= employmentStartUtc);
            validItems.forEach((item) => {
                const rangeStart = new Date(item.date);
                rangeStart.setHours(0, 0, 0, 0);
                const rangeEnd = new Date(item.date);
                rangeEnd.setHours(23, 59, 59, 999);
                const itemDateRange = { start: rangeStart, end: rangeEnd };
                const routineTypes = item.routineTypes ?? [];
                if (routineTypes.length === 0) {
                    app_logs_1.logger.error(`Missing routineTypes while creating JHR report.`);
                    return;
                }
                const allAre = (val) => routineTypes.every((rt) => rt === val);
                if (allAre(dal_constants_1.DalConstants.PacsWorkplanPeriodRoutineTypes.Week)) {
                    const publicDayBeforeAdd = publicDay;
                    item.holidays?.forEach((holiday) => {
                        const dateRange = { start: new Date(holiday.r.s), end: new Date(holiday.r.e) };
                        publicDay += this.getIntersectionDuration(dateRange, itemDateRange);
                    });
                    if (item.permissions?.length > 0) {
                        item.permissions.forEach((permission) => {
                            const dateRange = { start: new Date(permission.r.s), end: new Date(permission.r.e) };
                            if (permission.pt === Constants.PermissionTypeIds.AbsentDay && permission.u !== 0) {
                                let absentDuration = this.getIntersectionDuration(dateRange, itemDateRange);
                                item.holidays?.forEach((holiday) => {
                                    const holidayRange = { start: new Date(holiday.r.s), end: new Date(holiday.r.e) };
                                    const overlap = this.getIntersectionDuration(holidayRange, dateRange);
                                    absentDuration -= overlap;
                                });
                                absentDay += Math.max(absentDuration, 0);
                            }
                        });
                    }
                    const hasHoliday = item.holidays?.length > 0;
                    const hasPermission = item.permissions?.length > 0;
                    const allPermissionsUnused = item.permissions?.every((p) => p.u === 0) ?? true;
                    if (!hasHoliday && !hasPermission && item.expectedWork === 0) {
                        weeklyDay++;
                    }
                    else if (!hasHoliday && hasPermission && item.expectedWork === 0 && allPermissionsUnused) {
                        weeklyDay++;
                    }
                    else if (hasHoliday && item.expectedWork === 0 && (!hasPermission || (hasPermission && allPermissionsUnused))) {
                        weeklyDay += 1 - (publicDay - publicDayBeforeAdd);
                    }
                }
                else if (allAre(dal_constants_1.DalConstants.PacsWorkplanPeriodRoutineTypes.Day)) {
                    let dayPublicDuration = 0;
                    let dayWeeklyDuration = 0;
                    let dayAbsentDuration = 0;
                    item.holidays?.forEach((holiday) => {
                        const dateRange = { start: new Date(holiday.r.s), end: new Date(holiday.r.e) };
                        dayPublicDuration += this.getIntersectionDuration(dateRange, itemDateRange);
                    });
                    if (item.permissions?.length > 0) {
                        item.permissions.forEach((permission) => {
                            const dateRange = { start: new Date(permission.r.s), end: new Date(permission.r.e) };
                            if (permission.pt === Constants.PermissionTypeIds.PublicDay && dayPublicDuration === 0) {
                                dayPublicDuration += this.getIntersectionDuration(dateRange, itemDateRange);
                            }
                            else if (permission.pt === Constants.PermissionTypeIds.WeeklyDay) {
                                dayWeeklyDuration += this.getIntersectionDuration(dateRange, itemDateRange);
                            }
                            else if (permission.pt === Constants.PermissionTypeIds.AbsentDay) {
                                dayAbsentDuration += this.getIntersectionDuration(dateRange, itemDateRange);
                            }
                        });
                    }
                    const overlap = Math.min(dayPublicDuration, dayWeeklyDuration);
                    if (overlap > 0) {
                        publicDay += overlap;
                        weeklyDay += dayWeeklyDuration - overlap;
                    }
                    else {
                        publicDay += dayPublicDuration;
                        weeklyDay += dayWeeklyDuration;
                    }
                    absentDay += dayAbsentDuration;
                }
                else {
                    app_logs_1.logger.error(`Unexpected routineTypes while creating JHR report: ${JSON.stringify(routineTypes)}`);
                    return;
                }
            });
            normalDay = validItems.length - publicDay - weeklyDay - absentDay;
            if (validItems.length > 0) {
                const firstItemDate = new Date(validItems[0].date);
                const lastItemDate = new Date(validItems[validItems.length - 1].date);
                const firstDayOfMonth = new Date(firstItemDate.getFullYear(), firstItemDate.getMonth(), 1);
                const lastDayOfMonth = new Date(lastItemDate.getFullYear(), lastItemDate.getMonth() + 1, 0);
                firstItemDate.setHours(0, 0, 0, 0);
                firstDayOfMonth.setHours(0, 0, 0, 0);
                lastItemDate.setHours(0, 0, 0, 0);
                lastDayOfMonth.setHours(0, 0, 0, 0);
                if (firstItemDate.getTime() === firstDayOfMonth.getTime() &&
                    lastItemDate.getTime() === lastDayOfMonth.getTime() &&
                    firstItemDate.getMonth() === 1 &&
                    employmentStartUtc <= firstDayOfMonth &&
                    absentDay === 0) {
                    const daysInFebruary = lastDayOfMonth.getDate();
                    normalDay += 30 - daysInFebruary;
                }
                if (firstItemDate.getTime() === firstDayOfMonth.getTime() &&
                    lastItemDate.getTime() === lastDayOfMonth.getTime() &&
                    lastDayOfMonth.getDate() === 31 &&
                    employmentStartUtc <= firstDayOfMonth &&
                    absentDay === 0) {
                    normalDay--;
                }
            }
        }
        let rowData = [
            record.uniqueId,
            record.name,
            record.surname,
            "0",
            "0",
            "0",
            absentWorkReason,
            "0",
            "1",
            "0",
            "0",
            "",
            "0",
            "1",
            "1",
            normalDay,
            "0",
            "0",
            "1",
            2,
            weeklyDay,
            "0",
            "0",
            "1",
            "3",
            publicDay,
            "0",
            "0",
            "1",
            "10",
            absentDay,
            "0",
            "0",
        ];
        return rowData;
    }
    addGeneralRow(record) {
        let rowData = this.getRowData(record);
        this.addCellsToRow(rowData, 1, this._generalRowIndex, this._wsGeneral);
        this._isGrey = !this._isGrey;
        this._generalRowIndex++;
    }
}
exports.TKMarketJHRCustomReport = TKMarketJHRCustomReport;
async function generateReport(request, locale) {
    let report = new TKMarketJHRCustomReport(request, locale);
    return report.generateReport();
}
exports.generateReport = generateReport;
