"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CreateHook = void 0;
const business_hooks_1 = require("../../../business/business.hooks");
const dal_manager_1 = require("../../../dal/dal.manager");
const moment = require("moment");
const app_enums_1 = require("../../../app.enums");
const dal_constants_1 = require("../../../dal/dal.constants");
const uuid = require("uuid");
const messageBroker_server_to_device_pub_1 = require("../../../messageBroker/messageBroker.server-to-device.pub");
const app_logs_1 = require("../../../app.logs");
const messagebroker_models_1 = require("../../../messageBroker/messagebroker.models");
const visitorAccessControlPoints = ["b948b67a-b05c-4f04-94b3-376e27002ef7", "f543fde1-a2c3-4e30-a4aa-2583a30916a6"];
const registrationPointExitACPMapping = {
    "162919b1-f1c2-4d99-993e-bce349791ed7": "b948b67a-b05c-4f04-94b3-376e27002ef7",
};
const registrationPointEntranceACPMapping = {
    "162919b1-f1c2-4d99-993e-bce349791ed7": "f543fde1-a2c3-4e30-a4aa-2583a30916a6",
};
function CreateHook() {
    return new SapEnstitusuHook();
}
exports.CreateHook = CreateHook;
class SapEnstitusuHook extends business_hooks_1.OrganizationHookModels.IArmonHook {
    constructor() {
        super();
        this.onPACSSelfAbsentEmployeeSMSNotification = async function (params) {
            if (params.receiverUser.l === dal_constants_1.DalConstants.SupportedLocales.English) {
                return {
                    text: "Although you have to start working, it has been found that you did not read your card. Please have your card scanned from your nearest entry point.",
                    phoneNumber: params.receiverUser.m,
                };
            }
            else if (params.receiverUser.l === dal_constants_1.DalConstants.SupportedLocales.Turkish) {
                return {
                    text: "Mesaiyi başlamanız gerektiği halde kartınızı okumadığınız tespit edilmiştir. Lütfen kartınızı en yakın yetkili olduğunuz giriş noktasından okutunuz.",
                    phoneNumber: params.receiverUser.m,
                };
            }
        };
        this.onPACSSelfOverworkedEmployeeSMSNotification = async function (params) {
            if (params.receiverUser.l === dal_constants_1.DalConstants.SupportedLocales.English) {
                return {
                    text: "Although you have to stop working, it has been found that you did not read your card. Please have your card scanned from your nearest exit point.",
                    phoneNumber: params.receiverUser.m,
                };
            }
            else if (params.receiverUser.l === dal_constants_1.DalConstants.SupportedLocales.Turkish) {
                return {
                    text: "Mesaiyi bitirmeniz gerektiği halde kartınızı okumadığınız tespit edilmiştir. Lütfen kartınızı en yakın yetkili olduğunuz çıkış noktasından okutunuz.",
                    phoneNumber: params.receiverUser.m,
                };
            }
        };
        this.afterVisitorSave = async function (params) {
            let result = {
                errorMessage: "",
                isValid: true,
            };
            let visitorSettings = await dal_manager_1.dbManager.accessVisitor.getVisitAndVisitorFormSettings(params.organizationId, params.trx);
            let visitDetailed = await dal_manager_1.dbManager.accessVisitor.getActiveVisitDetailed(params.organizationId, params.visitId, visitorSettings, params.trx);
            let licensePlate = visitDetailed.profile.fields["licencePlate"];
            if (!licensePlate) {
                return Promise.resolve(null);
            }
            let opTime = new Date();
            let credentialCheck = await params.trx
                .withSchema(params.organizationId)
                .from("userOrganizationCredentials")
                .where("data", licensePlate)
                .where("type", app_enums_1.enums.CredentialType.VehiclePlate)
                .where("userId", visitDetailed.userId)
                .first();
            let newCredentialId = uuid.v4();
            let credential = {
                id: newCredentialId,
                createdAt: opTime,
                updatedAt: opTime,
                deletedAt: null,
                organizationId: params.organizationId,
                userId: visitDetailed.userId,
                type: app_enums_1.enums.CredentialType.VehiclePlate,
                data: licensePlate,
                expiresOn: moment(opTime).endOf("day").toDate(),
                credentialNumber: licensePlate,
                extensionFields: null,
                source: dal_constants_1.DalConstants.SourceType.System
            };
            if (credentialCheck) {
                await params.trx.withSchema(params.organizationId).from("userOrganizationCredentials").where("id", credential.id).delete();
            }
            await params.trx.withSchema(params.organizationId).from("userOrganizationCredentials").insert(credential);
            let accessRights = [];
            for (const acpId of visitorAccessControlPoints) {
                let newAccessRightId = uuid.v4();
                accessRights.push({
                    id: newAccessRightId,
                    createdAt: opTime,
                    updatedAt: opTime,
                    userId: visitDetailed.userId,
                    accessControlPointId: acpId,
                    remoteAccess: false,
                    access: true,
                });
            }
            await params.trx.withSchema(params.organizationId).from("userAccessRights").insert(accessRights);
            let acpId = registrationPointEntranceACPMapping[visitDetailed.visitorRegistrationPointId];
            if (acpId) {
                setTimeout(() => {
                    this.sendRemoteOpen(params.organizationId, acpId, visitDetailed.userId, dal_constants_1.DalConstants.AccessDirection.Entrance, false);
                }, 2000);
            }
            return Promise.resolve(result);
        }.bind(this);
        this.afterTerminateVisit = async function (params) {
            let acpId = registrationPointExitACPMapping[params.visitorRegistrationPointId];
            if (acpId) {
                setTimeout(() => {
                    this.sendRemoteOpen(params.organizationId, acpId, params.userId, dal_constants_1.DalConstants.AccessDirection.Exit, false);
                }, 2000);
            }
            return Promise.resolve({
                errorMessage: "",
                isValid: true,
            });
        }.bind(this);
    }
    async sendRemoteOpen(organizationId, accessControlPointId, userId, direction, qr) {
        try {
            let accessAccessControlPoint = await dal_manager_1.dbManager.accessAccessControlPoint.getAccessControlPointBasic(organizationId, accessControlPointId);
            if (accessAccessControlPoint.deviceId) {
                messageBroker_server_to_device_pub_1.amqpServerToDevicePub.sendToRpcQueue(accessAccessControlPoint.deviceId, {
                    e: messagebroker_models_1.ServerToDeviceRPCMessageType.RemoteAccess,
                    p: {
                        a: accessControlPointId,
                        d: direction ?? app_enums_1.enums.AccessDirection.All,
                        o: userId,
                        iq: qr,
                    },
                }, 3000, (err, success) => {
                    if (err) {
                        app_logs_1.logger.error("unable to send remote access " + err);
                    }
                });
            }
        }
        catch (error) {
            app_logs_1.logger.error("unable to send remote access " + error);
        }
    }
}
