"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.generateReport = exports.SAPAylikCustomRep = void 0;
const path_1 = __importDefault(require("path"));
const exceljs_1 = __importDefault(require("exceljs"));
const moment_1 = __importDefault(require("moment"));
const app_config_1 = require("../../../app.config");
const dal_manager_1 = require("../../../dal/dal.manager");
const uuid = require("uuid");
const i18n_1 = __importDefault(require("i18n"));
const app_logs_1 = require("../../../app.logs");
const app_enums_1 = require("../../../app.enums");
const generator_1 = require("../../../business/report/generator");
var Constants;
(function (Constants) {
    Constants.TimeFormat = "HH:mm";
    Constants.DateFormat = "dd.mm.yyyy";
    Constants.DateTimeFormat = "dd.mm.yyyy HH:mm";
    let Styling;
    (function (Styling) {
        Styling.AllThin = {
            right: {
                style: "thin",
            },
            left: {
                style: "thin",
            },
            bottom: {
                style: "thin",
            },
            top: {
                style: "thin",
            },
        };
        Styling.AllThinButBottom = {
            right: {
                style: "thin",
            },
            left: {
                style: "thin",
            },
            top: {
                style: "thin",
            },
        };
        Styling.Dotted = {
            right: {
                style: "dotted",
            },
            left: {
                style: "dotted",
            },
            bottom: {
                style: "dotted",
            },
            top: {
                style: "dotted",
            },
        };
        Styling.AllThinButRightThick = {
            right: {
                style: "thin",
            },
            left: {
                style: "thin",
            },
            bottom: {
                style: "thin",
            },
            top: {
                style: "thin",
            },
        };
        Styling.AllThick = {
            right: {
                style: "thick",
            },
            left: {
                style: "thick",
            },
            bottom: {
                style: "thick",
            },
            top: {
                style: "thick",
            },
        };
        Styling.BottomThin = {
            bottom: {
                style: "thin",
            },
        };
        Styling.BottomThinRightDotted = {
            right: {
                style: "dotted",
            },
            bottom: {
                style: "thin",
            },
        };
        Styling.AllDottedButTop = {
            right: {
                style: "dotted",
            },
            left: {
                style: "dotted",
            },
            bottom: {
                style: "dotted",
            },
        };
        Styling.AllDottedButBottom = {
            right: {
                style: "dotted",
            },
            left: {
                style: "dotted",
            },
            bottom: {
                style: "thin",
            },
        };
        Styling.BottomAndRightThin = {
            right: {
                style: "thin",
            },
            bottom: {
                style: "thin",
            },
        };
    })(Styling = Constants.Styling || (Constants.Styling = {}));
    Constants.PPermissionTypes = {
        gorevlendirme: "349a1e1d-2142-4139-a6cf-0dd56824c510",
        gunlukVeyaYillik: "685434ed-01c4-46a9-b4a2-f5fcd5b71da7",
        hastlıkRaporu: "887b815d-10ba-44f1-af35-69fbc6c9aeae",
        hastane: "f4d837f9-4cb3-467f-9c41-aceb0f7dda80",
        idariIzin: "61d7c673-c1f2-4c61-a06b-0826eef211b8",
        mazeretSaatlik: "20a57a8f-a961-423b-a245-103fe8667983",
        mazeretGunluk: "3d7f573e-e973-47b0-b383-ec7fb60f4cdc",
        nobet: "8d82dfae-39ce-4605-98df-028fe65d1dfe",
        saatlik: "04bf1cbc-8d75-4a47-b627-61d521e946ae",
        saatlikUzaktanCalısma: "8f588f1b-0501-4acf-96b4-8fb380200c92",
        sendika: "d8cb94c4-baaa-4f4d-a727-df374e878176",
        uzaktanCalısma: "5b292ccb-6e55-4953-bd0f-f3bda038592b",
    };
    Constants.ppermissionTypesForSAP = {
        G: "Görevli",
        C: "Cumartesi",
        P: "Pazar",
        T: "Tatil, Bayram, Resmi Tatil",
        R: "Hastalık Raporu",
        İİ: "İdari İzin",
        UÇ: "Saatlik Uzaktan Çalışma, Uzaktan Çalışma",
        İ: "Günlük veya Yıllık İzin",
        X: "Mazeret (SAATLİK), Nöbet veya Saatlik İzin",
        Mİ: "Mazeret İzni (GÜNLÜK)",
        Sİ: "Sendika İzni",
        H: "Hastane",
        Nİ: "Nöbet İzni",
    };
    Constants.thoseWithSignatoryPowers = { "Yağmur Bulut EKER": "Personel Birim Sorumlusu", "Uzm. Mehmet KARAKAYA": "Müdür Yrd. V.", "Ertan AĞTÜRK": "Ensitütü Müdür V." };
})(Constants || (Constants = {}));
class SAPAylikCustomRep extends generator_1.CustomReportGenerator {
    constructor(request, locale) {
        super(request, locale);
        this._request = request;
        this._filter = request.filter;
        this._wb = new exceljs_1.default.Workbook();
        this._options = {
            startDate: (0, moment_1.default)(this._filter.filters.find((i) => i.type === app_enums_1.enums.CustomOrganizationReportFilterType.DateMonth).value).startOf("month"),
            endDate: (0, moment_1.default)(this._filter.filters.find((i) => i.type === app_enums_1.enums.CustomOrganizationReportFilterType.DateMonth).value).endOf("month"),
            organizationUnitIds: this._filter.filters.find((i) => i.type === app_enums_1.enums.CustomOrganizationReportFilterType.OrganizationUnit).value,
            userGroups: this._filter.filters.find((i) => i.type === app_enums_1.enums.CustomOrganizationReportFilterType.UserGroup).value,
            organizationUnitHierarchically: this._filter.filters.find((i) => i.type === app_enums_1.enums.CustomOrganizationReportFilterType.OrganizationUnitHierarchically).value,
            organizationId: this._request.organizationId,
            requesterUserId: this._request.requesterUserId,
            locale: this._locale,
        };
        this._daysTotal = this._options.endDate.diff(this._options.startDate, "days");
    }
    async generateReport() {
        const data = await dal_manager_1.dbManager.accessPacs2.getDataSapCustomReports(this._options);
        const organizationUnits = this._options.organizationUnitIds && this._options.organizationUnitIds.length > 0
            ? [
                {
                    id: this._options.organizationUnitIds[0],
                    includeDescendants: this._options.organizationUnitHierarchically,
                },
            ]
            : null;
        const activeUsers = (await dal_manager_1.dbManager.accessIdentity.searchIdentity({
            organizationId: this._options.organizationId,
            take: null,
            skip: null,
            status: app_enums_1.enums.IdentityStatusType.Enabled,
            profileFilter: null,
            organizationUnits: organizationUnits,
            userGroupIds: this._options.userGroups,
            credentialExtensionFilters: [],
            hasMail: false,
            permissions: [],
            workplans: [],
        })).items;
        const activeUsersList = activeUsers.map((user) => user.id);
        const userInfos = await dal_manager_1.dbManager.accessUser.getBasicUserInfoList(this._options.organizationId, activeUsersList);
        this._filePath = await this.generateDailyFirstInLastOutReport(data, userInfos, activeUsersList);
        return {
            format: app_enums_1.enums.ReportFormat.Excel,
            preparedReportId: this._fileId,
            filePath: this._filePath,
            notificationType: undefined,
            customReportName: "ŞAP ENSTİTÜSÜ MÜDÜRLÜĞÜ İŞÇİ PUANTAJ RAPORU",
            sendFileInAttachments: undefined,
            reportType: app_enums_1.enums.ReportCode.CustomReport,
        };
    }
    async generateDailyFirstInLastOutReport(data, userInfos, userIdsList) {
        this._wsGeneral = this._wb.addWorksheet("Puantaj Raporu", {
            pageSetup: { fitToPage: true, fitToWidth: 1, fitToHeight: 0, paperSize: 9, orientation: "landscape" },
        });
        this._wsGeneral.properties.defaultRowHeight = 15;
        this._generalRowIndex = 8;
        this.initGeneralSheet(this._wsGeneral, 5, 1);
        const requestedUserCaption = await dal_manager_1.dbManager.accessUser.getUserOrganizationCaptionLines(this._options.organizationId, [this._options.requesterUserId]);
        if (requestedUserCaption.length < 1) {
            throw new Error("Not found");
        }
        if (requestedUserCaption[0].captionLines && requestedUserCaption[0].captionLines[0] && requestedUserCaption[0].captionLines[0].text !== null) {
            this._requestedUserCaption = requestedUserCaption[0].captionLines[0].text[0];
        }
        else {
            this._requestedUserCaption = "";
        }
        this._wb.creator = this._requestedUserCaption;
        app_logs_1.logger.debug("Generating report...");
        const filters = [];
        if (this._options.organizationUnitIds && this._options.organizationUnitIds.length > 0) {
            const organizationUnitNames = await dal_manager_1.dbManager.accessOrganizationUnit.getIdNamePairsOfOrganizationUnits(this._options.organizationId, this._options.organizationUnitIds);
            filters.push(i18n_1.default.__({ phrase: "EXCEL-REPORT.ORGANIZATION_UNITS", locale: this._locale }) + " : " + organizationUnitNames.map((oun) => oun.name).join(", "));
            if (this._options.organizationUnitHierarchically) {
                filters.push(i18n_1.default.__({ phrase: "EXCEL-REPORT.INCLUDE_DESCENDANTS", locale: this._locale }) + " : " + i18n_1.default.__({ phrase: "EXCEL-REPORT.YES", locale: this._locale }));
            }
        }
        app_logs_1.logger.debug("\n\nApplied Filters:\n");
        app_logs_1.logger.debug(filters.join("\r\n"));
        app_logs_1.logger.debug("\n\n");
        this.addFilterToSheet(this._wsGeneral, 1, 1, filters.join("\r\n"), filters.length);
        if (data && data.length > 0 && userIdsList && userIdsList.length > 0) {
            for (const userId of userIdsList) {
                const userData = data.filter((d) => d.userId === userId);
                const userInfo = userInfos.find((d) => d.id === userId);
                if (userData && userData.length > 0 && userInfo) {
                    this.addGeneralRow(userData, userInfo);
                }
            }
        }
        this.setDataCell({
            rowIndex: this._generalRowIndex + 2,
            colIndex: 1,
            value: this.stringfy(),
            ws: this._wsGeneral,
            border: Constants.Styling.AllThin,
        });
        let colIndexForSignatoryPowers = 6;
        for (const [key, value] of Object.entries(Constants.thoseWithSignatoryPowers)) {
            this.setDataCell({
                rowIndex: this._generalRowIndex + 3,
                colIndex: colIndexForSignatoryPowers,
                value: (key + "\n" + value),
                ws: this._wsGeneral,
            });
            this._wsGeneral.getColumn(colIndexForSignatoryPowers).width = 30;
            colIndexForSignatoryPowers += 4;
        }
        this._wsGeneral.pageSetup.printArea = "A1:" + this._wsGeneral.getColumn(this._wsGeneral.columns.length).letter + (this._generalRowIndex + 5);
        this._wsGeneral.pageSetup.printTitlesRow = "5:7";
        this._fileId = uuid.v4();
        this._filePath = path_1.default.join(app_config_1.appConfig.tmpDirectory, this._fileId + ".xlsx");
        await this._wb.xlsx.writeFile(this._filePath);
        app_logs_1.logger.debug("File is ready -> " + this._filePath);
        return this._filePath;
    }
    initGeneralSheet(wsRaw, startRowIndex, startColIndex) {
        const columns = [];
        this.addInitCell(wsRaw, startRowIndex, startColIndex, i18n_1.default.__({ phrase: "EXCEL-REPORT.name_surname", locale: this._locale }), Constants.Styling.AllThin);
        columns.push({ width: 45 });
        this.addInitCell(wsRaw, startRowIndex + 1, startColIndex, i18n_1.default.__({ phrase: "EXCEL-REPORT.POSITION_TITLE", locale: this._locale }), Constants.Styling.AllThin);
        wsRaw.mergeCells(startRowIndex, startColIndex, startRowIndex + 2, startColIndex++);
        this.addInitCell(wsRaw, startRowIndex, startColIndex, i18n_1.default.__({ phrase: "EXCEL-REPORT.DAYS", locale: this._locale }), Constants.Styling.AllThin);
        wsRaw.mergeCells(startRowIndex, startColIndex, startRowIndex, startColIndex + this._daysTotal + 1);
        const start = this._options.startDate;
        const end = this._options.endDate;
        let current = start.clone();
        while (current.isSameOrBefore(end)) {
            this.addInitCell(wsRaw, startRowIndex + 1, startColIndex, current.date(), Constants.Styling.AllThin);
            columns.push({ width: 4 });
            wsRaw.mergeCells(startRowIndex + 1, startColIndex, startRowIndex + 2, startColIndex++);
            current = current.add(1, "day");
        }
        this.addInitCell(wsRaw, startRowIndex + 1, startColIndex, i18n_1.default.__({ phrase: "COMMON.TOTAL", locale: this._locale }), Constants.Styling.AllThin);
        columns.push({ width: 10 });
        this.addInitCell(wsRaw, startRowIndex + 2, startColIndex++, "Gn.Sy.", Constants.Styling.AllThin);
        columns.push({ width: 10 });
        this.addInitCell(wsRaw, startRowIndex, startColIndex, "PARAF", Constants.Styling.AllThin);
        columns.push({ width: 15 });
        wsRaw.mergeCells(startRowIndex, startColIndex, startRowIndex + 2, startColIndex++);
        wsRaw.columns = columns;
        wsRaw.views = [{ state: "frozen", ySplit: startRowIndex + 2, activeCell: "A1", showGridLines: false }];
    }
    addInitCell(ws, row, col, value, border) {
        const c = ws.getCell(row, col);
        c.value = value;
        c.alignment = {
            horizontal: "center",
            vertical: "middle",
            wrapText: true,
        };
        c.font = {
            bold: true,
        };
        c.border = border;
    }
    findPPermissionType(item) {
        const data = item;
        let value = "İ";
        const ppermission = data.p[0];
        if (data?.p?.length > 0) {
            switch (ppermission.pt) {
                case Constants.PPermissionTypes.hastlıkRaporu:
                    value = "R";
                    break;
                case Constants.PPermissionTypes.idariIzin:
                    value = "İİ";
                    break;
                case Constants.PPermissionTypes.uzaktanCalısma:
                case Constants.PPermissionTypes.saatlikUzaktanCalısma:
                    value = "UÇ";
                    break;
                case Constants.PPermissionTypes.gunlukVeyaYillik:
                    value = "İ";
                    break;
                case Constants.PPermissionTypes.nobet:
                    value = "Nİ";
                    break;
                case Constants.PPermissionTypes.saatlik:
                case Constants.PPermissionTypes.mazeretSaatlik:
                    value = "X";
                    break;
                case Constants.PPermissionTypes.mazeretGunluk:
                    value = "Mİ";
                    break;
                case Constants.PPermissionTypes.sendika:
                    value = "Sİ";
                    break;
                case Constants.PPermissionTypes.gorevlendirme:
                    value = "Gİ";
                    break;
                case Constants.PPermissionTypes.hastane:
                    value = "H";
                    break;
                default:
                    break;
            }
        }
        return value;
    }
    checkDay(item) {
        const weekend = this.checkWeekend(item);
        let day = "";
        const data = item?.data[0];
        if (data?.s?.uh > 0) {
            return "T";
        }
        else if (data?.s?.n > 0 || data?.s?.e > 0) {
            if (data?.s?.n > 300) {
                day = "X";
            }
            else {
                day = "A.Ç";
            }
        }
        else if (data?.p?.length > 0) {
            return this.findPPermissionType(data);
        }
        if (weekend) {
            return weekend;
        }
        return day;
    }
    checkWeekend(item) {
        var day = new Date(item.data[0].d).getDay();
        if (day === 6) {
            return "C";
        }
        else if (day === 0) {
            return "P";
        }
        else {
            return null;
        }
    }
    addGeneralRow(days, userInfo) {
        let colIndex = 1;
        if (!days) {
            return;
        }
        this.setDataCell({
            rowIndex: this._generalRowIndex,
            colIndex: colIndex,
            value: userInfo.fullname.toUpperCase(),
            ws: this._wsGeneral,
            border: Constants.Styling.AllThinButBottom,
        });
        this.setDataCell({
            rowIndex: this._generalRowIndex + 1,
            colIndex: colIndex++,
            value: (userInfo.orgTitle === undefined ? "" : userInfo.orgTitle),
            ws: this._wsGeneral,
            border: Constants.Styling.BottomAndRightThin,
        });
        if (!days || !(days.length > 0)) {
            const start = this._options.startDate;
            const end = this._options.endDate;
            let current = start.clone();
            while (current.isSameOrBefore(end)) {
                let val = "";
                const day = current.toDate().getDay();
                if (day === 6) {
                    val = "C";
                }
                else if (day === 0) {
                    val = "P";
                }
                this.setDataCell({
                    rowIndex: this._generalRowIndex,
                    colIndex: colIndex,
                    value: "",
                    ws: this._wsGeneral,
                    border: Constants.Styling.AllDottedButTop,
                });
                this.setDataCell({
                    rowIndex: this._generalRowIndex + 1,
                    colIndex: colIndex++,
                    value: val,
                    ws: this._wsGeneral,
                    border: Constants.Styling.AllDottedButBottom,
                });
                current = current.add(1, "day");
            }
        }
        else {
            const start = this._options.startDate;
            const end = this._options.endDate;
            let current = start.clone();
            while (current.isSameOrBefore(end)) {
                const data = days.find((d) => (0, moment_1.default)(d.date).isSame(current));
                if (data) {
                    this.setDataCell({
                        rowIndex: this._generalRowIndex,
                        colIndex: colIndex,
                        value: "",
                        ws: this._wsGeneral,
                        border: Constants.Styling.AllDottedButTop,
                    });
                    this.setDataCell({
                        rowIndex: this._generalRowIndex + 1,
                        colIndex: colIndex++,
                        value: this.checkDay(data),
                        ws: this._wsGeneral,
                        border: Constants.Styling.AllDottedButBottom,
                    });
                }
                else {
                    this.setDataCell({
                        rowIndex: this._generalRowIndex,
                        colIndex: colIndex,
                        value: "",
                        ws: this._wsGeneral,
                        border: Constants.Styling.AllDottedButTop,
                    });
                    this.setDataCell({
                        rowIndex: this._generalRowIndex + 1,
                        colIndex: colIndex++,
                        value: "",
                        ws: this._wsGeneral,
                        border: Constants.Styling.AllDottedButBottom,
                    });
                }
                current = current.add(1, "day");
            }
            days.shift();
        }
        this.setDataCell({
            rowIndex: this._generalRowIndex,
            colIndex: colIndex,
            value: (this._daysTotal + 1),
            ws: this._wsGeneral,
            border: Constants.Styling.AllThin,
        });
        const startCell = this._wsGeneral.getCell(this._generalRowIndex + 1, colIndex - this._daysTotal - 1).address;
        const endCell = this._wsGeneral.getCell(this._generalRowIndex + 1, colIndex - 1).address;
        this.setDataCell({
            rowIndex: this._generalRowIndex + 1,
            colIndex: colIndex++,
            value: "",
            ws: this._wsGeneral,
            border: Constants.Styling.AllThin,
            formula: "SUM(" + startCell + ":" + endCell + ")+COUNTIF(" + startCell + ":" + endCell + ',"X")',
        });
        this._generalRowIndex += 2;
    }
    setDataCell(params) {
        const c = params.ws.getCell(params.rowIndex, params.colIndex);
        if (params.formula) {
            c.value = {
                formula: params.formula,
            };
        }
        else {
            c.value = params.value;
        }
        c.alignment = {
            horizontal: "left",
            vertical: "middle",
            wrapText: true,
        };
        if (params.border) {
            c.border = params.border;
        }
        if (params.backgroundColorCode)
            c.fill = {
                type: "pattern",
                pattern: "solid",
                fgColor: { argb: params.backgroundColorCode },
            };
        if (params.isTextWhite)
            c.font = {
                color: { argb: "FFFFFF" },
                bold: true,
            };
    }
    addFilterToSheet(ws, startRowIndex, startColIndex, filter, filterlength) {
        const border = {
            left: {
                style: "thin",
            },
            top: {
                style: "thin",
            },
            right: {
                style: "thin",
            },
            bottom: {
                style: "thin",
            },
        };
        this.addFilterCell(ws, startRowIndex, startColIndex, "5996 SAYILI KANUN KAPSAMINDA KONTROL GÖREVİ YAPAN ÜNVANLARA AİT AYLIK PUANTAJ", border, { bold: true });
        this.addFilterCell(ws, startRowIndex + 1, startColIndex, "AİT OLDUĞU AY VE YIL", border);
        this.addFilterCell(ws, startRowIndex + 1, startColIndex + 1, (0, moment_1.default)(this._options.startDate).locale(this._locale).format("LL") + " - " + (0, moment_1.default)(this._options.endDate).locale(this._locale).format("LL"), border, { italic: true }, Constants.DateFormat);
        ws.mergeCells(startRowIndex, startColIndex, startRowIndex, startColIndex + 15);
        ws.mergeCells(startRowIndex + 1, startColIndex + 1, startRowIndex + 1, startColIndex + 15);
        ws.mergeCells(startRowIndex + 2, startColIndex + 1, startRowIndex + 2, startColIndex + 15);
        this.addFilterCell(ws, startRowIndex + 2, startColIndex, "KURUMU", border);
        this.addFilterCell(ws, startRowIndex + 2, startColIndex + 2, "ŞAP ENSTİTÜSÜ MÜDÜRLÜĞÜ - ANKARA", border, { italic: true }, Constants.DateFormat);
    }
    addFilterCell(ws, row, col, value, border, font, numFmt) {
        const c = ws.getCell(row, col);
        c.value = value;
        c.alignment = {
            horizontal: "left",
            vertical: "middle",
            wrapText: true,
        };
        c.border = border;
        c.font = font;
        c.numFmt = numFmt;
    }
    stringfy() {
        let permissionDescriptions = [];
        for (const [key, value] of Object.entries(Constants.ppermissionTypesForSAP)) {
            permissionDescriptions.push(`${key}` + ":" + `${value}`);
        }
        return permissionDescriptions.join("\r\n");
    }
}
exports.SAPAylikCustomRep = SAPAylikCustomRep;
async function generateReport(request, locale) {
    const report = new SAPAylikCustomRep(request, locale);
    return report.generateReport();
}
exports.generateReport = generateReport;
