"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.generateReport = exports.ControlScoringSurekliIsciCustomReport = void 0;
const path_1 = __importDefault(require("path"));
const exceljs_1 = __importDefault(require("exceljs"));
const moment_1 = __importDefault(require("moment"));
const app_config_1 = require("../../../app.config");
const dal_manager_1 = require("../../../dal/dal.manager");
const dal_constants_1 = require("../../../dal/dal.constants");
const uuid = require("uuid");
const i18n_1 = __importDefault(require("i18n"));
const app_logs_1 = require("../../../app.logs");
const app_enums_1 = require("../../../app.enums");
const business_pacs_claim_1 = require("../../../business/pacs/business.pacs.claim");
const generator_1 = require("../../../business/report/generator");
var Constants;
(function (Constants) {
    Constants.TimeFormat = "HH:mm";
    Constants.DateFormat = "dd.mm.yyyy";
    Constants.DateTimeFormat = "dd.mm.yyyy HH:mm";
    let Styling;
    (function (Styling) {
        Styling.AllThin = {
            right: {
                style: "thin",
            },
            left: {
                style: "thin",
            },
            bottom: {
                style: "thin",
            },
            top: {
                style: "thin",
            },
        };
        Styling.Dotted = {
            right: {
                style: "dotted",
            },
            left: {
                style: "dotted",
            },
            bottom: {
                style: "dotted",
            },
            top: {
                style: "dotted",
            },
        };
        Styling.AllThinButRightThick = {
            right: {
                style: "thin",
            },
            left: {
                style: "thin",
            },
            bottom: {
                style: "thin",
            },
            top: {
                style: "thin",
            },
        };
        Styling.AllThick = {
            right: {
                style: "thick",
            },
            left: {
                style: "thick",
            },
            bottom: {
                style: "thick",
            },
            top: {
                style: "thick",
            },
        };
        Styling.BottomThin = {
            bottom: {
                style: "thin",
            },
        };
        Styling.BottomThinRightDotted = {
            right: {
                style: "dotted",
            },
            bottom: {
                style: "thin",
            },
        };
        Styling.AllDottedButTop = {
            right: {
                style: "dotted",
            },
            left: {
                style: "dotted",
            },
            bottom: {
                style: "dotted",
            },
        };
        Styling.AllDottedButBottom = {
            right: {
                style: "dotted",
            },
            left: {
                style: "dotted",
            },
            bottom: {
                style: "thin",
            },
        };
    })(Styling = Constants.Styling || (Constants.Styling = {}));
    Constants.LojmanGrubu = "83e011d2-2845-487a-947c-996bb602af8d";
    Constants.PPermissionTypes = {
        gorevlendirme: "349a1e1d-2142-4139-a6cf-0dd56824c510",
        gunlukVeyaYillik: "685434ed-01c4-46a9-b4a2-f5fcd5b71da7",
        hastlıkRaporu: "887b815d-10ba-44f1-af35-69fbc6c9aeae",
        hastane: "f4d837f9-4cb3-467f-9c41-aceb0f7dda80",
        idariIzin: "61d7c673-c1f2-4c61-a06b-0826eef211b8",
        mazeretSaatlik: "20a57a8f-a961-423b-a245-103fe8667983",
        mazeretGunluk: "3d7f573e-e973-47b0-b383-ec7fb60f4cdc",
        nobet: "8d82dfae-39ce-4605-98df-028fe65d1dfe",
        saatlik: "04bf1cbc-8d75-4a47-b627-61d521e946ae",
        saatlikUzaktanCalısma: "8f588f1b-0501-4acf-96b4-8fb380200c92",
        sendika: "d8cb94c4-baaa-4f4d-a727-df374e878176",
        uzaktanCalısma: "5b292ccb-6e55-4953-bd0f-f3bda038592b",
    };
    Constants.ppermissionTypesForSAP = {
        G: "Görevli",
        C: "Cumartesi",
        P: "Pazar",
        T: "Tatil, Bayram, Resmi Tatil",
        R: "Hastalık Raporu",
        İİ: "İdari İzin",
        UÇ: "Saatlik Uzaktan Çalışma, Uzaktan Çalışma",
        İ: "Günlük veya Yıllık İzin",
        X: "Mazeret (SAATLİK), Nöbet veya Saatlik İzin",
        Mİ: "Mazeret İzni (GÜNLÜK)",
        Sİ: "Sendika İzni",
        H: "Hastane",
        Ni: "Nöbet İzni",
    };
})(Constants || (Constants = {}));
class ControlScoringSurekliIsciCustomReport extends generator_1.CustomReportGenerator {
    constructor(request, locale) {
        super(request, locale);
        this._request = request;
        this._filter = request.filter;
        this._wb = new exceljs_1.default.Workbook();
        this._options = {
            startDate: (0, moment_1.default)(this._filter.filters.find((i) => i.type === app_enums_1.enums.CustomOrganizationReportFilterType.DateRange).value.startDay).startOf("day"),
            endDate: (0, moment_1.default)(this._filter.filters.find((i) => i.type === app_enums_1.enums.CustomOrganizationReportFilterType.DateRange).value.endDay).endOf("day"),
            organizationUnitIds: this._filter.filters.find((i) => i.type === app_enums_1.enums.CustomOrganizationReportFilterType.OrganizationUnit).value,
            userGroups: this._filter.filters.find((i) => i.type === app_enums_1.enums.CustomOrganizationReportFilterType.UserGroup).value,
            organizationUnitHierarchically: this._filter.filters.find((i) => i.type === app_enums_1.enums.CustomOrganizationReportFilterType.OrganizationUnitHierarchically).value,
            organizationId: this._request.organizationId,
            requesterUserId: this._request.requesterUserId,
            locale: this._locale,
        };
        this._daysTotal = this._options.endDate.diff(this._options.startDate, "days");
    }
    async generateReport() {
        const data = await dal_manager_1.dbManager.accessPacs2.getDataSapCustomReports(this._options);
        const organizationUnits = this._options.organizationUnitIds && this._options.organizationUnitIds.length > 0
            ? [
                {
                    id: this._options.organizationUnitIds[0],
                    includeDescendants: this._options.organizationUnitHierarchically,
                },
            ]
            : null;
        const activeUsers = (await dal_manager_1.dbManager.accessIdentity.searchIdentity({
            organizationId: this._options.organizationId,
            take: null,
            skip: null,
            status: app_enums_1.enums.IdentityStatusType.Enabled,
            profileFilter: null,
            organizationUnits: organizationUnits,
            userGroupIds: this._options.userGroups,
            credentialExtensionFilters: [],
            hasMail: false,
            permissions: [],
            workplans: [],
        })).items;
        const activeUsersList = activeUsers.map((user) => {
            return { userId: user.id, userGroups: user.userGroups };
        });
        const userInfos = await dal_manager_1.dbManager.accessUser.getBasicUserInfoList(this._options.organizationId, activeUsersList.map((elem) => elem.userId));
        this._filePath = await this.generateDailyFirstInLastOutReport(data, userInfos, activeUsersList);
        return {
            format: app_enums_1.enums.ReportFormat.Excel,
            preparedReportId: this._fileId,
            filePath: this._filePath,
            notificationType: undefined,
            customReportName: "ŞAP ENSTİTÜSÜ MÜDÜRLÜĞÜ İŞÇİ PUANTAJ RAPORU",
            sendFileInAttachments: undefined,
            reportType: app_enums_1.enums.ReportCode.CustomReport,
        };
    }
    async generateDailyFirstInLastOutReport(data, userInfos, activeUsersList) {
        this._wsGeneral = this._wb.addWorksheet("Puantaj Raporu", {
            pageSetup: { fitToPage: true, fitToWidth: 1, fitToHeight: 0, paperSize: 9, orientation: "landscape" },
        });
        this._wsGeneral.properties.defaultRowHeight = 15;
        this._generalRowIndex = 8;
        this._wsPermission = this._wb.addWorksheet("Kalan İzin", {
            pageSetup: { fitToPage: true, fitToWidth: 1, fitToHeight: 0, paperSize: 9, orientation: "landscape" },
        });
        this._wsPermission.properties.defaultRowHeight = 15;
        this._permissionRowIndex = 3;
        this.initGeneralSheet(this._wsGeneral, 5, 1);
        this.initPermissionSheet(this._wsPermission, 1, 1);
        const requestedUserCaption = await dal_manager_1.dbManager.accessUser.getUserOrganizationCaptionLines(this._options.organizationId, [this._options.requesterUserId]);
        if (requestedUserCaption.length < 1) {
            throw new Error("Not found");
        }
        if (requestedUserCaption[0].captionLines && requestedUserCaption[0].captionLines[0] && requestedUserCaption[0].captionLines[0].text !== null) {
            this._requestedUserCaption = requestedUserCaption[0].captionLines[0].text[0];
        }
        else {
            this._requestedUserCaption = "";
        }
        this._wb.creator = this._requestedUserCaption;
        app_logs_1.logger.debug("Generating report...");
        const filters = [];
        if (this._options.organizationUnitIds && this._options.organizationUnitIds.length > 0) {
            const organizationUnitNames = await dal_manager_1.dbManager.accessOrganizationUnit.getIdNamePairsOfOrganizationUnits(this._options.organizationId, this._options.organizationUnitIds);
            filters.push(i18n_1.default.__({ phrase: "EXCEL-REPORT.ORGANIZATION_UNITS", locale: this._locale }) + " : " + organizationUnitNames.map((oun) => oun.name).join(", "));
            if (this._options.organizationUnitHierarchically) {
                filters.push(i18n_1.default.__({ phrase: "EXCEL-REPORT.INCLUDE_DESCENDANTS", locale: this._locale }) + " : " + i18n_1.default.__({ phrase: "EXCEL-REPORT.YES", locale: this._locale }));
            }
        }
        app_logs_1.logger.debug("\n\nApplied Filters:\n");
        app_logs_1.logger.debug(filters.join("\r\n"));
        app_logs_1.logger.debug("\n\n");
        this.addFilterToSheet(this._wsGeneral, 1, 1, filters.join("\r\n"), filters.length);
        if (data && data.length > 0 && activeUsersList && activeUsersList.length > 0) {
            for (const user of activeUsersList) {
                const userData = data.filter((d) => d.userId === user.userId);
                const userInfo = userInfos.find((d) => d.id === user.userId);
                if (userData && userData.length > 0 && userInfo) {
                    if (user.userGroups.find((elem) => elem.id === Constants.LojmanGrubu)) {
                        this.addGeneralRow(userData, userInfo, true);
                    }
                    else {
                        this.addGeneralRow(userData, userInfo, false);
                    }
                }
            }
        }
        this.setDataCell({
            rowIndex: this._generalRowIndex + 2,
            colIndex: 1,
            value: this.stringfy(),
            ws: this._wsGeneral,
            border: Constants.Styling.AllThin,
        });
        const ppermissionTypes = (await dal_manager_1.dbManager.accessPacs.listPPermissionTypes(this._options.organizationId, {
            take: 1000,
            skip: 0,
        })).items;
        const ppt = ppermissionTypes.find((permissionType) => permissionType.type === dal_constants_1.DalConstants.PredefinedPPermissionType.Annual);
        const usages = await (0, business_pacs_claim_1.getPPermissionTypeUsageOfUsersBetweenDates)(this._options.organizationId, activeUsersList.map((d) => d.userId), ppt.id, this._options.startDate.toDate(), this._options.endDate.toDate());
        for (const user of activeUsersList) {
            try {
                const usage = usages.find((per) => per.userId === user.userId);
                const period = usage.periods.find((per) => per.periodStart.getFullYear() === this._options.endDate.toDate().getFullYear());
                const userInfo = userInfos.find((d) => d.id === user.userId);
                this.addPermissionRow(period.remaining, userInfo);
            }
            catch (error) {
                continue;
            }
        }
        this._wsGeneral.pageSetup.printArea = "A1:" + this._wsGeneral.getColumn(this._wsGeneral.columns.length).letter + (this._generalRowIndex + 5);
        this._wsGeneral.pageSetup.printTitlesRow = "5:7";
        this._fileId = uuid.v4();
        this._filePath = path_1.default.join(app_config_1.appConfig.tmpDirectory, this._fileId + ".xlsx");
        await this._wb.xlsx.writeFile(this._filePath);
        app_logs_1.logger.debug("File is ready -> " + this._filePath);
        return this._filePath;
    }
    initGeneralSheet(wsRaw, startRowIndex, startColIndex) {
        const columns = [];
        this.addInitCell(wsRaw, startRowIndex, startColIndex, i18n_1.default.__({ phrase: "EXCEL-REPORT.name_surname", locale: this._locale }), Constants.Styling.AllThin);
        columns.push({ width: 45 });
        wsRaw.mergeCells(startRowIndex, startColIndex, startRowIndex + 2, startColIndex++);
        this.addInitCell(wsRaw, startRowIndex, startColIndex, "Bir Günlük\r\nYevmiyesi", Constants.Styling.AllThin);
        columns.push({ width: 10 });
        wsRaw.mergeCells(startRowIndex, startColIndex, startRowIndex + 2, startColIndex++);
        this.addInitCell(wsRaw, startRowIndex, startColIndex, "Ücret\r\nToplamı", Constants.Styling.AllThin);
        columns.push({
            width: 10,
        });
        wsRaw.mergeCells(startRowIndex, startColIndex, startRowIndex + 2, startColIndex++);
        this.addInitCell(wsRaw, startRowIndex, startColIndex, i18n_1.default.__({ phrase: "EXCEL-REPORT.DAYS", locale: this._locale }), Constants.Styling.AllThin);
        wsRaw.mergeCells(startRowIndex, startColIndex, startRowIndex, startColIndex + this._daysTotal + 1);
        const start = this._options.startDate;
        const end = this._options.endDate;
        let current = start.clone();
        while (current.isSameOrBefore(end)) {
            this.addInitCell(wsRaw, startRowIndex + 1, startColIndex, current.date(), Constants.Styling.AllThin);
            columns.push({ width: 4 });
            wsRaw.mergeCells(startRowIndex + 1, startColIndex, startRowIndex + 2, startColIndex++);
            current = current.add(1, "day");
        }
        this.addInitCell(wsRaw, startRowIndex + 1, startColIndex, "T.Gün", Constants.Styling.AllThin);
        columns.push({ width: 6 });
        wsRaw.mergeCells(startRowIndex + 1, startColIndex, startRowIndex + 2, startColIndex++);
        this.addInitCell(wsRaw, startRowIndex, startColIndex, "", Constants.Styling.AllThin);
        columns.push({ width: 15 });
        wsRaw.mergeCells(startRowIndex, startColIndex, startRowIndex + 2, startColIndex++);
        this.addInitCell(wsRaw, startRowIndex, startColIndex, "T.Gün", Constants.Styling.AllThin);
        columns.push({ width: 6 });
        wsRaw.mergeCells(startRowIndex, startColIndex, startRowIndex + 2, startColIndex++);
        this.addInitCell(wsRaw, startRowIndex, startColIndex, "", Constants.Styling.AllThin);
        columns.push({ width: 15 });
        wsRaw.mergeCells(startRowIndex, startColIndex, startRowIndex + 2, startColIndex++);
        wsRaw.columns = columns;
        wsRaw.views = [{ state: "frozen", ySplit: startRowIndex + 2, activeCell: "A1", showGridLines: false }];
    }
    initPermissionSheet(wsRaw, startRowIndex, startColIndex) {
        const columns = [];
        this.addInitCell(wsRaw, startRowIndex, startColIndex, "İŞÇİ KALAN İZİN", Constants.Styling.AllThin);
        wsRaw.mergeCells(startRowIndex, startColIndex, startRowIndex, startColIndex + 1);
        this.addInitCell(wsRaw, startRowIndex + 1, startColIndex++, "ADI SOYADI", Constants.Styling.AllThin);
        columns.push({ width: 25 });
        this.addInitCell(wsRaw, startRowIndex + 1, startColIndex++, "KALAN İZİN", Constants.Styling.AllThin);
        columns.push({ width: 15 });
        wsRaw.columns = columns;
        wsRaw.views = [{ state: "frozen", ySplit: startRowIndex + 1, activeCell: "A1", showGridLines: false }];
    }
    addInitCell(ws, row, col, value, border) {
        const c = ws.getCell(row, col);
        c.value = value;
        c.alignment = {
            horizontal: "center",
            vertical: "middle",
            wrapText: true,
        };
        c.font = {
            bold: true,
        };
        c.border = border;
    }
    findPPermissionType(item) {
        const data = item;
        let value = "İ";
        const ppermission = data.p[0];
        if (data?.p?.length > 0) {
            switch (ppermission.pt) {
                case Constants.PPermissionTypes.hastlıkRaporu:
                    value = "R";
                    break;
                case Constants.PPermissionTypes.idariIzin:
                    value = "İİ";
                    break;
                case Constants.PPermissionTypes.uzaktanCalısma:
                case Constants.PPermissionTypes.saatlikUzaktanCalısma:
                    value = "UÇ";
                    break;
                case Constants.PPermissionTypes.gunlukVeyaYillik:
                    value = "İ";
                    break;
                case Constants.PPermissionTypes.nobet:
                    value = "Nİ";
                    break;
                case Constants.PPermissionTypes.saatlik:
                case Constants.PPermissionTypes.mazeretSaatlik:
                    value = "X";
                    break;
                case Constants.PPermissionTypes.mazeretGunluk:
                    value = "Mİ";
                    break;
                case Constants.PPermissionTypes.sendika:
                    value = "Sİ";
                    break;
                case Constants.PPermissionTypes.gorevlendirme:
                    value = "Gİ";
                    break;
                case Constants.PPermissionTypes.hastane:
                    value = "H";
                    break;
                default:
                    break;
            }
        }
        return value;
    }
    checkDay(item) {
        const weekend = this.checkWeekend(item);
        let day = "";
        const data = item?.data[0];
        if (data?.s?.uh > 0) {
            return "T";
        }
        else if (data?.s?.n > 0 || data?.s?.e > 0) {
            day = "X";
        }
        else if (data?.p?.length > 0) {
            return this.findPPermissionType(data);
        }
        if (weekend) {
            return weekend;
        }
        return day;
    }
    checkWeekend(item) {
        var day = new Date(item.data[0].d).getDay();
        if (day === 6) {
            return "C";
        }
        else if (day === 0) {
            return "P";
        }
        else {
            return null;
        }
    }
    addPermissionRow(remainingPermission, userInfo) {
        let colIndex = 1;
        this.setDataCell({
            rowIndex: this._permissionRowIndex,
            colIndex: colIndex++,
            value: userInfo.fullname.toUpperCase(),
            ws: this._wsPermission,
            border: Constants.Styling.AllThin,
        });
        this.setDataCell({
            rowIndex: this._permissionRowIndex,
            colIndex: colIndex++,
            value: remainingPermission ? remainingPermission : "",
            ws: this._wsPermission,
            border: Constants.Styling.AllThin,
        });
        for (let index = 0; index < 5; index++) {
            this.setDataCell({
                rowIndex: this._permissionRowIndex,
                colIndex: colIndex++,
                value: "",
                ws: this._wsPermission,
                border: Constants.Styling.AllThin,
            });
        }
        this._permissionRowIndex++;
    }
    addGeneralRow(days, userInfo, staticGroupBasedOperation) {
        let colIndex = 1;
        if (!days) {
            return;
        }
        this.setDataCell({
            rowIndex: this._generalRowIndex,
            colIndex: colIndex,
            value: userInfo.fullname.toUpperCase(),
            ws: this._wsGeneral,
            border: Constants.Styling.AllThin,
        });
        this._wsGeneral.mergeCells(this._generalRowIndex, colIndex, this._generalRowIndex + 1, colIndex++);
        this.setDataCell({
            rowIndex: this._generalRowIndex,
            colIndex: colIndex,
            value: "",
            ws: this._wsGeneral,
            border: Constants.Styling.AllDottedButTop,
        });
        this.setDataCell({
            rowIndex: this._generalRowIndex + 1,
            colIndex: colIndex++,
            value: "",
            ws: this._wsGeneral,
            border: Constants.Styling.BottomThinRightDotted,
        });
        this.setDataCell({
            rowIndex: this._generalRowIndex,
            colIndex: colIndex,
            value: "",
            ws: this._wsGeneral,
            border: Constants.Styling.AllDottedButTop,
        });
        this.setDataCell({
            rowIndex: this._generalRowIndex + 1,
            colIndex: colIndex,
            value: "",
            ws: this._wsGeneral,
            border: Constants.Styling.BottomThin,
            formula: "=" + this._wsGeneral.getCell(this._generalRowIndex + 1, colIndex - 1).address,
        });
        colIndex++;
        if (!days || !(days.length > 0)) {
            const start = this._options.startDate;
            const end = this._options.endDate;
            let current = start.clone();
            while (current.isSameOrBefore(end)) {
                let val = "";
                const day = current.toDate().getDay();
                if (day === 6) {
                    val = "C";
                }
                else if (day === 0) {
                    val = "P";
                }
                this.setDataCell({
                    rowIndex: this._generalRowIndex,
                    colIndex: colIndex,
                    value: "",
                    ws: this._wsGeneral,
                    border: Constants.Styling.AllDottedButTop,
                });
                this.setDataCell({
                    rowIndex: this._generalRowIndex + 1,
                    colIndex: colIndex++,
                    value: val,
                    ws: this._wsGeneral,
                    border: Constants.Styling.AllDottedButBottom,
                });
                current = current.add(1, "day");
            }
        }
        else {
            const start = this._options.startDate;
            const end = this._options.endDate;
            let current = start.clone();
            while (current.isSameOrBefore(end)) {
                const data = days.find((d) => (0, moment_1.default)(d.date).isSame(current));
                if (data) {
                    this.setDataCell({
                        rowIndex: this._generalRowIndex,
                        colIndex: colIndex,
                        value: "",
                        ws: this._wsGeneral,
                        border: Constants.Styling.AllDottedButTop,
                    });
                    this.setDataCell({
                        rowIndex: this._generalRowIndex + 1,
                        colIndex: colIndex++,
                        value: this.checkDay(data),
                        ws: this._wsGeneral,
                        border: Constants.Styling.AllDottedButBottom,
                    });
                }
                else {
                    this.setDataCell({
                        rowIndex: this._generalRowIndex,
                        colIndex: colIndex,
                        value: "",
                        ws: this._wsGeneral,
                        border: Constants.Styling.AllDottedButTop,
                    });
                    this.setDataCell({
                        rowIndex: this._generalRowIndex + 1,
                        colIndex: colIndex++,
                        value: "",
                        ws: this._wsGeneral,
                        border: Constants.Styling.AllDottedButBottom,
                    });
                }
                current = current.add(1, "day");
            }
            days.shift();
        }
        const startCell = this._wsGeneral.getCell(this._generalRowIndex + 1, colIndex - this._daysTotal - 1).address;
        const endCell = this._wsGeneral.getCell(this._generalRowIndex + 1, colIndex - 1).address;
        this.setDataCell({
            rowIndex: this._generalRowIndex,
            colIndex: colIndex,
            value: "",
            ws: this._wsGeneral,
            border: Constants.Styling.AllThin,
            formula: "COLUMNS(" + startCell + ":" + endCell + ")-COUNTIF(" + startCell + ":" + endCell + ',"R")',
        });
        this.setDataCell({
            rowIndex: this._generalRowIndex + 1,
            colIndex: colIndex++,
            value: "",
            ws: this._wsGeneral,
            border: Constants.Styling.AllThin,
            formula: "SUM(" +
                startCell +
                ":" +
                endCell +
                ")+COUNTIF(" +
                startCell +
                ":" +
                endCell +
                ',"X")+COUNTIF(' +
                startCell +
                ":" +
                endCell +
                ',"G")+COUNTIF(' +
                startCell +
                ":" +
                endCell +
                ',"İİ")+COUNTIF(' +
                startCell +
                ":" +
                endCell +
                ',"UÇ")+COUNTIF(' +
                startCell +
                ":" +
                endCell +
                ',"H")+COUNTIF(' +
                startCell +
                ":" +
                endCell +
                ',"C")+COUNTIF(' +
                startCell +
                ":" +
                endCell +
                ',"Nİ")+COUNTIF(' +
                startCell +
                ":" +
                endCell +
                ',"Gİ")',
        });
        this.setDataCell({
            rowIndex: this._generalRowIndex,
            colIndex: colIndex,
            value: "Gün Ücret",
            ws: this._wsGeneral,
            border: Constants.Styling.AllThin,
        });
        this.setDataCell({
            rowIndex: this._generalRowIndex + 1,
            colIndex: colIndex++,
            value: "Gün Kalifiye",
            ws: this._wsGeneral,
            border: Constants.Styling.AllThin,
        });
        this.setDataCell({
            rowIndex: this._generalRowIndex,
            colIndex: colIndex,
            value: "",
            ws: this._wsGeneral,
            border: Constants.Styling.AllThin,
            formula: "SUM(" +
                startCell +
                ":" +
                endCell +
                ")+COUNTIF(" +
                startCell +
                ":" +
                endCell +
                ',"X")+COUNTIF(' +
                startCell +
                ":" +
                endCell +
                ',"G")+COUNTIF(' +
                startCell +
                ":" +
                endCell +
                ',"İİ")+COUNTIF(' +
                startCell +
                ":" +
                endCell +
                ',"UÇ")+COUNTIF(' +
                startCell +
                ":" +
                endCell +
                ',"H")+COUNTIF(' +
                startCell +
                ":" +
                endCell +
                ',"Nİ")+COUNTIF(' +
                startCell +
                ":" +
                endCell +
                ',"Gİ")',
        });
        if (staticGroupBasedOperation) {
            this.setDataCell({
                rowIndex: this._generalRowIndex + 1,
                colIndex: colIndex++,
                value: 0,
                ws: this._wsGeneral,
                border: Constants.Styling.AllThin,
            });
        }
        else {
            this.setDataCell({
                rowIndex: this._generalRowIndex + 1,
                colIndex: colIndex++,
                value: "",
                ws: this._wsGeneral,
                border: Constants.Styling.AllThin,
                formula: "SUM(" +
                    startCell +
                    ":" +
                    endCell +
                    ")+COUNTIF(" +
                    startCell +
                    ":" +
                    endCell +
                    ',"X")+COUNTIF(' +
                    startCell +
                    ":" +
                    endCell +
                    ',"G")+COUNTIF(' +
                    startCell +
                    ":" +
                    endCell +
                    ',"İİ")+COUNTIF(' +
                    startCell +
                    ":" +
                    endCell +
                    ',"UÇ")+COUNTIF(' +
                    startCell +
                    ":" +
                    endCell +
                    ',"H")+COUNTIF(' +
                    startCell +
                    ":" +
                    endCell +
                    ',"Nİ")+COUNTIF(' +
                    startCell +
                    ":" +
                    endCell +
                    ',"Gİ")',
            });
        }
        this.setDataCell({
            rowIndex: this._generalRowIndex,
            colIndex: colIndex,
            value: "Gün Yemek",
            ws: this._wsGeneral,
            border: Constants.Styling.AllThin,
        });
        this.setDataCell({
            rowIndex: this._generalRowIndex + 1,
            colIndex: colIndex++,
            value: "Gün Yol",
            ws: this._wsGeneral,
            border: Constants.Styling.AllThin,
        });
        this._generalRowIndex += 2;
    }
    setDataCell(params) {
        const c = params.ws.getCell(params.rowIndex, params.colIndex);
        if (params.formula) {
            c.value = {
                formula: params.formula,
            };
        }
        else {
            c.value = params.value;
        }
        c.alignment = {
            horizontal: "left",
            vertical: "middle",
            wrapText: true,
        };
        if (params.border) {
            c.border = params.border;
        }
        if (params.backgroundColorCode)
            c.fill = {
                type: "pattern",
                pattern: "solid",
                fgColor: { argb: params.backgroundColorCode },
            };
        if (params.isTextWhite)
            c.font = {
                color: { argb: "FFFFFF" },
                bold: true,
            };
    }
    addFilterToSheet(ws, startRowIndex, startColIndex, filter, filterlength) {
        const border = {
            left: {
                style: "thin",
            },
            top: {
                style: "thin",
            },
            right: {
                style: "thin",
            },
            bottom: {
                style: "thin",
            },
        };
        this.addFilterCell(ws, startRowIndex, startColIndex, "İŞÇİ PUANTAJ CETVELİ", border, { bold: true });
        this.addFilterCell(ws, startRowIndex + 1, startColIndex, "AİT OLDUĞU AY VE YIL", border);
        this.addFilterCell(ws, startRowIndex + 1, startColIndex + 1, (0, moment_1.default)(this._options.startDate).locale(this._locale).format("LL") + " - " + (0, moment_1.default)(this._options.endDate).locale(this._locale).format("LL"), border, { italic: true }, Constants.DateFormat);
        ws.mergeCells(startRowIndex, startColIndex, startRowIndex, startColIndex + 15);
        ws.mergeCells(startRowIndex + 1, startColIndex + 1, startRowIndex + 1, startColIndex + 15);
        ws.mergeCells(startRowIndex + 2, startColIndex + 1, startRowIndex + 2, startColIndex + 15);
        this.addFilterCell(ws, startRowIndex + 2, startColIndex, "KURUMU", border);
        this.addFilterCell(ws, startRowIndex + 2, startColIndex + 2, "ŞAP ENSTİTÜSÜ MÜDÜRLÜĞÜ", border, { italic: true }, Constants.DateFormat);
    }
    addFilterCell(ws, row, col, value, border, font, numFmt) {
        const c = ws.getCell(row, col);
        c.value = value;
        c.alignment = {
            horizontal: "left",
            vertical: "middle",
            wrapText: true,
        };
        c.border = border;
        c.font = font;
        c.numFmt = numFmt;
    }
    stringfy() {
        let permissionDescriptions = [];
        for (const [key, value] of Object.entries(Constants.ppermissionTypesForSAP)) {
            permissionDescriptions.push(`${key}` + ":" + `${value}`);
        }
        return permissionDescriptions.join("\r\n");
    }
}
exports.ControlScoringSurekliIsciCustomReport = ControlScoringSurekliIsciCustomReport;
async function generateReport(request, locale) {
    const report = new ControlScoringSurekliIsciCustomReport(request, locale);
    return report.generateReport();
}
exports.generateReport = generateReport;
