"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.duplicateOrganizationUnitRemover = void 0;
const app_logs_1 = require("../../../../app.logs");
const dal_db_armon_schema_1 = require("../../../../dal/db/armon/dal.db.armon.schema");
const constants_1 = require("../utils/constants");
const dal_constants_1 = require("../../../../dal/dal.constants");
const duplicateOrganizationUnitRemover = async (client) => {
    const { rows: checkDuplicateOrganizationUnitRows, rowCount: duplicateOrganizationUnitRowCount } = await client.query(`
    SELECT DISTINCT (ou1.name) FROM "${constants_1.METU_ORGANIZATION_ID}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.organizationUnits}" ou1
    LEFT JOIN "${constants_1.METU_ORGANIZATION_ID}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.organizationUnits}" ou2
        ON regexp_replace (unaccent(lower(ou1.name)), '[\s+.]', '', 'g') = regexp_replace (unaccent(lower(ou2.name)), '[\s+.]', '', 'g') AND ou1.id != ou2.id
    WHERE ou2.id is not null
        AND ou1."deletedAt" IS NULL
        AND ou2."deletedAt" IS NULL
    `);
    if (duplicateOrganizationUnitRowCount) {
        app_logs_1.logger.warn(`There are duplicate organization units at armon database! 
Taking evasive action for units with names: ${checkDuplicateOrganizationUnitRows.map((m) => m.name).join(", ")}`);
        const { rows: updatedMappingRows, rowCount: updatedMappingRowCount } = await client.query(`
            UPDATE "${constants_1.METU_ORGANIZATION_ID}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userOrganizationOrganizationUnits}" x
            SET "organizationUnitId" = s."targetId", "source" = ${dal_constants_1.DalConstants.SourceType.System}
            FROM (
                SELECT p.id AS "targetId", uoou."organizationUnitId" 
                FROM "${constants_1.METU_ORGANIZATION_ID}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userOrganizationOrganizationUnits}" uoou
                INNER JOIN "${constants_1.METU_ORGANIZATION_ID}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.organizationUnits}" ou
                    ON uoou."organizationUnitId" = ou.id
                INNER JOIN 
                (
                    SELECT DISTINCT ON (regexp_replace (unaccent(lower(ou.name)), '[\s+.]', '', 'g'))
                    ou.id, regexp_replace (unaccent(lower(ou.name)), '[\s+.]', '', 'g') AS name 
                    FROM (
                        SELECT regexp_replace (unaccent(lower(oui.name)), '[\s+.]', '', 'g') AS name, COUNT(*)	
                        FROM "${constants_1.METU_ORGANIZATION_ID}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.organizationUnits}" oui
                            WHERE oui."deletedAt" IS NULL
                        GROUP BY regexp_replace (unaccent(lower(oui."name")), '[\s+.]', '', 'g')
                    ) k
                    INNER JOIN  "${constants_1.METU_ORGANIZATION_ID}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.organizationUnits}" ou
                        ON k.name = regexp_replace (unaccent(lower(ou.name)), '[\s+.]', '', 'g')
                        AND ou."deletedAt" IS NULL
                    LEFT JOIN "${constants_1.METU_ORGANIZATION_ID}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userOrganizationOrganizationUnits}" uoou
                        ON uoou."organizationUnitId" = ou.id
                        AND uoou."deletedAt" IS NULL
                    WHERE k.count > 1
                    GROUP BY ou.id
                    ORDER BY (regexp_replace (unaccent(lower(ou.name)), '[\s+.]', '', 'g')) asc ,  
                        (("parentId" is null), "parentId") ASC , COUNT(uoou.*) DESC
                    
                )p
                ON p.name = regexp_replace (unaccent(lower(ou.name)), '[\s+.]', '', 'g') AND p.id != ou.id
                GROUP BY (p.id, uoou."organizationUnitId") 
                ORDER BY p.id
            ) AS s
            WHERE s."organizationUnitId" = x."organizationUnitId"
        `);
        app_logs_1.logger.info(`${updatedMappingRowCount} user mappings updated`);
        const { rows: duplicateMappingRows, rowCount: duplicateMappingRowCount } = await client.query(`
            DELETE FROM "${constants_1.METU_ORGANIZATION_ID}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userOrganizationOrganizationUnits}"
            WHERE id IN (
                SELECT k.id FROM (
                    SELECT id, row_number() over (partition by  "organizationUnitId",  "userOrganizationId") AS rn
                    FROM "${constants_1.METU_ORGANIZATION_ID}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userOrganizationOrganizationUnits}"
                    WHERE "deletedAt" IS NULL) 
                AS k
                WHERE k.rn > 1
            )
        `);
        app_logs_1.logger.info(`${duplicateMappingRowCount} duplicate user mappings removed`);
        const { rows: removedUnitRows, rowCount: removedUnitRowCount } = await client.query(`
        DELETE FROM "${constants_1.METU_ORGANIZATION_ID}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.organizationUnits}"
        WHERE id IN (
            SELECT ou.id FROM "${constants_1.METU_ORGANIZATION_ID}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.organizationUnits}" ou
            LEFT JOIN "${constants_1.METU_ORGANIZATION_ID}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userOrganizationOrganizationUnits}" uoou
                ON ou.id = uoou."organizationUnitId"
            WHERE uoou.id IS NULL
            AND ou.id IN (
                SELECT DISTINCT (oui.id) FROM
                (
                    SELECT regexp_replace (unaccent(lower(ouii.name)), '[\s+.]', '', 'g') AS name, COUNT(*)	
                    FROM "${constants_1.METU_ORGANIZATION_ID}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.organizationUnits}" ouii
                    GROUP BY regexp_replace (unaccent(lower(ouii.name)), '[\s+.]', '', 'g')
                ) AS k
                INNER JOIN "${constants_1.METU_ORGANIZATION_ID}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.organizationUnits}" oui
                    ON k.name = regexp_replace (unaccent(lower(oui.name)), '[\s+.]', '', 'g')
                WHERE k.count > 1
            )
        )
        `);
        app_logs_1.logger.info(`${removedUnitRowCount} duplicate organization units removed`);
    }
    else {
        app_logs_1.logger.info(`There are no duplicate organization units at armon database. Operation resuming...`);
    }
};
exports.duplicateOrganizationUnitRemover = duplicateOrganizationUnitRemover;
