"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.generateReport = exports.GEDIZEYASAdditionalPaymentsTypeOneCustomReport = void 0;
const path_1 = __importDefault(require("path"));
const exceljs_1 = __importDefault(require("exceljs"));
const uuid = require("uuid");
const i18n_1 = __importDefault(require("i18n"));
const constants_1 = require("./models/constants");
const luxon_1 = require("luxon");
const app_config_1 = require("../../../app.config");
const app_enums_1 = require("../../../app.enums");
const generator_1 = require("../../../business/report/generator");
const dal_constants_1 = require("../../../dal/dal.constants");
const dal_manager_1 = require("../../../dal/dal.manager");
const app_logs_1 = require("../../../app.logs");
const dal_access_psql_common_1 = require("../../../dal/access/psql/dal.access.psql.common");
class GEDIZEYASAdditionalPaymentsTypeOneCustomReport extends generator_1.CustomReportGenerator {
    constructor(request, locale) {
        super(request, locale);
        this._request = request;
        this._filter = request.filter;
        this._wb = new exceljs_1.default.Workbook();
        this._options = {
            startDate: luxon_1.DateTime.fromFormat(this._filter.filters.find((i) => i.type === app_enums_1.enums.CustomOrganizationReportFilterType.DateMonth).value, "yyyy-MM").startOf("month"),
            endDate: luxon_1.DateTime.fromFormat(this._filter.filters.find((i) => i.type === app_enums_1.enums.CustomOrganizationReportFilterType.DateMonth).value, "yyyy-MM").endOf("month"),
            organizationUnitIds: this._filter.filters.find((i) => i.type === app_enums_1.enums.CustomOrganizationReportFilterType.OrganizationUnit).value,
            userGroups: this._filter.filters.find((i) => i.type === app_enums_1.enums.CustomOrganizationReportFilterType.UserGroup).value,
            organizationUnitHierarchically: this._filter.filters.find((i) => i.type === app_enums_1.enums.CustomOrganizationReportFilterType.OrganizationUnitHierarchically).value,
            userIds: this._filter.filters.find((i) => i.type === app_enums_1.enums.CustomOrganizationReportFilterType.UserIdFromFreeSearch).value,
            organizationId: this._request.organizationId,
            requesterUserId: this._request.requesterUserId,
            locale: this._locale,
        };
        this._workSheets = [];
        this._offsetDayCount = this._options.startDate.minus({ days: 1 }).day - 25;
        this._monthInterval = luxon_1.Interval.fromDateTimes(this._options.startDate, this._options.endDate);
        this._calendarDaysOfTheMonth = Math.round(this._options.endDate.diff(this._options.startDate, "days").toObject().days);
    }
    async generateReport() {
        this._filePath = await this.generateDailyFirstInLastOutReport();
        return {
            format: app_enums_1.enums.ReportFormat.Excel,
            preparedReportId: this._fileId,
            filePath: this._filePath,
            notificationType: undefined,
            customReportName: "GEDIZ EYAS SAP Ek Ödemeler",
            sendFileInAttachments: undefined,
            reportType: app_enums_1.enums.ReportCode.CustomReport,
        };
    }
    async generateDailyFirstInLastOutReport() {
        this.generateWorkSheets();
        const filters = [];
        if (this._options.organizationUnitIds && this._options.organizationUnitIds.length > 0) {
            const organizationUnitNames = await dal_manager_1.dbManager.accessOrganizationUnit.getIdNamePairsOfOrganizationUnits(this._options.organizationId, this._options.organizationUnitIds);
            filters.push(i18n_1.default.__({ phrase: "EXCEL-REPORT.ORGANIZATION_UNITS", locale: this._locale }) + " : " + organizationUnitNames.map((oun) => oun.name).join(", "));
            if (this._options.organizationUnitHierarchically) {
                filters.push(i18n_1.default.__({ phrase: "EXCEL-REPORT.INCLUDE_DESCENDANTS", locale: this._locale }) + " : " + i18n_1.default.__({ phrase: "EXCEL-REPORT.YES", locale: this._locale }));
            }
        }
        if (this._options.userGroups && this._options.userGroups.length > 0) {
            let userGroupNames = (await dal_manager_1.dbManager.accessUserGroup.listUserGroupsByIds(this._request.organizationId, this._options.userGroups)).map((elem) => elem.name).join(", ");
            filters.push(i18n_1.default.__({ phrase: "EXCEL-REPORT.USER_GROUPS", locale: this._locale }) + " : " + userGroupNames);
        }
        this.addFilterToSheet(this._workSheets.find((elem) => elem.key === "FILTER"), filters.join("\r\n"));
        this._workSheets.forEach((elem) => {
            if (elem.key !== "FILTER") {
                this.initGeneralSheet(elem, 1);
            }
        });
        const requestedUserCaption = await dal_manager_1.dbManager.accessUser.getUserOrganizationCaptionLines(this._options.organizationId, [this._options.requesterUserId]);
        if (requestedUserCaption.length < 1) {
            throw new Error("Not found");
        }
        let userFilter = (0, dal_access_psql_common_1.getReportUserFilterForPgClient)({
            organizationId: this._options.organizationId,
            requesterUserId: this._options.requesterUserId,
            idBasedUserFilter: {
                userGroupIds: this._options.userGroups,
                organizationUnitIds: this._options.organizationUnitIds,
                userOrganizationStatus: dal_constants_1.DalConstants.IdentityStatusType.All,
                userIds: this._options.userIds,
            },
            requiredOrganizationUnitWidePermissions: ["e:u", "u:b", "g:r", "i:b"],
            requiredOrganizationWidePermissions: ["e:u", "u:b", "g:r", "i:b"],
            bindingKeys: [],
            specificSelectItems: ["userId", "name", "surname", "uniqueId"],
        });
        await dal_manager_1.dbManager.systemTransaction(async (trx) => {
            let { query, bindings } = (0, constants_1.generateEmployeeDataQuery)(this._options.organizationId, userFilter, this._options.startDate.toSQL(), this._options.startDate.minus({ days: this._offsetDayCount }).toSQL(), this._options.endDate.toSQL(), this._options.endDate.set({ day: 26 }).toSQL());
            await trx.query(query, bindings);
            let { rows } = await trx.query("FETCH 100 FROM employee_day_cursor");
            while (rows.length > 0) {
                this.addGeneralRow(rows);
                rows = (await trx.query("FETCH 100 FROM employee_day_cursor")).rows;
            }
            await trx.query(`CLOSE employee_day_cursor;`);
        });
        if (requestedUserCaption[0].captionLines && requestedUserCaption[0].captionLines[0] && requestedUserCaption[0].captionLines[0].text !== null) {
            this._requestedUserCaption = requestedUserCaption[0].captionLines[0].text[0];
        }
        else {
            this._requestedUserCaption = "";
        }
        this._wb.creator = this._requestedUserCaption;
        app_logs_1.logger.debug("Generating report...");
        this._fileId = uuid.v4();
        this._filePath = path_1.default.join(app_config_1.appConfig.tmpDirectory, this._fileId + ".xlsx");
        await this._wb.xlsx.writeFile(this._filePath);
        app_logs_1.logger.debug("File is ready -> " + this._filePath);
        return this._filePath;
    }
    generateWorkSheets() {
        this._workSheets.push({
            key: constants_1.AdditionalPaymentFirstReportFeeTypes.YEMEK_ODEME_SENDIKA,
            workSheet: this._wb.addWorksheet("Yemek Ödeme Sendika 2975", {
                pageSetup: { fitToPage: true, fitToWidth: 1, fitToHeight: 0, paperSize: 9, orientation: "landscape" },
            }),
            rowIndex: 1,
        });
        this._workSheets.push({
            key: constants_1.AdditionalPaymentFirstReportFeeTypes.YEMEK_UCRETI_NET,
            workSheet: this._wb.addWorksheet("Yemek Sayısı-2010", {
                pageSetup: { fitToPage: true, fitToWidth: 1, fitToHeight: 0, paperSize: 9, orientation: "landscape" },
            }),
            rowIndex: 1,
        });
        this._workSheets.push({
            key: constants_1.AdditionalPaymentFirstReportFeeTypes.YOL_UCRETI_AKTARIM,
            workSheet: this._wb.addWorksheet("Yol Ücreti Aktarım-2050", {
                pageSetup: { fitToPage: true, fitToWidth: 1, fitToHeight: 0, paperSize: 9, orientation: "landscape" },
            }),
            rowIndex: 1,
        });
        this._workSheets.push({
            key: "FILTER",
            workSheet: this._wb.addWorksheet("Uygulanan Filtreler", {
                pageSetup: { fitToPage: true, fitToWidth: 1, fitToHeight: 0, paperSize: 9, orientation: "landscape" },
            }),
            rowIndex: 1,
        });
    }
    initGeneralSheet(workSheetProps, startColIndex) {
        const columns = [];
        this.addInitCell(workSheetProps.workSheet, workSheetProps.rowIndex, startColIndex++, i18n_1.default.__({ phrase: "EXCEL-REPORT.EMPLOYEE_NUMBER", locale: this._locale }), generator_1.ReportGenerator.Constants.Styling.AllThin);
        columns.push({ width: 45 });
        this.addInitCell(workSheetProps.workSheet, workSheetProps.rowIndex, startColIndex++, "İsim Soyisim", generator_1.ReportGenerator.Constants.Styling.AllThin);
        columns.push({ width: 45 });
        this.addInitCell(workSheetProps.workSheet, workSheetProps.rowIndex, startColIndex++, i18n_1.default.__({ phrase: "EXCEL-REPORT.START_DATE", locale: this._locale }), generator_1.ReportGenerator.Constants.Styling.AllThin);
        columns.push({ width: 45 });
        this.addInitCell(workSheetProps.workSheet, workSheetProps.rowIndex, startColIndex++, i18n_1.default.__({ phrase: "EXCEL-REPORT.END_DATE", locale: this._locale }), generator_1.ReportGenerator.Constants.Styling.AllThin);
        columns.push({ width: 45 });
        this.addInitCell(workSheetProps.workSheet, workSheetProps.rowIndex, startColIndex++, i18n_1.default.__({ phrase: "EXCEL-REPORT.FEE_TYPE", locale: this._locale }), generator_1.ReportGenerator.Constants.Styling.AllThin);
        columns.push({ width: 45 });
        this.addInitCell(workSheetProps.workSheet, workSheetProps.rowIndex, startColIndex++, "Ücret Türü Açıklaması", generator_1.ReportGenerator.Constants.Styling.AllThin);
        columns.push({ width: 45 });
        this.addInitCell(workSheetProps.workSheet, workSheetProps.rowIndex, startColIndex++, i18n_1.default.__({ phrase: "CUSTOM-REPORT.GEDIZ.AMOUNT", locale: this._locale }), generator_1.ReportGenerator.Constants.Styling.AllThin);
        columns.push({ width: 45 });
        this.addInitCell(workSheetProps.workSheet, workSheetProps.rowIndex, startColIndex++, i18n_1.default.__({ phrase: "CUSTOM-REPORT.GEDIZ.DAY_COUNT", locale: this._locale }), generator_1.ReportGenerator.Constants.Styling.AllThin);
        columns.push({ width: 45 });
        columns.push({
            width: 45,
        });
        workSheetProps.rowIndex += 1;
        workSheetProps.workSheet.columns = columns;
        workSheetProps.workSheet.views = [{ state: "frozen", ySplit: 1, activeCell: "A1", showGridLines: false }];
    }
    addInitCell(ws, row, col, value, border) {
        const c = ws.getCell(row, col);
        c.value = value;
        c.alignment = {
            horizontal: "center",
            vertical: "middle",
            wrapText: true,
        };
        c.font = {
            bold: true,
        };
        c.border = border;
    }
    async addGeneralRow(userInfo) {
        this._workSheets.forEach((elem) => {
            if (elem.key !== "FILTER") {
                userInfo.forEach((user) => {
                    Object.entries(constants_1.FirstReportFeeTypeRules).forEach(([typeId, feeTypeRule]) => {
                        const employmentStartUtc = user.employmentStartUtc ? luxon_1.DateTime.fromJSDate(user.employmentStartUtc) : undefined;
                        const employmentEndUtc = user.employmentEndUtc ? luxon_1.DateTime.fromJSDate(user.employmentEndUtc) : undefined;
                        let feeCount = user.countOfWorkingDays;
                        if (feeTypeRule.rules.find((rule) => {
                            if (rule.extensionFieldRules.every((extField) => {
                                return extField.validValues.includes(user.extensionFields[extField.key]);
                            })) {
                                rule.decreasingPermissions.forEach((permType) => {
                                    const permUsage = user.permissions
                                        ?.filter((elem) => elem.typeId === permType)
                                        .map((item) => item.usageDay)
                                        .reduce((acc, curr) => acc + curr, 0);
                                    feeCount -= permUsage ?? 0;
                                });
                                return true;
                            }
                        }) &&
                            typeId === elem.key) {
                            let columnIndex = 1;
                            if (constants_1.UniqueIdExtensionFieldRule.validValues.includes(user.extensionFields[constants_1.UniqueIdExtensionFieldRule.key])) {
                                this.setDataCell({
                                    rowIndex: elem.rowIndex,
                                    colIndex: columnIndex++,
                                    value: user.uniqueId,
                                    ws: elem.workSheet,
                                    border: generator_1.ReportGenerator.Constants.Styling.Dotted,
                                });
                            }
                            else {
                                this.setDataCell({
                                    rowIndex: elem.rowIndex,
                                    colIndex: columnIndex++,
                                    value: " ",
                                    ws: elem.workSheet,
                                    border: generator_1.ReportGenerator.Constants.Styling.Dotted,
                                });
                            }
                            this.setDataCell({
                                rowIndex: elem.rowIndex,
                                colIndex: columnIndex++,
                                value: user.fullname,
                                ws: elem.workSheet,
                                border: generator_1.ReportGenerator.Constants.Styling.Dotted,
                            });
                            this.setDataCell({
                                rowIndex: elem.rowIndex,
                                colIndex: columnIndex++,
                                value: employmentStartUtc && this._monthInterval.contains(employmentStartUtc)
                                    ? employmentStartUtc.toFormat("dd.MM.yyyy")
                                    : this._options.startDate.toFormat("dd.MM.yyyy"),
                                ws: elem.workSheet,
                                border: generator_1.ReportGenerator.Constants.Styling.Dotted,
                            });
                            this.setDataCell({
                                rowIndex: elem.rowIndex,
                                colIndex: columnIndex++,
                                value: employmentEndUtc && this._monthInterval.contains(employmentEndUtc)
                                    ? employmentEndUtc.toFormat("dd.MM.yyyy")
                                    : this._options.endDate.toFormat("dd.MM.yyyy"),
                                ws: elem.workSheet,
                                border: generator_1.ReportGenerator.Constants.Styling.Dotted,
                            });
                            this.setDataCell({
                                rowIndex: elem.rowIndex,
                                colIndex: columnIndex++,
                                value: typeId,
                                ws: elem.workSheet,
                                border: generator_1.ReportGenerator.Constants.Styling.Dotted,
                            });
                            this.setDataCell({
                                rowIndex: elem.rowIndex,
                                colIndex: columnIndex++,
                                value: feeTypeRule.name,
                                ws: elem.workSheet,
                                border: generator_1.ReportGenerator.Constants.Styling.Dotted,
                            });
                            this.setDataCell({
                                rowIndex: elem.rowIndex,
                                colIndex: columnIndex++,
                                value: "",
                                ws: elem.workSheet,
                                border: generator_1.ReportGenerator.Constants.Styling.Dotted,
                            });
                            if (typeId === constants_1.AdditionalPaymentFirstReportFeeTypes.YEMEK_ODEME_SENDIKA) {
                                this.setDataCell({
                                    rowIndex: elem.rowIndex,
                                    colIndex: columnIndex++,
                                    value: user.mealFee,
                                    ws: elem.workSheet,
                                    border: generator_1.ReportGenerator.Constants.Styling.Dotted,
                                });
                            }
                            else {
                                this.setDataCell({
                                    rowIndex: elem.rowIndex,
                                    colIndex: columnIndex++,
                                    value: feeCount,
                                    ws: elem.workSheet,
                                    border: generator_1.ReportGenerator.Constants.Styling.Dotted,
                                });
                            }
                            elem.rowIndex++;
                        }
                    });
                });
            }
        });
    }
    setDataCell(params) {
        const c = params.ws.getCell(params.rowIndex, params.colIndex);
        if (params.formula) {
            c.value = {
                formula: params.formula,
            };
        }
        else {
            c.value = params.value;
        }
        c.alignment = {
            horizontal: "left",
            vertical: "middle",
            wrapText: true,
        };
        if (params.border) {
            c.border = params.border;
        }
        if (params.backgroundColorCode)
            c.fill = {
                type: "pattern",
                pattern: "solid",
                fgColor: { argb: params.backgroundColorCode },
            };
        if (params.isTextWhite)
            c.font = {
                color: { argb: "FFFFFF" },
                bold: true,
            };
    }
    addFilterToSheet(ws, filter) {
        const startColIndex = 1;
        const columns = [{ width: 45 }, { width: 45 }, { width: 45 }];
        this.addFilterCell(ws.workSheet, ws.rowIndex, startColIndex, "EK ÖDEMELER RAPORU", constants_1.HeadersStyling.v1.border, constants_1.HeadersStyling.v1.font);
        ws.workSheet.mergeCells(ws.rowIndex, startColIndex, ws.rowIndex, startColIndex + 2);
        this.addFilterCell(ws.workSheet, ws.rowIndex + 1, startColIndex, "AİT OLDUĞU AY VE YIL", constants_1.HeadersStyling.v2.border, constants_1.HeadersStyling.v2.font);
        this.addFilterCell(ws.workSheet, ws.rowIndex + 1, startColIndex + 1, this._options.startDate.setLocale(this._locale).toFormat("LLLL yyyy"), constants_1.HeadersStyling.v2.border, constants_1.HeadersStyling.v3.font, generator_1.ReportGenerator.Constants.DateFormat);
        ws.workSheet.mergeCells(ws.rowIndex + 1, startColIndex + 1, ws.rowIndex + 1, startColIndex + 2);
        this.addFilterCell(ws.workSheet, ws.rowIndex + 2, startColIndex, "KURUM", constants_1.HeadersStyling.v2.border, constants_1.HeadersStyling.v2.font);
        this.addFilterCell(ws.workSheet, ws.rowIndex + 2, startColIndex + 1, "GEDIZ EYAS", constants_1.HeadersStyling.v2.border, constants_1.HeadersStyling.v3.font);
        ws.workSheet.mergeCells(ws.rowIndex + 2, startColIndex + 1, ws.rowIndex + 2, startColIndex + 2);
        if (filter.length > 0) {
            this.addFilterCell(ws.workSheet, ws.rowIndex + 3, startColIndex, "UYGULANAN FILTRELER", constants_1.HeadersStyling.v2.border, constants_1.HeadersStyling.v2.font);
            this.addFilterCell(ws.workSheet, ws.rowIndex + 3, startColIndex + 1, filter, constants_1.HeadersStyling.v2.border, constants_1.HeadersStyling.v3.font);
            ws.workSheet.mergeCells(ws.rowIndex + 3, startColIndex + 1, ws.rowIndex + 3, startColIndex + 2);
            let filterlength = filter.split("\r\n").length;
            let row = ws.workSheet.getRow(ws.rowIndex + 3);
            row.height = filterlength * 30;
        }
        ws.workSheet.columns = columns;
        ws.workSheet.views = [{ state: "frozen", ySplit: 4, activeCell: "A1", showGridLines: false }];
    }
    addFilterCell(ws, row, col, value, border, font, numFmt) {
        const c = ws.getCell(row, col);
        c.value = value;
        c.alignment = {
            horizontal: "left",
            vertical: "middle",
            wrapText: true,
        };
        c.border = border;
        c.font = font;
        c.numFmt = numFmt;
    }
}
exports.GEDIZEYASAdditionalPaymentsTypeOneCustomReport = GEDIZEYASAdditionalPaymentsTypeOneCustomReport;
async function generateReport(request, locale) {
    const report = new GEDIZEYASAdditionalPaymentsTypeOneCustomReport(request, locale);
    return report.generateReport();
}
exports.generateReport = generateReport;
