"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.transformNotificationToCRMParameters = void 0;
const restapi_1 = require("../../../lib/es/models/restapi");
const crm_consts_1 = require("./crm-consts");
const dal_manager_1 = require("../../../dal/dal.manager");
const generator_1 = require("../../../business/notification/generator");
const luxon_1 = require("luxon");
const dal_db_armon_schema_1 = require("../../../dal/db/armon/dal.db.armon.schema");
const dal_constants_1 = require("../../../dal/dal.constants");
const transformNotificationToCRMParameters = async (organizationId, params, trx) => {
    const notificationEvent = await dal_manager_1.dbManager.accessNotifications.getNotificationOfEvent({ organizationId: params.message.o, eventId: params.message.i, trx });
    const receiverUserDbResult = await trx.query(`
		SELECT "receiverUserId"
		FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.notificationInstance}"
		WHERE id = $1
	`, [params.instanceId]);
    const receiverUserId = receiverUserDbResult.rows[0]?.receiverUserId;
    switch (notificationEvent.type) {
        case restapi_1.NotificationType.VisitorCame:
            const visitorCameInstanceData = params.message.d;
            const visitorCameVisitInfo = await dal_manager_1.dbManager.accessVisitor.getVisitorFullnameAndRegistrationPoint(organizationId, visitorCameInstanceData.a, trx);
            const receiverUser = await dal_manager_1.dbManager.accessRedisCache.getUserNotificationCache({ organizationId, userId: receiverUserId, trx: trx });
            if (params.medium === restapi_1.NotificationMedium.Email) {
                const baseEmailParameters = await getBaseEmailParameters(organizationId, {
                    notificationType: notificationEvent.type,
                    locale: "tr",
                    receiverUserId,
                }, trx);
                let transformedVariables = [
                    ...baseEmailParameters,
                    { PNAME: "P5", PVALUE: visitorCameVisitInfo.date.toLocaleString("tr") },
                    { PNAME: "P6", PVALUE: visitorCameVisitInfo.visitorFullname },
                ];
                let campaignCode;
                switch (visitorCameVisitInfo.visitorRegistrationPointId) {
                    case crm_consts_1.EnerjiSAVisitorRegistrationPointIds.BASKENT:
                    case crm_consts_1.EnerjiSAVisitorRegistrationPointIds.HANIMELI:
                        campaignCode = crm_consts_1.EmailCampaignCode.BASKENT_VISITOR_CAME;
                        break;
                    case crm_consts_1.EnerjiSAVisitorRegistrationPointIds.AYEDAS:
                    case crm_consts_1.EnerjiSAVisitorRegistrationPointIds.KUCUKYALI:
                        campaignCode = crm_consts_1.EmailCampaignCode.AYEDAS_VISITOR_CAME;
                        break;
                    case crm_consts_1.EnerjiSAVisitorRegistrationPointIds.TOROSLAR:
                        campaignCode = crm_consts_1.EmailCampaignCode.TOROSLAR_VISITOR_CAME;
                        break;
                }
                return {
                    isImplemented: true,
                    transformedParameters: {
                        campaignCode,
                        campaignVariables: transformedVariables,
                        reciever: receiverUser.e,
                    },
                };
            }
            else {
                let campaignCode;
                switch (visitorCameVisitInfo.visitorRegistrationPointId) {
                    case crm_consts_1.EnerjiSAVisitorRegistrationPointIds.BASKENT:
                    case crm_consts_1.EnerjiSAVisitorRegistrationPointIds.HANIMELI:
                        campaignCode = crm_consts_1.SMSCampaignCode.BASKENT_VISITOR_CAME;
                        break;
                    case crm_consts_1.EnerjiSAVisitorRegistrationPointIds.AYEDAS:
                    case crm_consts_1.EnerjiSAVisitorRegistrationPointIds.KUCUKYALI:
                        campaignCode = crm_consts_1.SMSCampaignCode.AYEDAS_VISITOR_CAME;
                        break;
                    case crm_consts_1.EnerjiSAVisitorRegistrationPointIds.TOROSLAR:
                        campaignCode = crm_consts_1.SMSCampaignCode.TOROSLAR_VISITOR_CAME;
                        break;
                }
                let transformedVariables = [
                    { PNAME: "P1", PVALUE: receiverUser.f },
                    { PNAME: "P2", PVALUE: visitorCameVisitInfo.visitorFullname },
                ];
                return {
                    isImplemented: true,
                    transformedParameters: {
                        campaignCode,
                        campaignVariables: transformedVariables,
                        reciever: receiverUser.m,
                    },
                };
            }
        case restapi_1.NotificationType.VisitorInvitation:
            const visitorInvitationInstanceData = params.message.d;
            const invitationInfo = visitorInvitationInstanceData.i;
            const invitationVisitInfo = await dal_manager_1.dbManager.accessVisitor.getVisitorFullnameAndRegistrationPoint(organizationId, invitationInfo.visitId, trx);
            if (params.medium === restapi_1.NotificationMedium.Email) {
                return {
                    isImplemented: false,
                    transformedParameters: null,
                };
            }
            else {
                let campaignCode;
                switch (invitationVisitInfo.visitorRegistrationPointId) {
                    case crm_consts_1.EnerjiSAVisitorRegistrationPointIds.BASKENT:
                    case crm_consts_1.EnerjiSAVisitorRegistrationPointIds.HANIMELI:
                        campaignCode = crm_consts_1.SMSCampaignCode.BASKENT_VISITOR_INVITATION;
                        break;
                    case crm_consts_1.EnerjiSAVisitorRegistrationPointIds.AYEDAS:
                    case crm_consts_1.EnerjiSAVisitorRegistrationPointIds.KUCUKYALI:
                        campaignCode = crm_consts_1.SMSCampaignCode.AYEDAS_VISITOR_INVITATION;
                        break;
                    case crm_consts_1.EnerjiSAVisitorRegistrationPointIds.TOROSLAR:
                        campaignCode = crm_consts_1.SMSCampaignCode.TOROSLAR_VISITOR_INVITATION;
                        break;
                    default:
                        if (!invitationVisitInfo?.visitorRegistrationPointId) {
                            const preRegistrationCheckDbResult = await trx.query(`
								SELECT log->>'r' as "requesterUserId"
								FROM "${organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.VisitorPreregistrationHistory}"
								WHERE log->>'vid' = $1
							`, [invitationInfo.visitId]);
                            if (preRegistrationCheckDbResult.rowCount) {
                                const preregistrarUserId = preRegistrationCheckDbResult.rows[0].requesterUserId;
                                const preregistrarUser = await dal_manager_1.dbManager.accessIdentity.getIdentityDetailed(organizationId, dal_constants_1.DalConstants.SystemUserId, {
                                    userId: preregistrarUserId,
                                    hasIdentityFullWrite: true,
                                    hasOrganizationWideRight: true,
                                    trx,
                                });
                                if (preregistrarUser?.organizationProfile?.extensionFields["org_company_code"]) {
                                    switch (preregistrarUser.organizationProfile.extensionFields["org_company_code"]) {
                                        case "0050":
                                            campaignCode = crm_consts_1.SMSCampaignCode.BASKENT_VISITOR_INVITATION;
                                            break;
                                        case "0680":
                                            campaignCode = crm_consts_1.SMSCampaignCode.AYEDAS_VISITOR_INVITATION;
                                            break;
                                        case "0750":
                                            campaignCode = crm_consts_1.SMSCampaignCode.TOROSLAR_VISITOR_INVITATION;
                                            break;
                                    }
                                }
                            }
                        }
                        break;
                }
                let transformedVariables = [
                    { PNAME: "P1", PVALUE: invitationInfo.organizationContactInfo.name },
                    { PNAME: "P2", PVALUE: "https://panel.armongate.com/qr/?qr=" + encodeURI(JSON.stringify(invitationInfo.qrCodeData)) },
                ];
                return {
                    isImplemented: true,
                    transformedParameters: {
                        campaignCode,
                        campaignVariables: transformedVariables,
                        reciever: Array.isArray(invitationInfo.visitorProfile.fields)
                            ? invitationInfo.visitorProfile.fields.find((f) => f.name === "uniqueId")?.value
                            : invitationInfo.visitorProfile.fields.uniqueId,
                    },
                };
            }
        default:
            return {
                isImplemented: false,
                transformedParameters: null,
            };
    }
};
exports.transformNotificationToCRMParameters = transformNotificationToCRMParameters;
const getBaseEmailParameters = async (organizationId, params, trx) => {
    const urls = await (0, generator_1.unsubscribeUrls)({ organizationId, notificationType: params.notificationType, receiverUserId: params.receiverUserId, locale: params.locale, trx });
    return [
        {
            PNAME: "P1",
            PVALUE: "data:image/jpeg;base64,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",
        },
        { PNAME: "P2", PVALUE: urls.unsubscribeTypeUrl },
        { PNAME: "P3", PVALUE: urls.unsubscribeEmailUrl },
        { PNAME: "P4", PVALUE: luxon_1.DateTime.now().year.toString() },
    ];
};
