"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CRMNotificationTask = void 0;
const app_enums_1 = require("../../../app.enums");
const app_logs_1 = require("../../../app.logs");
const dal_manager_1 = require("../../../dal/dal.manager");
const restapi_1 = require("../../../lib/es/models/restapi");
const crm_api_1 = require("./crm-api");
const crmSecretId = "d498a852-982a-49da-937d-d97bd5742864";
class CRMNotificationTask {
    constructor(params, transformResult) {
        this._notificationParams = params;
        this._transformedResult = transformResult;
    }
    async perform() {
        console.log(`Sending notification with instance id ${this._notificationParams.notification.instanceId} via CRM Notification Queue`);
        let crmInstance = await dal_manager_1.dbManager.systemTransaction(async (trx) => {
            return crm_api_1.CRMAPI.getInstance(this._notificationParams.message.o, crmSecretId, trx);
        });
        switch (this._notificationParams.medium) {
            case restapi_1.NotificationMedium.Email:
                const mailResult = await crmInstance.sendMail(this._transformedResult.transformedParameters.campaignCode, this._transformedResult.transformedParameters.campaignVariables, [this._transformedResult.transformedParameters.reciever], this._notificationParams.notification.instanceId);
                if (mailResult.isSuccess) {
                    await dal_manager_1.dbManager.systemTransaction(async (trx) => {
                        await dal_manager_1.dbManager.accessNotifications.setNotificationInstanceState({
                            instanceId: this._notificationParams.notification.instanceId,
                            organizationId: this._notificationParams.organizationId,
                            state: 4,
                            trx,
                        });
                    });
                }
                else {
                    app_logs_1.logger.error(`[crm-queue.ts] Custom notification channel send error for notification with instance id [${this._notificationParams.notification.instanceId}], details are above`);
                    await dal_manager_1.dbManager.systemTransaction(async (trx) => {
                        await dal_manager_1.dbManager.accessNotifications.setNotificationInstanceState({
                            instanceId: this._notificationParams.notification.instanceId,
                            organizationId: this._notificationParams.organizationId,
                            state: 3,
                            actionNote: {
                                errorCode: app_enums_1.enums.ErrorCode.CustomNotificationChannelError,
                                message: `Error while sending email notification via CRM. CRM response: ${JSON.stringify(mailResult.failReason, null, 4)}`,
                            },
                            trx,
                        });
                    });
                }
                break;
            case restapi_1.NotificationMedium.SMS:
                const regex = new RegExp(/^5([0-9]){9}$/);
                if (!regex.test(this._transformedResult.transformedParameters.reciever.replace(/\s/g, ""))) {
                    await dal_manager_1.dbManager.systemTransaction(async (trx) => {
                        await dal_manager_1.dbManager.accessNotifications.setNotificationInstanceState({
                            instanceId: this._notificationParams.notification.instanceId,
                            organizationId: this._notificationParams.organizationId,
                            state: 3,
                            actionNote: {
                                errorCode: app_enums_1.enums.ErrorCode.CustomNotificationChannelError,
                                message: `User phone number is not vaild for CRM.`,
                            },
                            trx,
                        });
                    });
                }
                const smsResult = await crmInstance.sendSMS(this._transformedResult.transformedParameters.campaignCode, this._transformedResult.transformedParameters.campaignVariables, this._transformedResult.transformedParameters.reciever.replace(/\s/g, ""), this._notificationParams.notification.instanceId);
                if (smsResult.isSuccess) {
                    await dal_manager_1.dbManager.systemTransaction(async (trx) => {
                        await dal_manager_1.dbManager.accessNotifications.setNotificationInstanceState({
                            instanceId: this._notificationParams.notification.instanceId,
                            organizationId: this._notificationParams.organizationId,
                            state: 4,
                            trx,
                        });
                    });
                }
                else {
                    app_logs_1.logger.error(`[crm-queue.ts] Custom notification channel send error for notification with instance id [${this._notificationParams.notification.instanceId}], details are above`);
                    await dal_manager_1.dbManager.systemTransaction(async (trx) => {
                        await dal_manager_1.dbManager.accessNotifications.setNotificationInstanceState({
                            instanceId: this._notificationParams.notification.instanceId,
                            organizationId: this._notificationParams.organizationId,
                            state: 3,
                            actionNote: {
                                errorCode: app_enums_1.enums.ErrorCode.CustomNotificationChannelError,
                                message: `Error while sending sms notification via CRM. CRM response: ${JSON.stringify(smsResult.failReason, null, 4)}`,
                            },
                            trx,
                        });
                    });
                }
                break;
            default:
                break;
        }
    }
}
exports.CRMNotificationTask = CRMNotificationTask;
