"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CreateHook = void 0;
const business_hooks_1 = require("../../../business/business.hooks");
function CreateHook() {
    return new ArventoHook();
}
exports.CreateHook = CreateHook;
class ArventoHook extends business_hooks_1.OrganizationHookModels.IArmonHook {
    constructor() {
        super();
        this.permissionApprovementLevel = async function (rootOrganizationIdsApprovementList, neededApprovements) {
            const rootOrganizationApprovementListExceptHR = rootOrganizationIdsApprovementList.filter((elem) => elem !== null);
            let neededApprovementsExceptRoot = [];
            if (neededApprovements.filter((elem) => elem.organizationUnitId !== null).length > 1) {
                let afterRootDecreaseOrder = false;
                for (const approvements of neededApprovements) {
                    if (rootOrganizationApprovementListExceptHR.includes(approvements.organizationUnitId)) {
                        afterRootDecreaseOrder = true;
                    }
                    if (approvements.organizationUnitId === null || !rootOrganizationApprovementListExceptHR.includes(approvements.organizationUnitId)) {
                        if (afterRootDecreaseOrder) {
                            approvements.order = approvements.order - 1;
                        }
                        neededApprovementsExceptRoot.push(approvements);
                    }
                }
            }
            else {
                neededApprovementsExceptRoot = neededApprovements;
            }
            return neededApprovementsExceptRoot;
        }.bind(this);
    }
}
