"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CreateHook = void 0;
const business_hooks_1 = require("../../../business/business.hooks");
const dal_manager_1 = require("../../../dal/dal.manager");
function CreateHook() {
    return new AlfaSolarHook();
}
exports.CreateHook = CreateHook;
class AlfaSolarHook extends business_hooks_1.OrganizationHookModels.IArmonHook {
    constructor() {
        super();
        this.changePermissionApprovementLevel = async function (organizationId, userId, approvementList, permissionTypeId) {
            const annualPermissionTypeId = "75de69bd-8abc-4407-823a-9b464b33b19d";
            const organizationIdNamePair = [
                {
                    name: "Kuzey Uretim",
                    id: "2f549bb6-cd0a-4b30-8e93-61aaf7e6591a",
                },
                {
                    name: "Mustafa Sayar",
                    id: "e3574db2-6103-4f1b-be92-ce1839798210",
                },
                {
                    name: "Burak Bülbül",
                    id: "d948638e-7f99-44bf-8ad5-fb242c5d15f4",
                },
                {
                    name: "Mikail Bilgin",
                    id: "73f6045e-c9f1-46a6-bf82-be191da1a4ba",
                },
                {
                    name: "Güney Uretim",
                    id: "68a21e58-72fe-4aff-9f38-45d1e2488cc8",
                },
                {
                    name: "Sahin Baran",
                    id: "4fc76c00-f01b-4edd-8279-767bb9bf1e2d",
                },
                {
                    name: "Furkan Aydın",
                    id: "b5cc779d-525c-4667-b27d-9b5f89b160f2",
                },
                {
                    name: "Hulusi Tanrıverdi",
                    id: "3a245305-c6ee-4e72-881c-e3fcc06eb051",
                },
            ];
            const permissionApprovementRule = ["239c5522-1d4a-4a04-afab-15e078d2961f", "239c5522-1d4a-4a04-afab-15e078d2961f", null];
            const organizationUnitsOfUser = await dal_manager_1.dbManager.accessOrganizationUnit.getOrganizationUnitBasicOfUser(organizationId, userId);
            if (permissionTypeId &&
                permissionTypeId === annualPermissionTypeId &&
                organizationUnitsOfUser.find((elem) => organizationIdNamePair.find((item) => item.id === elem.id && elem.manager?.id !== userId))) {
                return permissionApprovementRule;
            }
            return approvementList;
        }.bind(this);
    }
}
