"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CreateHook = void 0;
const business_hooks_1 = require("../../../business/business.hooks");
const moment_1 = __importDefault(require("moment"));
const dal_manager_1 = require("../../../dal/dal.manager");
const moment_range_1 = require("moment-range");
const EXCUSE_PERMISSION_TYPE_ID = "1d709efc-60af-45e7-a8f8-48e0c3d84cc5";
function CreateHook() {
    return new BatisanAydinlatmaHook();
}
exports.CreateHook = CreateHook;
class BatisanAydinlatmaHook extends business_hooks_1.OrganizationHookModels.IArmonHook {
    constructor() {
        super();
        this.getPPermissionsClaimWindowRanges = async function (organizationId, userId, ppermissionTypeId, timestamp) {
            let ppermissionWindowRanges = {
                weekRange: new moment_range_1.DateRange(timestamp.clone().startOf("week"), timestamp.clone().add(1, "week").startOf("week")),
                monthRange: new moment_range_1.DateRange(timestamp.clone().startOf("month"), timestamp.clone().add(1, "month").startOf("month")),
                yearRange: new moment_range_1.DateRange(timestamp.clone().startOf("year"), timestamp.clone().add(1, "year").startOf("year")),
            };
            const employmentStartUtc = (await dal_manager_1.dbManager.accessUser.getUserOrganizationProfileEmploymentInfo(organizationId, userId))?.employmentStartUtc;
            if (employmentStartUtc && ppermissionTypeId === EXCUSE_PERMISSION_TYPE_ID) {
                const employeeTimestamp = (0, moment_1.default)(employmentStartUtc);
                if (timestamp.isSameOrAfter(employeeTimestamp)) {
                    const yearRange = new moment_range_1.DateRange(employeeTimestamp.clone(), employeeTimestamp.clone().add(1, "year"));
                    while (!yearRange.contains(timestamp)) {
                        yearRange.start = yearRange.end.clone();
                        yearRange.end = yearRange.end.clone().add(1, "year");
                    }
                    ppermissionWindowRanges.yearRange = yearRange;
                }
            }
            return ppermissionWindowRanges;
        };
        this.getPPermissionsClaimWindowRangesBulk = async function (organizationId, userIds, ppermissionTypeIds, timestamp, trx) {
            const resultMap = new Map();
            const employmentInfo = await dal_manager_1.dbManager.accessUser.getEmploymentsUserOrganizationProfileInfos(organizationId, userIds, trx);
            const employmentStartUtcMap = new Map();
            employmentInfo?.forEach((employmentInfo) => employmentStartUtcMap.set(employmentInfo.userId, employmentInfo?.employeeProfileInfo.employmentStartUtc));
            for (const userId of userIds) {
                const userResultMap = new Map();
                for (const ppermissionTypeId of ppermissionTypeIds) {
                    let weekRange = new moment_range_1.DateRange(timestamp.clone().startOf("week"), timestamp.clone().add(1, "week").startOf("week"));
                    let monthRange = new moment_range_1.DateRange(timestamp.clone().startOf("month"), timestamp.clone().add(1, "month").startOf("month"));
                    let yearRange = new moment_range_1.DateRange(timestamp.clone().startOf("year"), timestamp.clone().add(1, "year").startOf("year"));
                    if (ppermissionTypeId === EXCUSE_PERMISSION_TYPE_ID) {
                        const employmentStartUtc = employmentStartUtcMap.get(userId);
                        if (employmentStartUtc) {
                            const employeeTimestamp = (0, moment_1.default)(employmentStartUtc);
                            if (timestamp.isSameOrAfter(employeeTimestamp)) {
                                let customYearRange = new moment_range_1.DateRange(employeeTimestamp.clone(), employeeTimestamp.clone().add(1, "year"));
                                while (!customYearRange.contains(timestamp)) {
                                    customYearRange.start = customYearRange.end.clone();
                                    customYearRange.end = customYearRange.end.clone().add(1, "year");
                                }
                                yearRange = customYearRange;
                            }
                        }
                    }
                    userResultMap.set(ppermissionTypeId, {
                        weekRange,
                        monthRange,
                        yearRange,
                    });
                }
                resultMap.set(userId, userResultMap);
            }
            return resultMap;
        };
    }
}
