"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.generateReport = exports.TKYemEmployeeWorkingDurationCustomReport = void 0;
const i18n_1 = __importDefault(require("i18n"));
const luxon_1 = require("luxon");
const app_enums_1 = require("../../../app.enums");
const excel_report_column_extractor_1 = __importStar(require("../../../business/report/excel.report.column.extractor"));
const excel_report_refactory_1 = require("../../../business/report/excel.report.refactory");
const generator_1 = require("../../../business/report/generator");
const dal_constants_1 = require("../../../dal/dal.constants");
const dal_manager_1 = require("../../../dal/dal.manager");
const dal_db_armon_schema_1 = require("../../../dal/db/armon/dal.db.armon.schema");
const app_logs_1 = require("../../../app.logs");
const reportdef = {
    dataColumns: [
        excel_report_column_extractor_1.EmployeeDayDataColumnTypes.Date,
        excel_report_column_extractor_1.EmployeeDayDataColumnTypes.FirstInTime,
        excel_report_column_extractor_1.EmployeeDayDataColumnTypes.LastOutTime,
        excel_report_column_extractor_1.EmployeeDayDataColumnTypes.AttendanceStatusText,
        excel_report_column_extractor_1.EmployeeDayDataColumnTypes.UsedPermissions,
        excel_report_column_extractor_1.EmployeeDayDataColumnTypes.WorkplanText,
        excel_report_column_extractor_1.EmployeeDayDataColumnTypes.ExpectedEntrance,
        excel_report_column_extractor_1.EmployeeDayDataColumnTypes.ExpectedLeave,
        excel_report_column_extractor_1.EmployeeDayDataColumnTypes.ExpectedWorkDuration,
        excel_report_column_extractor_1.EmployeeDayDataColumnTypes.NormalWorkDuration,
        excel_report_column_extractor_1.EmployeeDayDataColumnTypes.MissingWorkDuration,
        excel_report_column_extractor_1.EmployeeDayDataColumnTypes.ExtraWorkDuration,
        excel_report_column_extractor_1.EmployeeDayDataColumnTypes.PhysicallyInRegionDuration,
        excel_report_column_extractor_1.EmployeeDayDataColumnTypes.FixedBreakDuration,
    ],
};
class TKYemEmployeeWorkingDurationCustomReport extends generator_1.CustomReportGenerator {
    constructor(request, locale) {
        super(request, locale);
        this._workplansWithPeriods = [];
        this._ppermissions = [];
        this._holidays = [];
        const options = request.filter;
        this._reportFactory = new excel_report_refactory_1.ReportFactory(this._request.organizationId, this._locale);
        this._filter = {
            dateRange: {
                startDateTime: new Date(options.filters.find((i) => i.type === app_enums_1.enums.CustomOrganizationReportFilterType.DateRange).value.startDay),
                endDateTime: new Date(options.filters.find((i) => i.type === app_enums_1.enums.CustomOrganizationReportFilterType.DateRange).value.endDay),
            },
            userFilter: {
                organizationUnitIds: options.filters.find((i) => i.type === app_enums_1.enums.CustomOrganizationReportFilterType.OrganizationUnit).value,
                organizationUnitHierachially: options.filters.find((f) => f.type === app_enums_1.enums.CustomOrganizationReportFilterType.OrganizationUnitHierarchically).value,
                userIds: options.filters.find((i) => i.type === app_enums_1.enums.CustomOrganizationReportFilterType.UserIdFromFreeSearch).value,
                userGroupIds: options.filters.find((i) => i.type === app_enums_1.enums.CustomOrganizationReportFilterType.UserGroup).value,
                status: options.filters.find((f) => f.type === app_enums_1.enums.CustomOrganizationReportFilterType.UserStatus)?.value,
            },
            organizationId: request.organizationId,
            requesterUserId: request.requesterUserId,
            locale: locale,
        };
    }
    async onDataCallbackFunctionReader(rows) {
        app_logs_1.logger.debug("Fetch reader data %s rows", rows.length);
        const wps = new Set();
        const leaveIds = new Set();
        const holidayIds = new Set();
        const userIds = [];
        for (const row of rows) {
            userIds.push(row.userId);
            row.data.w.forEach((w) => {
                wps.add(w);
            });
            row.data.p.forEach((leave) => {
                leaveIds.add(leave.p);
            });
            row.data.h.forEach((holiday) => {
                holidayIds.add(holiday.h);
            });
        }
        await this._reportFactory.appendToUserInfo(userIds);
        await dal_manager_1.dbManager.systemTransaction(async (trx) => {
            if (wps.size !== 0) {
                const workplansWithPeriods = (await trx.query(`SELECT wp.id, wp.name , wpp."details"
									FROM "${this._request.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.workPlans}" wp
									LEFT JOIN "${this._request.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.viewNames.vW_WorkPlanPeriodTstzrange}" wpp ON wpp."workPlanId" = wp.id
									WHERE wp."id" = ANY($1)`, [Array.from(wps)])).rows;
                this._workplansWithPeriods = [...this._workplansWithPeriods, ...workplansWithPeriods];
            }
            if (leaveIds.size !== 0) {
                const ppermissions = (await trx.query(`SELECT p."id" as pid, pt."id" as ptid, pt."name", p."status", p."startDateTime", p."endDateTime"
								FROM "${this._request.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.ppermissionTypes}" pt
								INNER JOIN "${this._request.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.ppermissions}" p ON p."ppermissionTypeId" = pt.id
								WHERE p."id" = ANY($1)`, [Array.from(leaveIds)])).rows;
                this._ppermissions = [...this._ppermissions, ...ppermissions];
            }
            if (holidayIds.size !== 0) {
                this._holidays = (await trx.query(`SELECT id, title, "startDateTime", "endDateTime"
  					 FROM "${this._request.organizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.vacations}"
   					 WHERE "id" = ANY($1)`, [Array.from(holidayIds)])).rows;
                this._holidays = [...this._holidays, ...holidayIds];
            }
            for (const row of rows) {
                let context = {
                    workplans: this._workplansWithPeriods,
                    leaves: this._ppermissions,
                    holidays: this._holidays,
                    user: {
                        id: row.userId,
                        name: row.name,
                        surname: row.surname,
                        uniqueId: row.uniqueId,
                    },
                    date: row.date,
                    locale: this._locale,
                };
                const sheetInfo = [
                    {
                        sheetName: i18n_1.default.__({ phrase: "EXCEL-REPORT.GENERAL", locale: this._locale }),
                        data: [],
                    },
                ];
                let generatedColumns = [];
                if (row.data) {
                    for (const element of reportdef.dataColumns) {
                        generatedColumns.push(excel_report_column_extractor_1.default.invoke(element, row.data, context, trx));
                    }
                    let customColumns = await this.addCustomColumns(row);
                    sheetInfo[0].data.push({
                        userId: row.userId,
                        cells: [...generatedColumns, ...customColumns],
                    });
                }
                else {
                    sheetInfo[0].data.push({
                        userId: row.userId,
                        cells: [
                            {
                                value: i18n_1.default.__({ phrase: "EXCEL-REPORT.STILL_CALCULATING", locale: context.locale }),
                                border: generator_1.ReportGenerator.Constants.Styling.AllDotted,
                            },
                        ],
                    });
                }
                this._reportFactory.appendData(sheetInfo);
            }
        });
        return Promise.resolve();
    }
    getHeaders() {
        const headers = [
            {
                phrase: "EXCEL-REPORT.DATE",
                width: 35,
            },
            {
                phrase: "EXCEL-REPORT.FIRST_START",
                width: 20,
            },
            {
                phrase: "EXCEL-REPORT.LAST_LEAVE",
                width: 20,
            },
            {
                phrase: "EXCEL-REPORT.STATUS",
                width: 20,
            },
            {
                phrase: "EXCEL-REPORT.USED_PERMISSION",
                width: 20,
            },
            {
                phrase: "EXCEL-REPORT.WORKPLAN",
                width: 20,
            },
            {
                phrase: "EXCEL-REPORT.EXPECTED_ENTRANCE",
                width: 20,
            },
            {
                phrase: "EXCEL-REPORT.EXPECTED_EXIT",
                width: 20,
            },
            {
                phrase: "EXCEL-REPORT.EXPECTED_WORK_DURATION",
                width: 20,
            },
            {
                phrase: "EXCEL-REPORT.NORMAL_WORK_DURATION",
                width: 20,
            },
            {
                phrase: "EXCEL-REPORT.MISSING_WORK",
                width: 20,
            },
            {
                phrase: "EXCEL-REPORT.OVERTIME",
                width: 20,
            },
            {
                phrase: "EXCEL-REPORT.PHYSICALLY_IN_REGION_DURATION",
                width: 20,
            },
            {
                phrase: "EXCEL-REPORT.USED_TOTAL_BREAK_DURATION",
                width: 20,
            },
            {
                value: "Yemek Puantaj Günü",
                width: 20,
            },
            {
                value: "Hafta İçi Fazla Çalışma",
                width: 20,
            },
            {
                value: "Hafta Sonu Fazla Mesai",
                width: 20,
            },
            {
                value: "Bayram / Resmi Tatil Mesaisi",
                width: 20,
            },
            {
                value: "Gece Çalışma",
                width: 20,
            },
            {
                value: "Toplam",
                width: 20,
            },
        ];
        return headers;
    }
    async generateReport() {
        let fileObj;
        const sheetInfo = [
            {
                sheetName: i18n_1.default.__({ phrase: "EXCEL-REPORT.GENERAL", locale: this._locale }),
                headers: this.getHeaders(),
            },
        ];
        const reportInfoSheetData = {
            reportNameValue: "TK Yem Özel Günlük Çalışma Detayı Raporu",
            filters: {
                organizationUnitIds: this._filter.userFilter.organizationUnitIds,
                organizationUnitHierachially: this._filter.userFilter.organizationUnitHierachially,
                userIds: this._filter.userFilter.userIds,
                userGroupIds: this._filter.userFilter.userGroupIds,
                status: this._filter.userFilter.status,
            },
        };
        await this._reportFactory.initialize({
            requesterUserId: this._request.requesterUserId,
            userIds: [],
            reportInfoSheetData,
            sheetInfo: sheetInfo,
            profileColumnsIndex: 1,
        });
        await dal_manager_1.dbManager.accessPacs2.getEmployeeDaysFiltered(this._request.organizationId, this._request.requesterUserId, {
            startDate: this._filter.dateRange.startDateTime,
            endDate: this._filter.dateRange.endDateTime,
            organizationUnitIds: this._filter.userFilter?.organizationUnitIds,
            organizationUnitHierarchically: this._filter.userFilter?.organizationUnitHierachially,
            userGroupIds: this._filter.userFilter?.userGroupIds,
            userIds: this._filter.userFilter?.userIds,
            status: this._filter.userFilter.status,
            sortType: 1,
            sortOrder: "ASC",
            take: null,
            skip: null,
        }, this.onDataCallbackFunctionReader.bind(this));
        fileObj = await this._reportFactory.finalize(reportInfoSheetData);
        return {
            format: app_enums_1.enums.ReportFormat.Excel,
            preparedReportId: fileObj.fileId,
            filePath: fileObj.filePath,
            notificationType: undefined,
            reportType: app_enums_1.enums.ReportCode.PacsFirstInLastOutSummaryMultipleUsers,
            sendFileInAttachments: undefined,
        };
    }
    addCustomColumns(row) {
        let foodRight = 1;
        if (+row.data.s.n + +row.data.s.e < 210) {
            foodRight = 0;
        }
        if (+row.data.s.n + +row.data.s.e > 660) {
            foodRight = 2;
        }
        const workDurationOnHoliday = row.data.s.eh - row.data.s.uh;
        const luxonDate = luxon_1.DateTime.fromJSDate(row.date);
        const weekDayExtraWork = workDurationOnHoliday > 0 ? 0 : luxonDate.weekday < 7 ? +(row.data.s.e / 60).toFixed(2) : 0;
        let weekEndExtraWork = workDurationOnHoliday > 0 ? 0 : luxonDate.weekday === 7 ? +(row.data.s.e / 60).toFixed(2) : 0;
        weekEndExtraWork = weekEndExtraWork < 8.5 && weekEndExtraWork > 0 ? 7.5 : weekEndExtraWork > 8.5 ? weekEndExtraWork - 1 : null;
        const nightWorkRangeOfDate = luxon_1.Interval.fromDateTimes(luxonDate.startOf("day"), luxonDate.startOf("day").plus({ hours: 8 }));
        let nightWorkDuration = 0;
        row.data.c.forEach((seg) => {
            if (seg.at === dal_constants_1.DalConstants.AttendanceTimeRangeType.DeclaredAttendance || seg.at === dal_constants_1.DalConstants.AttendanceTimeRangeType.AccountedPhysicalAttendance) {
                let segRange = luxon_1.Interval.fromDateTimes(luxon_1.DateTime.fromISO(seg.s), luxon_1.DateTime.fromISO(seg.e));
                const intersection = nightWorkRangeOfDate.intersection(segRange)?.toDuration()?.as("minutes") ?? 0;
                if (intersection > 0) {
                    nightWorkDuration += intersection;
                }
            }
        });
        const rowData = [
            {
                value: foodRight,
                border: generator_1.ReportGenerator.Constants.Styling.AllDotted,
                numFmt: null,
            },
            {
                value: weekDayExtraWork,
                border: generator_1.ReportGenerator.Constants.Styling.AllDotted,
                numFmt: null,
            },
            {
                value: weekEndExtraWork,
                border: generator_1.ReportGenerator.Constants.Styling.AllDotted,
                numFmt: null,
            },
            {
                value: workDurationOnHoliday !== 0 ? (workDurationOnHoliday / 60).toFixed(2) : null,
                border: generator_1.ReportGenerator.Constants.Styling.AllDotted,
                numFmt: null,
            },
            {
                value: nightWorkDuration !== 0 ? (nightWorkDuration / 60).toFixed(2) : null,
                border: generator_1.ReportGenerator.Constants.Styling.AllDotted,
                numFmt: null,
            },
            {
                value: (+weekDayExtraWork + +weekEndExtraWork + workDurationOnHoliday / 60).toFixed(2),
                border: generator_1.ReportGenerator.Constants.Styling.AllDotted,
                numFmt: null,
            },
        ];
        return rowData;
    }
}
exports.TKYemEmployeeWorkingDurationCustomReport = TKYemEmployeeWorkingDurationCustomReport;
async function generateReport(request, locale) {
    let report = new TKYemEmployeeWorkingDurationCustomReport(request, locale);
    return report.generateReport();
}
exports.generateReport = generateReport;
