"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PredefinedOAuthClients = exports.OAuthClientProfile = void 0;
var OAuthClientProfile;
(function (OAuthClientProfile) {
    OAuthClientProfile[OAuthClientProfile["WebApplication"] = 0] = "WebApplication";
    OAuthClientProfile[OAuthClientProfile["UserAgent"] = 1] = "UserAgent";
    OAuthClientProfile[OAuthClientProfile["Native"] = 2] = "Native";
})(OAuthClientProfile = exports.OAuthClientProfile || (exports.OAuthClientProfile = {}));
exports.PredefinedOAuthClients = {
    ArmonWebClient: {
        id: "341c5cfd-e7ac-4841-b5cc-eab2a369ff93",
        name: "Armon Web Client",
        profile: OAuthClientProfile.UserAgent
    },
    ArmonCPServer: {
        id: "ef488b85-6798-4b23-9ae3-05360e302bcf",
        name: "Armon CP Server",
        profile: OAuthClientProfile.Native
    },
    ArmonMobileAndroidClient: {
        id: "9bf5c4ae-1341-49f3-88ab-b8e2521ca438",
        name: "Armon Mobile Android Client",
        profile: OAuthClientProfile.Native
    },
    ArmonMobileIOSClient: {
        id: "35301e4f-f752-4cca-8fb1-4b6ce8f25f1e",
        name: "Armon Mobile IOS Client",
        profile: OAuthClientProfile.Native
    },
    SwaggerDocs: {
        id: "d2c84c26-1346-41ad-8e60-26d8949ccc8a",
        name: "Swagger",
        profile: OAuthClientProfile.UserAgent,
        redirectUris: JSON.stringify([
            "http://localhost:3024/api-docs/oauth2-redirect.html",
            "https://localhost:3024/api-docs/oauth2-redirect.html",
            "http://localhost:3024/user-api-docs/oauth2-redirect.html",
            "https://localhost:3024/user-api-docs/oauth2-redirect.html",
            "http://localhost:3024/visitor-api-docs/oauth2-redirect.html",
            "https://localhost:3024/visitor-api-docs/oauth2-redirect.html"
        ])
    }
};
