"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const dal_utils_1 = require("../../../dal.utils");
async function up(client, dbuser, dbsuperuser) {
    const q = `
    -- FUNCTION: ___ORGANIZATION_ID___.before_up_in_del_user_organization_credentials()
    -- DROP FUNCTION IF EXISTS "___ORGANIZATION_ID___".before_up_in_del_user_organization_credentials();
    CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_organization_credentials()
        RETURNS trigger
        LANGUAGE 'plpgsql'
        COST 100
        VOLATILE NOT LEAKPROOF
    AS $BODY$
    DECLARE
        transaction_id	bigint;
        t_factors		text;
        factors 		text[];
        credential_one_time_assignable_status boolean;
        organization_license_settings	jsonb;
        active_credential_count	integer;
        base_module_max_count	integer;
        BEGIN
            transaction_id := txid_current();
            IF (TG_OP = 'DELETE') THEN
                INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                ("id", "transactionId", "deviceId", "actionT", "type", "data")
                SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 2,
                    JSON_BUILD_OBJECT('id', OLD."id")
                    FROM (SELECT acp."id", acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num
                        FROM "___ORGANIZATION_ID___"."userOrganizationCredentials" AS uoc
                        INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uoc."userId" = uar."userId"
                        AND uar."deletedAt" IS NULL AND uoc."deletedAt" IS NULL AND uar."access" = true
                        INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON acp."id" = uar."accessControlPointId"
                        AND POSITION('"factor":' || uoc."type"::text IN acp."authenticationFactors"::text) > 1
                        AND uoc."organizationId" = acp."organizationId" AND uoc."id" = OLD."id")
                    AS T
                WHERE T."row_num" = 1;
                RETURN OLD;
            ELSIF (TG_OP = 'UPDATE') THEN
                IF NEW."userId" != OLD."userId"
                OR NEW."organizationId" != OLD."organizationId"
                OR NEW."type" != OLD."type"
                OR NEW."data" != OLD."data"
                OR NEW."specialData" != OLD."specialData"
                OR NEW."specialDataSecondary" != OLD."specialDataSecondary"
                THEN
                    RAISE EXCEPTION 'userId, organizationId, type, data, specialData, specialDataSecondary can not be changed';
                END IF;
    
                ----- If the user is activated
                IF (OLD."deletedAt" IS NOT NULL AND NEW."deletedAt" IS NULL)
                THEN
                ----- One Time Assignable setting, support added for METU UHF credentials!
                    credential_one_time_assignable_status := (
                        SELECT CASE WHEN ((T1.element->'oneTimeAssignable')::jsonb) IS NOT NULL 
                            THEN ((T1.element->'oneTimeAssignable')::jsonb)::boolean ELSE FALSE END 
                        FROM (SELECT json_array_elements("credentialTypes") as element FROM "___ORGANIZATION_ID___".organizations) T1
                        WHERE ((element->'type')::JSONB)::INTEGER = NEW.type
                    );
                    IF(credential_one_time_assignable_status IS TRUE) THEN
                            RAISE EXCEPTION '20000'; -- Check appweb ErrorCode enums for detail
                    END IF;
    
                    ----- Check if credential already assigned to another user            
                    IF EXISTS(SELECT FROM "___ORGANIZATION_ID___"."userOrganizationCredentials"
                        WHERE "type" = NEW."type" AND "data" = NEW."data" AND NEW."type" != 9 ----- the last one is for fingerprint specialData
                        AND "organizationId" = NEW."organizationId"
                        AND "deletedAt" IS NULL) THEN
                            RAISE EXCEPTION '20002,%', NEW.data; -- Check appweb ErrorCode enums for detail
                    END IF;
                END IF;	
                ----- One Time Assignable setting, support added for METU UHF credentials!
                    
                IF (OLD."deletedAt" IS NULL AND NEW."deletedAt" IS NOT NULL)
                THEN							
                    INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                    ("id", "transactionId", "deviceId", "actionT", "type", "data")
                    SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 2,
                    JSON_BUILD_OBJECT('id', OLD."id")
                    FROM (SELECT acp."id", acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num
                        FROM "___ORGANIZATION_ID___"."userOrganizationCredentials" AS uoc
                        INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uoc."userId" = uar."userId"
                        AND uar."deletedAt" IS NULL AND uoc."deletedAt" IS NULL  AND uar."access" = true
                        INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON acp."id" = uar."accessControlPointId"
                        AND POSITION('"factor":' || uoc."type"::text IN acp."authenticationFactors"::text) > 1
                        AND uoc."organizationId" = acp."organizationId" AND uoc."id" = OLD."id")
                    AS T
                    WHERE T."row_num" = 1;
                END IF;
    
                IF (OLD."expiresOn" IS DISTINCT FROM NEW."expiresOn" OR
                    OLD."groupNumber" IS DISTINCT FROM NEW."groupNumber" OR 
                    NOT (to_jsonb(OLD."extensionFields") @> to_jsonb(NEW."extensionFields") 
                            AND to_jsonb(OLD."extensionFields") <@ to_jsonb(NEW."extensionFields")))
                THEN
                    INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                    ("id", "transactionId", "deviceId", "actionT", "type", "data")
                    SELECT uuid_generate_v4(),transaction_id, T."deviceId", now(), 22,
                        JSON_BUILD_OBJECT(	'id', OLD."id", 
                                                'expiresOnISO', NEW."expiresOn",
                                                'groupNumber', NEW."groupNumber",
                                                'extensionFields', NEW."extensionFields")
                    FROM (SELECT acp."id", acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num
                        FROM "___ORGANIZATION_ID___"."userOrganizationCredentials" AS uoc
                        INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uoc."userId" = uar."userId"
                        AND uar."deletedAt" IS NULL AND uoc."deletedAt" IS NULL AND uar."access" = true
                        INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON acp."id" = uar."accessControlPointId"
                        AND POSITION('"factor":' || uoc."type"::text IN acp."authenticationFactors"::text) > 1
                        AND uoc."organizationId" = acp."organizationId" AND uoc."id" = OLD."id")
                    AS T
                    WHERE T."row_num" = 1;
                END IF;
            ELSIF (TG_OP = 'INSERT') THEN
                IF (NEW."deletedAt" IS NULL)
                THEN
                
                    ----- One Time Assignable setting, support added for METU UHF credentials!
                    credential_one_time_assignable_status := (
                        SELECT CASE WHEN ((T1.element->'oneTimeAssignable')::jsonb) IS NOT NULL 
                            THEN ((T1.element->'oneTimeAssignable')::jsonb)::boolean ELSE FALSE END 
                        FROM (SELECT json_array_elements("credentialTypes") as element FROM "___ORGANIZATION_ID___".organizations) T1
                        WHERE ((element->'type')::JSONB)::INTEGER = NEW.type
                    );
                    IF EXISTS(SELECT FROM "___ORGANIZATION_ID___"."userOrganizationCredentials"
                                WHERE "type" = NEW."type" AND "data" = NEW."data" AND NEW."type" != 9  ----- the last one is for fingerprint specialData
                                AND "organizationId" = NEW."organizationId"
                                AND "deletedAt" IS NULL) THEN
                                    RAISE EXCEPTION '20002,%', NEW.data; -- Check appweb ErrorCode enums for detail
                        ELSIF(credential_one_time_assignable_status IS TRUE AND 
                            EXISTS (SELECT id FROM "___ORGANIZATION_ID___"."userOrganizationCredentials" WHERE data = NEW.data)  ) THEN
                                RAISE EXCEPTION '20000'; -- Check appweb ErrorCode enums for detail
                    END IF;
                    
                    ----- One Time Assignable setting, support added for METU UHF credentials!
    
                    ----- Delete old mobile credentials to prevent duplicates!
                    IF EXISTS(SELECT FROM "___ORGANIZATION_ID___"."userOrganizationCredentials"
                        WHERE "type" = NEW."type" AND "data" = NEW."data"
                        AND "organizationId" = NEW."organizationId"
                        AND "deletedAt" IS NULL AND "type" IN (2,8,12)) THEN
                        
                        UPDATE "___ORGANIZATION_ID___"."userOrganizationCredentials" SET "deletedAt" = now()
                        WHERE "userId" = NEW."userId" AND "organizationId" = NEW."organizationId"
                            AND "type" = NEW."type" AND "deletedAt" IS NULL;
                    END IF;
                    ----- Delete old mobile credentials to prevent duplicates!
    
                    INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                    ("id", "transactionId", "deviceId", "actionT", "type", "data")
                    SELECT uuid_generate_v4(), transaction_id, T."deviceId", now() as "actionT", 1 as "type",
                    json_build_object(
                        'id', T."id",
                        'userId', T."userId",
                        'type', T."type",
                        'data', T."data",
                        'groupNumber', T."groupNumber",
                        'specialData', T."specialData",
                        'specialDataSecondary', T."specialDataSecondary",
                        'expiresOnISO', T."expiresOn",
                        'extensionFields', T."extensionFields"
                    ) AS "data" FROM
                    (SELECT NEW."id", NEW."type", NEW."data", NEW."specialData", NEW."userId", NEW."groupNumber",
                    NEW."specialDataSecondary", NEW."expiresOn", NEW."extensionFields", T2."deviceId"
                    FROM
                        (SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num
                            FROM "___ORGANIZATION_ID___"."userAccessRights" AS uar
                            INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON acp."id" = uar."accessControlPointId"
                            AND POSITION('"factor":' || (CASE WHEN NEW."type" = 12 THEN '14' ELSE NEW."type"::text END) IN acp."authenticationFactors"::text) > 1
                            AND NEW."organizationId" = acp."organizationId" AND uar."access" = true
                            WHERE NEW."userId" = uar."userId" AND uar."deletedAt" IS NULL
                            ) AS T2
                        WHERE T2.row_num=1
                        ) AS T;
                END IF;
            END IF;
            RETURN NEW;
        END;
    $BODY$;
    
    ALTER FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_organization_credentials()
        OWNER TO ${dbsuperuser};
    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_organization_credentials() TO ${dbsuperuser};
    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_organization_credentials() TO PUBLIC;
    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_organization_credentials() TO ${dbuser};    
    `;
    (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, q, "___ORGANIZATION_ID___");
    const organizationModulesQ = `
        ALTER TABLE "___ORGANIZATION_ID___"."organizationModules"
            RENAME COLUMN "maxCredentialCount" TO "usageLimit";

        ALTER TABLE "___ORGANIZATION_ID___"."organizationModules"
            ADD COLUMN "exceedPercentage" INTEGER DEFAULT 0 NOT NULL,
            ADD COLUMN "licenseControlPolicy" INTEGER DEFAULT 1 NOT NULL;

        UPDATE "___ORGANIZATION_ID___"."organizationModules"
        SET 
            "exceedPercentage" = COALESCE ((SELECT ("settings"->'organizationLicenseSettings'->>'exceedPercentage')::INTEGER FROM "___ORGANIZATION_ID___"."organizations" LIMIT 1), 0),
            "licenseControlPolicy" = COALESCE((SELECT ("settings"->'organizationLicenseSettings'->>'licenseControlPolicy')::INTEGER FROM "___ORGANIZATION_ID___"."organizations" LIMIT 1), 2);        

        UPDATE "___ORGANIZATION_ID___"."organizations"
        SET "settings" = "settings" - 'organizationLicenseSettings';
    `;
    (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, organizationModulesQ, "___ORGANIZATION_ID___");
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) {
    const organizationModulesQ = `

        WITH module_values AS (
            SELECT 
                COALESCE("exceedPercentage", 0) AS "exceedPercentage", 
                COALESCE("licenseControlPolicy", 2) AS "licenseControlPolicy"
            FROM "___ORGANIZATION_ID___"."organizationModules"
            WHERE "module" = 0
            LIMIT 1
        )
        UPDATE "___ORGANIZATION_ID___"."organizations"
        SET "settings" = jsonb_set(
            "settings",
            '{organizationLicenseSettings}',
            (
                SELECT jsonb_build_object(
                    'exceedPercentage', module_values."exceedPercentage",
                    'licenseControlPolicy', module_values."licenseControlPolicy"
                )
                FROM module_values
            ),
            true
        );
        
        ALTER TABLE "___ORGANIZATION_ID___"."organizationModules"
            RENAME COLUMN "usageLimit" TO "maxCredentialCount";
        
        ALTER TABLE "___ORGANIZATION_ID___"."organizationModules"
            DROP COLUMN "exceedPercentage",
            DROP COLUMN "licenseControlPolicy";
    `;
    (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, organizationModulesQ, "___ORGANIZATION_ID___");
    const q = `
    -- FUNCTION: ___ORGANIZATION_ID___.before_up_in_del_user_organization_credentials()
    -- DROP FUNCTION IF EXISTS "___ORGANIZATION_ID___".before_up_in_del_user_organization_credentials();
    CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_organization_credentials()
        RETURNS trigger
        LANGUAGE 'plpgsql'
        COST 100
        VOLATILE NOT LEAKPROOF
    AS $BODY$
    DECLARE
        transaction_id	bigint;
        t_factors		text;
        factors 		text[];
        credential_one_time_assignable_status boolean;
        organization_license_settings	jsonb;
        active_credential_count	integer;
        base_module_max_count	integer;
        BEGIN
            transaction_id := txid_current();
            IF (TG_OP = 'DELETE') THEN
                INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                ("id", "transactionId", "deviceId", "actionT", "type", "data")
                SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 2,
                    JSON_BUILD_OBJECT('id', OLD."id")
                    FROM (SELECT acp."id", acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num
                        FROM "___ORGANIZATION_ID___"."userOrganizationCredentials" AS uoc
                        INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uoc."userId" = uar."userId"
                        AND uar."deletedAt" IS NULL AND uoc."deletedAt" IS NULL AND uar."access" = true
                        INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON acp."id" = uar."accessControlPointId"
                        AND POSITION('"factor":' || uoc."type"::text IN acp."authenticationFactors"::text) > 1
                        AND uoc."organizationId" = acp."organizationId" AND uoc."id" = OLD."id")
                    AS T
                WHERE T."row_num" = 1;
                RETURN OLD;
            ELSIF (TG_OP = 'UPDATE') THEN
                IF NEW."userId" != OLD."userId"
                OR NEW."organizationId" != OLD."organizationId"
                OR NEW."type" != OLD."type"
                OR NEW."data" != OLD."data"
                OR NEW."specialData" != OLD."specialData"
                OR NEW."specialDataSecondary" != OLD."specialDataSecondary"
                THEN
                    RAISE EXCEPTION 'userId, organizationId, type, data, specialData, specialDataSecondary can not be changed';
                END IF;

                ----- If the user is activated
                IF (OLD."deletedAt" IS NOT NULL AND NEW."deletedAt" IS NULL)
                THEN
                ----- One Time Assignable setting, support added for METU UHF credentials!
                    credential_one_time_assignable_status := (
                        SELECT CASE WHEN ((T1.element->'oneTimeAssignable')::jsonb) IS NOT NULL 
                            THEN ((T1.element->'oneTimeAssignable')::jsonb)::boolean ELSE FALSE END 
                        FROM (SELECT json_array_elements("credentialTypes") as element FROM "___ORGANIZATION_ID___".organizations) T1
                        WHERE ((element->'type')::JSONB)::INTEGER = NEW.type
                    );
                    IF(credential_one_time_assignable_status IS TRUE) THEN
                            RAISE EXCEPTION '20000'; -- Check appweb ErrorCode enums for detail
                    END IF;

                    ----- Check if credential already assigned to another user            
                    IF EXISTS(SELECT FROM "___ORGANIZATION_ID___"."userOrganizationCredentials"
                        WHERE "type" = NEW."type" AND "data" = NEW."data"
                        AND "organizationId" = NEW."organizationId"
                        AND "deletedAt" IS NULL AND "type" IN (0,3,5,6,16)) THEN
                            RAISE EXCEPTION '20002,%', NEW.data; -- Check appweb ErrorCode enums for detail
                    END IF;
                END IF;	
                ----- One Time Assignable setting, support added for METU UHF credentials!
                
                ----- License limit control logic!
                IF (
                    NOT (SELECT r."typeId" FROM "___ORGANIZATION_ID___"."roles" AS r
                        INNER JOIN  "___ORGANIZATION_ID___"."userOrganizations" AS uo
                        ON uo."roleId" = r.id
                        WHERE uo."deletedAt" IS NULL AND
                            r."deletedAt" IS NULL AND
                            NEW."userId" = uo."userId") = ANY(ARRAY['2a4ad5ff-1ced-45f8-992f-e19fc4e766d7', '9b8eebd7-057f-4021-ad6f-f2879733bdb9']::UUID[])
                    AND 
                    (
                        (OLD."deletedAt" IS NOT NULL AND NEW."deletedAt" IS NULL) OR 
                        (NEW."expiresOn" IS NULL AND OLD."expiresOn" IS NOT NULL) OR
                        (NEW."expiresOn" IS NOT NULL AND NEW."expiresOn" > now())
                    ) 
                )
                THEN
                    SELECT "settings"->'organizationLicenseSettings' INTO organization_license_settings
                    FROM "___ORGANIZATION_ID___"."organizations" LIMIT 1;
                
                    IF ((organization_license_settings->'licenseControlPolicy'):: INTEGER = 2 ) THEN
                        
                        SELECT COUNT (*) FILTER (WHERE NOT uoc."type" = ANY(ARRAY[2,8,12]::INTEGER[])) + 
                        COUNT (DISTINCT (uoc."userId")) FILTER (WHERE uoc."type" = ANY(ARRAY[2,8,12]::INTEGER[])) INTO active_credential_count
                        FROM "___ORGANIZATION_ID___"."userOrganizationCredentials" AS uoc
                        INNER JOIN "___ORGANIZATION_ID___"."userOrganizations" AS uo
                            ON uo."userId" = uoc."userId"
                        INNER JOIN "___ORGANIZATION_ID___"."roles" AS r
                            ON r."id" = uo."roleId"
                        WHERE uoc."deletedAt" IS NULL
                            AND ("expiresOn" IS NULL OR "expiresOn" > now())
                            AND NOT r."typeId" = ANY(ARRAY['2a4ad5ff-1ced-45f8-992f-e19fc4e766d7', '9b8eebd7-057f-4021-ad6f-f2879733bdb9']::UUID[])
                            AND uo."deletedAt" IS NULL
                            AND r."deletedAt" IS NULL
                            AND uo."isDisabled" = FALSE;
                        
                        SELECT "maxCredentialCount" INTO base_module_max_count
                            FROM "___ORGANIZATION_ID___"."organizationModules"
                            WHERE "module" = 0 /* ArmonApplicationModule.Base */ LIMIT 1;
                        IF (active_credential_count >= 
                            base_module_max_count + (base_module_max_count * (organization_license_settings->'exceedPercentage')::INTEGER / 100)) THEN
                            RAISE EXCEPTION '20001'; -- Check appweb ErrorCode enums for detail
                        END IF;
                    END IF;
                END IF;
                ----- License limit control logic!
                    
                IF (OLD."deletedAt" IS NULL AND NEW."deletedAt" IS NOT NULL)
                THEN							
                    INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                    ("id", "transactionId", "deviceId", "actionT", "type", "data")
                    SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 2,
                    JSON_BUILD_OBJECT('id', OLD."id")
                    FROM (SELECT acp."id", acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num
                        FROM "___ORGANIZATION_ID___"."userOrganizationCredentials" AS uoc
                        INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uoc."userId" = uar."userId"
                        AND uar."deletedAt" IS NULL AND uoc."deletedAt" IS NULL  AND uar."access" = true
                        INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON acp."id" = uar."accessControlPointId"
                        AND POSITION('"factor":' || uoc."type"::text IN acp."authenticationFactors"::text) > 1
                        AND uoc."organizationId" = acp."organizationId" AND uoc."id" = OLD."id")
                    AS T
                    WHERE T."row_num" = 1;
                END IF;

                IF (OLD."expiresOn" IS DISTINCT FROM NEW."expiresOn" OR
                    OLD."groupNumber" IS DISTINCT FROM NEW."groupNumber" OR 
                    NOT (to_jsonb(OLD."extensionFields") @> to_jsonb(NEW."extensionFields") 
                            AND to_jsonb(OLD."extensionFields") <@ to_jsonb(NEW."extensionFields")))
                THEN
                    INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                    ("id", "transactionId", "deviceId", "actionT", "type", "data")
                    SELECT uuid_generate_v4(),transaction_id, T."deviceId", now(), 22,
                        JSON_BUILD_OBJECT(	'id', OLD."id", 
                                                'expiresOnISO', NEW."expiresOn",
                                                'groupNumber', NEW."groupNumber",
                                                'extensionFields', NEW."extensionFields")
                    FROM (SELECT acp."id", acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num
                        FROM "___ORGANIZATION_ID___"."userOrganizationCredentials" AS uoc
                        INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uoc."userId" = uar."userId"
                        AND uar."deletedAt" IS NULL AND uoc."deletedAt" IS NULL AND uar."access" = true
                        INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON acp."id" = uar."accessControlPointId"
                        AND POSITION('"factor":' || uoc."type"::text IN acp."authenticationFactors"::text) > 1
                        AND uoc."organizationId" = acp."organizationId" AND uoc."id" = OLD."id")
                    AS T
                    WHERE T."row_num" = 1;
                END IF;
            ELSIF (TG_OP = 'INSERT') THEN
                IF (NEW."deletedAt" IS NULL)
                THEN
                
                    ----- One Time Assignable setting, support added for METU UHF credentials!
                    credential_one_time_assignable_status := (
                        SELECT CASE WHEN ((T1.element->'oneTimeAssignable')::jsonb) IS NOT NULL 
                            THEN ((T1.element->'oneTimeAssignable')::jsonb)::boolean ELSE FALSE END 
                        FROM (SELECT json_array_elements("credentialTypes") as element FROM "___ORGANIZATION_ID___".organizations) T1
                        WHERE ((element->'type')::JSONB)::INTEGER = NEW.type
                    );
                    IF EXISTS(SELECT FROM "___ORGANIZATION_ID___"."userOrganizationCredentials"
                                WHERE "type" = NEW."type" AND "data" = NEW."data"
                                AND "organizationId" = NEW."organizationId"
                                AND "deletedAt" IS NULL
                                AND ("type" NOT IN (13,10,14,9,11,7,2,8) OR "specialData" = NEW."specialData")) THEN
                                    RAISE EXCEPTION '20002'; -- Check appweb ErrorCode enums for detail
                        ELSIF(credential_one_time_assignable_status IS TRUE AND 
                            EXISTS (SELECT id FROM "___ORGANIZATION_ID___"."userOrganizationCredentials" WHERE data = NEW.data)  ) THEN
                                RAISE EXCEPTION '20000'; -- Check appweb ErrorCode enums for detail
                    END IF;
                    
                    ----- One Time Assignable setting, support added for METU UHF credentials!

                    ----- Delete old mobile credentials to prevent duplicates!
                    IF EXISTS(SELECT FROM "___ORGANIZATION_ID___"."userOrganizationCredentials"
                        WHERE "type" = NEW."type" AND "data" = NEW."data"
                        AND "organizationId" = NEW."organizationId"
                        AND "deletedAt" IS NULL AND "type" IN (2,8,12)) THEN
                        
                        UPDATE "___ORGANIZATION_ID___"."userOrganizationCredentials" SET "deletedAt" = now()
                        WHERE "userId" = NEW."userId" AND "organizationId" = NEW."organizationId"
                            AND "type" = NEW."type" AND "deletedAt" IS NULL;
                    END IF;
                    ----- Delete old mobile credentials to prevent duplicates!
                    
                    ----- License limit control logic!
                    SELECT "settings"->'organizationLicenseSettings' INTO organization_license_settings
                    FROM "___ORGANIZATION_ID___"."organizations" LIMIT 1;
                
                    IF (
                        NOT (SELECT r."typeId" FROM "___ORGANIZATION_ID___"."roles" AS r
                        INNER JOIN  "___ORGANIZATION_ID___"."userOrganizations" AS uo
                        ON uo."roleId" = r.id
                        WHERE uo."deletedAt" IS NULL AND
                            r."deletedAt" IS NULL AND
                            NEW."userId" = uo."userId") = ANY(ARRAY['2a4ad5ff-1ced-45f8-992f-e19fc4e766d7', '9b8eebd7-057f-4021-ad6f-f2879733bdb9']::UUID[])
                        AND 
                        (organization_license_settings->'licenseControlPolicy'):: INTEGER = 2 
                    ) THEN
                        
                        SELECT COUNT (*) FILTER (WHERE NOT uoc."type" = ANY(ARRAY[2,8,12]::INTEGER[])) + 	-- mobile credentials
                        COUNT (DISTINCT (uoc."userId")) FILTER (WHERE uoc."type" = ANY(ARRAY[2,8,12]::INTEGER[])) INTO active_credential_count
                        FROM "___ORGANIZATION_ID___"."userOrganizationCredentials" AS uoc
                        INNER JOIN "___ORGANIZATION_ID___"."userOrganizations" AS uo
                            ON uo."userId" = uoc."userId"
                        INNER JOIN "___ORGANIZATION_ID___"."roles" AS r
                            ON r."id" = uo."roleId"
                        WHERE uoc."deletedAt" IS NULL
                            AND ("expiresOn" IS NULL OR "expiresOn" > now())
                            AND NOT r."typeId" = ANY(ARRAY['2a4ad5ff-1ced-45f8-992f-e19fc4e766d7', '9b8eebd7-057f-4021-ad6f-f2879733bdb9']::UUID[]) -- visitor type id's
                            AND uo."deletedAt" IS NULL
                            AND r."deletedAt" IS NULL
                            AND uo."isDisabled" = FALSE;
                        
                        SELECT "maxCredentialCount" INTO base_module_max_count
                            FROM "___ORGANIZATION_ID___"."organizationModules"
                            WHERE "module" = 0 /* ArmonApplicationModule.Base */ LIMIT 1;
                        IF (active_credential_count >= 
                            base_module_max_count + (base_module_max_count * (organization_license_settings->'exceedPercentage')::INTEGER / 100)) THEN
                            RAISE EXCEPTION '20001'; -- Check appweb ErrorCode enums for detail
                        END IF;
                    END IF;
                    ----- License limit control logic!

                    INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                    ("id", "transactionId", "deviceId", "actionT", "type", "data")
                    SELECT uuid_generate_v4(), transaction_id, T."deviceId", now() as "actionT", 1 as "type",
                    json_build_object(
                        'id', T."id",
                        'userId', T."userId",
                        'type', T."type",
                        'data', T."data",
                        'groupNumber', T."groupNumber",
                        'specialData', T."specialData",
                        'specialDataSecondary', T."specialDataSecondary",
                        'expiresOnISO', T."expiresOn",
                        'extensionFields', T."extensionFields"
                    ) AS "data" FROM
                    (SELECT NEW."id", NEW."type", NEW."data", NEW."specialData", NEW."userId", NEW."groupNumber",
                    NEW."specialDataSecondary", NEW."expiresOn", NEW."extensionFields", T2."deviceId"
                    FROM
                        (SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num
                            FROM "___ORGANIZATION_ID___"."userAccessRights" AS uar
                            INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON acp."id" = uar."accessControlPointId"
                            AND POSITION('"factor":' || (CASE WHEN NEW."type" = 12 THEN '14' ELSE NEW."type"::text END) IN acp."authenticationFactors"::text) > 1
                            AND NEW."organizationId" = acp."organizationId" AND uar."access" = true
                            WHERE NEW."userId" = uar."userId" AND uar."deletedAt" IS NULL
                            ) AS T2
                        WHERE T2.row_num=1
                        ) AS T;
                END IF;
            END IF;
            RETURN NEW;
        END;
    $BODY$;

    ALTER FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_organization_credentials()
        OWNER TO ${dbsuperuser};
    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_organization_credentials() TO ${dbsuperuser};
    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_organization_credentials() TO PUBLIC;
    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_organization_credentials() TO ${dbuser};
    `;
    (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, q, "___ORGANIZATION_ID___");
}
exports.down = down;
