"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const dal_utils_1 = require("../../../dal.utils");
async function up(client) {
    let query = `
    -- Add primary key to integrationClients if not exist
    DO $$
    BEGIN
        IF NOT EXISTS (
            SELECT 1
            FROM information_schema.table_constraints
            WHERE table_schema = '___ORGANIZATION_ID___'
              AND table_name = 'integrationClients'
              AND constraint_type = 'PRIMARY KEY'
              AND constraint_name = 'integration_client_pkey'
        ) THEN
            ALTER TABLE "___ORGANIZATION_ID___"."integrationClients" ADD CONSTRAINT integration_client_pkey PRIMARY KEY (id);
        END IF;
    END
    $$;
    
    -- Add sourceId and source columns (if not exist) and foreign key to userOrganizationCredentials
    ALTER TABLE "___ORGANIZATION_ID___"."userOrganizationCredentials"
    ADD COLUMN IF NOT EXISTS "sourceId" UUID,
    ADD COLUMN IF NOT EXISTS "source" VARCHAR(255) NOT NULL DEFAULT 1,
    ADD CONSTRAINT credential_source_integration_client_id
        FOREIGN KEY ("sourceId") 
        REFERENCES "___ORGANIZATION_ID___"."integrationClients"(id);
    
    -- Add sourceId and source columns (if not exist) and foreign key to userOrganizationOrganizationUnits
    ALTER TABLE "___ORGANIZATION_ID___"."userOrganizationOrganizationUnits"
    ADD COLUMN IF NOT EXISTS "sourceId" UUID,
    ADD COLUMN IF NOT EXISTS "source" VARCHAR(255) NOT NULL DEFAULT 1,
    ADD CONSTRAINT user_user_organization_unit_integration_client_id
        FOREIGN KEY ("sourceId") 
        REFERENCES "___ORGANIZATION_ID___"."integrationClients"(id);
    
    -- Add sourceId and source columns (if not exist) and foreign key to userGroupUserOrganizations
    ALTER TABLE "___ORGANIZATION_ID___"."userGroupUserOrganizations"
    ADD COLUMN IF NOT EXISTS "sourceId" UUID,
    ADD COLUMN IF NOT EXISTS "source" VARCHAR(255) NOT NULL DEFAULT 1,
    ADD CONSTRAINT user_group_user_organization_integration_client_id
        FOREIGN KEY ("sourceId") 
        REFERENCES "___ORGANIZATION_ID___"."integrationClients"(id);
    `;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query, "___ORGANIZATION_ID___");
}
exports.up = up;
async function down(client) {
    let query = `
    -- Drop foreign key and columns from userGroupUserOrganizations
    ALTER TABLE "___ORGANIZATION_ID___"."userGroupUserOrganizations"
    DROP CONSTRAINT IF EXISTS user_group_user_organization_integration_client_id,
    DROP COLUMN IF EXISTS "sourceId",
    DROP COLUMN IF EXISTS "source";

    -- Drop foreign key and columns from userOrganizationOrganizationUnits
    ALTER TABLE "___ORGANIZATION_ID___"."userOrganizationOrganizationUnits"
    DROP CONSTRAINT IF EXISTS user_user_organization_unit_integration_client_id,
    DROP COLUMN IF EXISTS "sourceId",
    DROP COLUMN IF EXISTS "source";

    -- Drop foreign key and columns from userOrganizationCredentials
    ALTER TABLE "___ORGANIZATION_ID___"."userOrganizationCredentials"
    DROP CONSTRAINT IF EXISTS credential_source_integration_client_id,
    DROP COLUMN IF EXISTS "sourceId",
    DROP COLUMN IF EXISTS "source";

    -- Drop primary key from integrationClients
    ALTER TABLE "___ORGANIZATION_ID___"."integrationClients"
    DROP CONSTRAINT IF EXISTS integration_client_pkey;
    `;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query, "___ORGANIZATION_ID___");
}
exports.down = down;
