"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const dal_utils_1 = require("../../../dal.utils");
async function up(client, dbuser, dbsuperuser) {
    const query = `
        DROP TRIGGER sms_balance_trigger ON "___ORGANIZATION_ID___".organizations;

        CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".notify_sms_balance() 
        RETURNS TRIGGER AS $$
        BEGIN
            IF NEW."smsBalance" < 100 AND OLD."smsBalance" >= 100 THEN
                PERFORM pg_notify('sms_balance_notification', 
                                json_build_object('organizationId', NEW.id, 'threshold', 100)::text);
            ELSIF NEW."smsBalance" < 50 AND OLD."smsBalance" >= 50 THEN
                PERFORM pg_notify('sms_balance_notification', 
                                json_build_object('organizationId', NEW.id, 'threshold', 50)::text);
            END IF;
            
            RETURN NEW;
        END;
        $$ LANGUAGE plpgsql;

        CREATE TRIGGER sms_balance_trigger
        BEFORE UPDATE OF "smsBalance" ON "___ORGANIZATION_ID___".organizations
        FOR EACH ROW
        WHEN (OLD."smsBalance" IS DISTINCT FROM NEW."smsBalance")
        EXECUTE FUNCTION "___ORGANIZATION_ID___".notify_sms_balance();
    `;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query, "___ORGANIZATION_ID___");
    await client.query(`DROP FUNCTION IF EXISTS public.notify_sms_balance();`);
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) {
    await client.query(`
        CREATE OR REPLACE FUNCTION notify_sms_balance() 
        RETURNS TRIGGER AS $$
        BEGIN
            IF NEW."smsBalance" < 100 AND OLD."smsBalance" >= 100 THEN
                PERFORM pg_notify('sms_balance_notification', 
                                json_build_object('organizationId', NEW.id, 'threshold', 100)::text);
            ELSIF NEW."smsBalance" < 50 AND OLD."smsBalance" >= 50 THEN
                PERFORM pg_notify('sms_balance_notification', 
                                json_build_object('organizationId', NEW.id, 'threshold', 50)::text);
            END IF;
            
            RETURN NEW;
        END;
        $$ LANGUAGE plpgsql;`);
    const query = `
        DROP TRIGGER sms_balance_trigger ON "___ORGANIZATION_ID___".organizations;

        CREATE TRIGGER sms_balance_trigger
        BEFORE UPDATE OF "smsBalance" ON "___ORGANIZATION_ID___".organizations
        FOR EACH ROW
        WHEN (OLD."smsBalance" IS DISTINCT FROM NEW."smsBalance")
        EXECUTE FUNCTION notify_sms_balance();
    `;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query, "___ORGANIZATION_ID___");
}
exports.down = down;
