"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const dal_utils_1 = require("../../../dal.utils");
async function up(client, dbuser, dbsuperuser) {
    const query = `
        WITH duplicate_user_unit_records AS (
            SELECT id,
                ROW_NUMBER() OVER (PARTITION BY "userOrganizationId", "organizationUnitId"
                                    ORDER BY "updatedAt" DESC) AS rn
            FROM "___ORGANIZATION_ID___"."userOrganizationOrganizationUnits"
            WHERE "deletedAt" IS NULL
        )
        DELETE FROM "___ORGANIZATION_ID___"."userOrganizationOrganizationUnits"
        WHERE id IN (
            SELECT id
            FROM duplicate_user_unit_records
            WHERE rn > 1
        );

        CREATE UNIQUE INDEX unique_user_unit_check
        ON "___ORGANIZATION_ID___"."userOrganizationOrganizationUnits"("userOrganizationId", "organizationUnitId")
        WHERE "deletedAt" IS NULL;

        WITH duplicate_user_group_records AS (
            SELECT id,
                ROW_NUMBER() OVER (PARTITION BY "userOrganizationId", "userGroupId"
                                    ORDER BY "updatedAt" DESC) AS rn
            FROM "___ORGANIZATION_ID___"."userGroupUserOrganizations"
            WHERE "deletedAt" IS NULL
        )
        DELETE FROM "___ORGANIZATION_ID___"."userGroupUserOrganizations"
        WHERE id IN (
            SELECT id
            FROM duplicate_user_group_records
            WHERE rn > 1
        );

        CREATE UNIQUE INDEX unique_user_group_check
        ON "___ORGANIZATION_ID___"."userGroupUserOrganizations"("userOrganizationId", "userGroupId")
        WHERE "deletedAt" IS NULL;

        WITH duplicate_ppermissions AS (
            SELECT id,
                ROW_NUMBER() OVER (PARTITION BY "userId", "ppermissionId") AS rn
            FROM "___ORGANIZATION_ID___"."userPPermissions"
        )
        DELETE FROM "___ORGANIZATION_ID___"."userPPermissions" up 
        WHERE id IN (
            SELECT id
            FROM duplicate_ppermissions
            WHERE rn > 1
        );

        ALTER TABLE "___ORGANIZATION_ID___"."userPPermissions"
        ADD CONSTRAINT unique_user_permission_constraint
        UNIQUE ("userId", "ppermissionId");

        CREATE EXTENSION IF NOT EXISTS btree_gist;

        ALTER TABLE "___ORGANIZATION_ID___"."userWorkPlans"
        ADD CONSTRAINT unique_work_plan_no_overlap
        EXCLUDE USING gist (
        "userId" WITH =,
        tstzrange("startDateTime", "endDateTime") WITH &&
        )
        DEFERRABLE INITIALLY DEFERRED;
    `;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query, "___ORGANIZATION_ID___");
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) {
    const query = `
        DROP INDEX IF EXISTS "___ORGANIZATION_ID___"."unique_user_unit_check";

        DROP INDEX IF EXISTS "___ORGANIZATION_ID___"."unique_user_group_check";

        ALTER TABLE "___ORGANIZATION_ID___"."userPPermissions"
        DROP CONSTRAINT IF EXISTS unique_user_permission_constraint;

        ALTER TABLE "___ORGANIZATION_ID___"."userWorkPlans"
        DROP CONSTRAINT IF EXISTS unique_work_plan_no_overlap;

        DROP EXTENSION IF EXISTS btree_gist CASCADE;
	`;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query, "___ORGANIZATION_ID___");
}
exports.down = down;
