"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const dal_utils_1 = require("../../../dal.utils");
const dal_db_armon_schema_1 = require("../../armon/dal.db.armon.schema");
const uuid_1 = __importDefault(require("uuid"));
async function up(client, dbuser, dbsuperuser) {
    const query = `
    CREATE TABLE IF NOT EXISTS "___ORGANIZATION_ID___".ppermission_type_rules
    (
        "id" uuid NOT NULL,
        "ppermissionTypeId" uuid NOT NULL,
        "userFilterId" uuid,
        "applicableDays" integer[],
        CONSTRAINT "ppermission_type_rules_permissionTypeId_fkey" FOREIGN KEY ("ppermissionTypeId")
            REFERENCES "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.ppermissionTypes}" (id)
            ON DELETE CASCADE,
        CONSTRAINT "ppermission_type_rules_userFilterId_fkey" FOREIGN KEY ("userFilterId")
            REFERENCES "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userFilter}" (id)
            ON DELETE CASCADE,
        CONSTRAINT unique_permission_type_user_filter UNIQUE ("ppermissionTypeId", "userFilterId")
    );`;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query, "___ORGANIZATION_ID___");
    const organizations = await client.query(`SELECT id from public."organizationList"`);
    const alfaSolarId = "62aea32d-b452-4c3b-ab4e-d8b1df2ffaab";
    const hasAlfaSolar = organizations.rows.find((org) => org.id === alfaSolarId);
    const applicableDaysMap = {
        "3b3fd1a7-0c3a-4034-a549-32f0ca956072": [
            {
                ppermissionTypeId: "094101f2-6481-4ea7-9b54-91f934a7060f",
                userFilterId: null,
                applicableDays: [1, 2, 3, 4, 5, 6, 7],
            },
        ],
        "3fc6d618-d5db-4fe0-a9b9-f070d2fd9815": [
            {
                ppermissionTypeId: "d130ace1-9bef-480e-acd5-059df79043ef",
                userFilterId: null,
                applicableDays: [1, 2, 3, 4, 5, 6],
            },
            {
                ppermissionTypeId: "78bc8f61-1974-41c5-82ac-27a17c926ca7",
                userFilterId: null,
                applicableDays: [1, 2, 3, 4, 5, 6],
            },
            {
                ppermissionTypeId: "1d709efc-60af-45e7-a8f8-48e0c3d84cc5",
                userFilterId: null,
                applicableDays: [1, 2, 3, 4, 5, 6],
            },
            {
                ppermissionTypeId: "7eca389e-5e1a-44ac-a807-389fd1e73d25",
                userFilterId: null,
                applicableDays: [1, 2, 3, 4, 5, 6, 7],
            },
        ],
        "4a5c591e-c303-43a7-968d-0378a2fc0c0d": [
            {
                ppermissionTypeId: null,
                userFilterId: null,
                applicableDays: [1, 2, 3, 4, 5, 6],
            },
        ],
        "60d3591e-7f24-4eed-85f4-640fd3cfaa20": [
            {
                ppermissionTypeId: "71a7cb99-62c5-4937-b9e1-66ce2b89f278",
                userFilterId: null,
                applicableDays: [1, 2, 3, 4, 5, 6],
            },
        ],
        "62aea32d-b452-4c3b-ab4e-d8b1df2ffaab": [
            {
                ppermissionTypeId: null,
                userFilterId: null,
                applicableDays: [1, 2, 3, 4, 5, 6],
            },
            {
                ppermissionTypeId: null,
                userFilterId: null,
                applicableDays: [1, 2, 3, 4, 5, 6],
            },
        ],
        "97de9098-fe23-4837-9842-6886dcaa71fb": [
            {
                ppermissionTypeId: null,
                userFilterId: null,
                applicableDays: [1, 2, 3, 4, 5, 6],
            },
        ],
        "1325e507-3b10-4047-b439-cf50d6fe1358": [
            {
                ppermissionTypeId: null,
                userFilterId: null,
                applicableDays: [1, 2, 3, 4, 5, 6, 7],
            },
        ],
        "1593b82d-b0bf-49c6-a487-8cbd49e365ea": [
            {
                ppermissionTypeId: "4a7e696f-280f-4936-ae2e-66a84a9a4a69",
                userFilterId: null,
                applicableDays: [1, 2, 3, 4, 5, 6],
            },
        ],
        "acf328eb-b466-4212-a784-61bb663f03b3": [
            {
                ppermissionTypeId: "34a2a0bb-de49-499f-95d0-de1daf89875a",
                userFilterId: null,
                applicableDays: [1, 2, 3, 4, 5, 6],
            },
        ],
        "eb0b3531-4a9f-42d1-8843-5cc0327ec9a1": [
            {
                ppermissionTypeId: null,
                userFilterId: null,
                applicableDays: [1, 2, 3, 4, 5, 6],
            },
        ],
        "efda173d-2d5e-4779-8723-f28b1a9a0e99": [
            {
                ppermissionTypeId: "8a1a17c0-f77b-4e56-8e45-9d566bbfa2d1",
                userFilterId: null,
                applicableDays: [1, 2, 3, 4, 5, 6, 7],
            },
            {
                ppermissionTypeId: "97584458-3820-4a2a-b65f-212f04af69b7",
                userFilterId: null,
                applicableDays: [1, 2, 3, 4, 5, 6, 7],
            },
            {
                ppermissionTypeId: "8c967827-594b-419e-8aff-81e834137631",
                userFilterId: null,
                applicableDays: [1, 2, 3, 4, 5, 6, 7],
            },
            {
                ppermissionTypeId: "33c6c68b-6bf5-4fff-95ab-5108e61682da",
                userFilterId: null,
                applicableDays: [1, 2, 3, 4, 5, 6, 7],
            },
            {
                ppermissionTypeId: "0d57b6da-6cf9-4e3f-bd86-01889b869540",
                userFilterId: null,
                applicableDays: [1, 2, 3, 4, 5, 6, 7],
            },
            {
                ppermissionTypeId: "b0bcd43a-5cd5-48fb-8825-1e000879954f",
                userFilterId: null,
                applicableDays: [1, 2, 3, 4, 5, 6, 7],
            },
            {
                ppermissionTypeId: "0d61c9a2-0019-476b-943c-4d39c7869877",
                userFilterId: null,
                applicableDays: [1, 2, 3, 4, 5, 6],
            },
        ],
        "eec6c4b4-b540-4bfb-8720-ca8457c5de39": [
            {
                ppermissionTypeId: "17ecd956-e08f-40ed-8bf8-9f4624823b8f",
                userFilterId: null,
                applicableDays: [1, 2, 3, 4, 5, 6, 7],
            },
            {
                ppermissionTypeId: "f8e1538a-4b2d-4454-adf3-22d911237812",
                userFilterId: null,
                applicableDays: [1, 2, 3, 4, 5, 6, 7],
            },
            {
                ppermissionTypeId: "276f5b17-7832-44a7-a4b1-60f8f8731722",
                userFilterId: null,
                applicableDays: [1, 2, 3, 4, 5, 6, 7],
            },
            {
                ppermissionTypeId: "d5b5044a-31c7-42df-9de2-82bcd1563a17",
                userFilterId: null,
                applicableDays: [1, 2, 3, 4, 5, 6, 7],
            },
            {
                ppermissionTypeId: "9d8513cb-003f-4825-89ae-9dd9fb11bbc5",
                userFilterId: null,
                applicableDays: [1, 2, 3, 4, 5, 6, 7],
            },
            {
                ppermissionTypeId: "ec415398-bb4d-4fda-ba9e-e8a8c8d9b0d4",
                userFilterId: null,
                applicableDays: [1, 2, 3, 4, 5, 6, 7],
            },
            {
                ppermissionTypeId: "c466d2e0-eda6-4091-a391-9b13b41d4ab9",
                userFilterId: null,
                applicableDays: [1, 2, 3, 4, 5, 6, 7],
            },
            {
                ppermissionTypeId: "96127f05-828f-42c5-9762-4c3dec1d0ee3",
                userFilterId: null,
                applicableDays: [1, 2, 3, 4, 5, 6, 7],
            },
            {
                ppermissionTypeId: "7fd46ae0-c584-4dec-b269-35bd06d127e3",
                userFilterId: null,
                applicableDays: [1, 2, 3, 4, 5, 6, 7],
            },
            {
                ppermissionTypeId: "f73f093d-d354-423c-bc9f-a802439c111d",
                userFilterId: null,
                applicableDays: [1, 2, 3, 4, 5, 6, 7],
            },
            {
                ppermissionTypeId: "6fa5af9a-f038-490a-886f-368ea4e7951e",
                userFilterId: null,
                applicableDays: [1, 2, 3, 4, 5, 6, 7],
            },
            {
                ppermissionTypeId: "8c5ed703-aafb-40bb-9ba0-89b9aa77a2f9",
                userFilterId: null,
                applicableDays: [1, 2, 3, 4, 5, 6, 7],
            },
        ],
        "392cf6af-0c91-4a42-a5fc-249044cd851f": [
            {
                ppermissionTypeId: "685434ed-01c4-46a9-b4a2-f5fcd5b71da7",
                userFilterId: null,
                applicableDays: [1, 2, 3, 4, 5, 6, 7],
            },
            {
                ppermissionTypeId: "61d7c673-c1f2-4c61-a06b-0826eef211b8",
                userFilterId: null,
                applicableDays: [1, 2, 3, 4, 5, 6, 7],
            },
            {
                ppermissionTypeId: "fac75b91-dcf9-4f87-97c1-2539d1fa164f",
                userFilterId: null,
                applicableDays: [1, 2, 3, 4, 5, 6, 7],
            },
            {
                ppermissionTypeId: "20a57a8f-a961-423b-a245-103fe8667983",
                userFilterId: null,
                applicableDays: [1, 2, 3, 4, 5, 6, 7],
            },
            {
                ppermissionTypeId: "8d82dfae-39ce-4605-98df-028fe65d1dfe",
                userFilterId: null,
                applicableDays: [1, 2, 3, 4, 5, 6, 7],
            },
            {
                ppermissionTypeId: "5b292ccb-6e55-4953-bd0f-f3bda038592b",
                userFilterId: null,
                applicableDays: [1, 2, 3, 4, 5, 6, 7],
            },
            {
                ppermissionTypeId: "d8cb94c4-baaa-4f4d-a727-df374e878176",
                userFilterId: null,
                applicableDays: [1, 2, 3, 4, 5, 6, 7],
            },
            {
                ppermissionTypeId: "8f588f1b-0501-4acf-96b4-8fb380200c92",
                userFilterId: null,
                applicableDays: [1, 2, 3, 4, 5, 6, 7],
            },
        ],
        "610bda2b-be46-4210-adab-b789e7e319f6": [
            {
                ppermissionTypeId: "af339686-c4d9-4590-9053-51d6317450bb",
                userFilterId: null,
                applicableDays: [1, 2, 3, 4, 5, 6],
            },
        ],
    };
    if (hasAlfaSolar) {
        const alfaUserFilter1Id = uuid_1.default.v4();
        const alfaUserFilter2Id = uuid_1.default.v4();
        const AlfaSolarUserFilterInserts = `INSERT INTO "62aea32d-b452-4c3b-ab4e-d8b1df2ffaab"."user_filter"(
            "id")
            VALUES ('${alfaUserFilter1Id}');
            
            INSERT INTO "62aea32d-b452-4c3b-ab4e-d8b1df2ffaab"."user_filter"(
                "id")
                VALUES ('${alfaUserFilter2Id}');`;
        await client.query(AlfaSolarUserFilterInserts);
        const AlfaSolarUserFilterGroupInserts = `INSERT INTO "62aea32d-b452-4c3b-ab4e-d8b1df2ffaab"."user_filter_group"(
            "filterId", "groupId")
            VALUES ('${alfaUserFilter1Id}', '196abbaa-fd81-4693-87d3-b7fc294b6173');
            
            INSERT INTO "62aea32d-b452-4c3b-ab4e-d8b1df2ffaab"."user_filter_group"(
            "filterId", "groupId")
            VALUES ('${alfaUserFilter2Id}', '7a0b0a94-e556-45f0-9e40-c0adaab3aee8');`;
        await client.query(AlfaSolarUserFilterGroupInserts);
        applicableDaysMap["62aea32d-b452-4c3b-ab4e-d8b1df2ffaab"][0].userFilterId = alfaUserFilter1Id;
        applicableDaysMap["62aea32d-b452-4c3b-ab4e-d8b1df2ffaab"][1].userFilterId = alfaUserFilter2Id;
    }
    let insertQuery = "";
    for (let org of organizations.rows) {
        const orgRules = applicableDaysMap[org.id];
        if (!orgRules) {
            continue;
        }
        if (!orgRules[0].ppermissionTypeId) {
            const orgPermissionIds = await client.query(`SELECT id FROM  "${org.id}"."ppermissionTypes" WHERE "deletedAt" IS NULL`);
            let arrayPerOrg = [];
            applicableDaysMap[org.id].forEach((ruleToUpdate) => {
                orgPermissionIds.rows.forEach((row) => {
                    arrayPerOrg.push({
                        ppermissionTypeId: row.id,
                        userFilterId: ruleToUpdate.userFilterId,
                        applicableDays: ruleToUpdate.applicableDays,
                    });
                });
            });
            applicableDaysMap[org.id] = arrayPerOrg;
        }
        if (applicableDaysMap[org.id]) {
            applicableDaysMap[org.id].forEach((rule) => {
                insertQuery += `INSERT INTO "${org.id}"."ppermission_type_rules"(
                                    "id","ppermissionTypeId", "userFilterId", "applicableDays")
                                    VALUES (uuid_generate_v4(), '${rule.ppermissionTypeId}', ${rule.userFilterId ? "'" + rule.userFilterId + "'" : "NULL"} , '{${rule.applicableDays}}');`;
            });
        }
    }
    await client.query(insertQuery);
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) {
    const query = `
	DROP TABLE IF EXISTS "___ORGANIZATION_ID___"."ppermission_type_rules";
`;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query, "___ORGANIZATION_ID___");
}
exports.down = down;
