"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const dal_utils_1 = require("../../../dal.utils");
async function up(client, dbuser, dbsuperuser) {
    const userFilterView = `
     CREATE OR REPLACE VIEW "___ORGANIZATION_ID___".vw_user_filter AS
     SELECT uf.id,
            json_build_object('id', uf.id, 
                            'groupIds', COALESCE(jsonb_agg(ufg."groupId") FILTER (WHERE ufg."groupId" IS NOT NULL), NULL::jsonb), 
                            'roleIds', COALESCE(jsonb_agg(ufor."roleId") FILTER (WHERE ufor."roleId" IS NOT NULL), NULL::jsonb), 
                            'userIds', COALESCE(jsonb_agg(ufu."userId") FILTER (WHERE ufu."userId" IS NOT NULL), NULL::jsonb), 
                            'workPlanIds', COALESCE(jsonb_agg(ufw."workPlanId") FILTER (WHERE ufw."workPlanId" IS NOT NULL), NULL::jsonb), 
                            'units', COALESCE(jsonb_agg(jsonb_build_object('id', ufn."unitId", 'hierarchically', ufn.hierarchically, 'roleIds', ufuragg."roleIds")) FILTER (WHERE ufn."unitId" IS NOT NULL), NULL::jsonb)) AS filter
    FROM "___ORGANIZATION_ID___".user_filter uf
    LEFT JOIN "___ORGANIZATION_ID___".user_filter_group ufg ON uf.id = ufg."filterId"
    LEFT JOIN "___ORGANIZATION_ID___".user_filter_organization_role ufor ON uf.id = ufor."filterId"
    LEFT JOIN "___ORGANIZATION_ID___".user_filter_user ufu ON uf.id = ufu."filterId"
    LEFT JOIN "___ORGANIZATION_ID___".user_filter_work_plan ufw ON uf.id = ufw."filterId"
    LEFT JOIN "___ORGANIZATION_ID___".user_filter_unit ufn ON uf.id = ufn."filterId"
    LEFT JOIN ( SELECT ufur."filterId",
            ufur."unitId",
            COALESCE(json_agg(ufur."roleId") FILTER (WHERE ufur."roleId" IS NOT NULL), NULL::json) AS "roleIds"
        FROM "___ORGANIZATION_ID___".user_filter_unit_role ufur
        GROUP BY ufur."filterId", ufur."unitId") ufuragg ON ufuragg."unitId" = ufn."unitId" AND ufn."filterId" = ufuragg."filterId"
    GROUP BY uf.id;
    `;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, userFilterView, "___ORGANIZATION_ID___");
    const ownerOfView = `
    	ALTER TABLE "___ORGANIZATION_ID___"."vw_user_filter"
		OWNER TO ${dbsuperuser};
    `;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, ownerOfView, "___ORGANIZATION_ID___");
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) {
    const userFilterView = `
    CREATE OR REPLACE VIEW "___ORGANIZATION_ID___".vw_user_filter AS
    SELECT uf.id,
           json_build_object('id', uf.id, 
                           'groupIds', COALESCE(jsonb_agg(ufg."groupId") FILTER (WHERE ufg."groupId" IS NOT NULL), NULL::jsonb), 
                           'roleIds', COALESCE(jsonb_agg(ufor."roleId") FILTER (WHERE ufor."roleId" IS NOT NULL), NULL::jsonb), 
                           'userIds', COALESCE(jsonb_agg(ufu."userId") FILTER (WHERE ufu."userId" IS NOT NULL), NULL::jsonb), 
                           'workPlanIds', COALESCE(jsonb_agg(ufw."workPlanId") FILTER (WHERE ufw."workPlanId" IS NOT NULL), NULL::jsonb), 
                           'units', COALESCE(jsonb_agg(jsonb_build_object('unitId', ufn."unitId", 'hierarchically', ufn.hierarchically, 'roleIds', ufuragg."roleIds")) FILTER (WHERE ufn."unitId" IS NOT NULL), NULL::jsonb)) AS filter
    FROM "___ORGANIZATION_ID___".user_filter uf
    LEFT JOIN "___ORGANIZATION_ID___".user_filter_group ufg ON uf.id = ufg."filterId"
    LEFT JOIN "___ORGANIZATION_ID___".user_filter_organization_role ufor ON uf.id = ufor."filterId"
    LEFT JOIN "___ORGANIZATION_ID___".user_filter_user ufu ON uf.id = ufu."filterId"
    LEFT JOIN "___ORGANIZATION_ID___".user_filter_work_plan ufw ON uf.id = ufw."filterId"
    LEFT JOIN "___ORGANIZATION_ID___".user_filter_unit ufn ON uf.id = ufn."filterId"
    LEFT JOIN ( SELECT ufur."filterId",
            ufur."unitId",
            COALESCE(json_agg(ufur."roleId") FILTER (WHERE ufur."roleId" IS NOT NULL), NULL::json) AS "roleIds"
        FROM "___ORGANIZATION_ID___".user_filter_unit_role ufur
        GROUP BY ufur."filterId", ufur."unitId") ufuragg ON ufuragg."unitId" = ufn."unitId" AND ufn."filterId" = ufuragg."filterId"
    GROUP BY uf.id;
   `;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, userFilterView, "___ORGANIZATION_ID___");
    const ownerOfView = `
    ALTER TABLE "___ORGANIZATION_ID___"."vw_user_filter"
    OWNER TO ${dbsuperuser};
    `;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, ownerOfView, "___ORGANIZATION_ID___");
}
exports.down = down;
