"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const dal_utils_1 = require("../../../dal.utils");
async function up(client, dbuser, dbsuperuser) {
    const query = `
   	UPDATE "___ORGANIZATION_ID___"."organizationVisitorModuleSettings"
		SET "settings" = 
			jsonb_set(
		    	"settings"::JSONB, '{qrSettings}', jsonb_build_object('communicationMedium', "settings"->'gdprSettings'->'communicationMedium')
	    	) #- '{gdprSettings,communicationMedium}'     
    `;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query, "___ORGANIZATION_ID___");
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) {
    const query = `
   	UPDATE "___ORGANIZATION_ID___"."organizationVisitorModuleSettings"
		SET "settings" = 
			jsonb_set(
		    	"settings"::JSONB, '{gdprSettings,communicationMedium}', ("settings"->'qrSettings'->'communicationMedium')::JSONB
	    	) #- '{qrSettings}'     
    `;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query, "___ORGANIZATION_ID___");
}
exports.down = down;
