"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
async function up(client, dbuser, dbsuperuser) {
    const organizationIds = (await client.query(` SELECT id FROM public."organizationList";`)).rows.map((r) => r.id);
    for (const organizationId of organizationIds) {
        await client.query(`
            WITH org_settings AS (
                SELECT settings FROM "${organizationId}".organizations
                WHERE id = $1
            )
            UPDATE "${organizationId}".organizations org
            SET settings = CASE
                WHEN NOT EXISTS (
                    SELECT 1 FROM org_settings
                    WHERE settings->'integrations' IS NOT NULL
                )
                THEN jsonb_set(org_settings.settings || '{"integrations": []}'::jsonb, '{integrations}', '[]', true)
                ELSE org_settings.settings
                END
            FROM org_settings
            WHERE org.id = $1
            AND org."deletedAt" IS NULL;
            `, [organizationId]);
    }
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) {
    const organizationIds = (await client.query(` SELECT id FROM public."organizationList";`)).rows.map((r) => r.id);
    for (const organizationId of organizationIds) {
        await client.query(`
        WITH org_settings AS (
            SELECT settings FROM "${organizationId}".organizations
            WHERE id = $1
        )
        UPDATE "${organizationId}".organizations org
        SET settings = org_settings.settings #- '{integrations}'
        FROM org_settings
        WHERE org.id = $1
        AND org."deletedAt" IS NULL;
        `, [organizationId]);
    }
}
exports.down = down;
