"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const dal_utils_1 = require("../../../dal.utils");
async function up(client, dbuser, dbsuperuser) {
    const removeInappropriateAutoShifts = `
    DELETE FROM "___ORGANIZATION_ID___".auto_shift_rule_set
    WHERE id = ANY(
                    SELECT DISTINCT(asrs.id)
                    FROM "___ORGANIZATION_ID___".auto_shift_rule_set as asrs
                         ,unnest(rules) as rule
                    LEFT JOIN "___ORGANIZATION_ID___"."workPlans" as wp
                        ON wp.id = (rule->>'workPlanId')::uuid
                    WHERE wp.id IS NULL
                  )
	`;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, removeInappropriateAutoShifts, "___ORGANIZATION_ID___");
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) { }
exports.down = down;
