"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const dal_utils_1 = require("../../../dal.utils");
async function up(client, dbuser, dbsuperuser) {
    const query = `
		ALTER TABLE  "___ORGANIZATION_ID___"."devices"
			ADD COLUMN "softwareUpdateInterfaceState" INTEGER NOT NULL DEFAULT 3,
			ADD COLUMN "serverConnectionState" INTEGER NOT NULL DEFAULT 2;
		`;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query, "___ORGANIZATION_ID___");
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) {
    const query = `
		ALTER TABLE  "___ORGANIZATION_ID___"."devices"
			DROP COLUMN "softwareUpdateInterfaceState",
			DROP COLUMN "serverConnectionState";
		`;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query, "___ORGANIZATION_ID___");
}
exports.down = down;
