"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const dal_utils_1 = require("../../../dal.utils");
async function up(client, dbuser, dbsuperuser) {
    const query = `
		ALTER TABLE "___ORGANIZATION_ID___"."organizationVisitorModuleSettings"
			DROP COLUMN IF EXISTS "visitorProfileFormFields",
			DROP COLUMN IF EXISTS "availableCredentials",
			DROP COLUMN IF EXISTS "visitFormFields",
			DROP COLUMN IF EXISTS "visitorProfileFormFieldSearchEndPoint",
			DROP COLUMN IF EXISTS "visitorProfileFormSearchEndPoint",
			DROP COLUMN IF EXISTS "visitFormFieldSearchEndPoint",
			DROP COLUMN IF EXISTS "preRegistrationAvailable",
			DROP COLUMN IF EXISTS "visitorStates",
			DROP COLUMN IF EXISTS "forceToSelectRegistrationPoint",
			DROP COLUMN IF EXISTS "maxExpectedDayCount",
			DROP COLUMN IF EXISTS "visitFormFinalizedEndPoints";
		`;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query, "___ORGANIZATION_ID___");
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) {
    const query = `
		ALTER TABLE "___ORGANIZATION_ID___"."organizationVisitorModuleSettings"
			ADD COLUMN IF NOT EXISTS "visitorProfileFormFields" JSON NOT NULL DEFAULT '{}'::JSON,
			ADD COLUMN IF NOT EXISTS "availableCredentials" JSON NOT NULL DEFAULT '{}'::JSON,
			ADD COLUMN IF NOT EXISTS "visitFormFields" JSON NOT NULL DEFAULT '{}'::JSON,
			ADD COLUMN IF NOT EXISTS "visitorProfileFormFieldSearchEndPoint" CHARACTER VARYING(511) COLLATE pg_catalog."default" NOT NULL DEFAULT '',
			ADD COLUMN IF NOT EXISTS "visitorProfileFormSearchEndPoint" CHARACTER VARYING(511) COLLATE pg_catalog."default" NOT NULL DEFAULT '',
			ADD COLUMN IF NOT EXISTS "visitFormFieldSearchEndPoint" CHARACTER VARYING(511) COLLATE pg_catalog."default" NOT NULL DEFAULT '',
			ADD COLUMN IF NOT EXISTS "preRegistrationAvailable" BOOLEAN NOT NULL DEFAULT TRUE,
			ADD COLUMN IF NOT EXISTS "visitorStates" JSON,
			ADD COLUMN IF NOT EXISTS "forceToSelectRegistrationPoint" BOOLEAN NOT NULL DEFAULT FALSE,
			ADD COLUMN IF NOT EXISTS "maxExpectedDayCount" INTEGER,
			ADD COLUMN IF NOT EXISTS "visitFormFinalizedEndPoints" JSON;
		`;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query, "___ORGANIZATION_ID___");
}
exports.down = down;
