"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const dal_utils_1 = require("../../../dal.utils");
async function up(client, dbuser, dbsuperuser) {
    await updateForeignKeyConstraints.up(client, dbuser, dbsuperuser);
    await accessRuleSetTrigger.up(client, dbuser, dbsuperuser);
    await cleanupUnusedDbElements.up(client, dbuser, dbsuperuser);
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) {
    await cleanupUnusedDbElements.down(client, dbuser, dbsuperuser);
    await accessRuleSetTrigger.down(client, dbuser, dbsuperuser);
    await updateForeignKeyConstraints.down(client, dbuser, dbsuperuser);
}
exports.down = down;
const updateForeignKeyConstraints = {
    up: async (client, dbuser, dbsuperuser) => {
        const q = `
			ALTER TABLE "___ORGANIZATION_ID___"."accessControlPoints"
				DROP CONSTRAINT accesscontrolpoints_deviceid_foreign, 
				ADD CONSTRAINT accesscontrolpoints_deviceid_foreign 
					FOREIGN KEY ("deviceId") REFERENCES "___ORGANIZATION_ID___".devices(id) 
						ON UPDATE CASCADE
						ON DELETE SET NULL;

			ALTER TABLE "___ORGANIZATION_ID___"."cameras"
				DROP CONSTRAINT "cameras_accessControlPointId_fkey", 
				ADD CONSTRAINT "cameras_accessControlPointId_fkey" 
					FOREIGN KEY ("accessControlPointId") REFERENCES "___ORGANIZATION_ID___"."accessControlPoints"(id) 
						ON UPDATE CASCADE
						ON DELETE CASCADE; -- possible to set null, but might be broking

			ALTER TABLE "___ORGANIZATION_ID___"."devices"
				DROP CONSTRAINT "devices_organizationid_foreign", 
				ADD CONSTRAINT "devices_organizationid_foreign" 
					FOREIGN KEY ("organizationId") REFERENCES "___ORGANIZATION_ID___"."organizations"(id) 
						ON UPDATE CASCADE
						ON DELETE CASCADE; -- cascaded on delete because column is not nullable

			ALTER TABLE "___ORGANIZATION_ID___"."organizationActiveVisits"
				DROP CONSTRAINT "organizationActiveVisits_escortUserOrganizationId_fkey", 
				ADD CONSTRAINT "organizationActiveVisits_escortUserOrganizationId_fkey" 
					FOREIGN KEY ("escortUserOrganizationId") REFERENCES "___ORGANIZATION_ID___"."userOrganizations"(id) 
						ON UPDATE CASCADE
						ON DELETE SET NULL,
				DROP CONSTRAINT "organizationActiveVisits_visitedOrganizationUnitId_fkey", 
				ADD CONSTRAINT "organizationActiveVisits_visitedOrganizationUnitId_fkey" 
					FOREIGN KEY ("visitedOrganizationUnitId") REFERENCES "___ORGANIZATION_ID___"."organizationUnits"(id) 
						ON UPDATE CASCADE
						ON DELETE SET NULL,
				DROP CONSTRAINT "organizationActiveVisits_visitedUserOrganizationId_fkey", 
				ADD CONSTRAINT "organizationActiveVisits_visitedUserOrganizationId_fkey" 
					FOREIGN KEY ("visitedUserOrganizationId") REFERENCES "___ORGANIZATION_ID___"."userOrganizations"(id) 
						ON UPDATE CASCADE
						ON DELETE SET NULL;

			ALTER TABLE "___ORGANIZATION_ID___"."organizationUnitDefaultAccessControlPoints"
				DROP CONSTRAINT "organizationUnitDefaultAccessControlP_accessControlPointId_fkey", 
				ADD CONSTRAINT "organizationUnitDefaultAccessControlP_accessControlPointId_fkey" 
					FOREIGN KEY ("accessControlPointId") REFERENCES "___ORGANIZATION_ID___"."accessControlPoints"(id) 
						ON UPDATE CASCADE
						ON DELETE CASCADE; -- cascaded on delete because column is not nullable

			ALTER TABLE "___ORGANIZATION_ID___"."organizationUnits"
				DROP CONSTRAINT IF EXISTS "organizationUnits_managerUserOrganizationId_fkey", 
				ADD CONSTRAINT "organizationUnits_managerUserOrganizationId_fkey" 
					FOREIGN KEY ("managerUserOrganizationId") REFERENCES "___ORGANIZATION_ID___"."userOrganizations"(id) 
						ON UPDATE CASCADE
						ON DELETE SET NULL,
				DROP CONSTRAINT "organizationUnits_organizationId_fkey", 
				ADD CONSTRAINT "organizationUnits_organizationId_fkey" 
					FOREIGN KEY ("organizationId") REFERENCES "___ORGANIZATION_ID___"."organizations"(id) 
						ON UPDATE CASCADE
						ON DELETE CASCADE; -- cascaded on delete because column is not nullable
			
			ALTER TABLE "___ORGANIZATION_ID___"."organizationVisitorModuleSettings"
				DROP CONSTRAINT "organizationVisitorModuleSettings_organizationId_fkey", 
				ADD CONSTRAINT "organizationVisitorModuleSettings_organizationId_fkey" 
					FOREIGN KEY ("organizationId") REFERENCES "___ORGANIZATION_ID___"."organizations"(id) 
						ON UPDATE CASCADE
						ON DELETE CASCADE; -- cascaded on delete because column is not nullable
			
			ALTER TABLE "___ORGANIZATION_ID___"."organizations"
				DROP CONSTRAINT "organizations_organizationUnitDynamicFormId_fkey", 
				ADD CONSTRAINT "organizations_organizationUnitDynamicFormId_fkey" 
					FOREIGN KEY ("organizationUnitDynamicFormId") REFERENCES "___ORGANIZATION_ID___"."dynamicForms"(id) 
						ON UPDATE CASCADE
						ON DELETE SET NULL;

			ALTER TABLE "___ORGANIZATION_ID___"."organizationUnits"
				DROP CONSTRAINT "orgunit_type_id_orguserdefinedlistvalues_id", 
				ADD CONSTRAINT "orgunit_type_id_orguserdefinedlistvalues_id" 
					FOREIGN KEY ("typeId") REFERENCES "___ORGANIZATION_ID___"."organizationUserDefinedListValues"(id) 
						ON UPDATE CASCADE
						ON DELETE CASCADE; -- cascaded on delete because column is not nullable
				
			ALTER TABLE "___ORGANIZATION_ID___"."ppermissionClaims"
				DROP CONSTRAINT "ppermissionClaims_organizationId_fkey", 
				ADD CONSTRAINT "ppermissionClaims_organizationId_fkey" 
					FOREIGN KEY ("organizationId") REFERENCES "___ORGANIZATION_ID___"."organizations"(id) 
						ON UPDATE CASCADE
						ON DELETE CASCADE; -- cascaded on delete because column is not nullable
	
			ALTER TABLE "___ORGANIZATION_ID___"."ppermissions"
				DROP CONSTRAINT "ppermissions_organizationId_fkey", 
				ADD CONSTRAINT "ppermissions_organizationId_fkey" 
					FOREIGN KEY ("organizationId") REFERENCES "___ORGANIZATION_ID___"."organizations"(id) 
						ON UPDATE CASCADE
						ON DELETE CASCADE; -- cascaded on delete because column is not nullable
	
			ALTER TABLE "___ORGANIZATION_ID___"."userGroupUserOrganizations"
				DROP CONSTRAINT "userGroupUserOrganizations_userGroupId_fkey", 
				ADD CONSTRAINT "userGroupUserOrganizations_userGroupId_fkey" 
					FOREIGN KEY ("userGroupId") REFERENCES "___ORGANIZATION_ID___"."userGroups"(id) 
						ON UPDATE CASCADE
						ON DELETE CASCADE; -- cascaded on delete because column is not nullable

			ALTER TABLE "___ORGANIZATION_ID___"."userOrganizationDeputies"
				DROP CONSTRAINT "userOrganizationDeputies_organizationUnitId_fkey", 
				ADD CONSTRAINT "userOrganizationDeputies_organizationUnitId_fkey" 
					FOREIGN KEY ("organizationUnitId") REFERENCES "___ORGANIZATION_ID___"."organizationUnits"(id) 
						ON UPDATE CASCADE
						ON DELETE SET NULL,
				DROP CONSTRAINT "userOrganizationDeputies_ppermissionId_fkey", 
				ADD CONSTRAINT "userOrganizationDeputies_ppermissionId_fkey" 
					FOREIGN KEY ("ppermissionId") REFERENCES "___ORGANIZATION_ID___"."ppermissions"(id) 
						ON UPDATE CASCADE
						ON DELETE SET NULL;
					
			ALTER TABLE "___ORGANIZATION_ID___"."userOrganizationOrganizationUnits"
				DROP CONSTRAINT "userOrganizationOrganizationUnits_roleId_fkey", 
				ADD CONSTRAINT "userOrganizationOrganizationUnits_roleId_fkey" 
					FOREIGN KEY ("roleId") REFERENCES "___ORGANIZATION_ID___"."roles"(id) 
						ON UPDATE CASCADE
						ON DELETE CASCADE; -- cascaded on delete because column is not nullable

			ALTER TABLE "___ORGANIZATION_ID___"."userRegionTicketUnits"
				DROP CONSTRAINT "userregionticketunits_lastupdateaccesscontrolpointid_foreign", 
				ADD CONSTRAINT "userregionticketunits_lastupdateaccesscontrolpointid_foreign" 
					FOREIGN KEY ("lastUpdateAccessControlPointId") REFERENCES "___ORGANIZATION_ID___"."accessControlPoints"(id) 
						ON UPDATE CASCADE
						ON DELETE SET NULL,
				DROP CONSTRAINT "userregionticketunits_lastupdateuserid_foreign", 
				ADD CONSTRAINT "userregionticketunits_lastupdateuserid_foreign" 
					FOREIGN KEY ("lastUpdateUserId") REFERENCES "___ORGANIZATION_ID___"."users"(id) 
						ON UPDATE CASCADE
						ON DELETE SET NULL;

			ALTER TABLE "___ORGANIZATION_ID___"."visitorRegistrationPoints"
				DROP CONSTRAINT "visitorRegistrationPoints_tabletDeviceId_fkey", 
				ADD CONSTRAINT "visitorRegistrationPoints_tabletDeviceId_fkey" 
					FOREIGN KEY ("tabletDeviceId") REFERENCES "___ORGANIZATION_ID___"."devices"(id) 
						ON UPDATE CASCADE
						ON DELETE SET NULL;

			ALTER TABLE "___ORGANIZATION_ID___"."visitorDailySummaries"
				DROP CONSTRAINT "visitordailysummaries_organizationid_foreign", 
				ADD CONSTRAINT "visitordailysummaries_organizationid_foreign" 
					FOREIGN KEY ("organizationId") REFERENCES "___ORGANIZATION_ID___"."organizations"(id) 
						ON UPDATE CASCADE
						ON DELETE CASCADE, -- cascaded on delete because column is not nullable
				DROP CONSTRAINT "visitordailysummaries_visitorregistrationpointid_foreign", 
				ADD CONSTRAINT "visitordailysummaries_visitorregistrationpointid_foreign" 
					FOREIGN KEY ("visitorRegistrationPointId") REFERENCES "___ORGANIZATION_ID___"."visitorRegistrationPoints"(id) 
						ON UPDATE CASCADE
						ON DELETE CASCADE; -- cascaded on delete because column is not nullable

			ALTER TABLE "___ORGANIZATION_ID___"."ppermissionTypeApprovements"
				DROP CONSTRAINT "ppermissionTypeApprovements_rootOrganizationUnitId_fkey", 
				ADD CONSTRAINT "ppermissionTypeApprovements_rootOrganizationUnitId_fkey" 
					FOREIGN KEY ("rootOrganizationUnitId") REFERENCES "___ORGANIZATION_ID___"."organizationUnits"(id) 
						ON UPDATE CASCADE
						ON DELETE NO ACTION; -- checked at business level, not expected to occur

			ALTER TABLE "___ORGANIZATION_ID___"."userPPermissionApprovements"
				DROP CONSTRAINT "userPPermissionApprovements_organizationUnitId_fkey", 
				ADD CONSTRAINT "userPPermissionApprovements_organizationUnitId_fkey" 
					FOREIGN KEY ("organizationUnitId") REFERENCES "___ORGANIZATION_ID___"."organizationUnits"(id)
						ON UPDATE CASCADE
						ON DELETE NO ACTION; -- checked at business level, not expected to occur

			
			ALTER TABLE "___ORGANIZATION_ID___"."userOrganizations"
				DROP CONSTRAINT "userOrganizations_roleId_fkey", 
				ADD CONSTRAINT "userOrganizations_roleId_fkey" 
					FOREIGN KEY ("roleId") REFERENCES "___ORGANIZATION_ID___"."roles"(id) 
						ON UPDATE CASCADE
						ON DELETE NO ACTION; -- checked at business level, not expected to occur

		`;
        await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, q, "___ORGANIZATION_ID___");
    },
    down: async (client, dbuser, dbsuperuser) => {
        const q = `

			ALTER TABLE "___ORGANIZATION_ID___"."accessControlPoints"
				DROP CONSTRAINT accesscontrolpoints_deviceid_foreign, 
				ADD CONSTRAINT accesscontrolpoints_deviceid_foreign 
					FOREIGN KEY ("deviceId") REFERENCES "___ORGANIZATION_ID___".devices(id);

			ALTER TABLE "___ORGANIZATION_ID___"."cameras"
				DROP CONSTRAINT "cameras_accessControlPointId_fkey", 
				ADD CONSTRAINT "cameras_accessControlPointId_fkey" 
					FOREIGN KEY ("accessControlPointId") REFERENCES "___ORGANIZATION_ID___"."accessControlPoints"(id);

			ALTER TABLE "___ORGANIZATION_ID___"."devices"
				DROP CONSTRAINT "devices_organizationid_foreign", 
				ADD CONSTRAINT "devices_organizationid_foreign" 
					FOREIGN KEY ("organizationId") REFERENCES "___ORGANIZATION_ID___"."organizations"(id);

			ALTER TABLE "___ORGANIZATION_ID___"."organizationActiveVisits"
				DROP CONSTRAINT "organizationActiveVisits_escortUserOrganizationId_fkey", 
				ADD CONSTRAINT "organizationActiveVisits_escortUserOrganizationId_fkey" 
					FOREIGN KEY ("escortUserOrganizationId") REFERENCES "___ORGANIZATION_ID___"."userOrganizations"(id),
				DROP CONSTRAINT "organizationActiveVisits_visitedOrganizationUnitId_fkey", 
				ADD CONSTRAINT "organizationActiveVisits_visitedOrganizationUnitId_fkey" 
					FOREIGN KEY ("visitedOrganizationUnitId") REFERENCES "___ORGANIZATION_ID___"."organizationUnits"(id),
				DROP CONSTRAINT "organizationActiveVisits_visitedUserOrganizationId_fkey", 
				ADD CONSTRAINT "organizationActiveVisits_visitedUserOrganizationId_fkey" 
					FOREIGN KEY ("visitedUserOrganizationId") REFERENCES "___ORGANIZATION_ID___"."userOrganizations"(id);

			ALTER TABLE "___ORGANIZATION_ID___"."organizationUnitDefaultAccessControlPoints"
				DROP CONSTRAINT "organizationUnitDefaultAccessControlP_accessControlPointId_fkey", 
				ADD CONSTRAINT "organizationUnitDefaultAccessControlP_accessControlPointId_fkey" 
					FOREIGN KEY ("accessControlPointId") REFERENCES "___ORGANIZATION_ID___"."accessControlPoints"(id);

			ALTER TABLE "___ORGANIZATION_ID___"."organizationUnits"
				DROP CONSTRAINT "organizationUnits_managerUserOrganizationId_fkey", 
				ADD CONSTRAINT "organizationUnits_managerUserOrganizationId_fkey" 
					FOREIGN KEY ("managerUserOrganizationId") REFERENCES "___ORGANIZATION_ID___"."userOrganizations"(id),
				DROP CONSTRAINT "organizationUnits_organizationId_fkey", 
				ADD CONSTRAINT "organizationUnits_organizationId_fkey" 
					FOREIGN KEY ("organizationId") REFERENCES "___ORGANIZATION_ID___"."organizations"(id);

			ALTER TABLE "___ORGANIZATION_ID___"."organizationVisitorModuleSettings"
				DROP CONSTRAINT "organizationVisitorModuleSettings_organizationId_fkey", 
				ADD CONSTRAINT "organizationVisitorModuleSettings_organizationId_fkey" 
					FOREIGN KEY ("organizationId") REFERENCES "___ORGANIZATION_ID___"."organizations"(id);
			
			ALTER TABLE "___ORGANIZATION_ID___"."organizations"
				DROP CONSTRAINT "organizations_organizationUnitDynamicFormId_fkey", 
				ADD CONSTRAINT "organizations_organizationUnitDynamicFormId_fkey" 
					FOREIGN KEY ("organizationUnitDynamicFormId") REFERENCES "___ORGANIZATION_ID___"."dynamicForms"(id);

			ALTER TABLE "___ORGANIZATION_ID___"."organizationUnits"
				DROP CONSTRAINT "orgunit_type_id_orguserdefinedlistvalues_id", 
				ADD CONSTRAINT "orgunit_type_id_orguserdefinedlistvalues_id" 
					FOREIGN KEY ("typeId") REFERENCES "___ORGANIZATION_ID___"."organizationUserDefinedListValues"(id);
				
			ALTER TABLE "___ORGANIZATION_ID___"."ppermissionClaims"
				DROP CONSTRAINT "ppermissionClaims_organizationId_fkey", 
				ADD CONSTRAINT "ppermissionClaims_organizationId_fkey" 
					FOREIGN KEY ("organizationId") REFERENCES "___ORGANIZATION_ID___"."organizations"(id);
	
			ALTER TABLE "___ORGANIZATION_ID___"."ppermissions"
				DROP CONSTRAINT "ppermissions_organizationId_fkey", 
				ADD CONSTRAINT "ppermissions_organizationId_fkey" 
					FOREIGN KEY ("organizationId") REFERENCES "___ORGANIZATION_ID___"."organizations"(id);
	
			ALTER TABLE "___ORGANIZATION_ID___"."userGroupUserOrganizations"
				DROP CONSTRAINT "userGroupUserOrganizations_userGroupId_fkey", 
				ADD CONSTRAINT "userGroupUserOrganizations_userGroupId_fkey" 
					FOREIGN KEY ("userGroupId") REFERENCES "___ORGANIZATION_ID___"."userGroups"(id);

			ALTER TABLE "___ORGANIZATION_ID___"."userOrganizationDeputies"
				DROP CONSTRAINT "userOrganizationDeputies_organizationUnitId_fkey", 
				ADD CONSTRAINT "userOrganizationDeputies_organizationUnitId_fkey" 
					FOREIGN KEY ("organizationUnitId") REFERENCES "___ORGANIZATION_ID___"."organizationUnits"(id),
				DROP CONSTRAINT "userOrganizationDeputies_ppermissionId_fkey", 
				ADD CONSTRAINT "userOrganizationDeputies_ppermissionId_fkey" 
					FOREIGN KEY ("ppermissionId") REFERENCES "___ORGANIZATION_ID___"."ppermissions"(id);
					
			ALTER TABLE "___ORGANIZATION_ID___"."userOrganizationOrganizationUnits"
				DROP CONSTRAINT "userOrganizationOrganizationUnits_roleId_fkey", 
				ADD CONSTRAINT "userOrganizationOrganizationUnits_roleId_fkey" 
					FOREIGN KEY ("roleId") REFERENCES "___ORGANIZATION_ID___"."roles"(id);

			ALTER TABLE "___ORGANIZATION_ID___"."userOrganizations"
				DROP CONSTRAINT "userOrganizations_roleId_fkey", 
				ADD CONSTRAINT "userOrganizations_roleId_fkey" 
					FOREIGN KEY ("roleId") REFERENCES "___ORGANIZATION_ID___"."roles"(id);

			ALTER TABLE "___ORGANIZATION_ID___"."userRegionTicketUnits"
				DROP CONSTRAINT "userregionticketunits_lastupdateaccesscontrolpointid_foreign", 
				ADD CONSTRAINT "userregionticketunits_lastupdateaccesscontrolpointid_foreign" 
					FOREIGN KEY ("lastUpdateAccessControlPointId") REFERENCES "___ORGANIZATION_ID___"."accessControlPoints"(id),
				DROP CONSTRAINT "userregionticketunits_lastupdateuserid_foreign", 
				ADD CONSTRAINT "userregionticketunits_lastupdateuserid_foreign" 
					FOREIGN KEY ("lastUpdateUserId") REFERENCES "___ORGANIZATION_ID___"."users"(id);

			ALTER TABLE "___ORGANIZATION_ID___"."visitorRegistrationPoints"
				DROP CONSTRAINT "visitorRegistrationPoints_tabletDeviceId_fkey", 
				ADD CONSTRAINT "visitorRegistrationPoints_tabletDeviceId_fkey" 
					FOREIGN KEY ("tabletDeviceId") REFERENCES "___ORGANIZATION_ID___"."devices"(id);

			ALTER TABLE "___ORGANIZATION_ID___"."visitorDailySummaries"
				DROP CONSTRAINT "visitordailysummaries_organizationid_foreign", 
				ADD CONSTRAINT "visitordailysummaries_organizationid_foreign" 
					FOREIGN KEY ("organizationId") REFERENCES "___ORGANIZATION_ID___"."organizations"(id),
				DROP CONSTRAINT "visitordailysummaries_visitorregistrationpointid_foreign", 
				ADD CONSTRAINT "visitordailysummaries_visitorregistrationpointid_foreign" 
					FOREIGN KEY ("visitorRegistrationPointId") REFERENCES "___ORGANIZATION_ID___"."visitorRegistrationPoints"(id);

			ALTER TABLE "___ORGANIZATION_ID___"."ppermissionTypeApprovements"
				DROP CONSTRAINT "ppermissionTypeApprovements_rootOrganizationUnitId_fkey", 
				ADD CONSTRAINT "ppermissionTypeApprovements_rootOrganizationUnitId_fkey" 
					FOREIGN KEY ("rootOrganizationUnitId") REFERENCES "___ORGANIZATION_ID___"."organizationUnits"(id);

			ALTER TABLE "___ORGANIZATION_ID___"."userPPermissionApprovements"
				DROP CONSTRAINT "userPPermissionApprovements_organizationUnitId_fkey", 
				ADD CONSTRAINT "userPPermissionApprovements_organizationUnitId_fkey" 
					FOREIGN KEY ("organizationUnitId") REFERENCES "___ORGANIZATION_ID___"."organizationUnits"(id);
							
	`;
        await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, q, "___ORGANIZATION_ID___");
    },
};
const accessRuleSetTrigger = {
    up: async (client, dbuser, dbsuperuser) => {
        const q = `
			CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".before_up_in_delete_access_rule_sets()
			RETURNS trigger
			LANGUAGE 'plpgsql'
			COST 100
			VOLATILE NOT LEAKPROOF
			AS $BODY$
			DECLARE
				transaction_id	bigint;
				device_id_list  uuid[];
				BEGIN
					transaction_id := txid_current();
					IF (TG_OP = 'DELETE') THEN
						SELECT ARRAY_AGG(DISTINCT(acp."deviceId"))
							FROM "___ORGANIZATION_ID___"."accessControlPoints" AS acp
							INNER JOIN "___ORGANIZATION_ID___"."regionAccessControlPoints" AS racp 
								ON racp."accessControlPointId" =  acp."id"
							WHERE racp."regionId" = OLD."regionId"
								AND acp."deletedAt" IS NULL
								AND acp."organizationId" = OLD."organizationId"
								AND OLD."deletedAt" IS NULL
						INTO device_id_list;
					ELSIF (TG_OP = 'UPDATE') THEN
						SELECT ARRAY_AGG(DISTINCT(acp."deviceId"))
							FROM "___ORGANIZATION_ID___"."accessControlPoints" AS acp
							INNER JOIN "___ORGANIZATION_ID___"."regionAccessControlPoints" AS racp 
								ON racp."accessControlPointId" =  acp."id"
							WHERE (racp."regionId" = NEW."regionId" 
									OR racp."regionId" = OLD."regionId")
								AND acp."deletedAt" IS NULL
								AND acp."organizationId" = NEW."organizationId"
						INTO device_id_list;
					ELSE
						SELECT ARRAY_AGG(DISTINCT(acp."deviceId"))
							FROM "___ORGANIZATION_ID___"."accessControlPoints" AS acp
							INNER JOIN "___ORGANIZATION_ID___"."regionAccessControlPoints" as racp ON racp."accessControlPointId" =  acp."id"
							WHERE racp."regionId" = NEW."regionId"
								AND acp."deletedAt" IS NULL
								AND acp."organizationId" = NEW."organizationId"
						INTO device_id_list;
					END IF;
					INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
						("id", "transactionId", "deviceId", "actionT", "type", "data")
					VALUES(uuid_generate_v4(), transaction_id, UNNEST(device_id_list), now(), 3, '{}'::json);

					IF (TG_OP = 'DELETE') THEN
						RETURN OLD;
					ELSE
						RETURN NEW;
					END IF;

				END;

			$BODY$;

			ALTER FUNCTION "___ORGANIZATION_ID___".before_up_in_delete_access_rule_sets()
			OWNER TO ${dbsuperuser};
			GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_delete_access_rule_sets() TO PUBLIC;
			GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_delete_access_rule_sets() TO ${dbuser};
			GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_delete_access_rule_sets() TO ${dbsuperuser};

		`;
        await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, q, "___ORGANIZATION_ID___");
    },
    down: async (client, dbuser, dbsuperuser) => {
    },
};
const cleanupUnusedDbElements = {
    up: async (client, dbuser, dbsuperuser) => {
        const query = `
			CREATE OR REPLACE VIEW "___ORGANIZATION_ID___"."vW_CredentialUserProfiles"
				AS
				SELECT uoc.id,
					uoc.id AS "credentialId",
					uop.id AS "profileId",
					uoc.data,
					uoc."userId",
					(((uop.name)::text || ' '::text) || (uop.surname)::text) AS "fullName",
					uoc."organizationId",
					uo."roleId"
				FROM "___ORGANIZATION_ID___"."userOrganizationCredentials" uoc
					JOIN "___ORGANIZATION_ID___"."userOrganizations" uo 
						ON uo."userId" = uoc."userId"
							AND uo."organizationId" = uoc."organizationId"
							AND uo."deletedAt" IS NULL 
							AND uoc."deletedAt" IS NULL
					JOIN "___ORGANIZATION_ID___".roles r 
						ON r."organizationId" = uo."organizationId" 
							AND uo."roleId" = r.id 
							AND (
								r."typeId" IS NULL OR
								r."typeId" <> ALL (ARRAY['2a4ad5ff-1ced-45f8-992f-e19fc4e766d7'::uuid, '9b8eebd7-057f-4021-ad6f-f2879733bdb9'::uuid])
							)
					JOIN "___ORGANIZATION_ID___"."userOrganizationProfiles" uop 
					ON uoc."userId" = uop."userId" 
						AND uop."deletedAt" IS NULL 
						AND uoc."deletedAt" IS NULL
				UNION ALL
					SELECT uoc.id,
					uoc.id AS "credentialId",
					ovp.id AS "profileId",
					uoc.data,
					uoc."userId",
					(((ovp.name)::text || ' '::text) || (ovp.surname)::text) AS "fullName",
					uoc."organizationId",
					uo."roleId"
					FROM "___ORGANIZATION_ID___"."userOrganizationCredentials" uoc
						JOIN "___ORGANIZATION_ID___"."userOrganizations" uo 
							ON uo."userId" = uoc."userId" 
								AND uo."organizationId" = uoc."organizationId"
								AND uo."deletedAt" IS NULL
								AND uoc."deletedAt" IS NULL
						JOIN "___ORGANIZATION_ID___".roles r 
							ON r."organizationId" = uo."organizationId" 
								AND uo."roleId" = r.id
								AND r."typeId" = ANY (ARRAY['2a4ad5ff-1ced-45f8-992f-e19fc4e766d7'::uuid, '9b8eebd7-057f-4021-ad6f-f2879733bdb9'::uuid])
						JOIN "___ORGANIZATION_ID___"."organizationVisitorProfiles" ovp 
							ON ovp."userOrganizationId" = uo.id 
							AND ovp."deletedAt" IS NULL 
							AND ovp."deletedAt" IS NULL;
		
			ALTER TABLE "___ORGANIZATION_ID___"."vW_CredentialUserProfiles"
				OWNER TO ${dbsuperuser};

			DROP TABLE IF EXISTS "___ORGANIZATION_ID___"."userOrganizationVisits";
			DROP TABLE IF EXISTS "___ORGANIZATION_ID___"."userOrganizationVisitorProfiles";
			DROP TABLE IF EXISTS "___ORGANIZATION_ID___"."organizationVisitorDefaultAccessControlPoints";
			DROP TABLE IF EXISTS "___ORGANIZATION_ID___"."softwares";
			DROP TABLE IF EXISTS "___ORGANIZATION_ID___"."userOrganizationLeaves";
			DROP TABLE IF EXISTS "___ORGANIZATION_ID___"."workingHoursScheduleUnrestricteds";
			DROP TABLE IF EXISTS "___ORGANIZATION_ID___"."organizationUserSync";
			DROP TABLE IF EXISTS "___ORGANIZATION_ID___"."stickerAccessControlPointMappings";
			DROP TABLE IF EXISTS "___ORGANIZATION_ID___"."attendanceAccessControlPoints";
			
        `;
        await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query, "___ORGANIZATION_ID___");
    },
    down: async (client, dbuser, dbsuperuser) => {
    },
};
