"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const dynamicFormCurrent_1 = require("../../../../lib/es/models/dynamicFormCurrent");
const dal_utils_1 = require("../../../dal.utils");
async function up(client, dbuser, dbsuperuser) {
    const organizations = (await client.query(`SELECT id FROM public."organizationList"`)).rows.map((elem) => elem.id);
    const addingCameraSnapshotCol = `	
	ALTER TABLE "___ORGANIZATION_ID___"."visit_history"
	ADD COLUMN IF NOT EXISTS "cameraSnapshot" bytea;`;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, addingCameraSnapshotCol, "___ORGANIZATION_ID___");
    for (const organizationId of organizations) {
        const organizationVisitorModuleSettings = (await client.query(`
		SELECT settings 
		FROM "${organizationId}"."organizationVisitorModuleSettings"
		`)).rows[0];
        const dynamicSnapshotFieldName = organizationVisitorModuleSettings?.settings.visitFormFields.find((elem) => elem.type === dynamicFormCurrent_1.FormFieldType.ImageCapture)?.name;
        if (dynamicSnapshotFieldName) {
            const updatingCameraSnapshotValue = `
			UPDATE "${organizationId}"."visit_history"
			SET "cameraSnapshot" = (log->'v'->$1->>'data')::bytea
			WHERE "cameraSnapshot" IS NULL;
			`;
            await client.query(updatingCameraSnapshotValue, [dynamicSnapshotFieldName]);
            const removingCameraSnpashotValueFromLog = `
			UPDATE "${organizationId}"."visit_history"
			SET log = log #- '{v,${dynamicSnapshotFieldName}}';
			`;
            await client.query(removingCameraSnpashotValueFromLog);
        }
    }
    await client.query("COMMIT");
    await client.query("BEGIN");
    const creatingLogIndex = `
	CREATE INDEX "visit_history_log_trgm_idx" ON "___ORGANIZATION_ID___"."visit_history"  
	USING GIN ((log::text) gin_trgm_ops);   
	`;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, creatingLogIndex, "___ORGANIZATION_ID___");
    const visitHistoryStartUtcIndex = `
	CREATE INDEX IF NOT EXISTS "visit_history_startUtc_idx" 
	ON "___ORGANIZATION_ID___".visit_history 
	USING btree("startUtc" DESC);
	`;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, visitHistoryStartUtcIndex, "___ORGANIZATION_ID___");
    const activeVisistStartUtcIndex = `
	CREATE INDEX IF NOT EXISTS "organizationActiveVisits_startUtc_idx" 
	ON "___ORGANIZATION_ID___"."organizationActiveVisits" 
	USING btree("startUtc" DESC);
	`;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, activeVisistStartUtcIndex, "___ORGANIZATION_ID___");
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) {
    const organizations = (await client.query(`SELECT id FROM public."organizationList"`)).rows.map((elem) => elem.id);
    const dropLogIndex = `
	DROP INDEX "___ORGANIZATION_ID___"."visit_history_log_trgm_idx";
	`;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, dropLogIndex, "___ORGANIZATION_ID___");
    const dropVisitHistoryStartUtcIndex = `
	DROP INDEX "___ORGANIZATION_ID___"."visit_history_startUtc_idx";
	`;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, dropVisitHistoryStartUtcIndex, "___ORGANIZATION_ID___");
    const dropActiveVisistStartUtcIndex = `
	DROP INDEX "___ORGANIZATION_ID___"."organizationActiveVisits_startUtc_idx";
	`;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, dropActiveVisistStartUtcIndex, "___ORGANIZATION_ID___");
    await client.query("COMMIT");
    for (const organizationId of organizations) {
        const organizationVisitorModuleSettings = (await client.query(`
			SELECT settings 
			FROM "${organizationId}"."organizationVisitorModuleSettings"
		`)).rows[0];
        await client.query("BEGIN");
        const dynamicSnapshotFieldName = organizationVisitorModuleSettings.settings.visitFormFields.find((elem) => elem.type === dynamicFormCurrent_1.FormFieldType.ImageCapture)?.name;
        if (dynamicSnapshotFieldName) {
            const addingCameraSnpashotValueIntoLog = `
			UPDATE "${organizationId}"."visit_history"
			SET log = jsonb_set(log,'{v,${dynamicSnapshotFieldName}}',('{"data":' ||'"' || convert_from("cameraSnapshot",'UTF8') || '"' || '}')::jsonb)
			WHERE "cameraSnapshot" IS NOT NULL;
			`;
            await client.query(addingCameraSnpashotValueIntoLog);
        }
    }
    const dropCameraSnapshotCol = `	
	ALTER TABLE "___ORGANIZATION_ID___"."visit_history"
	DROP COLUMN "cameraSnapshot";`;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, dropCameraSnapshotCol, "___ORGANIZATION_ID___");
}
exports.down = down;
