"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const dal_utils_1 = require("../../../dal.utils");
async function up(client, dbuser, dbsuperuser) {
    const query = `
		CREATE OR REPLACE FUNCTION "__ORGANIZATION_ID__".before_up_in_del_camera()
		RETURNS trigger
		LANGUAGE 'plpgsql'
		COST 100
		VOLATILE NOT LEAKPROOF
	AS $BODY$
		BEGIN
			INSERT INTO "__ORGANIZATION_ID__"."terminalChanges"
			("id", "transactionId", "deviceId", "actionT", "type", "data")
			SELECT uuid_generate_v4(), txid_current(), acp."deviceId", now(), 3, '{}'::json
			FROM "__ORGANIZATION_ID__"."cameraActions" AS ca 
			INNER JOIN "__ORGANIZATION_ID__"."accessControlPoints" AS acp 
				ON ca."accessControlPointId" = acp."id" 
				AND acp."deletedAt" IS NULL
			WHERE ca."cameraId" = COALESCE(NEW.id, OLD.id);

			INSERT INTO "__ORGANIZATION_ID__"."terminalChanges"
			("id", "transactionId", "deviceId", "actionT", "type", "data")
			SELECT uuid_generate_v4(), txid_current(), COALESCE(NEW."proxyTerminalId", OLD."proxyTerminalId") , now(), 3, '{}'::json;
			
			RETURN COALESCE(NEW, OLD);
		END;
	$BODY$;


		CREATE OR REPLACE FUNCTION "__ORGANIZATION_ID__".before_up_in_del_camera_actions()
		RETURNS trigger
		LANGUAGE 'plpgsql'
		COST 100
		VOLATILE NOT LEAKPROOF
	AS $BODY$
		BEGIN
			INSERT INTO "__ORGANIZATION_ID__"."terminalChanges"
			("id", "transactionId", "deviceId", "actionT", "type", "data")
			SELECT uuid_generate_v4(), txid_current(), "deviceId", now(), 3, '{}'::json
			FROM "__ORGANIZATION_ID__"."accessControlPoints"
			WHERE id = COALESCE(NEW."accessControlPointId", OLD."accessControlPointId")
			AND "deletedAt" IS NULL;

			RETURN COALESCE(NEW, OLD);
		END;
	$BODY$;
	`;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query, "__ORGANIZATION_ID__");
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) {
    const query = `
		CREATE OR REPLACE FUNCTION "__ORGANIZATION_ID__".before_up_in_del_camera()
		RETURNS trigger
		LANGUAGE 'plpgsql'
		COST 100
		VOLATILE NOT LEAKPROOF
		AS $BODY$
		DECLARE
			transaction_id	bigint;
			camera_id 		uuid;
			proxy_terminal_id 		uuid;
		BEGIN
			transaction_id := txid_current();
			IF (TG_OP = 'DELETE') THEN
				camera_id:= OLD."id";
				proxy_terminal_id:= OLD."proxyTerminalId";
			ELSE
				camera_id:= NEW."id";
				proxy_terminal_id:= NEW."proxyTerminalId";
			END IF;
			INSERT INTO "__ORGANIZATION_ID__"."terminalChanges"
			("id", "transactionId", "deviceId", "actionT", "type", "data")
			SELECT uuid_generate_v4(), transaction_id, acp."deviceId", now(), 3, '{}'::json
			FROM "__ORGANIZATION_ID__"."cameras" AS c
			INNER JOIN "__ORGANIZATION_ID__"."cameraActions" AS ca ON c."id" = ca."cameraId" AND c."deletedAt" IS NULL AND c."id" = camera_id
			INNER JOIN "__ORGANIZATION_ID__"."accessControlPoints" AS acp ON ca."accessControlPointId" = acp."id" AND acp."deletedAt" IS NULL;

			INSERT INTO "__ORGANIZATION_ID__"."terminalChanges"
			("id", "transactionId", "deviceId", "actionT", "type", "data")
			SELECT uuid_generate_v4(), transaction_id, proxy_terminal_id, now(), 3, '{}'::json;
			IF (TG_OP = 'DELETE') THEN
				RETURN OLD;
			ELSE
				RETURN NEW;
			END IF;

		END;
		$BODY$;

		CREATE OR REPLACE FUNCTION "__ORGANIZATION_ID__".before_up_in_del_camera_actions()
		RETURNS trigger
		LANGUAGE 'plpgsql'
		COST 100
		VOLATILE NOT LEAKPROOF
		AS $BODY$
		DECLARE
			transaction_id	bigint;
			camera_id 		uuid;
		BEGIN
			transaction_id := txid_current();
			IF (TG_OP = 'DELETE') THEN
				camera_id:= OLD."cameraId";
			ELSE
				camera_id:= NEW."cameraId";
			END IF;
			INSERT INTO "__ORGANIZATION_ID__"."terminalChanges"
			("id", "transactionId", "deviceId", "actionT", "type", "data")
			SELECT uuid_generate_v4(), transaction_id, acp."deviceId", now(), 3, '{}'::json
			FROM "__ORGANIZATION_ID__"."cameras" AS c
			INNER JOIN "__ORGANIZATION_ID__"."cameraActions" AS ca ON c."id" = ca."cameraId" AND c."deletedAt" IS NULL AND c."id" = camera_id
			INNER JOIN "__ORGANIZATION_ID__"."accessControlPoints" AS acp ON ca."accessControlPointId" = acp."id" AND acp."deletedAt" IS NULL;

			IF (TG_OP = 'DELETE') THEN
				RETURN OLD;
			ELSE
				RETURN NEW;
			END IF;
		END;	
		$BODY$;		
	`;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query, "__ORGANIZATION_ID__");
}
exports.down = down;
