"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const app_logs_1 = require("../../../../app.logs");
const dal_utils_1 = require("../../../dal.utils");
async function up(client, dbuser, dbsuperuser) {
    const query = `
			CREATE OR REPLACE FUNCTION "__ORGANIZATION_ID__".zz_notification_instance()
		RETURNS trigger
		LANGUAGE 'plpgsql'
		COST 100
		VOLATILE NOT LEAKPROOF
		AS $BODY$
				DECLARE
					_now timestamp without time zone;
				BEGIN   
					_now := now();
					IF (TG_OP = 'INSERT' AND NOT EXISTS (SELECT id FROM "__ORGANIZATION_ID__".zz_notification_instance WHERE id = NEW.id)) THEN
						INSERT INTO "__ORGANIZATION_ID__".zz_notification_instance (
							id, action, "actionT", "transactionId", "createdT", "mediumGroupId", medium, "notificationId", "receiverUserId", content, "eventId")
						VALUES(NEW.id, 1, _now, txid_current(), NEW."createdT", NEW."mediumGroupId", NEW.medium, NEW."notificationId", NEW."receiverUserId", NEW.content, NEW."eventId");
					
						INSERT INTO "__ORGANIZATION_ID__".zz_notification_instance_state(
							id, action, "actionT", "transactionId", state, note)
						VALUES (NEW.id, 1, _now, txid_current(), NEW.state, NEW.note);

					ELSIF (TG_OP = 'UPDATE') THEN
					
						IF (
							NEW.id IS DISTINCT FROM OLD.id OR
							NEW."createdT" IS DISTINCT FROM OLD."createdT" OR
							NEW."mediumGroupId" IS DISTINCT FROM OLD."mediumGroupId" OR
							NEW.medium IS DISTINCT FROM OLD.medium OR
							NEW."notificationId" IS DISTINCT FROM OLD."notificationId" OR
							NEW."receiverUserId" IS DISTINCT FROM OLD."receiverUserId" OR
							NEW.content::text IS DISTINCT FROM OLD.content::text OR
							NEW."eventId" IS DISTINCT FROM OLD."eventId"
						) THEN
							INSERT INTO "__ORGANIZATION_ID__".zz_notification_instance(
								id,action,"actionT","transactionId","createdT","mediumGroupId",medium,"notificationId","receiverUserId",content,"eventId")
							VALUES( NEW.id,2,_now,txid_current(),NEW."createdT",NEW."mediumGroupId",NEW.medium,NEW."notificationId",NEW."receiverUserId",NEW.content,NEW."eventId");
						END IF;
						
						IF (NEW.state IS DISTINCT FROM OLD.state) THEN
							INSERT INTO "__ORGANIZATION_ID__".zz_notification_instance_state (
								id, action, "actionT", "transactionId", state, note)
							VALUES (NEW.id, 2, _now, txid_current(), NEW.state, NEW.note);       
						END IF;   
					ELSIF (TG_OP = 'DELETE') THEN
						INSERT INTO "__ORGANIZATION_ID__".zz_notification_instance( 
							id,action,"actionT","transactionId","createdT","mediumGroupId",medium,"notificationId","receiverUserId",content,"eventId")
						VALUES(OLD.id, 3, _now, txid_current(), OLD."createdT", OLD."mediumGroupId", OLD.medium, OLD."notificationId", OLD."receiverUserId", OLD.content, OLD."eventId");
						
						INSERT INTO "__ORGANIZATION_ID__".zz_notification_instance_state (
							id, action, "actionT", "transactionId", state, note)
						VALUES ( OLD.id, 3, _now, txid_current(), OLD.state, OLD.note);     
						
					END IF;    
					RETURN NULL;
					END;			
		$BODY$;

		CREATE OR REPLACE FUNCTION "__ORGANIZATION_ID__".zz_notification()
		RETURNS trigger
		LANGUAGE 'plpgsql'
		COST 100
		VOLATILE NOT LEAKPROOF
		AS $BODY$
		DECLARE
			_now timestamp without time zone;
		BEGIN
			_now:= now();
			IF(TG_OP = 'INSERT' AND NOT EXISTS (SELECT id FROM "__ORGANIZATION_ID__".zz_notification WHERE id = NEW.id)) THEN
				INSERT INTO "__ORGANIZATION_ID__".zz_notification
					(
						id,
						action,
						"actionT",
						"transactionId",
						"createdT",
						type,
						"createdByUserId",
						"receiverFilterId",
						"settings",
						email,
						sms,
						web,
						"pushNotification"
					)
					VALUES(
						NEW.id,
						1,
						_now,
						txid_current(),
						NEW."createdT",
						NEW.type,
						NEW."createdByUserId",
						NEW."receiverFilterId",
						NEW."settings",
						NEW.email,
						NEW.sms,
						NEW.web,
						NEW."pushNotification"
					);
			ELSIF(TG_OP = 'UPDATE' AND (
				NEW.id IS DISTINCT FROM OLD.id OR
				NEW."createdT" IS DISTINCT FROM OLD."createdT" OR
				NEW."createdByUserId" IS DISTINCT FROM OLD."createdByUserId" OR
				NEW.type IS DISTINCT FROM OLD.type OR
				NEW."receiverFilterId" IS DISTINCT FROM OLD."receiverFilterId" OR
				NEW.settings::text IS DISTINCT FROM OLD.settings::text OR
				NEW.email IS DISTINCT FROM OLD.email OR
				NEW.sms IS DISTINCT FROM OLD.sms OR
				NEW.web IS DISTINCT FROM OLD.web OR
				NEW."pushNotification" IS DISTINCT FROM OLD."pushNotification"
			)) THEN
				INSERT INTO "__ORGANIZATION_ID__".zz_notification
					(
						id,
						action,
						"actionT",
						"transactionId",
						"createdT",
						type,
						"createdByUserId",
						"receiverFilterId",
						"settings",
						email,
						sms,
						web,
						"pushNotification"
					)
					VALUES(
						NEW.id,
						2,
						_now,
						txid_current(),
						NEW."createdT",
						NEW.type,
						NEW."createdByUserId",
						NEW."receiverFilterId",
						NEW."settings",
						NEW.email,
						NEW.sms,
						NEW.web,
						NEW."pushNotification"
					);
			ELSIF(TG_OP = 'DELETE') THEN
				INSERT INTO "__ORGANIZATION_ID__".zz_notification
					(
						id,
						action,
						"actionT",
						"transactionId",
						"createdT",
						type,
						"createdByUserId",
						"receiverFilterId",
						"settings",
						email,
						sms,
						web,
						"pushNotification"
					)
					VALUES(
						OLD.id,
						3,
						_now,
						txid_current(),
						OLD."createdT",
						OLD.type,
						OLD."createdByUserId",
						OLD."receiverFilterId",
						OLD."settings",
						OLD.email,
						OLD.sms,
						OLD.web,
						OLD."pushNotification"
					);
			END IF;
			RETURN NULL;
		END;
		$BODY$;
	`;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query, "__ORGANIZATION_ID__");
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) {
    app_logs_1.logger.info("migrate down to 20210102");
}
exports.down = down;
