"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
async function up(client, dbuser, dbsuperuser) {
    const organizationIds = (await client.query(`SELECT id FROM public."organizationList"`)).rows.map((row) => row.id);
    for (const organizationId of organizationIds) {
        await client.query(`
			DELETE FROM "${organizationId}"."notification_unsubscribe" nu1
				  USING "${organizationId}"."notification_unsubscribe" nu2
			WHERE nu1.ctid > nu2.ctid
			AND nu1."userId" = nu2."userId"
			AND nu1.type IS NOT DISTINCT FROM nu2.type`);
    }
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) {
}
exports.down = down;
