"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const dal_utils_1 = require("../../../dal.utils");
async function up(client, dbuser, dbsuperuser) {
    await deviceDryContactInputsDeviceRelayCustomFK.up(client, dbuser, dbsuperuser);
    await createAfterInsertZZNotificationInstanceStateDefaultTrigger.up(client, dbuser, dbsuperuser);
    await updateSmtpSettingsEnabled.up(client, dbuser, dbsuperuser);
    await registrationPointAndOrganizationUnitRelation.up(client, dbuser, dbsuperuser);
    await fixOrganizationUnitsAncestorIds.up(client, dbuser, dbsuperuser);
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) {
    await fixOrganizationUnitsAncestorIds.down(client, dbuser, dbsuperuser);
    await registrationPointAndOrganizationUnitRelation.down(client, dbuser, dbsuperuser);
    await updateSmtpSettingsEnabled.down(client, dbuser, dbsuperuser);
    await createAfterInsertZZNotificationInstanceStateDefaultTrigger.down(client, dbuser, dbsuperuser);
    await deviceDryContactInputsDeviceRelayCustomFK.down(client, dbuser, dbsuperuser);
}
exports.down = down;
const deviceDryContactInputsDeviceRelayCustomFK = {
    up: async (client, dbuser, dbsuperuser) => {
        const q = `
	CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".device_relay_id_fk()
		RETURNS trigger
		LANGUAGE 'plpgsql'
		COST 100
		VOLATILE NOT LEAKPROOF
	AS $BODY$
		BEGIN
			IF (TG_OP = 'DELETE' OR (TG_OP = 'UPDATE' AND OLD."deletedAt" IS NULL AND NEW."deletedAt" IS NOT NULL)) THEN
				UPDATE "___ORGANIZATION_ID___"."deviceDryContactInputs"
				SET "accessControlPointId" = NULL,
					"type" = 0, -- not configured dry contact input
					"settings" = NULL
				WHERE settings->'relayId' IS NOT NULL AND 
					settings->>'relayId' != '' AND 
					(settings ->> 'relayId')::uuid = OLD.id;
			ELSIF (TG_OP = 'UPDATE' AND NEW.id != OLD.id) THEN
				UPDATE "___ORGANIZATION_ID___"."deviceDryContactInputs"
				SET settings = (settings::jsonb) || jsonb_build_object('relayId', NEW.id)
				WHERE 
					settings->'relayId' IS NOT NULL AND 
					settings->>'relayId' != '' AND 
					(settings ->> 'relayId')::uuid = OLD.id;
			END IF;
			RETURN NULL;
		END;
	$BODY$;

	ALTER FUNCTION "___ORGANIZATION_ID___".device_relay_id_fk()
		OWNER TO ${dbsuperuser};

	GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".device_relay_id_fk() TO ${dbsuperuser};

	GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".device_relay_id_fk() TO PUBLIC;

	GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".device_relay_id_fk() TO ${dbuser};
		`;
        await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, q, "___ORGANIZATION_ID___");
    },
    down: async (client, dbuser, dbsuperuser) => {
        const q = `
	CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".device_relay_id_fk()
		RETURNS trigger
		LANGUAGE 'plpgsql'
		COST 100
		VOLATILE NOT LEAKPROOF
	AS $BODY$
		BEGIN
			IF (TG_OP = 'DELETE' OR (TG_OP = 'UPDATE' AND (OLD."deletedAt" IS NULL AND NEW."deletedAt" IS NOT NULL))) THEN
				DELETE FROM "___ORGANIZATION_ID___"."deviceDryContactInputs"
				WHERE (settings ->> 'relayId')::uuid = OLD.id;
			ELSIF (TG_OP = 'UPDATE' AND NEW.id != OLD.id) THEN
				UPDATE "___ORGANIZATION_ID___"."deviceDryContactInputs"
				SET settings = (settings::jsonb - 'relayId') || jsonb_build_object('relayId', NEW.id)
				WHERE (settings ->> 'relayId')::uuid = OLD.id;
			END IF;
			RETURN NULL;
		END;
	$BODY$;
	
	ALTER FUNCTION "___ORGANIZATION_ID___".device_relay_id_fk()
		OWNER TO ${dbsuperuser};
	
	GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".device_relay_id_fk() TO ${dbsuperuser};
	
	GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".device_relay_id_fk() TO PUBLIC;
	
	GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".device_relay_id_fk() TO ${dbuser};
	`;
        await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, q, "___ORGANIZATION_ID___");
    },
};
const createAfterInsertZZNotificationInstanceStateDefaultTrigger = {
    up: async (client, dbuser, dbsuperuser) => {
        const query = `
        CREATE TRIGGER after_insert_zz_notification_instance_state_default 
        AFTER INSERT 
            ON "___ORGANIZATION_ID___".zz_notification_instance_state_default
        FOR EACH ROW 
            EXECUTE FUNCTION public.after_insert_default();`;
        await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query, "___ORGANIZATION_ID___");
    },
    down: async (client, dbuser, dbsuperuser) => {
        const query = `
        DROP TRIGGER IF EXISTS after_insert_zz_notification_instance_state_default  
            ON "___ORGANIZATION_ID___".zz_notification_instance_state_default`;
        await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query, "___ORGANIZATION_ID___");
    },
};
const registrationPointAndOrganizationUnitRelation = {
    up: async (client, dbuser, dbsuperuser) => {
        const query = `
            ALTER TABLE "___ORGANIZATION_ID___"."visitorRegistrationPoints"
            ADD COLUMN "organizationUnitId" uuid;

            ALTER TABLE "___ORGANIZATION_ID___"."visitorRegistrationPoints"
            ADD CONSTRAINT "organization_unit_id_fkey" 
                FOREIGN KEY ("organizationUnitId")
                REFERENCES "___ORGANIZATION_ID___"."organizationUnits" (id)
                ON UPDATE CASCADE
                ON DELETE SET NULL;
        `;
        await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query, "___ORGANIZATION_ID___");
    },
    down: async (client, dbuser, dbsuperuser) => {
        const query = `
            ALTER TABLE "___ORGANIZATION_ID___"."visitorRegistrationPoints"
            DROP CONSTRAINT IF EXISTS "organization_unit_id_fkey";

            ALTER TABLE "___ORGANIZATION_ID___"."visitorRegistrationPoints"
            DROP COLUMN "organizationUnitId";
        `;
        await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query, "___ORGANIZATION_ID___");
    },
};
const updateSmtpSettingsEnabled = {
    up: async (client, dbuser, dbsuperuser) => {
        const organizationIds = (await client.query(`SELECT id FROM "public"."organizationList"`)).rows.map((row) => row.id);
        for (const organizationId of organizationIds) {
            const smtpSettings = (await client.query(`SELECT settings->'notification'->'smtpSettings' FROM "${organizationId}"."organizations"`)).rows[0];
            if (smtpSettings) {
                await client.query(`UPDATE "${organizationId}"."organizations"
                                SET settings = jsonb_set(settings, '{notification, smtpSettings, enabled}', 'true')`);
            }
        }
    },
    down: async (client, dbuser, dbsuperuser) => {
        const organizationIds = (await client.query(`SELECT id FROM "public"."organizationList"`)).rows.map((row) => row.id);
        for (const organizationId of organizationIds) {
            const smtpSettings = (await client.query(`SELECT settings->'notification'->'smtpSettings' FROM "${organizationId}"."organizations"`)).rows[0];
            if (smtpSettings) {
                await client.query(`UPDATE "${organizationId}"."organizations"
                                SET settings = settings #- '{notification,smtpSettings,enabled}'`);
            }
        }
    },
};
const fixOrganizationUnitsAncestorIds = {
    up: async (client, dbuser, dbsuperuser) => {
        const query = `
            DROP TABLE IF EXISTS "firstLevelOrganizationUnits";

            CREATE TEMPORARY TABLE "firstLevelOrganizationUnits"
            ON COMMIT DROP
            AS (SELECT ou.id as parent, ou2."id" as child
                FROM "___ORGANIZATION_ID___"."organizationUnits" AS ou
                CROSS JOIN "___ORGANIZATION_ID___"."organizationUnits" AS ou2
                WHERE ou."deletedAt" IS NULL 
                    AND ou."parentId" IS NULL
                    AND ou2."deletedAt" IS NULL
                    AND ou."id" = ou2."parentId");
                
            UPDATE "___ORGANIZATION_ID___"."organizationUnits" AS ou
            SET "parentId" = NULL
            FROM "firstLevelOrganizationUnits" as flou
            WHERE ou."id" = flou."child";

            UPDATE "___ORGANIZATION_ID___"."organizationUnits" AS ou
            SET "parentId" = flou."parent"
            FROM "firstLevelOrganizationUnits" as flou
            WHERE ou."parentId" IS NULL 
            AND ou."id" = flou."child";
        `;
        await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query, "___ORGANIZATION_ID___");
    },
    down: async (client, dbuser, dbsuperuser) => { },
};
