"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const dal_utils_1 = require("../../../dal.utils");
const dal_db_armon_schema_1 = require("../../armon/dal.db.armon.schema");
async function up(client, dbuser, dbsuperuser) {
    await updateVisitorDailySummaries.up(client);
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) {
    await updateVisitorDailySummaries.down(client);
}
exports.down = down;
const updateVisitorDailySummaries = {
    up: async (client) => {
        const visitorDailySummaryUpdateQuery = `
			DROP TABLE IF EXISTS "recalculatedVisitorDailySummaries";

			CREATE TEMPORARY TABLE "recalculatedVisitorDailySummaries"
			ON COMMIT DROP
			AS (SELECT date_trunc('day', vh."startUtc") as "date",
					vh."organizationId",
					vh."visitorRegistrationPointId" as "visitorRegistrationPointId",
					(vh."log"->'v'->>'reason')::decimal as "reason",
					COUNT(*) as count
				FROM "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.VisitHistory}" as vh
				GROUP BY ("date", vh."organizationId", vh."visitorRegistrationPointId", "reason"));
					
			--- Faster than a subquery
			UPDATE "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.visitorDailySummaries}" as vds
			SET count = CASE 
							WHEN rvds.count IS NOT NULL 
							THEN rvds.count::int
							ELSE 0
						END
			FROM  "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.visitorDailySummaries}" as vds1
			LEFT JOIN "recalculatedVisitorDailySummaries" as rvds
			ON vds1."date" = rvds."date" AND
				vds1."organizationId" = rvds."organizationId" AND
				vds1."visitorRegistrationPointId" = rvds."visitorRegistrationPointId" AND
				vds1."reason" = rvds."reason"
			WHERE vds.id = vds1.id;
					
			--- Delete records if it is not in the temporary table, namely, there is no visit for that record in the new logic
			--- For example; a record (16.02.2023, <uuid>, 1) as (date, visitorRegistrationId, reason) should be deleted if that one record is shifted to 15.02.2023 by new logic
			DELETE
			FROM "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.visitorDailySummaries}" as vds
			WHERE vds.count = 0;
			
			--- Insert records if it is not exist in the table before but calculated via new logic
			INSERT INTO "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.visitorDailySummaries}"(
				id, "organizationId", "visitorRegistrationPointId", reason, count, date, "averageProcessTime")
				SELECT gen_random_uuid(), 
					rvds."organizationId", 
					rvds."visitorRegistrationPointId", 
					rvds."reason", 
					rvds.count, 
					rvds."date", 
					(SELECT AVG("averageProcessTime") FROM "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.visitorDailySummaries}") as "averageProcessTime"
					FROM "recalculatedVisitorDailySummaries" as rvds 
					WHERE (rvds.date,rvds."visitorRegistrationPointId",rvds."reason") NOT IN (SELECT date,"visitorRegistrationPointId",reason FROM "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.visitorDailySummaries}");
		`;
        await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, visitorDailySummaryUpdateQuery, "___ORGANIZATION_ID___");
        const alterDateColumOfVisitorDailySummary = `
			ALTER TABLE "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.visitorDailySummaries}"
			ALTER COLUMN date TYPE date;
		`;
        await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, alterDateColumOfVisitorDailySummary, "___ORGANIZATION_ID___");
        const visitorDailySummariesUniqueness = `
			ALTER TABLE "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.visitorDailySummaries}"
			DROP CONSTRAINT IF EXISTS "date_reasons_visitorRegistrationPointId_uniqueness";

			ALTER TABLE "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.visitorDailySummaries}"
			ADD CONSTRAINT "date_reasons_visitorRegistrationPointId_uniqueness" UNIQUE("visitorRegistrationPointId", reason, date);
		`;
        await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, visitorDailySummariesUniqueness, "___ORGANIZATION_ID___");
        const preregistrationDailySummaryUpdateQuery = `
			DROP TABLE IF EXISTS "recalculatedPreregistrationDailySummaries";

			CREATE TEMPORARY TABLE "recalculatedPreregistrationDailySummaries"
			ON COMMIT DROP
			AS (SELECT date_trunc('day', date(vph.log->>'u')) as "date",
						vph."organizationId",
						SUM( CASE 
								WHEN vph.log->'v'->'visitedPerson'->>'userId' = vph.log->>'r'
								THEN 1
								ELSE 0
							END ) as "selfPreregisterCount",
						COUNT(*) as "totalCount",
						SUM(CASE 
								WHEN vh.id IS NOT NULL
								THEN 1
								ELSE 0
							END ) as "totalToVisitCount",
						SUM( CASE 
								WHEN (vh.id IS NOT NULL) AND (vph.log->'v'->'visitedPerson'->>'userId' = vph.log->>'r')
								THEN 1
								ELSE 0
							END ) as "selfToVisitCount"
				FROM "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.VisitorPreregistrationHistory}" as vph
				LEFT JOIN "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.VisitHistory}" as vh
					ON vh.log->>'id' = vph.log->>'vid'
				GROUP BY ("date", vph."organizationId"));
				
			
			UPDATE "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.preregisterDailySummaries}" as pds
				SET "selfPreregisterCount" = rpds."selfPreregisterCount",
					"totalCount" = rpds."totalCount",
					"totaltoVisitCount" = rpds."totalToVisitCount",
					"selftoVisitCount" = rpds."selfToVisitCount"
				FROM "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.preregisterDailySummaries}" as pds1
				LEFT JOIN "recalculatedPreregistrationDailySummaries" as rpds
					ON pds1.date = rpds.date
				WHERE pds1.id = pds.id;

			--- Delete records if it is not in the temporary table, namely, there is no preregistration for that date in the new logic
			--- For example; a preregistration can be count to 15.06.2023 by its endDate, but in the new logic, it should be count according to its startDate
			--- If the only record for 15.06.2023 is shifted to 14.06.2023, then the record for the date 15.06.2023 should be empty and should be deleted.
			DELETE
			FROM "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.preregisterDailySummaries}" as pds
			WHERE pds."totalCount" IS NULL;
			
			INSERT INTO "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.preregisterDailySummaries}"(
				id, "organizationId", "selfPreregisterCount", "totalCount", "totaltoVisitCount", "selftoVisitCount", date)
				SELECT gen_random_uuid(), 
					rpds."organizationId", 
					rpds."selfPreregisterCount", 
					rpds."totalCount", 
					rpds."totalToVisitCount", 
					rpds."selfToVisitCount", 
					rpds.date
					FROM "recalculatedPreregistrationDailySummaries" as rpds 
					WHERE rpds.date NOT IN (SELECT date FROM "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.preregisterDailySummaries}");
		`;
        await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, preregistrationDailySummaryUpdateQuery, "___ORGANIZATION_ID___");
        const alterDateColumOfpreregisterDailySummary = `
			ALTER TABLE "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.preregisterDailySummaries}"
			ALTER COLUMN date TYPE date;
		`;
        await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, alterDateColumOfpreregisterDailySummary, "___ORGANIZATION_ID___");
        const preregisterDailySummariesDateUniqueness = `
			ALTER TABLE "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.preregisterDailySummaries}"
			DROP CONSTRAINT IF EXISTS date_uniqueness;

			ALTER TABLE "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.preregisterDailySummaries}"
			ADD CONSTRAINT date_uniqueness UNIQUE(date);
		`;
        await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, preregisterDailySummariesDateUniqueness, "___ORGANIZATION_ID___");
    },
    down: async (client) => {
        const alterDailySummariesTables = `
			ALTER TABLE "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.visitorDailySummaries}"
			ALTER COLUMN date TYPE timestamp with time zone;


			ALTER TABLE "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.preregisterDailySummaries}"
			ALTER COLUMN date TYPE timestamp with time zone;
		`;
        await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, alterDailySummariesTables, "___ORGANIZATION_ID___");
    },
};
