"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const dal_utils_1 = require("../../../dal.utils");
async function up(client, dbuser, dbsuperuser) {
    let query = `
        CREATE OR REPLACE VIEW "___ORGANIZATION_ID___"."vW_CredentialUserProfiles" AS
        SELECT uoc.id,
            uoc.id AS "credentialId",
            uop.id AS "profileId",
            uoc.data,
            uoc."userId",
            (((uop.name)::text || ' '::text) || (uop.surname)::text) AS "fullName",
            uoc."organizationId",
            uo."roleId"
        FROM "___ORGANIZATION_ID___"."userOrganizationCredentials" uoc
            JOIN "___ORGANIZATION_ID___"."userOrganizations" uo 
                ON uo."userId" = uoc."userId"
                    AND uo."organizationId" = uoc."organizationId"
                    AND uo."deletedAt" IS NULL 
                    AND uoc."deletedAt" IS NULL
            JOIN "___ORGANIZATION_ID___".roles r 
                ON r."organizationId" = uo."organizationId" 
                    AND uo."roleId" = r.id 
                    AND (
                        r."typeId" IS NULL OR
                        r."typeId" <> ALL (ARRAY['2a4ad5ff-1ced-45f8-992f-e19fc4e766d7'::uuid, '9b8eebd7-057f-4021-ad6f-f2879733bdb9'::uuid])
                    
                    )
            JOIN "___ORGANIZATION_ID___"."userOrganizationProfiles" uop 
            ON uoc."userId" = uop."userId" 
                AND uop."deletedAt" IS NULL 
                AND uoc."deletedAt" IS NULL
        UNION ALL
            SELECT uoc.id,
            uoc.id AS "credentialId",
            uovp.id AS "profileId",
            uoc.data,
            uoc."userId",
            (((uovp.name)::text || ' '::text) || (uovp.surname)::text) AS "fullName",
            uoc."organizationId",
            uo."roleId"
            FROM "___ORGANIZATION_ID___"."userOrganizationCredentials" uoc
                JOIN "___ORGANIZATION_ID___"."userOrganizations" uo 
                    ON uo."userId" = uoc."userId" 
                        AND uo."organizationId" = uoc."organizationId"
                        AND uo."deletedAt" IS NULL
                        AND uoc."deletedAt" IS NULL
                JOIN "___ORGANIZATION_ID___".roles r 
                    ON r."organizationId" = uo."organizationId" 
                        AND uo."roleId" = r.id
                        AND r."typeId" = ANY (ARRAY['2a4ad5ff-1ced-45f8-992f-e19fc4e766d7'::uuid, '9b8eebd7-057f-4021-ad6f-f2879733bdb9'::uuid])
                JOIN "___ORGANIZATION_ID___"."userOrganizationVisitorProfiles" uovp 
                    ON uovp."userOrganizationId" = uo.id 
                    AND uovp."deletedAt" IS NULL 
                    AND uovp."deletedAt" IS NULL;
        
    
    ALTER TABLE "___ORGANIZATION_ID___"."vW_CredentialUserProfiles" OWNER TO ${dbsuperuser};
    `;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query, "___ORGANIZATION_ID___");
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) {
    let query = `
        CREATE OR REPLACE VIEW "___ORGANIZATION_ID___"."vW_CredentialUserProfiles" AS
        SELECT uoc.id,
            uoc.id AS "credentialId",
            uop.id AS "profileId",
            uoc.data,
            uoc."userId",
            (((uop.name)::text || ' '::text) || (uop.surname)::text) AS "fullName",
            uoc."organizationId",
            uo."roleId"
        FROM "___ORGANIZATION_ID___"."userOrganizationCredentials" uoc
            JOIN "___ORGANIZATION_ID___"."userOrganizations" uo 
                ON uo."userId" = uoc."userId"
                    AND uo."organizationId" = uoc."organizationId"
                    AND uo."deletedAt" IS NULL 
                    AND uoc."deletedAt" IS NULL
            JOIN "___ORGANIZATION_ID___".roles r 
                ON r."organizationId" = uo."organizationId" 
                    AND uo."roleId" = r.id 
                    AND r."typeId" <> ALL (ARRAY['2a4ad5ff-1ced-45f8-992f-e19fc4e766d7'::uuid, '9b8eebd7-057f-4021-ad6f-f2879733bdb9'::uuid])
            JOIN "___ORGANIZATION_ID___"."userOrganizationProfiles" uop 
            ON uoc."userId" = uop."userId" 
                AND uop."deletedAt" IS NULL 
                AND uoc."deletedAt" IS NULL
        UNION ALL
            SELECT uoc.id,
            uoc.id AS "credentialId",
            uovp.id AS "profileId",
            uoc.data,
            uoc."userId",
            (((uovp.name)::text || ' '::text) || (uovp.surname)::text) AS "fullName",
            uoc."organizationId",
            uo."roleId"
            FROM "___ORGANIZATION_ID___"."userOrganizationCredentials" uoc
                JOIN "___ORGANIZATION_ID___"."userOrganizations" uo 
                    ON uo."userId" = uoc."userId" 
                        AND uo."organizationId" = uoc."organizationId"
                        AND uo."deletedAt" IS NULL
                        AND uoc."deletedAt" IS NULL
                JOIN "___ORGANIZATION_ID___".roles r 
                    ON r."organizationId" = uo."organizationId" 
                        AND uo."roleId" = r.id
                        AND r."typeId" = ANY (ARRAY['2a4ad5ff-1ced-45f8-992f-e19fc4e766d7'::uuid, '9b8eebd7-057f-4021-ad6f-f2879733bdb9'::uuid])
                JOIN "___ORGANIZATION_ID___"."userOrganizationVisitorProfiles" uovp 
                    ON uovp."userOrganizationId" = uo.id 
                    AND uovp."deletedAt" IS NULL 
                    AND uovp."deletedAt" IS NULL;
        
    
    ALTER TABLE "___ORGANIZATION_ID___"."vW_CredentialUserProfiles" OWNER TO ${dbsuperuser};
    `;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query, "___ORGANIZATION_ID___");
}
exports.down = down;
