"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const assaAbloyBatteryLevelNotification = 47;
async function up(client, dbuser, dbsuperuser) {
    const organizationList = await client.query(`
        SELECT id FROM public."organizationList"
    `);
    await Promise.all(organizationList.rows.map(async (organization) => await client.query(`
            UPDATE "${organization.id}".organizations
            SET settings = jsonb_insert(settings, '{notification, enabledTypes, -1}', '${assaAbloyBatteryLevelNotification}');

            INSERT INTO "${organization.id}".notification
            (id, "createdT", "createdByUserId", type, "receiverFilterId", settings, email, sms, web, "pushNotification") 
            VALUES (uuid_generate_v4(), now(), NULL, ${assaAbloyBatteryLevelNotification}, NULL, NULL, TRUE, FALSE, TRUE, TRUE); 

            ALTER TABLE "${organization.id}".notification_unsubscribe 
            DROP CONSTRAINT notification_unsubscribe_type_check;

            ALTER TABLE "${organization.id}".notification_unsubscribe
            ADD CONSTRAINT notification_unsubscribe_type_check CHECK (type = ANY ('{1,2,3,4,6,8,9,10,11,15,18,19,24,25,27,28,31,32,34,35,36,37,38,39,40,41,42,43,44,45,46,47,999}'::smallint[]));

            
CREATE OR REPLACE FUNCTION "${organization.id}".before_up_in_del_aperio_locks()
RETURNS trigger
LANGUAGE 'plpgsql'
COST 100
VOLATILE NOT LEAKPROOF
AS $BODY$
DECLARE
    transaction_id	bigint;
    device_id 		uuid;
    BEGIN
        transaction_id := txid_current();
        IF (TG_OP = 'DELETE') THEN
            device_id:= OLD."hubDeviceId";
        ELSE
            device_id:= NEW."hubDeviceId";
        END IF;
        
        INSERT INTO "${organization.id}"."terminalChanges"
        ("id", "transactionId", "deviceId", "actionT", "type", "data")
        VALUES(uuid_generate_v4(), transaction_id, device_id, now(), 3, '{}'::json);

        IF (TG_OP = 'DELETE') THEN
            RETURN OLD;
        ELSE
            RETURN NEW;
        END IF;

    END;

$BODY$;

ALTER FUNCTION "${organization.id}".before_up_in_del_aperio_locks()
OWNER TO ${dbsuperuser};
GRANT EXECUTE ON FUNCTION "${organization.id}".before_up_in_del_aperio_locks() TO ${dbsuperuser};
GRANT EXECUTE ON FUNCTION "${organization.id}".before_up_in_del_aperio_locks() TO PUBLIC;
GRANT EXECUTE ON FUNCTION "${organization.id}".before_up_in_del_aperio_locks() TO ${dbuser};

DROP TRIGGER IF EXISTS before_up_in_del_aperio_locks ON "${organization.id}"."aperioLocks";
CREATE TRIGGER before_up_in_del_aperio_locks
BEFORE INSERT OR DELETE OR UPDATE 
ON "${organization.id}"."aperioLocks"
FOR EACH ROW
EXECUTE FUNCTION "${organization.id}".before_up_in_del_aperio_locks();


  `)));
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) {
    const organizationList = await client.query(`
    SELECT id FROM public."organizationList"
    `);
    await Promise.all(organizationList.rows.map(async (organization) => await client.query(`
            UPDATE "${organization.id}".organizations
            SET settings = jsonb_set(settings, '{notification, enabledTypes}',(
                SELECT
                    array_to_json(array_agg("enabledTypes")::int[])::jsonb
                FROM 
                  (
                    SELECT
                      jsonb_array_elements_text(settings -> 'notification' -> 'enabledTypes') as "enabledTypes" 
                    FROM "${organization.id}".organizations 
                    ORDER BY jsonb_array_elements_text(settings -> 'notification' -> 'enabledTypes')::int
                  ) as T 
                WHERE ("enabledTypes" != '${assaAbloyBatteryLevelNotification}'))
            );

            DELETE FROM "${organization.id}".notification
            WHERE type = ${assaAbloyBatteryLevelNotification};   

            ALTER TABLE "${organization.id}".notification_unsubscribe 
            DROP CONSTRAINT notification_unsubscribe_type_check;

            ALTER TABLE "${organization.id}".notification_unsubscribe
            ADD CONSTRAINT notification_unsubscribe_type_check CHECK (type = ANY ('{1,2,3,4,6,8,9,10,11,15,18,19,24,25,27,28,31,32,34,35,36,37,38,39,40,41,42,43,44,45,46,999}'::smallint[]));
    
            `)));
}
exports.down = down;
