"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const dal_utils_1 = require("../../../dal.utils");
const dal_db_armon_schema_1 = require("../../armon/dal.db.armon.schema");
async function up(client, dbuser, dbsuperuser) {
    const q = `
    UPDATE "___ORGANIZATION_ID___".organizations SET settings = settings || '{"passiveUserSettings":{"anonymize": false}}';

    ALTER TABLE "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userOrganizationProfiles}" 
    ADD COLUMN IF NOT EXISTS "isAnonymized" boolean NOT NULL DEFAULT false;

    ALTER TABLE "___ORGANIZATION_ID___".notification_event
    ADD COLUMN IF NOT EXISTS "finalizedT" timestamp without time zone;

    ALTER TABLE "___ORGANIZATION_ID___".zz_notification_event
        ADD COLUMN IF NOT EXISTS "finalizedT" timestamp without time zone;

    `;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, q, "___ORGANIZATION_ID___");
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) {
    const q = `
    ALTER TABLE "___ORGANIZATION_ID___"."${dal_db_armon_schema_1.ArmonSchema.tableNames.userOrganizationProfiles}" 
    DROP COLUMN IF EXISTS "isAnonymized";

    UPDATE "___ORGANIZATION_ID___".organizations SET settings = settings #- '{"passiveUserSettings"}';
    `;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, q, "___ORGANIZATION_ID___");
}
exports.down = down;
