"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const dal_utils_1 = require("../../../dal.utils");
async function up(client, dbuser, dbsuperuser) {
    let query = `
    -- FUNCTION: "___ORGANIZATION_ID___".add_recalculate_record_for_approvements_states_change()

    -- DROP FUNCTION "___ORGANIZATION_ID___".add_recalculate_record_for_approvements_states_change();
    
    CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".add_recalculate_record_for_approvements_states_change()
        RETURNS trigger
        LANGUAGE 'plpgsql'
        COST 100
        VOLATILE NOT LEAKPROOF
    AS $BODY$
    DECLARE
        is_permission_approvements_states_completed boolean;
    BEGIN
    
        IF (TG_OP = 'INSERT' OR TG_OP = 'UPDATE' ) THEN
            SELECT bool_and("approvementDate" is not null) INTO is_permission_approvements_states_completed 
            FROM "___ORGANIZATION_ID___"."userPPermissionApprovements"
            WHERE "userId" = NEW."userId" and "ppermissionId" = NEW."ppermissionId";
            
            IF(is_permission_approvements_states_completed ) THEN
                    INSERT INTO "___ORGANIZATION_ID___"."recalculateWorkQueue"
                    (id, "userId", "organizationId", reason, "startDate")
                    SELECT uuid_generate_v4(), upp."userId", wp."organizationId", 16,
                        LOWER(tstzrange(uwp."startDateTime", uwp."endDateTime")*wpp."range"*tstzrange(pp."startDateTime", pp."endDateTime"))
                    FROM "___ORGANIZATION_ID___"."userWorkPlans" uwp
                    INNER JOIN "___ORGANIZATION_ID___"."workPlans" wp ON wp."id" = uwp."workPlanId"
                    INNER JOIN "___ORGANIZATION_ID___"."vW_WorkPlanPeriodTstzrange" wpp ON wpp."workPlanId" = wp."id"
                    INNER JOIN "___ORGANIZATION_ID___"."ppermissions" pp ON pp."id" = NEW."ppermissionId"
                    INNER JOIN "___ORGANIZATION_ID___"."userPPermissions" upp ON upp."ppermissionId" = NEW."ppermissionId" AND uwp."userId" = upp."userId"
                    INNER JOIN "___ORGANIZATION_ID___"."userOrganizations" uo ON uwp."userId" = uo."userId" AND uo."deletedAt" IS NULL AND uo."isDisabled" = false
                    WHERE NOT isEmpty(tstzrange(uwp."startDateTime", uwp."endDateTime")*wpp."range"*tstzrange(pp."startDateTime", pp."endDateTime"));
                    
                   UPDATE "___ORGANIZATION_ID___"."employeeLiveDay" eld SET "updateRequiredReason"="updateRequiredReason" | 16, "updateRequiredRaisedAt" = now()
                   FROM "___ORGANIZATION_ID___"."userPPermissions" upp
                   INNER JOIN "___ORGANIZATION_ID___"."ppermissions" pp ON upp."ppermissionId" = pp."id"
                   WHERE upp."ppermissionId" = NEW."ppermissionId" AND pp."id" = NEW."ppermissionId" AND eld."userId" = upp."userId"
                   AND (pp."startDateTime"::date <= now()::date);
                    
            END IF;
            RETURN NEW;
        END IF;
        RETURN NEW;
    END;
    $BODY$;
    
    ALTER FUNCTION "___ORGANIZATION_ID___".add_recalculate_record_for_approvements_states_change()
        OWNER TO ${dbsuperuser};
    
    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".add_recalculate_record_for_approvements_states_change() TO ${dbsuperuser};
    
    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".add_recalculate_record_for_approvements_states_change() TO PUBLIC;
    
    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".add_recalculate_record_for_approvements_states_change() TO ${dbuser};
    

    DROP TRIGGER IF EXISTS add_recalculate_record_for_approvements_states_change_uppa on "___ORGANIZATION_ID___"."userPPermissionApprovements";

    CREATE TRIGGER add_recalculate_record_for_approvements_states_change_uppa
    AFTER INSERT OR UPDATE
    ON "___ORGANIZATION_ID___"."userPPermissionApprovements"
    FOR EACH ROW
    EXECUTE FUNCTION "___ORGANIZATION_ID___".add_recalculate_record_for_approvements_states_change();


    INSERT INTO "___ORGANIZATION_ID___"."recalculateWorkQueue"
    ("id", "userId", "organizationId", "reason", "startDate")
    SELECT uuid_generate_v4(), uwp."userId", wp."organizationId", 16, MIN(pp."startDateTime")::date
    FROM "___ORGANIZATION_ID___"."userWorkPlans" uwp
    INNER JOIN (
        SELECT '2021-11-01'::date as sdt, now()::date as edt
    ) range
    ON tstzrange(uwp."startDateTime", uwp."endDateTime") && tstzrange(range.sdt, range.edt)
    INNER JOIN "___ORGANIZATION_ID___"."workPlans" wp
    ON wp.id = uwp."workPlanId" AND wp."deletedAt" IS NULL
    INNER JOIN "___ORGANIZATION_ID___"."vW_WorkPlanPeriodTstzrange" wpp
    ON wpp."workPlanId" = wp.id AND wpp.range && tstzrange(range.sdt, range.edt)
    INNER JOIN "___ORGANIZATION_ID___"."userOrganizationProfiles" uop
    ON uop."userId" = uwp."userId" AND uop."deletedAt" IS NULL
    INNER JOIN "___ORGANIZATION_ID___"."userOrganizations" uo
    ON uo."userId" = uwp."userId" AND uo."deletedAt" IS NULL AND uo."isDisabled" = false
    INNER JOIN "___ORGANIZATION_ID___"."userPPermissions" upp
    ON upp."userId" = uwp."userId"
    INNER JOIN "___ORGANIZATION_ID___"."ppermissions" pp
    ON pp.id = upp. "ppermissionId" AND tstzrange(pp."startDateTime", pp."endDateTime") && tstzrange(range.sdt, range.edt)
    GROUP BY uwp."userId", wp."organizationId"
    `;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query, "___ORGANIZATION_ID___");
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) {
}
exports.down = down;
