"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const dal_utils_1 = require("../../../dal.utils");
async function up(client, dbuser, dbsuperuser) {
    const q = `
	--------------------------- USER ---------------------------
		CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".after_up_del_user()
		RETURNS trigger
		LANGUAGE 'plpgsql'
		COST 100
		VOLATILE NOT LEAKPROOF
	AS $BODY$
		BEGIN
			IF (TG_OP = 'UPDATE' AND (                    
					NEW."deletedAt" IS DISTINCT FROM OLD."deletedAt" OR 
					NEW."notificationToken" IS DISTINCT FROM OLD."notificationToken" OR 
					NEW."notificationTokenType" IS DISTINCT FROM OLD."notificationTokenType" OR 
					NEW."publicKey" IS DISTINCT FROM OLD."publicKey" OR
					NEW.settings->>'locale' IS DISTINCT FROM OLD.settings->>'locale'
				)) THEN
				PERFORM PG_NOTIFY('update_user_info_cache', JSON_BUILD_OBJECT('id', NEW.id, 'organizationId', TG_TABLE_SCHEMA)::text);								  		
			ELSIF (TG_OP = 'DELETE') THEN
				PERFORM PG_NOTIFY('update_user_info_cache', JSON_BUILD_OBJECT('id', OLD.id, 'organizationId', TG_TABLE_SCHEMA)::text);								  		
			END IF;
		RETURN NEW;
		END;
		
	$BODY$;

	ALTER FUNCTION "___ORGANIZATION_ID___".after_up_del_user()
		OWNER TO ${dbsuperuser};

	GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".after_up_del_user() TO ${dbsuperuser};
	GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".after_up_del_user() TO PUBLIC;
	GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".after_up_del_user() TO ${dbuser};


	--------------------------- region ---------------------------

	CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".after_up_del_region()
    RETURNS trigger
    LANGUAGE 'plpgsql'
    COST 100
    VOLATILE NOT LEAKPROOF
	AS $BODY$
    BEGIN
        IF (TG_OP = 'UPDATE' AND (
                NEW.name IS DISTINCT FROM OLD.name OR 
                NEW."visitorAccess" IS DISTINCT FROM OLD."visitorAccess" OR 
                NEW."terminateVisitOnExit" IS DISTINCT FROM OLD."terminateVisitOnExit")) THEN
            PERFORM PG_NOTIFY('update_region_info_cache', JSON_BUILD_OBJECT('id', NEW.id, 'organizationId', TG_TABLE_SCHEMA)::text);								  		
        ELSIF (TG_OP = 'DELETE') THEN
            PERFORM PG_NOTIFY('update_region_info_cache', JSON_BUILD_OBJECT('id', OLD.id, 'organizationId', TG_TABLE_SCHEMA)::text);								  		
        END IF;
    RETURN NEW;
    END;
    
	$BODY$;

	ALTER FUNCTION "___ORGANIZATION_ID___".after_up_del_region()
		OWNER TO ${dbsuperuser};

	GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".after_up_del_region() TO ${dbsuperuser};
	GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".after_up_del_region() TO PUBLIC;
	GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".after_up_del_region() TO ${dbuser};	

	--------------------------- access point ---------------------------

	CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".after_up_del_access_point()
    RETURNS trigger
    LANGUAGE 'plpgsql'
    COST 100
    VOLATILE NOT LEAKPROOF
AS $BODY$
    BEGIN
        IF (TG_OP = 'UPDATE' AND (NEW.name IS DISTINCT FROM OLD.name OR NEW."deletedAt" IS DISTINCT FROM OLD."deletedAt")) THEN
             PERFORM PG_NOTIFY('update_access_point_info_cache', JSON_BUILD_OBJECT('id', NEW.id, 'organizationId', TG_TABLE_SCHEMA)::text);								  		
		ELSIF (TG_OP = 'DELETE') THEN
             PERFORM PG_NOTIFY('update_access_point_info_cache', JSON_BUILD_OBJECT('id', OLD.id, 'organizationId', TG_TABLE_SCHEMA)::text);								  		
        END IF;
    RETURN NEW;
    END;
    
$BODY$;

ALTER FUNCTION "___ORGANIZATION_ID___".after_up_del_access_point()
    OWNER TO ${dbsuperuser};

GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".after_up_del_access_point() TO ${dbsuperuser};
GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".after_up_del_access_point() TO PUBLIC;
GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".after_up_del_access_point() TO ${dbuser};

--------------------------------- device state and notification --------------------------------------

CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".after_up_del_device_state_and_notification()
    RETURNS trigger
    LANGUAGE 'plpgsql'
    COST 100
    VOLATILE NOT LEAKPROOF
AS $BODY$
    DECLARE
        organization_id 	text;
        data json;
		updateDeviceStateCache boolean;
		updateDeviceNotificationInfoCache boolean;
    BEGIN
        IF (TG_OP = 'UPDATE') THEN
		   IF(OLD."deletedAt" IS NULL AND NEW."deletedAt" IS NOT NULL) THEN
				updateDeviceNotificationInfoCache := true;
				updateDeviceStateCache := true;
			END IF;
            IF ((NEW.health->>'isConnected')::boolean IS DISTINCT FROM (OLD.health->>'isConnected')::boolean OR
			(NEW.health->>'warnings')::text IS DISTINCT FROM (OLD.health->>'warnings')::text 
		   ) THEN
		   		updateDeviceStateCache := true;
			END IF;
			IF(NEW.brand IS DISTINCT FROM OLD.brand OR 
                NEW.model NOT LIKE OLD.model OR
                NEW.name IS DISTINCT FROM OLD.name OR
                NEW.location IS DISTINCT FROM OLD.location) THEN
				updateDeviceNotificationInfoCache := true;
			END IF;
		ELSIF (TG_OP = 'DELETE') THEN
				updateDeviceNotificationInfoCache := true;
				updateDeviceStateCache := true;
        END IF;
		IF(updateDeviceNotificationInfoCache = true) THEN
			PERFORM PG_NOTIFY('update_device_notification_info_cache', JSON_BUILD_OBJECT('id', NEW.id, 'organizationId', TG_TABLE_SCHEMA)::text);								  
		END IF;
		IF(updateDeviceStateCache = true) THEN
			PERFORM PG_NOTIFY('update_device_state_cache', JSON_BUILD_OBJECT('id', NEW.id, 'organizationId', TG_TABLE_SCHEMA)::text);								  
		END IF;
    RETURN NEW;
    END;
    
$BODY$;

ALTER FUNCTION "___ORGANIZATION_ID___".after_up_del_device_state_and_notification()
    OWNER TO ${dbsuperuser};

GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".after_up_del_device_state_and_notification() TO ${dbsuperuser};
GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".after_up_del_device_state_and_notification() TO PUBLIC;
GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".after_up_del_device_state_and_notification() TO ${dbuser};


--------------------------------- after_up_del_organization --------------------------------------


CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".after_up_del_organization()
    RETURNS trigger
    LANGUAGE 'plpgsql'
    COST 100
    VOLATILE NOT LEAKPROOF
AS $BODY$
    DECLARE
                transaction_id	bigint;
            BEGIN
                transaction_id := txid_current();
                IF (TG_OP = 'UPDATE') THEN
                    IF (NEW.settings->'webRtc' IS DISTINCT FROM OLD.settings->'webRtc') THEN
                        INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                        ("id", "transactionId", "deviceId", "actionT", "type", "data")
                        SELECT uuid_generate_v4(), transaction_id, T."proxyTerminalId", now(), 3, '{}'::json FROM
                        (SELECT DISTINCT "proxyTerminalId" FROM "___ORGANIZATION_ID___"."cameras") as T;
                        PERFORM PG_NOTIFY('webrtc_ice_servers', JSON_BUILD_OBJECT('id', NEW.id)::text);								  		
                    END IF;	
                END IF;	
                PERFORM PG_NOTIFY('organization_settings_changed', TG_TABLE_SCHEMA);
            RETURN NEW;
            END;
		
	$BODY$;

	ALTER FUNCTION "___ORGANIZATION_ID___".after_up_del_organization()
		OWNER TO ${dbsuperuser};

	GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".after_up_del_organization() TO ${dbsuperuser};
	GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".after_up_del_organization() TO PUBLIC;
	GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".after_up_del_organization() TO ${dbuser};

--------------------------------- after_up_del_organization --------------------------------------


	CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".after_up_del_user_organization()
		RETURNS trigger
		LANGUAGE 'plpgsql'
		COST 100
		VOLATILE NOT LEAKPROOF
	AS $BODY$
		BEGIN
				IF (TG_OP = 'UPDATE' AND (                    
						NEW."deletedAt" IS DISTINCT FROM OLD."deletedAt" OR 
						NEW."roleId" IS DISTINCT FROM OLD."roleId" OR 
						NEW."isDisabled" IS DISTINCT FROM OLD."isDisabled" OR 
						NEW.settings IS DISTINCT FROM OLD.settings
						)) THEN
					PERFORM PG_NOTIFY('update_user_info_cache', JSON_BUILD_OBJECT('id', NEW."userId", 'organizationId', TG_TABLE_SCHEMA)::text);								  		
				ELSIF (TG_OP = 'DELETE') THEN
					PERFORM PG_NOTIFY('update_user_info_cache', JSON_BUILD_OBJECT('id', OLD."userId", 'organizationId', TG_TABLE_SCHEMA)::text);								  		
				END IF;
			RETURN NEW;
			END;
		
	$BODY$;

	ALTER FUNCTION "___ORGANIZATION_ID___".after_up_del_user_organization()
		OWNER TO ${dbsuperuser};

	GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".after_up_del_user_organization() TO ${dbsuperuser};
	GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".after_up_del_user_organization() TO PUBLIC;
	GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".after_up_del_user_organization() TO ${dbuser};

	--------------------------------- after_up_del_user_organization_profile --------------------------------------

	CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".after_up_del_user_organization_profile()
		RETURNS trigger
		LANGUAGE 'plpgsql'
		COST 100
		VOLATILE NOT LEAKPROOF
	AS $BODY$
			BEGIN
				IF (TG_OP = 'UPDATE' AND (                    
						NEW."deletedAt" IS DISTINCT FROM OLD."deletedAt" OR 
						NEW."name" IS DISTINCT FROM OLD."name" OR 
						NEW."surname" IS DISTINCT FROM OLD."surname" OR 
						NEW."email" IS DISTINCT FROM OLD."email" OR
						NEW."phoneNumber" IS DISTINCT FROM OLD."phoneNumber" OR
						NEW."uniqueId" IS DISTINCT FROM OLD."uniqueId"
						)) THEN
					PERFORM PG_NOTIFY('update_user_info_cache', JSON_BUILD_OBJECT('id', NEW."userId", 'organizationId', TG_TABLE_SCHEMA)::text);								  		
				ELSIF (TG_OP = 'DELETE') THEN
					PERFORM PG_NOTIFY('update_user_info_cache', JSON_BUILD_OBJECT('id', OLD."userId", 'organizationId', TG_TABLE_SCHEMA)::text);								  		
				END IF;
			RETURN NEW;
			END;
			
	$BODY$;

	ALTER FUNCTION "___ORGANIZATION_ID___".after_up_del_user_organization_profile()
		OWNER TO ${dbsuperuser};

	GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".after_up_del_user_organization_profile() TO ${dbsuperuser};
	GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".after_up_del_user_organization_profile() TO PUBLIC;
	GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".after_up_del_user_organization_profile() TO ${dbuser};

	--------------------------------- after_up_del_user_profile --------------------------------------

	CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".after_up_del_user_profile()
    RETURNS trigger
    LANGUAGE 'plpgsql'
    COST 100
    VOLATILE NOT LEAKPROOF
	AS $BODY$
			BEGIN
				IF (TG_OP = 'UPDATE' AND (                    
						NEW."deletedAt" IS DISTINCT FROM OLD."deletedAt" OR 
						NEW."name" IS DISTINCT FROM OLD."name" OR 
						NEW."surname" IS DISTINCT FROM OLD."surname" OR 
						NEW."email" IS DISTINCT FROM OLD."email" OR
						NEW."phoneNumber" IS DISTINCT FROM OLD."phoneNumber"
						)) THEN
					PERFORM PG_NOTIFY('update_user_info_cache', JSON_BUILD_OBJECT('id', NEW."userId", 'organizationId', TG_TABLE_SCHEMA)::text);								  		
				ELSIF (TG_OP = 'DELETE') THEN
					PERFORM PG_NOTIFY('update_user_info_cache', JSON_BUILD_OBJECT('id', OLD."userId", 'organizationId', TG_TABLE_SCHEMA)::text);								  		
				END IF;
			RETURN NEW;
			END;
			
	$BODY$;

	ALTER FUNCTION "___ORGANIZATION_ID___".after_up_del_user_profile()
		OWNER TO ${dbsuperuser};

	GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".after_up_del_user_profile() TO ${dbsuperuser};
	GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".after_up_del_user_profile() TO PUBLIC;
	GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".after_up_del_user_profile() TO ${dbuser};

    `;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, q, "___ORGANIZATION_ID___");
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) {
}
exports.down = down;
