"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const dal_db_armon_schema_1 = require("../../armon/dal.db.armon.schema");
async function up(client, dbuser, dbsuperuser) {
    const organizationList = await client.query(`
    	SELECT id FROM public."${dal_db_armon_schema_1.ArmonSchema.tableNames.organizationList}"
    `);
    const permissionToDelete = '"p:s"';
    for (const organization of organizationList.rows) {
        const existingRoles = await client.query(`
        	SELECT id, permissions, "isOrganizationWide", "typeId" FROM "${organization.id}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.roles}" WHERE "deletedAt" IS NULL
        `);
        for (const role of existingRoles.rows) {
            const permissions = role.permissions.replace(new RegExp("[\\[\\]\\s]", "g"), "");
            let permissionsArray = permissions.indexOf(",") > 0 ? permissions.split(",") : [];
            let updateNeeded = false;
            if (permissionsArray.includes(permissionToDelete)) {
                updateNeeded = true;
                permissionsArray = permissionsArray.filter((p) => p != permissionToDelete);
            }
            if (updateNeeded) {
                const newPermissions = "[" + permissionsArray.join(",") + "]";
                await client.query(`
                UPDATE "${organization.id}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.roles}"
                SET permissions = $1
                WHERE id = $2
                `, [newPermissions, role.id]);
            }
        }
    }
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) { }
exports.down = down;
