"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const luxon_1 = require("luxon");
const dal_db_armon_schema_1 = require("../../armon/dal.db.armon.schema");
async function up(client, dbuser, dbsuperuser) {
    const METUOrganizationId = "701531d6-7ce3-4dce-afb4-3303a8f49ad2";
    const maximumPreregistrationDate = luxon_1.DateTime.now().startOf("day").plus({ days: 5 }).toSQL();
    const maximumPreregistrationDateTZFormat = luxon_1.DateTime.now().startOf("day").plus({ days: 5 }).setZone("UTC").toSQL();
    const hasMETU = (await client.query(`SELECT COUNT(id) > 0 as "hasMETU" FROM public."${dal_db_armon_schema_1.ArmonSchema.tableNames.organizationList}" WHERE id = $1`, [METUOrganizationId])).rows[0].hasMETU;
    let METULogsBackUp = "metuLogBackUp";
    if (hasMETU) {
        await client.query(`
            CREATE TABLE IF NOT EXISTS "${METUOrganizationId}"."${METULogsBackUp}"(
            id uuid,
            "expectedStartUtc" TIMESTAMPTZ)
            TABLESPACE pg_default;
            `);
        await client.query(`ALTER TABLE "${METUOrganizationId}"."${METULogsBackUp}" OWNER to ${dbsuperuser};`);
        await client.query(`
            INSERT INTO "${METUOrganizationId}"."${METULogsBackUp}"
            (id, "expectedStartUtc")
            (SELECT id, "expectedStartUtc"
             FROM "${METUOrganizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.organizationActiveVisits}"
             WHERE "expectedStartUtc" >= $1);
            `, [maximumPreregistrationDate]);
        await client.query(`
            UPDATE "${METUOrganizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.organizationActiveVisits}"
            SET "expectedStartUtc" = $1
            WHERE "expectedStartUtc" >= $1;
            `, [maximumPreregistrationDate]);
        await client.query(`
            UPDATE "${METUOrganizationId}"."${dal_db_armon_schema_1.ArmonSchema.tableNames.VisitorPreregistrationHistory}" as vph
            SET log= JSONB_SET(log,'{v}',(log->'v' || ('{"expectedDate":{"endDate": "'|| (vph.log->'v'->'expectedDate'->>'endDate')::text || '"'|| ',"startDate":"' || ($1)::text || '"}}')::jsonb)::jsonb,false)
            WHERE log->'v'->'expectedDate'->>'startDate' = $1;
            `, [maximumPreregistrationDateTZFormat]);
    }
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) { }
exports.down = down;
