"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const dal_utils_1 = require("../../../dal.utils");
async function up(client, dbuser, dbsuperuser) {
    const q = `
	CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".zz_user_organization_forbiddances()
	RETURNS trigger
	LANGUAGE 'plpgsql'
	COST 100
	VOLATILE NOT LEAKPROOF
	AS $BODY$
	DECLARE
				_now timestamp without time zone;
			BEGIN   
				_now := now();
				IF (TG_OP = 'INSERT' AND NOT EXISTS (SELECT id FROM "___ORGANIZATION_ID___"."userOrganizationForbiddances" WHERE id = NEW.id)) THEN
					INSERT INTO "___ORGANIZATION_ID___".zz_user_organization_forbiddances
					(
						id,
						action,
						"actionT",
						"transactionId",
						"userId",
						"createdAt",
						"updatedAt",
						"deletedAt",
						"startUtc",
						"endUtc",
						"regionId",
						note,
						"credentialIds"
					)
					VALUES(
						NEW.id,
						1,
						_now,
						txid_current(),
						NEW."userId",
						NEW."createdAt",
						NEW."updatedAt",
						NEW."deletedAt",
						NEW."startUtc",
						NEW."endUtc",
						NEW."regionId",
						NEW.note,
						NEW."credentialIds"
					);
				ELSIF (TG_OP = 'UPDATE' AND (
					NEW.id IS DISTINCT FROM OLD.id OR
					NEW."organizationId" IS DISTINCT FROM OLD."organizationId" OR
					NEW."userId" IS DISTINCT FROM OLD."userId" OR
					NEW."createdAt" IS DISTINCT FROM OLD."createdAt" OR
					NEW."updatedAt" IS DISTINCT FROM OLD."updatedAt" OR
					NEW."deletedAt" IS DISTINCT FROM OLD."deletedAt" OR
					NEW."startUtc" IS DISTINCT FROM OLD."startUtc" OR
					NEW."endUtc" IS DISTINCT FROM OLD."endUtc" OR
					NEW."regionId" IS DISTINCT FROM OLD."regionId" OR
					NEW.note IS DISTINCT FROM OLD.note OR
					NEW."credentialIds"::text IS DISTINCT FROM OLD."credentialIds"::text
				)) THEN
					INSERT INTO "___ORGANIZATION_ID___".zz_user_organization_forbiddances
					(
						id,
						action,
						"actionT",
						"transactionId",
						"userId",
						"createdAt",
						"updatedAt",
						"deletedAt",
						"startUtc",
						"endUtc",
						"regionId",
						note ,
						"credentialIds"
					)
					VALUES(
						NEW.id,
						2,
						_now,
						txid_current(),
						NEW."userId",
						NEW."createdAt",
						NEW."updatedAt",
						NEW."deletedAt",
						NEW."startUtc",
						NEW."endUtc",
						NEW."regionId",
						NEW.note,
						NEW."credentialIds"
					);    
				ELSIF (TG_OP = 'DELETE') THEN
					INSERT INTO "___ORGANIZATION_ID___".zz_user_organization_forbiddances
					(
						id,
						action,
						"actionT",
						"transactionId",
						"userId",
						"createdAt",
						"updatedAt",
						"deletedAt",
						"startUtc",
						"endUtc",
						"regionId",
						note,
						"credentialIds"
					)
					VALUES(
						OLD.id,
						3,
						_now,
						txid_current(),
						OLD."userId",
						OLD."createdAt",
						OLD."updatedAt",
						OLD."deletedAt",
						OLD."startUtc",
						OLD."endUtc",
						OLD."regionId",
						OLD.note,
						OLD."credentialIds"
					);       
				END IF;    
				RETURN NULL;
				END;
$BODY$;

ALTER FUNCTION "___ORGANIZATION_ID___".zz_user_organization_forbiddances()
	OWNER TO ${dbsuperuser};

GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".zz_user_organization_forbiddances() TO ${dbsuperuser};

GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".zz_user_organization_forbiddances() TO PUBLIC;

GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".zz_user_organization_forbiddances() TO ${dbuser};
   `;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, q, "___ORGANIZATION_ID___");
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) {
}
exports.down = down;
