"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const dal_utils_1 = require("../../../dal.utils");
async function up(client, dbuser, dbsuperuser) {
    const q = `

-- FUNCTION: ___ORGANIZATION_ID___.before_up_in_del_access_control_point()
-- DROP FUNCTION "___ORGANIZATION_ID___".before_up_in_del_access_control_point();
CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".before_up_in_del_access_control_point()
    RETURNS trigger
    LANGUAGE 'plpgsql'
    COST 100
    VOLATILE NOT LEAKPROOF
AS $BODY$
DECLARE
                transaction_id			uuid;
                i 						jsonb;
                j 						jsonb;
                l 						jsonb;
                new_available_factors		jsonb;
                factors_in_other_acps		jsonb;
                old_available_factors		jsonb;
                new_added_factors			jsonb;
                removed_factors				jsonb;
                factors_to_send_to_device		jsonb;
                t1					jsonb;
            BEGIN
        
                transaction_id := uuid_generate_v4();
                new_available_factors := '[]'::jsonb;
                factors_in_other_acps := '[]'::jsonb;
                old_available_factors := '[]'::jsonb;
                new_added_factors := '[]'::jsonb;
                removed_factors := '[]'::jsonb;
                factors_to_send_to_device := '[]'::jsonb;
                
                 IF (TG_OP = 'DELETE') THEN
                 
                     INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                        ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                        VALUES (uuid_generate_v4(), transaction_id, NEW."deviceId", now(), 3, '{}'::json);
                    RETURN OLD;
                ELSIF (TG_OP = 'UPDATE') THEN
                
                    IF NEW."organizationId" != OLD."organizationId" THEN
                        RAISE EXCEPTION 'Access control point can not be assigned to another organization!';
                    END IF;
    
                    IF NEW."deviceId" IS NULL AND OLD."deviceId" IS NULL
                    THEN
                        RETURN NEW;
                    END IF;
    
                    IF OLD."deletedAt" IS NOT NULL AND NEW."deletedAt" IS NOT NULL
                    THEN
                        RETURN NEW;
                    END IF;
    
                    IF NEW."deviceId" != OLD."deviceId" THEN
                            RAISE EXCEPTION 'Access control point can not be assigned to another device!';
                    END IF;
    
                    IF NEW."deletedAt" IS NULL AND OLD."deletedAt" IS NOT NULL THEN
                        RAISE EXCEPTION 'Deleted access control point can not be un-deleted!';
                    END IF;
                    -- SELECT NEW AUTHENTICATION FACTORS OF ACP
                    FOR i IN SELECT * FROM jsonb_array_elements(NEW."authenticationFactors"::jsonb)
                    LOOP
                        i := i->'and';
                        FOR j IN SELECT * FROM jsonb_array_elements(i)
                        LOOP
                            new_available_factors:= new_available_factors || jsonb_build_object(
                                'authenticatorType', "j"->'authenticatorType',
                                'factor', (''|| CASE WHEN ("j"->'factor')::text = 0::text THEN '0' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 1::text THEN '1' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 2::text THEN '2' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 3::text THEN '3' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 4::text THEN '4' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 5::text THEN '5' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 6::text THEN '6' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 7::text THEN '9' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 8::text THEN '8' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 9::text THEN '9' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 10::text THEN '9' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 11::text THEN '9' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 12::text THEN '13' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 13::text THEN '17' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 14::text THEN '12' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 15::text THEN '15' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 16::text THEN '16' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 17::text THEN '17' ELSE '' END)
                            );
                        END LOOP;
                    END LOOP;
    
                    -- SELECT OLD AUTHENTICATION FACTORS OF ACP
                    FOR i IN SELECT * FROM jsonb_array_elements(OLD."authenticationFactors"::jsonb)
                    LOOP
                        i := i->'and';
                        FOR j IN SELECT * FROM jsonb_array_elements(i)
                        LOOP
                            old_available_factors:= old_available_factors || jsonb_build_object(
                                'authenticatorType', "j"->'authenticatorType',
                                'factor', (''|| CASE WHEN ("j"->'factor')::text = 0::text THEN '0' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 1::text THEN '1' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 2::text THEN '2' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 3::text THEN '3' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 4::text THEN '4' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 5::text THEN '5' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 6::text THEN '6' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 7::text THEN '9' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 8::text THEN '8' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 9::text THEN '9' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 10::text THEN '9' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 11::text THEN '9' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 12::text THEN '13' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 13::text THEN '17' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 14::text THEN '12' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 15::text THEN '15' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 16::text THEN '16' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 17::text THEN '17' ELSE '' END)
                            );
                        END LOOP;
                    END LOOP;
    
                    -- SELECT AUTHENTICATION FACTORS FROM OTHER ACP's THAT BELONGS TO SAME DEVICE
                    FOR i IN SELECT * FROM jsonb_array_elements((SELECT JSONB_AGG(acp."authenticationFactors"::jsonb)
                        FROM "___ORGANIZATION_ID___"."accessControlPoints" AS acp
                        WHERE acp."deletedAt" IS NULL
                        AND acp."deviceId" = NEW."deviceId"
                        AND acp."id" != NEW."id"
                        AND acp."authenticationFactors" IS NOT NULL))
                    LOOP
                        FOR j IN SELECT * FROM jsonb_array_elements(i)
                        LOOP
                            j := j->'and';
                            FOR l IN SELECT * FROM jsonb_array_elements(j)
                            LOOP
                                t1:= jsonb_build_object(
                                    'authenticatorType', "l"->'authenticatorType',
                                    'factor', (''|| CASE WHEN ("l"->'factor')::text = 0::text THEN '0' ELSE '' END
                                                || CASE WHEN ("l"->'factor')::text = 1::text THEN '1' ELSE '' END
                                                || CASE WHEN ("l"->'factor')::text = 2::text THEN '2' ELSE '' END
                                                || CASE WHEN ("l"->'factor')::text = 3::text THEN '3' ELSE '' END
                                                || CASE WHEN ("l"->'factor')::text = 4::text THEN '4' ELSE '' END
                                                || CASE WHEN ("l"->'factor')::text = 5::text THEN '5' ELSE '' END
                                                || CASE WHEN ("l"->'factor')::text = 6::text THEN '6' ELSE '' END
                                                || CASE WHEN ("l"->'factor')::text = 7::text THEN '9' ELSE '' END
                                                || CASE WHEN ("l"->'factor')::text = 8::text THEN '8' ELSE '' END
                                                || CASE WHEN ("l"->'factor')::text = 9::text THEN '9' ELSE '' END
                                                || CASE WHEN ("l"->'factor')::text = 10::text THEN '9' ELSE '' END
                                                || CASE WHEN ("l"->'factor')::text = 11::text THEN '9' ELSE '' END
                                                || CASE WHEN ("l"->'factor')::text = 12::text THEN '13' ELSE '' END
                                                || CASE WHEN ("l"->'factor')::text = 13::text THEN '17' ELSE '' END
                                                || CASE WHEN ("l"->'factor')::text = 14::text THEN '12' ELSE '' END
                                                || CASE WHEN ("l"->'factor')::text = 15::text THEN '15' ELSE '' END
                                                || CASE WHEN ("l"->'factor')::text = 16::text THEN '16' ELSE '' END
                                                || CASE WHEN ("j"->'factor')::text = 17::text THEN '17' ELSE '' END));
                                IF ( factors_in_other_acps IS NULL OR POSITION (t1::text IN factors_in_other_acps::text) < 1)
                                THEN
                                    factors_in_other_acps:= factors_in_other_acps || t1;
                                END IF;
                            END LOOP;
                        END LOOP;
                    END LOOP;
    
                    -- FIND NEWLY ADDED AUTHENTICATION FACTORS OF ACP
                    IF (jsonb_array_length (new_available_factors) > 0) THEN
                        FOR i IN SELECT * FROM jsonb_array_elements(new_available_factors)
                        LOOP
                            IF (POSITION (i::text IN old_available_factors::text) < 1)
                            THEN
                                new_added_factors:= new_added_factors || i;
                            END IF;
                        END LOOP;
                    END IF;
    
                    -- FIND REMOVED AUTHENTICATION FACTORS OF ACP
                    IF (jsonb_array_length (old_available_factors) > 0) THEN
                        FOR i IN SELECT * FROM jsonb_array_elements(old_available_factors)
                        LOOP
                            IF (POSITION (i::text IN new_available_factors::text) < 1)
                            THEN
                                removed_factors:= removed_factors || i;
                            END IF;
                        END LOOP; 
                    END IF;
    
                    -- CHECK IF THERE IS ANY CHANGE IN AUTHENTICATION FACTORS OF ACP
                    IF (NOT( to_jsonb(OLD."authenticationFactors") @> to_jsonb(NEW."authenticationFactors") 
                                 AND to_jsonb(OLD."authenticationFactors") <@ to_jsonb(NEW."authenticationFactors"))
                           OR (OLD."authenticationFactors" IS NULL AND NEW."authenticationFactors" IS NOT NULL)
                        OR (NEW."authenticationFactors" IS NULL AND OLD."authenticationFactors" IS NOT NULL)
    
                       )
                    THEN
                        INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                            ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                            VALUES (uuid_generate_v4(), transaction_id, NEW."deviceId", now(), 3, '{}'::json);
                    END IF;
    
                    -- IF THERE ARE ADDED AUTHENTICATION FACTORS, SEND NEW CREDENTIALS
                    IF JSONB_ARRAY_LENGTH(new_added_factors) > 0
                    THEN
                        FOR i IN SELECT * FROM jsonb_array_elements(new_added_factors)
                        LOOP
                            IF (POSITION (i::text IN factors_in_other_acps::text) < 1) THEN
                                factors_to_send_to_device:= factors_to_send_to_device || i;
                            END IF;
                        END LOOP;
                        INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                        ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                        SELECT uuid_generate_v4(), transaction_id, NEW."deviceId", now() as "actionDateISO", 1 as "type",
                        json_build_object(
                            'id', T."id",
                            'userId', T."userId",
                            'type', T."type",
                            'data', T."data",
                            'groupNumber', T."groupNumber",
                            'specialData', T."specialData",
                            'specialDataSecondary', T."specialDataSecondary",
                            'expiresOnISO', T."expiresOn",
                            'extensionFields', T."extensionFields"
                        ) AS "data" FROM
                        (SELECT uoc."id", uoc."type", uoc."data", uoc."groupNumber", uoc."specialData", uoc."userId",
                            uoc."specialDataSecondary", uoc."expiresOn", uoc."extensionFields"
                        FROM "___ORGANIZATION_ID___"."userAccessRights" AS uar
                        INNER JOIN "___ORGANIZATION_ID___"."userOrganizationCredentials" AS uoc ON uar."userId" = uoc."userId"
                        INNER JOIN "___ORGANIZATION_ID___"."userOrganizations" AS uo ON uo."userId" = uoc."userId" AND uo."organizationId" = uoc."organizationId" AND uo."deletedAt" IS NULL
                        INNER JOIN "___ORGANIZATION_ID___"."roles" AS r ON uo."roleId" = r."id" AND r."deletedAt" IS NULL
                        WHERE uar."accessControlPointId" = NEW."id"
                        AND uar."deletedAt" IS NULL 
                        AND uoc."deletedAt" IS NULL
                        AND uoc."organizationId" = NEW."organizationId"
                        AND uar."access" = TRUE
                        AND POSITION(jsonb_build_object(
                            'authenticatorType', (CASE WHEN r."typeId" = '2a4ad5ff-1ced-45f8-992f-e19fc4e766d7'	OR r."typeId" = '9b8eebd7-057f-4021-ad6f-f2879733bdb9' THEN 2 ELSE 1 END),
                            'factor', uoc."type"::text)::text IN factors_to_send_to_device::text) > 0) AS T;
                    END IF;
                ELSIF (TG_OP = 'INSERT') THEN
                    INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                            ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                            VALUES (uuid_generate_v4(), transaction_id, NEW."deviceId", now(), 3, '{}'::json);
                END IF;
                RETURN NEW;
            END;
$BODY$;

ALTER FUNCTION "___ORGANIZATION_ID___".before_up_in_del_access_control_point()
    OWNER TO ${dbsuperuser};

GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_access_control_point() TO ${dbsuperuser};

GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_access_control_point() TO PUBLIC;

GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_access_control_point() TO ${dbuser};



-- FUNCTION: ___ORGANIZATION_ID___.before_up_in_del_user_access_rights()
-- DROP FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_access_rights();
CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_access_rights()
    RETURNS trigger
    LANGUAGE 'plpgsql'
    COST 100
    VOLATILE NOT LEAKPROOF
AS $BODY$
DECLARE
            transaction_id		uuid;
            device_id			uuid;
            organization_id		uuid;
            factors_of_acp		jsonb;
            factors_of_other_acps		jsonb;
            factors_to_send_to_device		jsonb;
            i 						jsonb;
            j 						jsonb;
            l 						jsonb;
            t1 						jsonb;
        
            BEGIN
                transaction_id := uuid_generate_v4();
                factors_of_acp := '[]'::jsonb;
                factors_of_other_acps := '[]'::jsonb;
                factors_to_send_to_device := '[]'::jsonb;
                IF (TG_OP = 'DELETE') THEN
                    SELECT "deviceId" INTO device_id FROM "___ORGANIZATION_ID___"."accessControlPoints" WHERE id=OLD."accessControlPointId";
                    INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                        ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                        VALUES (uuid_generate_v4(), transaction_id, device_id, now(), 8,
                                JSON_BUILD_OBJECT('id', OLD."id"));
                    RETURN OLD;
                ELSIF (TG_OP = 'UPDATE') THEN
                    SELECT "deviceId" INTO device_id FROM "___ORGANIZATION_ID___"."accessControlPoints" WHERE id=NEW."accessControlPointId";
                    SELECT "organizationId" INTO organization_id FROM "___ORGANIZATION_ID___"."accessControlPoints" WHERE "id"=NEW."accessControlPointId";
                    IF NEW."accessControlPointId" != OLD."accessControlPointId" OR NEW."userId" != OLD."userId" THEN
                        RAISE EXCEPTION 'user id or access control point id cannot be updated!';
                    END IF;
        
                    IF (OLD."access" IS TRUE AND OLD."deletedAt" IS NULL AND NEW."deletedAt" IS NOT NULL) OR
                        (OLD."access" IS TRUE AND NEW."access" IS FALSE AND NEW."deletedAt" IS NULL)
                    THEN
                        INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                        ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                        VALUES (uuid_generate_v4(), transaction_id, device_id, now(), 8,
                                JSON_BUILD_OBJECT('id', OLD."id"));
                    END IF;
                    IF (NEW."access" IS TRUE AND OLD."deletedAt" IS NOT NULL AND NEW."deletedAt" IS NULL) OR
                        (OLD."access" IS FALSE AND NEW."access" IS TRUE AND NEW."deletedAt" IS NULL)
                    THEN
                        -- send users has access rights
                        INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                        ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                        -- 1. user already has an access right for an access control point that is related with the device
                        -- Then, just send new access rights
                        SELECT uuid_generate_v4(), transaction_id, device_id, now(), 7,
                        json_build_object(
                            'id', NEW."id",
                            'userId', NEW."userId",
                            'accessControlPointId', NEW."accessControlPointId"
                        );
        
                        -- 1.1. find credentials those are not sent then sent new credentials
                        -- SELECT NEW AUTHENTICATION FACTORS OF ACP
                        FOR i IN SELECT * FROM jsonb_array_elements((SELECT acp."authenticationFactors"::jsonb
                            FROM "___ORGANIZATION_ID___"."accessControlPoints" AS acp
                            WHERE acp."id" = NEW."accessControlPointId"
                            AND acp."authenticationFactors" IS NOT NULL))
                        LOOP
                            i := i->'and';
                            FOR j IN SELECT * FROM jsonb_array_elements(i)
                            LOOP
                                factors_of_acp:= factors_of_acp || jsonb_build_object(
                                    'authenticatorType', "j"->'authenticatorType',
                                    'factor', (''|| CASE WHEN ("j"->'factor')::text = 0::text THEN '0' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 1::text THEN '1' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 2::text THEN '2' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 3::text THEN '3' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 4::text THEN '4' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 5::text THEN '5' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 6::text THEN '6' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 7::text THEN '9' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 8::text THEN '8' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 9::text THEN '9' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 10::text THEN '9' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 11::text THEN '9' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 12::text THEN '13' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 13::text THEN '17' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 14::text THEN '12' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 15::text THEN '15' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 16::text THEN '16' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 17::text THEN '17' ELSE '' END)
                                );
                            END LOOP;
                        END LOOP;
        
                        -- SELECT AUTHENTICATION FACTORS FROM OTHER ACP's THAT BELONGS TO SAME DEVICE
                        FOR i IN SELECT * FROM jsonb_array_elements((SELECT JSONB_AGG(acp."authenticationFactors"::jsonb)
                            FROM "___ORGANIZATION_ID___"."accessControlPoints" AS acp
                            INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uar."accessControlPointId" = acp.id
                            WHERE acp."deletedAt" IS NULL
                            AND acp."deviceId" = device_id
                            AND acp."id" != NEW."accessControlPointId"
                            AND acp."authenticationFactors" IS NOT NULL
                            AND uar."deletedAt" IS NULL
                            AND uar."userId" = NEW."userId"))
                        LOOP
                            FOR j IN SELECT * FROM jsonb_array_elements(i)
                            LOOP
                                j := j->'and';
                                FOR l IN SELECT * FROM jsonb_array_elements(j)
                                LOOP
                                    t1 := jsonb_build_object(
                                        'authenticatorType', "l"->'authenticatorType',
                                        'factor', (''|| CASE WHEN ("l"->'factor')::text = 0::text THEN '0' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 1::text THEN '1' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 2::text THEN '2' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 3::text THEN '3' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 4::text THEN '4' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 5::text THEN '5' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 6::text THEN '6' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 7::text THEN '9' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 8::text THEN '8' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 9::text THEN '9' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 10::text THEN '9' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 11::text THEN '9' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 12::text THEN '13' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 13::text THEN '17' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 14::text THEN '12' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 15::text THEN '15' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 16::text THEN '16' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 17::text THEN '17' ELSE '' END));
                                    IF (factors_of_other_acps IS NULL OR POSITION( t1::text IN factors_of_other_acps::text) < 1)
                                    THEN
                                        factors_of_other_acps:= factors_of_other_acps || t1;
                                    END IF;
                                END LOOP;
                            END LOOP;
                        END LOOP;
                        
                        FOR i IN SELECT * FROM jsonb_array_elements(factors_of_acp)
                        LOOP
                            IF (POSITION (i::text IN factors_of_other_acps::text) < 1) THEN
                                factors_to_send_to_device:= factors_to_send_to_device || i;
                            END IF;
                        END LOOP;
                        -- add new credentials for device
                        -- IF THERE ARE ADDED AUTHENTICATION FACTORS, SEND NEW CREDENTIALS
                        i:= jsonb_array_length(factors_to_send_to_device);
                        IF (jsonb_array_length(factors_to_send_to_device) > 0)
                        THEN
                            INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                            ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                            SELECT uuid_generate_v4(), transaction_id, device_id, now() as "actionDateISO", 1 as "type",
                            json_build_object(
                                'id', T."id",
                                'userId', T."userId",
                                'type', T."type",
                                'data', T."data",
                                'groupNumber', T."groupNumber",
                                'specialData', T."specialData",
                                'specialDataSecondary', T."specialDataSecondary",
                                'expiresOnISO', T."expiresOn",
                                'extensionFields', T."extensionFields"
                            ) AS "data" FROM
                            (SELECT uoc."id", uoc."type", uoc."data", uoc."groupNumber", uoc."specialData", uoc."userId",
                                uoc."specialDataSecondary", uoc."expiresOn", uoc."extensionFields"
                            FROM "___ORGANIZATION_ID___"."userOrganizationCredentials" AS uoc
                            INNER JOIN "___ORGANIZATION_ID___"."userOrganizations" AS uo ON uo."userId" = uoc."userId" AND uo."organizationId" = uoc."organizationId" AND uo."deletedAt" IS NULL
                            INNER JOIN "___ORGANIZATION_ID___"."roles" AS r ON uo."roleId" = r."id" AND r."deletedAt" IS NULL
                            WHERE uoc."deletedAt" IS NULL
                            AND uoc."userId" = NEW."userId"
                            AND POSITION(jsonb_build_object(
                                'authenticatorType', (CASE WHEN r."typeId" = '2a4ad5ff-1ced-45f8-992f-e19fc4e766d7'	OR r."typeId" = '9b8eebd7-057f-4021-ad6f-f2879733bdb9' THEN 2 ELSE 1 END),
                                'factor', uoc."type"::text)::text IN factors_to_send_to_device::text) > 0) AS T;
                        END IF;
                        
                            -- 2. users are new for that terminal
                            -- Then send add user
                        IF (jsonb_array_length(factors_of_other_acps) < 1) THEN
                            INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                            ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                            SELECT uuid_generate_v4(), transaction_id, device_id, now() as "actionDateISO", 5 as "type",
                                json_build_object(
                                    'user',
                                    json_build_object(
                                        'id', T."id",
                                        'roleId', T."roleId",
                                        'publicKey', T."publicKey",
                                        'isVisitor', T."isVisitor",
                                        'isDisabled', T."isDisabled",
                                        'userGroupIds', T."userGroupIds",
                                        'organizationUnitIds', T."organizationUnitIds",
                                        'accessRights', T."accessRights",
                                        'credentials', T."credentials",
                                        'coinBalances', T."coinBalances",
                                        'forbiddances', T."forbiddances",
                                        'accessRuleHistories', T."accessRuleHistories")
                                ) AS "data" FROM
                            (SELECT u."id", uo."roleId", u."publicKey", uo."isDisabled",
                            (CASE WHEN r."typeId" = '2a4ad5ff-1ced-45f8-992f-e19fc4e766d7'
                                OR r."typeId" = '9b8eebd7-057f-4021-ad6f-f2879733bdb9' THEN TRUE ELSE FALSE END) AS "isVisitor",
                            (SELECT JSON_AGG("userGroupId") FROM "___ORGANIZATION_ID___"."userGroupUserOrganizations" WHERE "userOrganizationId" = uo."id" AND "deletedAt" IS NULL) AS "userGroupIds",
                            (SELECT JSON_AGG("organizationUnitId") FROM "___ORGANIZATION_ID___"."userOrganizationOrganizationUnits" WHERE "userOrganizationId" = uo."id" AND "deletedAt" IS NULL) AS "organizationUnitIds",
                            (SELECT JSON_AGG(JSON_BUILD_OBJECT('id', uar."id",
                                                                'accessControlPointId', uar."accessControlPointId")) FROM "___ORGANIZATION_ID___"."userAccessRights" AS uar
                                            INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON acp."id" = "accessControlPointId" AND acp."deletedAt" IS NULL
                                        WHERE uar."userId" = u."id" AND acp."deviceId" = device_id AND uar."deletedAt" IS NULL AND acp."deletedAt" IS NULL AND uar."access" = TRUE) AS "accessRights",
                            (SELECT JSON_AGG(json_build_object(
                                                'id', "id",
                                                'type', "type",
                                                'data', "data",
                                                'specialData', "specialData",
                                                'specialDataSecondary', "specialDataSecondary",
                                                'expiresOnISO', "expiresOn",
                                                'extensionFields', "extensionFields"
                            )) FROM "___ORGANIZATION_ID___"."userOrganizationCredentials" AS uoc WHERE "userId" = uo."userId" AND "organizationId" = uo."organizationId" AND "deletedAt" IS NULL
                                   AND POSITION(json_build_object(
                                    'authenticatorType', (CASE WHEN r."typeId" = '2a4ad5ff-1ced-45f8-992f-e19fc4e766d7'	OR r."typeId" = '9b8eebd7-057f-4021-ad6f-f2879733bdb9' THEN 2 ELSE 1 END),
                                    'factor', uoc."type"::text)::text IN factors_to_send_to_device::text) > 0) AS "credentials",
                            (SELECT JSON_AGG(json_build_object(
                                                'id', "id",
                                                'balance', "remainingUnits")) FROM "___ORGANIZATION_ID___"."userRegionTicketUnits" WHERE "userId" = uo."userId" AND "organizationId" = uo."organizationId") AS "coinBalances",
                            (SELECT JSON_AGG(json_build_object(
                                                'id', "id",
                                                'regionId', "regionId",
                                                'startDateISO', "startUtc",
                                                'endDateISO', "endUtc",
                                                'credentialIds', "credentialIds")) FROM "___ORGANIZATION_ID___"."userOrganizationForbiddances" WHERE "userId" = uo."userId" AND "organizationId" = uo."organizationId" AND "deletedAt" IS NULL) AS "forbiddances",
                            (SELECT JSON_AGG(
                                json_build_object(
                                                'ruleId', arh."accessRuleId",
                                                'count', arh."count",
                                                'actionDateISO', arh."createdDate"
                            )) FROM "___ORGANIZATION_ID___"."accessRuleHistory" AS arh
                            INNER JOIN "___ORGANIZATION_ID___"."accessRules" AS ar ON arh."accessRuleId" = ar."id" AND ar."deletedAt" IS NULL AND arh."userId" = uo."userId"
                            INNER JOIN "___ORGANIZATION_ID___"."accessRuleSets" AS ars ON ar."accessRuleSetId" = ars."id" AND ars."deletedAt" IS NULL
                            AND ars."organizationId" = uo."organizationId") AS "accessRuleHistories"
                            FROM
                            "___ORGANIZATION_ID___"."users" AS u
                            INNER JOIN "___ORGANIZATION_ID___"."userOrganizations" AS uo ON u."id" = uo."userId" AND "organizationId" = organization_id AND uo."deletedAt" IS NULL
                            INNER JOIN "___ORGANIZATION_ID___"."roles" AS r ON uo."roleId" = r."id" AND r."deletedAt" IS NULL AND u."id" = NEW."userId") AS T;
                        END IF;
                    END IF;
                ELSIF (TG_OP = 'INSERT') THEN
                    IF EXISTS(SELECT 1 FROM "___ORGANIZATION_ID___"."userAccessRights"
                        WHERE "userId" = NEW."userId" AND "accessControlPointId" = NEW."accessControlPointId"
                        AND "deletedAt" IS NULL) THEN
                        RAISE EXCEPTION 'User access right  already exists';
                    END IF;
                    SELECT "deviceId" INTO device_id FROM "___ORGANIZATION_ID___"."accessControlPoints" WHERE id=NEW."accessControlPointId";
                    SELECT "organizationId" INTO organization_id FROM "___ORGANIZATION_ID___"."accessControlPoints" WHERE "id"=NEW."accessControlPointId";
                    IF (NEW."access" IS TRUE AND NEW."deletedAt" IS NULL)
                    THEN
                        -- send users has access rights
                        INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                        ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                        -- 1. user already has an access right for an access control point that is related with the device
                        -- Then, just send new access rights
                        SELECT uuid_generate_v4(), transaction_id, device_id, now(), 7,
                        json_build_object(
                            'id', NEW."id",
                            'userId', NEW."userId",
                            'accessControlPointId', NEW."accessControlPointId"
                        );
        
                        -- 1.1. find credentials those are not sent then sent new credentials
                        -- SELECT NEW AUTHENTICATION FACTORS OF ACP
                        FOR i IN SELECT * FROM jsonb_array_elements((SELECT acp."authenticationFactors"::jsonb
                            FROM "___ORGANIZATION_ID___"."accessControlPoints" AS acp
                            WHERE acp."id" = NEW."accessControlPointId"
                            AND acp."authenticationFactors" IS NOT NULL))
                        LOOP
                            i := i->'and';
                            FOR j IN SELECT * FROM jsonb_array_elements(i)
                            LOOP
                                factors_of_acp:= factors_of_acp || jsonb_build_object(
                                    'authenticatorType', "j"->'authenticatorType',
                                    'factor', (''|| CASE WHEN ("j"->'factor')::text = 0::text THEN '0' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 1::text THEN '1' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 2::text THEN '2' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 3::text THEN '3' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 4::text THEN '4' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 5::text THEN '5' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 6::text THEN '6' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 7::text THEN '9' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 8::text THEN '8' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 9::text THEN '9' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 10::text THEN '9' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 11::text THEN '9' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 12::text THEN '13' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 13::text THEN '17' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 14::text THEN '12' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 15::text THEN '15' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 16::text THEN '16' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 17::text THEN '17' ELSE '' END)
                                );
                            END LOOP;
                        END LOOP;
        
                        -- SELECT AUTHENTICATION FACTORS FROM OTHER ACP's THAT BELONGS TO SAME DEVICE
                        FOR i IN SELECT * FROM jsonb_array_elements((SELECT JSONB_AGG(acp."authenticationFactors"::jsonb)
                            FROM "___ORGANIZATION_ID___"."accessControlPoints" AS acp
                            INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uar."accessControlPointId" = acp.id
                            WHERE acp."deletedAt" IS NULL
                            AND acp."deviceId" = device_id
                            AND acp."id" != NEW."accessControlPointId"
                            AND acp."authenticationFactors" IS NOT NULL
                            AND uar."deletedAt" IS NULL
                            AND uar."userId" = NEW."userId"))
                        LOOP
                            FOR j IN SELECT * FROM jsonb_array_elements(i)
                            LOOP
                                j := j->'and';
                                FOR l IN SELECT * FROM jsonb_array_elements(j)
                                LOOP
                                    t1 := jsonb_build_object(
                                        'authenticatorType', "l"->'authenticatorType',
                                        'factor', (''|| CASE WHEN ("l"->'factor')::text = 0::text THEN '0' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 1::text THEN '1' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 2::text THEN '2' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 3::text THEN '3' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 4::text THEN '4' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 5::text THEN '5' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 6::text THEN '6' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 7::text THEN '9' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 8::text THEN '8' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 9::text THEN '9' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 10::text THEN '9' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 11::text THEN '9' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 12::text THEN '13' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 13::text THEN '17' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 14::text THEN '12' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 15::text THEN '15' ELSE '' END
                                                    || CASE WHEN ("l"->'factor')::text = 16::text THEN '16' ELSE '' END
                                                    || CASE WHEN ("j"->'factor')::text = 17::text THEN '17' ELSE '' END));
                                    IF (factors_of_other_acps IS NULL OR POSITION( t1::text IN factors_of_other_acps::text) < 1)
                                    THEN
                                        factors_of_other_acps:= factors_of_other_acps || t1;
                                    END IF;
                                END LOOP;
                            END LOOP;
                        END LOOP;
                        
                        FOR i IN SELECT * FROM jsonb_array_elements(factors_of_acp)
                        LOOP
                            IF (POSITION (i::text IN factors_of_other_acps::text) < 1) THEN
                                factors_to_send_to_device:= factors_to_send_to_device || i;
                            END IF;
                        END LOOP;
                        -- add new credentials for device
                        -- IF THERE ARE ADDED AUTHENTICATION FACTORS, SEND NEW CREDENTIALS
                        i:= jsonb_array_length(factors_to_send_to_device);
                        IF (jsonb_array_length(factors_to_send_to_device) > 0)
                        THEN
                            INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                            ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                            SELECT uuid_generate_v4(), transaction_id, device_id, now() as "actionDateISO", 1 as "type",
                            json_build_object(
                                'id', T."id",
                                'userId', T."userId",
                                'type', T."type",
                                'data', T."data",
                                'groupNumber', T."groupNumber",
                                'specialData', T."specialData",
                                'specialDataSecondary', T."specialDataSecondary",
                                'expiresOnISO', T."expiresOn",
                                'extensionFields', T."extensionFields"
                            ) AS "data" FROM
                            (SELECT uoc."id", uoc."type", uoc."data", uoc."groupNumber", uoc."specialData", uoc."userId",
                                uoc."specialDataSecondary", uoc."expiresOn", uoc."extensionFields"
                            FROM "___ORGANIZATION_ID___"."userOrganizationCredentials" AS uoc
                            INNER JOIN "___ORGANIZATION_ID___"."userOrganizations" AS uo ON uo."userId" = uoc."userId" AND uo."organizationId" = uoc."organizationId" AND uo."deletedAt" IS NULL
                            INNER JOIN "___ORGANIZATION_ID___"."roles" AS r ON uo."roleId" = r."id" AND r."deletedAt" IS NULL
                            WHERE uoc."deletedAt" IS NULL
                            AND uoc."userId" = NEW."userId"
                            AND POSITION(jsonb_build_object(
                                'authenticatorType', (CASE WHEN r."typeId" = '2a4ad5ff-1ced-45f8-992f-e19fc4e766d7'	OR r."typeId" = '9b8eebd7-057f-4021-ad6f-f2879733bdb9' THEN 2 ELSE 1 END),
                                'factor', uoc."type"::text)::text IN factors_to_send_to_device::text) > 0) AS T;
                        END IF;
                        
                            -- 2. users are new for that terminal
                            -- Then send add user
                        IF (jsonb_array_length(factors_of_other_acps) < 1) THEN
                            INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                            ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                            SELECT uuid_generate_v4(), transaction_id, device_id, now() as "actionDateISO", 5 as "type",
                                json_build_object(
                                    'user',
                                    json_build_object(
                                        'id', T."id",
                                        'roleId', T."roleId",
                                        'publicKey', T."publicKey",
                                        'isVisitor', T."isVisitor",
                                        'isDisabled', T."isDisabled",
                                        'userGroupIds', T."userGroupIds",
                                        'organizationUnitIds', T."organizationUnitIds",
                                        'accessRights', T."accessRights",
                                        'credentials', T."credentials",
                                        'coinBalances', T."coinBalances",
                                        'forbiddances', T."forbiddances",
                                        'accessRuleHistories', T."accessRuleHistories")
                                ) AS "data" FROM
                            (SELECT u."id", uo."roleId", u."publicKey", uo."isDisabled",
                            (CASE WHEN r."typeId" = '2a4ad5ff-1ced-45f8-992f-e19fc4e766d7'
                                OR r."typeId" = '9b8eebd7-057f-4021-ad6f-f2879733bdb9' THEN TRUE ELSE FALSE END) AS "isVisitor",
                            (SELECT JSON_AGG("userGroupId") FROM "___ORGANIZATION_ID___"."userGroupUserOrganizations" WHERE "userOrganizationId" = uo."id" AND "deletedAt" IS NULL) AS "userGroupIds",
                            (SELECT JSON_AGG("organizationUnitId") FROM "___ORGANIZATION_ID___"."userOrganizationOrganizationUnits" WHERE "userOrganizationId" = uo."id" AND "deletedAt" IS NULL) AS "organizationUnitIds",
                            (SELECT JSON_AGG(JSON_BUILD_OBJECT('id', uar."id",
                                                                'accessControlPointId', uar."accessControlPointId")) FROM "___ORGANIZATION_ID___"."userAccessRights" AS uar
                                            INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON acp."id" = "accessControlPointId" AND acp."deletedAt" IS NULL
                                        WHERE uar."userId" = u."id" AND acp."deviceId" = device_id AND uar."deletedAt" IS NULL AND acp."deletedAt" IS NULL  AND uar."access" = TRUE) AS "accessRights",
                            (SELECT JSON_AGG(json_build_object(
                                                'id', "id",
                                                'type', "type",
                                                'data', "data",
                                                'specialData', "specialData",
                                                'specialDataSecondary', "specialDataSecondary",
                                                'expiresOnISO', "expiresOn",
                                                'extensionFields', "extensionFields"
                            )) FROM "___ORGANIZATION_ID___"."userOrganizationCredentials" AS uoc WHERE "userId" = uo."userId" AND "organizationId" = uo."organizationId" AND "deletedAt" IS NULL
                                   AND POSITION(json_build_object(
                                    'authenticatorType', (CASE WHEN r."typeId" = '2a4ad5ff-1ced-45f8-992f-e19fc4e766d7'	OR r."typeId" = '9b8eebd7-057f-4021-ad6f-f2879733bdb9' THEN 2 ELSE 1 END),
                                    'factor', uoc."type"::text)::text IN factors_to_send_to_device::text) > 0) AS "credentials",
                            (SELECT JSON_AGG(json_build_object(
                                                'id', "id",
                                                'balance', "remainingUnits")) FROM "___ORGANIZATION_ID___"."userRegionTicketUnits" WHERE "userId" = uo."userId" AND "organizationId" = uo."organizationId") AS "coinBalances",
                            (SELECT JSON_AGG(json_build_object(
                                                'id', "id",
                                                'regionId', "regionId",
                                                'startDateISO', "startUtc",
                                                'endDateISO', "endUtc",
                                                'credentialIds', "credentialIds")) FROM "___ORGANIZATION_ID___"."userOrganizationForbiddances" WHERE "userId" = uo."userId" AND "organizationId" = uo."organizationId" AND "deletedAt" IS NULL) AS "forbiddances",
                            (SELECT JSON_AGG(
                                json_build_object(
                                                'ruleId', arh."accessRuleId",
                                                'count', arh."count",
                                                'actionDateISO', arh."createdDate"
                            )) FROM "___ORGANIZATION_ID___"."accessRuleHistory" AS arh
                            INNER JOIN "___ORGANIZATION_ID___"."accessRules" AS ar ON arh."accessRuleId" = ar."id" AND ar."deletedAt" IS NULL AND arh."userId" = uo."userId"
                            INNER JOIN "___ORGANIZATION_ID___"."accessRuleSets" AS ars ON ar."accessRuleSetId" = ars."id" AND ars."deletedAt" IS NULL
                            AND ars."organizationId" = uo."organizationId") AS "accessRuleHistories"
                            FROM
                            "___ORGANIZATION_ID___"."users" AS u
                            INNER JOIN "___ORGANIZATION_ID___"."userOrganizations" AS uo ON u."id" = uo."userId" AND "organizationId" = organization_id AND uo."deletedAt" IS NULL
                            INNER JOIN "___ORGANIZATION_ID___"."roles" AS r ON uo."roleId" = r."id" AND r."deletedAt" IS NULL AND u."id" = NEW."userId"
                            ) AS T;
                        END IF;
                    END IF;
                END IF;
                RETURN NEW;
            END;
$BODY$;

ALTER FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_access_rights()
    OWNER TO ${dbsuperuser};

GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_access_rights() TO ${dbsuperuser};

GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_access_rights() TO PUBLIC;

GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_access_rights() TO ${dbuser};




-- FUNCTION: ___ORGANIZATION_ID___.before_up_in_del_user_organization_credentials()
-- DROP FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_organization_credentials();
CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_organization_credentials()
    RETURNS trigger
    LANGUAGE 'plpgsql'
    COST 100
    VOLATILE NOT LEAKPROOF
AS $BODY$
DECLARE
				transaction_id	uuid;
				t_factors		text;
				factors 		text[];
				credential_one_time_assignable_status boolean;
				organization_license_settings	jsonb;
				active_credential_count	integer;
				base_module_max_count	integer;
				BEGIN
					transaction_id := uuid_generate_v4();
					IF (TG_OP = 'DELETE') THEN
						INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
						("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
						SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 2,
							JSON_BUILD_OBJECT('id', OLD."id")
							FROM (SELECT acp."id", acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num
								FROM "___ORGANIZATION_ID___"."userOrganizationCredentials" AS uoc
								INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uoc."userId" = uar."userId"
								AND uar."deletedAt" IS NULL AND uoc."deletedAt" IS NULL AND uar."access" = true
								INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON acp."id" = uar."accessControlPointId"
								AND POSITION('"factor":' || uoc."type"::text IN acp."authenticationFactors"::text) > 1
								AND uoc."organizationId" = acp."organizationId" AND uoc."id" = OLD."id")
							AS T
						WHERE T."row_num" = 1;
						RETURN OLD;
					ELSIF (TG_OP = 'UPDATE') THEN
						IF NEW."userId" != OLD."userId"
						OR NEW."organizationId" != OLD."organizationId"
						OR NEW."type" != OLD."type"
						OR NEW."data" != OLD."data"
						OR NEW."specialData" != OLD."specialData"
						OR NEW."specialDataSecondary" != OLD."specialDataSecondary"
						THEN
							RAISE EXCEPTION 'userId, organizationId, type, data, specialData, specialDataSecondary can not be changed';
						END IF;

						----- One Time Assignable setting, support added for METU UHF credentials!
						IF (OLD."deletedAt" IS NOT NULL AND NEW."deletedAt" IS NULL)
						THEN
							credential_one_time_assignable_status := (
								SELECT CASE WHEN ((T1.element->'oneTimeAssignable')::jsonb) IS NOT NULL 
									THEN ((T1.element->'oneTimeAssignable')::jsonb)::boolean ELSE FALSE END 
								FROM (SELECT json_array_elements("credentialTypes") as element FROM "___ORGANIZATION_ID___".organizations) T1
								WHERE ((element->'type')::JSONB)::INTEGER = NEW.type
							);
							IF(credential_one_time_assignable_status IS TRUE) THEN
									RAISE EXCEPTION '20000'; -- Check appweb ErrorCode enums for detail
							END IF;
						END IF;	
						----- One Time Assignable setting, support added for METU UHF credentials!
						
						----- License limit control logic!
						IF (
							NOT (SELECT r."typeId" FROM "___ORGANIZATION_ID___"."roles" AS r
								INNER JOIN  "___ORGANIZATION_ID___"."userOrganizations" AS uo
								ON uo."roleId" = r.id
								WHERE uo."deletedAt" IS NULL AND
									r."deletedAt" IS NULL AND
									NEW."userId" = uo."userId") = ANY(ARRAY['2a4ad5ff-1ced-45f8-992f-e19fc4e766d7', '9b8eebd7-057f-4021-ad6f-f2879733bdb9']::UUID[])
							AND 
							(
								(OLD."deletedAt" IS NOT NULL AND NEW."deletedAt" IS NULL) OR 
								(NEW."expiresOn" IS NULL AND OLD."expiresOn" IS NOT NULL) OR
								(NEW."expiresOn" IS NOT NULL AND NEW."expiresOn" > now())
							) 
						)
						THEN
							SELECT "settings"->'organizationLicenseSettings' INTO organization_license_settings
							FROM "___ORGANIZATION_ID___"."organizations" LIMIT 1;
						
							IF ((organization_license_settings->'licenseControlPolicy'):: INTEGER = 2 ) THEN
								
								SELECT COUNT (*) FILTER (WHERE NOT uoc."type" = ANY(ARRAY[2,8,12]::INTEGER[])) + 
								COUNT (DISTINCT (uoc."userId")) FILTER (WHERE uoc."type" = ANY(ARRAY[2,8,12]::INTEGER[])) INTO active_credential_count
								FROM "___ORGANIZATION_ID___"."userOrganizationCredentials" AS uoc
								INNER JOIN "___ORGANIZATION_ID___"."userOrganizations" AS uo
									ON uo."userId" = uoc."userId"
								INNER JOIN "___ORGANIZATION_ID___"."roles" AS r
									ON r."id" = uo."roleId"
								WHERE uoc."deletedAt" IS NULL
									AND ("expiresOn" IS NULL OR "expiresOn" > now())
									AND NOT r."typeId" = ANY(ARRAY['2a4ad5ff-1ced-45f8-992f-e19fc4e766d7', '9b8eebd7-057f-4021-ad6f-f2879733bdb9']::UUID[])
									AND uo."deletedAt" IS NULL
									AND r."deletedAt" IS NULL
									AND uo."isDisabled" = FALSE;
								
								SELECT "maxCredentialCount" INTO base_module_max_count
									FROM "___ORGANIZATION_ID___"."organizationModules"
									WHERE "module" = 0 /* ArmonApplicationModule.Base */ LIMIT 1;
								IF (active_credential_count >= 
									base_module_max_count + (base_module_max_count * (organization_license_settings->'exceedPercentage')::INTEGER / 100)) THEN
									RAISE EXCEPTION '20001'; -- Check appweb ErrorCode enums for detail
								END IF;
							END IF;
						END IF;
						----- License limit control logic!
							 
						IF (OLD."deletedAt" IS NULL AND NEW."deletedAt" IS NOT NULL)
						THEN							
							INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
							("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
							SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 2,
							JSON_BUILD_OBJECT('id', OLD."id")
							FROM (SELECT acp."id", acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num
								FROM "___ORGANIZATION_ID___"."userOrganizationCredentials" AS uoc
								INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uoc."userId" = uar."userId"
								AND uar."deletedAt" IS NULL AND uoc."deletedAt" IS NULL  AND uar."access" = true
								INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON acp."id" = uar."accessControlPointId"
								AND POSITION('"factor":' || uoc."type"::text IN acp."authenticationFactors"::text) > 1
								AND uoc."organizationId" = acp."organizationId" AND uoc."id" = OLD."id")
							AS T
							WHERE T."row_num" = 1;
						END IF;
			
						IF (OLD."expiresOn" IS DISTINCT FROM NEW."expiresOn" OR
							OLD."groupNumber" IS DISTINCT FROM NEW."groupNumber" OR 
							NOT (to_jsonb(OLD."extensionFields") @> to_jsonb(NEW."extensionFields") 
									AND to_jsonb(OLD."extensionFields") <@ to_jsonb(NEW."extensionFields")))
						THEN
							INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
							("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
							SELECT uuid_generate_v4(),transaction_id, T."deviceId", now(), 22,
								JSON_BUILD_OBJECT(	'id', OLD."id", 
														'expiresOnISO', NEW."expiresOn",
														'groupNumber', NEW."groupNumber",
														'extensionFields', NEW."extensionFields")
							FROM (SELECT acp."id", acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num
								FROM "___ORGANIZATION_ID___"."userOrganizationCredentials" AS uoc
								INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uoc."userId" = uar."userId"
								AND uar."deletedAt" IS NULL AND uoc."deletedAt" IS NULL AND uar."access" = true
								INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON acp."id" = uar."accessControlPointId"
								AND POSITION('"factor":' || uoc."type"::text IN acp."authenticationFactors"::text) > 1
								AND uoc."organizationId" = acp."organizationId" AND uoc."id" = OLD."id")
							AS T
							WHERE T."row_num" = 1;
						END IF;
					ELSIF (TG_OP = 'INSERT') THEN
						IF (NEW."deletedAt" IS NULL)
						THEN
						
							----- One Time Assignable setting, support added for METU UHF credentials!
							credential_one_time_assignable_status := (
								SELECT CASE WHEN ((T1.element->'oneTimeAssignable')::jsonb) IS NOT NULL 
									THEN ((T1.element->'oneTimeAssignable')::jsonb)::boolean ELSE FALSE END 
								FROM (SELECT json_array_elements("credentialTypes") as element FROM "___ORGANIZATION_ID___".organizations) T1
								WHERE ((element->'type')::JSONB)::INTEGER = NEW.type
							);
							IF EXISTS(SELECT FROM "___ORGANIZATION_ID___"."userOrganizationCredentials"
										WHERE "type" = NEW."type" AND "data" = NEW."data"
										AND "organizationId" = NEW."organizationId"
										AND "deletedAt" IS NULL
										AND ("type" NOT IN (13,10,14,9,11,7,2,8) OR "specialData" = NEW."specialData")) THEN
											RAISE EXCEPTION '20002'; -- Check appweb ErrorCode enums for detail
								ELSIF(credential_one_time_assignable_status IS TRUE AND 
									EXISTS (SELECT id FROM "___ORGANIZATION_ID___"."userOrganizationCredentials" WHERE data = NEW.data)  ) THEN
										RAISE EXCEPTION '20000'; -- Check appweb ErrorCode enums for detail
							END IF;
							
							----- One Time Assignable setting, support added for METU UHF credentials!

							----- Delete old mobile credentials to prevent duplicates!
							IF EXISTS(SELECT FROM "___ORGANIZATION_ID___"."userOrganizationCredentials"
								WHERE "type" = NEW."type" AND "data" = NEW."data"
								AND "organizationId" = NEW."organizationId"
								AND "deletedAt" IS NULL AND "type" IN (2,8,12)) THEN
								
								UPDATE "___ORGANIZATION_ID___"."userOrganizationCredentials" SET "deletedAt" = now()
								WHERE "userId" = NEW."userId" AND "organizationId" = NEW."organizationId"
									AND "type" = NEW."type" AND "deletedAt" IS NULL;
							END IF;
							----- Delete old mobile credentials to prevent duplicates!
							
							----- License limit control logic!
							SELECT "settings"->'organizationLicenseSettings' INTO organization_license_settings
							FROM "___ORGANIZATION_ID___"."organizations" LIMIT 1;
						
							IF (
								NOT (SELECT r."typeId" FROM "___ORGANIZATION_ID___"."roles" AS r
								INNER JOIN  "___ORGANIZATION_ID___"."userOrganizations" AS uo
								ON uo."roleId" = r.id
								WHERE uo."deletedAt" IS NULL AND
									r."deletedAt" IS NULL AND
									NEW."userId" = uo."userId") = ANY(ARRAY['2a4ad5ff-1ced-45f8-992f-e19fc4e766d7', '9b8eebd7-057f-4021-ad6f-f2879733bdb9']::UUID[])
								AND 
								(organization_license_settings->'licenseControlPolicy'):: INTEGER = 2 
							) THEN
								
								SELECT COUNT (*) FILTER (WHERE NOT uoc."type" = ANY(ARRAY[2,8,12]::INTEGER[])) + 	-- mobile credentials
								COUNT (DISTINCT (uoc."userId")) FILTER (WHERE uoc."type" = ANY(ARRAY[2,8,12]::INTEGER[])) INTO active_credential_count
								FROM "___ORGANIZATION_ID___"."userOrganizationCredentials" AS uoc
								INNER JOIN "___ORGANIZATION_ID___"."userOrganizations" AS uo
									ON uo."userId" = uoc."userId"
								INNER JOIN "___ORGANIZATION_ID___"."roles" AS r
									ON r."id" = uo."roleId"
								WHERE uoc."deletedAt" IS NULL
									AND ("expiresOn" IS NULL OR "expiresOn" > now())
									AND NOT r."typeId" = ANY(ARRAY['2a4ad5ff-1ced-45f8-992f-e19fc4e766d7', '9b8eebd7-057f-4021-ad6f-f2879733bdb9']::UUID[]) -- visitor type id's
									AND uo."deletedAt" IS NULL
									AND r."deletedAt" IS NULL
									AND uo."isDisabled" = FALSE;
								
								SELECT "maxCredentialCount" INTO base_module_max_count
									FROM "___ORGANIZATION_ID___"."organizationModules"
									WHERE "module" = 0 /* ArmonApplicationModule.Base */ LIMIT 1;
								IF (active_credential_count >= 
									base_module_max_count + (base_module_max_count * (organization_license_settings->'exceedPercentage')::INTEGER / 100)) THEN
									RAISE EXCEPTION '20001'; -- Check appweb ErrorCode enums for detail
								END IF;
							END IF;
							----- License limit control logic!

							INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
							("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
							SELECT uuid_generate_v4(), transaction_id, T."deviceId", now() as "actionDateISO", 1 as "type",
							json_build_object(
								'id', T."id",
								'userId', T."userId",
								'type', T."type",
								'data', T."data",
								'groupNumber', T."groupNumber",
								'specialData', T."specialData",
								'specialDataSecondary', T."specialDataSecondary",
								'expiresOnISO', T."expiresOn",
								'extensionFields', T."extensionFields"
							) AS "data" FROM
							(SELECT NEW."id", NEW."type", NEW."data", NEW."specialData", NEW."userId", NEW."groupNumber",
							NEW."specialDataSecondary", NEW."expiresOn", NEW."extensionFields", T2."deviceId"
							FROM
								(SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num
									FROM "___ORGANIZATION_ID___"."userAccessRights" AS uar
									INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON acp."id" = uar."accessControlPointId"
									AND POSITION('"factor":' || (CASE WHEN NEW."type" = 12 THEN '14' ELSE NEW."type"::text END) IN acp."authenticationFactors"::text) > 1
									AND NEW."organizationId" = acp."organizationId" AND uar."access" = true
									WHERE NEW."userId" = uar."userId" AND uar."deletedAt" IS NULL
									) AS T2
								WHERE T2.row_num=1
								) AS T;
						END IF;
					END IF;
					RETURN NEW;
				END;
$BODY$;

ALTER FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_organization_credentials()
    OWNER TO ${dbsuperuser};
GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_organization_credentials() TO ${dbsuperuser};
GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_organization_credentials() TO PUBLIC;
GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_organization_credentials() TO ${dbuser};



   `;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, q, "___ORGANIZATION_ID___");
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) {
}
exports.down = down;
