"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const dal_utils_1 = require("../../../dal.utils");
async function up(client, dbuser, dbsuperuser) {
    const q = `

-- FUNCTION: ___ORGANIZATION_ID___.before_up_in_del_user_region_ticket_unit()
-- DROP FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_region_ticket_unit();
CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_region_ticket_unit()
    RETURNS trigger
    LANGUAGE 'plpgsql'
    COST 100
    VOLATILE NOT LEAKPROOF
AS $BODY$
DECLARE
    transaction_id		uuid;
    user_id				uuid;
    region_ticket_id	uuid;
    BEGIN
        transaction_id := uuid_generate_v4();
        IF (TG_OP = 'DELETE') THEN
            user_id:= OLD."userId";
            INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
            ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
            SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 12, T."data"
            FROM
            (
                SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                    JSON_BUILD_OBJECT(
                    'userIds', ('["' || user_id || '"]')::json,
                    'amount', 0
                ) AS "data"
				FROM "___ORGANIZATION_ID___"."regionTickets" AS rt
				INNER JOIN "___ORGANIZATION_ID___"."regionAccessControlPoints" AS racp ON racp."regionId" = rt."regionId"
				INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uar."accessControlPointId" = racp."accessControlPointId" AND uar."deletedAt" IS NULL
				INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON acp."id" = uar."accessControlPointId" AND acp."deletedAt" IS NULL
				INNER JOIN "___ORGANIZATION_ID___"."userOrganizations" AS uo ON uo."userId" = uar."userId" AND uo."organizationId" = rt."organizationId" AND uo."deletedAt" IS NULL
				WHERE
					rt."deletedAt" IS NULL AND
					rt."organizationId" = OLD."organizationId" AND
					uar."userId" = OLD."userId"
            ) AS T
            WHERE T."row_num" = 1;
            RETURN OLD;
        ELSIF (TG_OP = 'INSERT') THEN

            user_id:= NEW."userId";

            INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
            ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
            SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 12, T."data"
            FROM
            (
                SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                    JSON_BUILD_OBJECT(
                    'userIds', ('["' || user_id || '"]')::json,
                    'amount', NEW."remainingUnits"
                ) AS "data"
				FROM "___ORGANIZATION_ID___"."regionTickets" AS rt
				INNER JOIN "___ORGANIZATION_ID___"."regionAccessControlPoints" AS racp ON racp."regionId" = rt."regionId"
				INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uar."accessControlPointId" = racp."accessControlPointId" AND uar."deletedAt" IS NULL
				INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON acp."id" = uar."accessControlPointId" AND acp."deletedAt" IS NULL
				INNER JOIN "___ORGANIZATION_ID___"."userOrganizations" AS uo ON uo."userId" = uar."userId" AND uo."organizationId" = rt."organizationId" AND uo."deletedAt" IS NULL
				WHERE
					rt."deletedAt" IS NULL AND
					rt."organizationId" = NEW."organizationId" AND
					uar."userId" = NEW."userId"
				--FROM "___ORGANIZATION_ID___"."userOrganizations" AS uo
                --INNER JOIN "___ORGANIZATION_ID___"."users" AS u ON uo."userId" = u."id" AND uo."deletedAt" IS NULL AND u."deletedAt" IS NULL
                --INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uar."userId" = uo."userId" AND uar."deletedAt" IS NULL
                --INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON uar."accessControlPointId" = acp."id" AND acp."deletedAt" IS NULL
                --INNER JOIN "___ORGANIZATION_ID___"."regionTickets" AS rt ON rt."accessControlPointId" = acp."id" AND acp."deletedAt" IS NULL
                --WHERE uo."organizationId" = NEW."organizationId" AND u."id" = NEW."userId"
            ) AS T
            WHERE T."row_num" = 1;
            RETURN NEW;
        ELSIF (TG_OP = 'UPDATE') THEN
            user_id:= NEW."userId";

            IF (NEW."remainingUnits" != OLD."remainingUnits" AND NOT NEW."totalSpentUnits" IS DISTINCT FROM OLD."totalSpentUnits")
            THEN
                INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 12, T."data"
                FROM
                (
                    SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                    JSON_BUILD_OBJECT(
                        'userIds', ('["' || user_id || '"]')::json,
                        'amount', NEW."lastUpdateAmount"
                    ) AS "data"
					FROM "___ORGANIZATION_ID___"."regionTickets" AS rt
					INNER JOIN "___ORGANIZATION_ID___"."regionAccessControlPoints" AS racp ON racp."regionId" = rt."regionId"
					INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uar."accessControlPointId" = racp."accessControlPointId" AND uar."deletedAt" IS NULL
					INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON acp."id" = uar."accessControlPointId" AND acp."deletedAt" IS NULL
					INNER JOIN "___ORGANIZATION_ID___"."userOrganizations" AS uo ON uo."userId" = uar."userId" AND uo."organizationId" = rt."organizationId" AND uo."deletedAt" IS NULL
					WHERE
						rt."deletedAt" IS NULL AND
						rt."organizationId" = NEW."organizationId" AND
						uar."userId" = NEW."userId"
                ) AS T
            	WHERE T."row_num" = 1;
            ELSIF (NEW."totalSpentUnits" IS DISTINCT FROM OLD."totalSpentUnits"
                    AND NEW."lastUpdateAccessControlPointId" IS NOT NULL)
            THEN
                SELECT rt."id" INTO region_ticket_id
                FROM "___ORGANIZATION_ID___"."regionTickets" AS rt
                INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON acp."id" = NEW."lastUpdateAccessControlPointId"
                INNER JOIN "___ORGANIZATION_ID___"."regionAccessControlPoints" AS racp ON racp."accessControlPointId" =  acp."id" AND racp."regionId" = rt."regionId"
                WHERE rt."deletedAt" IS NULL AND acp."deletedAt" IS NULL;

                INSERT INTO "___ORGANIZATION_ID___"."terminalChanges"
                ("id", "transactionId", "deviceId", "actionDateISO", "type", "data")
                SELECT uuid_generate_v4(), transaction_id, T."deviceId", now(), 13, T."data"
                FROM
                (
                    SELECT acp."deviceId", ROW_NUMBER() OVER (PARTITION BY acp."deviceId") AS row_num,
                    JSON_BUILD_OBJECT(
                        'userId', user_id,
                        'ticketId', region_ticket_id,
                        'amount', (OLD."remainingUnits" - NEW."remainingUnits")
                    ) AS "data"
                    FROM "___ORGANIZATION_ID___"."regionTickets" AS rt
					INNER JOIN "___ORGANIZATION_ID___"."regionAccessControlPoints" AS racp ON racp."regionId" = rt."regionId"
					INNER JOIN "___ORGANIZATION_ID___"."userAccessRights" AS uar ON uar."accessControlPointId" = racp."accessControlPointId" AND uar."deletedAt" IS NULL
					INNER JOIN "___ORGANIZATION_ID___"."accessControlPoints" AS acp ON acp."id" = uar."accessControlPointId" AND acp."deletedAt" IS NULL
					INNER JOIN "___ORGANIZATION_ID___"."userOrganizations" AS uo ON uo."userId" = uar."userId" AND uo."organizationId" = rt."organizationId" AND uo."deletedAt" IS NULL
					WHERE
						rt."deletedAt" IS NULL AND
						rt."organizationId" = NEW."organizationId" AND
						uar."userId" = NEW."userId" AND
						acp."id" != NEW."lastUpdateAccessControlPointId"
                ) AS T
				WHERE T."row_num" = 1;
            END IF;
            RETURN NEW;
        END IF;
    END;
$BODY$;

ALTER FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_region_ticket_unit()
    OWNER TO ${dbsuperuser};

GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_region_ticket_unit() TO ${dbsuperuser};

GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_region_ticket_unit() TO PUBLIC;

GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".before_up_in_del_user_region_ticket_unit() TO ${dbuser};


   `;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, q, "___ORGANIZATION_ID___");
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) {
}
exports.down = down;
