"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const dal_utils_1 = require("../../../dal.utils");
async function up(client, dbuser, dbsuperuser) {
    const q = `

    CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".after_up_del_user_organization()
        RETURNS trigger
        LANGUAGE 'plpgsql'
        COST 100
        VOLATILE NOT LEAKPROOF
    AS $BODY$
    BEGIN
            IF (TG_OP = 'UPDATE' AND (                    
                    NEW."deletedAt" != OLD."deletedAt" OR 
                    NEW."roleId" != OLD."roleId" OR 
                    NEW."isDisabled" != OLD."isDisabled" OR 
                    NEW.settings != OLD.settings
                    )) THEN
                PERFORM PG_NOTIFY('update_user_info_cache', JSON_BUILD_OBJECT('id', NEW."userId", 'organizationId', TG_TABLE_SCHEMA)::text);								  		
            ELSIF (TG_OP = 'DELETE') THEN
                PERFORM PG_NOTIFY('update_user_info_cache', JSON_BUILD_OBJECT('id', OLD."userId", 'organizationId', TG_TABLE_SCHEMA)::text);								  		
            END IF;
        RETURN NEW;
        END;
    $BODY$;

    ALTER FUNCTION "___ORGANIZATION_ID___".after_up_del_user_organization()
        OWNER TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".after_up_del_user_organization() TO ${dbsuperuser};

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".after_up_del_user_organization() TO PUBLIC;

    GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".after_up_del_user_organization() TO ${dbuser};


   `;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, q, "___ORGANIZATION_ID___");
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) {
}
exports.down = down;
