"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const app_logs_1 = require("../../../../app.logs");
const dal_utils_1 = require("../../../dal.utils");
async function up(client, dbuser, dbsuperuser) {
    app_logs_1.logger.debug("This migration may take longer than usual");
    await client.query(`


	------------------------ UPDATE public notification_instance history Trigger ----------------------
	CREATE OR REPLACE FUNCTION public.zz_notification_instance()
		RETURNS trigger
		LANGUAGE 'plpgsql'
		COST 100
		VOLATILE NOT LEAKPROOF
		AS $BODY$
		DECLARE
			_now timestamp without time zone;
		BEGIN   
			_now := now();
			IF (TG_OP = 'INSERT' AND NOT EXISTS (SELECT id FROM "public".notification_instance WHERE id = NEW.id)) THEN 
			INSERT INTO public.zz_notification_instance
				(
					id,
					action,
					"actionT",
					"transactionId",
					"createdT",
					"organizationId",
					state,
					note
				)
				VALUES(
					NEW.id,
					1,
					_now,
					txid_current(),
					NEW."createdT",
					NEW."organizationId",
					NEW.state,
					NEW.note
				);
			ELSIF (TG_OP = 'UPDATE' AND 
					(NEW.id IS DISTINCT FROM OLD.id OR
					NEW."createdT" IS DISTINCT FROM OLD."createdT" OR
					NEW."organizationId" IS DISTINCT FROM OLD."organizationId" OR
					NEW.state IS DISTINCT FROM OLD.state OR
					NEW.note::text IS DISTINCT FROM OLD.note::text)) THEN
				INSERT INTO public.zz_notification_instance
				(
					id,
					action,
					"actionT",
					"transactionId",
					"createdT",
					"organizationId",
					state,
					note
				)
				VALUES(
					NEW.id,
					2,
					_now,
					txid_current(),
					NEW."createdT",
					NEW."organizationId",
					NEW.state,
					NEW.note
				);    
			ELSIF (TG_OP = 'DELETE') THEN
				INSERT INTO public.zz_notification_instance
				(
					id,
					action,
					"actionT",
					"transactionId",
					"createdT",
					"organizationId",
					state,
					note
				)
				VALUES(
					OLD.id,
					3,
					_now,
					txid_current(),
					OLD."createdT",
					OLD."organizationId",
					OLD.state,
					OLD.note
				);       
			END IF;    
			RETURN NULL;
		END;
	$BODY$;

	ALTER FUNCTION public.zz_notification_instance()
		OWNER TO ${dbsuperuser};

	GRANT EXECUTE ON FUNCTION public.zz_notification_instance() TO ${dbsuperuser};

	GRANT EXECUTE ON FUNCTION public.zz_notification_instance() TO PUBLIC;

	GRANT EXECUTE ON FUNCTION public.zz_notification_instance() TO ${dbuser};


	------------------ CLEAR MULTIPLE INSERT LOGS --------------------
	DELETE FROM public.zz_notification_instance zpni
	USING (SELECT id, max("actionT") AS "actionT" FROM public.zz_notification_instance
			WHERE action = 1
			GROUP BY id
			HAVING count(id) > 1
		) T
	WHERE T.id = zpni.id AND T."actionT" = zpni."actionT"
	
	`);
    const query = `

	------------------------ UPDATE schema notification history trigger function ----------------------
	
	CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".zz_notification()
		RETURNS trigger
		LANGUAGE 'plpgsql'
		COST 100
		VOLATILE NOT LEAKPROOF
	AS $BODY$
	DECLARE
		_now timestamp without time zone;
	BEGIN
		_now:= now();
		IF(TG_OP = 'INSERT' AND NOT EXISTS (SELECT id FROM "___ORGANIZATION_ID___".notification WHERE id = NEW.id)) THEN
			INSERT INTO "___ORGANIZATION_ID___".zz_notification
				(
					id,
					action,
					"actionT",
					"transactionId",
					"createdT",
					type,
					"createdByUserId",
					"receiverFilterId",
					"settings",
					email,
					sms,
					web,
					"pushNotification"
				)
				VALUES(
					NEW.id,
					1,
					_now,
					txid_current(),
					NEW."createdT",
					NEW.type,
					NEW."createdByUserId",
					NEW."receiverFilterId",
					NEW."settings",
					NEW.email,
					NEW.sms,
					NEW.web,
					NEW."pushNotification"
				);
		ELSIF(TG_OP = 'UPDATE' AND (
			NEW.id IS DISTINCT FROM OLD.id OR
			NEW."createdT" IS DISTINCT FROM OLD."createdT" OR
			NEW."createdByUserId" IS DISTINCT FROM OLD."createdByUserId" OR
			NEW.type IS DISTINCT FROM OLD.type OR
			NEW."receiverFilterId" IS DISTINCT FROM OLD."receiverFilterId" OR
			NEW.settings::text IS DISTINCT FROM OLD.settings::text OR
			NEW.email IS DISTINCT FROM OLD.email OR
			NEW.sms IS DISTINCT FROM OLD.sms OR
			NEW.web IS DISTINCT FROM OLD.web OR
			NEW."pushNotification" IS DISTINCT FROM OLD."pushNotification"
		)) THEN
			INSERT INTO "___ORGANIZATION_ID___".zz_notification
				(
					id,
					action,
					"actionT",
					"transactionId",
					"createdT",
					type,
					"createdByUserId",
					"receiverFilterId",
					"settings",
					email,
					sms,
					web,
					"pushNotification"
				)
				VALUES(
					NEW.id,
					2,
					_now,
					txid_current(),
					NEW."createdT",
					NEW.type,
					NEW."createdByUserId",
					NEW."receiverFilterId",
					NEW."settings",
					NEW.email,
					NEW.sms,
					NEW.web,
					NEW."pushNotification"
				);
		ELSIF(TG_OP = 'DELETE') THEN
			INSERT INTO "___ORGANIZATION_ID___".zz_notification
				(
					id,
					action,
					"actionT",
					"transactionId",
					"createdT",
					type,
					"createdByUserId",
					"receiverFilterId",
					"settings",
					email,
					sms,
					web,
					"pushNotification"
				)
				VALUES(
					OLD.id,
					3,
					_now,
					txid_current(),
					OLD."createdT",
					OLD.type,
					OLD."createdByUserId",
					OLD."receiverFilterId",
					OLD."settings",
					OLD.email,
					OLD.sms,
					OLD.web,
					OLD."pushNotification"
				);
		END IF;
		RETURN NULL;
	END;
	$BODY$;

	ALTER FUNCTION "___ORGANIZATION_ID___".zz_notification()
	OWNER TO ${dbsuperuser};

	GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".zz_notification() TO ${dbsuperuser};

	GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".zz_notification() TO PUBLIC;

	GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".zz_notification() TO ${dbuser};

	------------------------ UPDATE organization notification access history trigger function ----------------------

	CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".zz_notification_access()
		RETURNS trigger
		LANGUAGE 'plpgsql'
		COST 100
		VOLATILE NOT LEAKPROOF
		AS $BODY$
		DECLARE
			_now timestamp without time zone;
		BEGIN   
			_now := now();
			IF (TG_OP = 'INSERT' AND NOT EXISTS (SELECT id FROM "___ORGANIZATION_ID___".notification_access WHERE id = NEW.id)) THEN
				INSERT INTO "___ORGANIZATION_ID___".zz_notification_access
				(
					id,
					action,
					"actionT",
					"transactionId",
					"targetUserId",
					"regionId",
					options 
				)
				VALUES(
					NEW.id,
					1,
					_now,
					txid_current(),
					NEW."targetUserId",
					NEW."regionId",
					NEW.options
				);
			ELSIF (TG_OP = 'UPDATE' AND (
				NEW.id IS DISTINCT FROM OLD.id OR
				NEW."targetUserId" IS DISTINCT FROM OLD."targetUserId" OR
				NEW."regionId" IS DISTINCT FROM OLD."regionId" OR
				NEW.options::text IS DISTINCT FROM OLD.options::text
			)) THEN
				INSERT INTO "___ORGANIZATION_ID___".zz_notification_access
				(
					id,
					action,
					"actionT",
					"transactionId",
					"targetUserId",
					"regionId",
					options
				)
				VALUES(
					NEW.id,
					2,
					_now,
					txid_current(),
					NEW."targetUserId",
					NEW."regionId",
					NEW.options
				);    
			ELSIF (TG_OP = 'DELETE') THEN
				INSERT INTO "___ORGANIZATION_ID___".zz_notification_access
				(
					id,
					action,
					"actionT",
					"transactionId",
					"targetUserId",
					"regionId",
					options
				)
				VALUES(
					OLD.id,
					3,
					_now,
					txid_current(),
					OLD."targetUserId",
					OLD."regionId",
					OLD.options
				);       
			END IF;    
			RETURN NULL;
		END;
	$BODY$;

	ALTER FUNCTION "___ORGANIZATION_ID___".zz_notification_access()
		OWNER TO ${dbsuperuser};

	GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".zz_notification_access() TO ${dbsuperuser};

	GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".zz_notification_access() TO PUBLIC;

	GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".zz_notification_access() TO ${dbuser};

	------------------------ UPDATE organization notification sensor history trigger function ----------------------

	CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".zz_notification_sensor()
		RETURNS trigger
		LANGUAGE 'plpgsql'
		COST 100
		VOLATILE NOT LEAKPROOF
	AS $BODY$
	DECLARE
        _now timestamp without time zone;
    BEGIN   
        _now := now();
        IF (TG_OP = 'INSERT' AND NOT EXISTS (SELECT id FROM "___ORGANIZATION_ID___".notification_sensor WHERE id = NEW.id)) THEN
            INSERT INTO "___ORGANIZATION_ID___".zz_notification_sensor
            (
                id,
                action,
                "actionT",
                "transactionId",
                "accessControlPointId",
                "sensorType",
                "deviceDryContactInputId",
                options
            )
            VALUES(
                NEW.id,
                1,
                _now,
                txid_current(),
                NEW."accessControlPointId",
                NEW."sensorType",
                NEW."deviceDryContactInputId",
                NEW.options
            );
        ELSIF (TG_OP = 'UPDATE' AND (
			NEW.id IS DISTINCT FROM OLD.id OR
			NEW."accessControlPointId" IS DISTINCT FROM OLD."accessControlPointId" OR
			NEW."sensorType" IS DISTINCT FROM OLD."sensorType" OR
			NEW."deviceDryContactInputId" IS DISTINCT FROM OLD."deviceDryContactInputId" OR
			NEW."options"::text IS DISTINCT FROM OLD.options::text
		)) THEN
            INSERT INTO "___ORGANIZATION_ID___".zz_notification_sensor
            (
                id,
                action,
                "actionT",
                "transactionId",
                "accessControlPointId",
                "sensorType",
                "deviceDryContactInputId",
                options
            )
            VALUES(
                NEW.id,
                2,
                _now,
                txid_current(),
                NEW."accessControlPointId",
                NEW."sensorType",
                NEW."deviceDryContactInputId",
                NEW.options
            );    
        ELSIF (TG_OP = 'DELETE') THEN
            INSERT INTO "___ORGANIZATION_ID___".zz_notification_sensor
            (
                id,
                action,
                "actionT",
                "transactionId",
                "accessControlPointId",
                "sensorType",
                "deviceDryContactInputId",
                options
            )
            VALUES(
                OLD.id,
                3,
                _now,
                txid_current(),
                OLD."accessControlPointId",
                OLD."sensorType",
                OLD."deviceDryContactInputId",
                OLD.options
            );       
        END IF;    
        RETURN NULL;
    END;
	$BODY$;

	ALTER FUNCTION "___ORGANIZATION_ID___".zz_notification_sensor()
		OWNER TO ${dbsuperuser};

	GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".zz_notification_sensor() TO ${dbsuperuser};

	GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".zz_notification_sensor() TO PUBLIC;

	GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".zz_notification_sensor() TO ${dbuser};

	------------------------ UPDATE organization pacs notification scheduled job history trigger function ----------------------
	CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".zz_pacs_notification_scheduled_job()
		RETURNS trigger
		LANGUAGE 'plpgsql'
		COST 100
		VOLATILE NOT LEAKPROOF
		AS $BODY$
		DECLARE
			_now timestamp without time zone;
		BEGIN   
			_now := now();
			IF (TG_OP = 'INSERT' AND NOT EXISTS (SELECT id FROM "___ORGANIZATION_ID___".pacs_notification_scheduled_job WHERE id = NEW.id)) THEN
				INSERT INTO "___ORGANIZATION_ID___".zz_pacs_notification_scheduled_job
				(
					id,
					action,
					"actionT",
					"transactionId",
					"subjectedEmployeesFilterId"
				)
				VALUES(
					NEW.id,
					1,
					_now,
					txid_current(),
					NEW."subjectedEmployeesFilterId"
				);
			ELSIF (TG_OP = 'UPDATE' AND (
				NEW.id IS DISTINCT FROM OLD.id OR
				NEW."subjectedEmployeesFilterId" IS DISTINCT FROM OLD."subjectedEmployeesFilterId"
			)) THEN
				INSERT INTO "___ORGANIZATION_ID___".zz_pacs_notification_scheduled_job
				(
					id,
					action,
					"actionT",
					"transactionId",
					"subjectedEmployeesFilterId"
				)
				VALUES(
					NEW.id,
					2,
					_now,
					txid_current(),
					NEW."subjectedEmployeesFilterId"
				);    
			ELSIF (TG_OP = 'DELETE') THEN
				INSERT INTO "___ORGANIZATION_ID___".zz_pacs_notification_scheduled_job
				(
					id,
					action,
					"actionT",
					"transactionId",
					"subjectedEmployeesFilterId"
				)
				VALUES(
					OLD.id,
					3,
					_now,
					txid_current(),
					OLD."subjectedEmployeesFilterId"
				);       
			END IF;    
			RETURN NULL;
		END;
	$BODY$;

	ALTER FUNCTION "___ORGANIZATION_ID___".zz_pacs_notification_scheduled_job()
		OWNER TO ${dbsuperuser};

	GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".zz_pacs_notification_scheduled_job() TO ${dbsuperuser};

	GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".zz_pacs_notification_scheduled_job() TO PUBLIC;

	GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".zz_pacs_notification_scheduled_job() TO ${dbuser};

	------------------------ UPDATE user_organization_forbiddances history trigger ----------------------
	
	CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".zz_user_organization_forbiddances()
		RETURNS trigger
		LANGUAGE 'plpgsql'
		COST 100
		VOLATILE NOT LEAKPROOF
		AS $BODY$
		DECLARE
					_now timestamp without time zone;
				BEGIN   
					_now := now();
					IF (TG_OP = 'INSERT' AND NOT EXISTS (SELECT id FROM "___ORGANIZATION_ID___".user_organization_forbiddances WHERE id = NEW.id)) THEN
						INSERT INTO "___ORGANIZATION_ID___".zz_user_organization_forbiddances
						(
							id,
							action,
							"actionT",
							"transactionId",
							"userId",
							"createdAt",
							"updatedAt",
							"deletedAt",
							"startUtc",
							"endUtc",
							"regionId",
							note,
							"credentialIds"
						)
						VALUES(
							NEW.id,
							1,
							_now,
							txid_current(),
							NEW."userId",
							NEW."createdAt",
							NEW."updatedAt",
							NEW."deletedAt",
							NEW."startUtc",
							NEW."endUtc",
							NEW."regionId",
							NEW.note,
							NEW."credentialIds"
						);
					ELSIF (TG_OP = 'UPDATE' AND (
						NEW.id IS DISTINCT FROM OLD.id OR
						NEW."organizationId" IS DISTINCT FROM OLD."organizationId" OR
						NEW."userId" IS DISTINCT FROM OLD."userId" OR
						NEW."createdAt" IS DISTINCT FROM OLD."createdT" OR
						NEW."updatedAt" IS DISTINCT FROM OLD."updatedAt" OR
						NEW."deletedAt" IS DISTINCT FROM OLD."deletedAt" OR
						NEW."startUtc" IS DISTINCT FROM OLD."startUtc" OR
						NEW."endUtc" IS DISTINCT FROM OLD."endUtc" OR
						NEW."regionId" IS DISTINCT FROM OLD."regionId" OR
						NEW.note IS DISTINCT FROM OLD.note OR
						NEW."credentialIds"::text IS DISTINCT FROM OLD."credentialIds"::text
					)) THEN
						INSERT INTO "___ORGANIZATION_ID___".zz_user_organization_forbiddances
						(
							id,
							action,
							"actionT",
							"transactionId",
							"userId",
							"createdAt",
							"updatedAt",
							"deletedAt",
							"startUtc",
							"endUtc",
							"regionId",
							note ,
							"credentialIds"
						)
						VALUES(
							NEW.id,
							2,
							_now,
							txid_current(),
							NEW."userId",
							NEW."createdAt",
							NEW."updatedAt",
							NEW."deletedAt",
							NEW."startUtc",
							NEW."endUtc",
							NEW."regionId",
							NEW.note,
							NEW."credentialIds"
						);    
					ELSIF (TG_OP = 'DELETE') THEN
						INSERT INTO "___ORGANIZATION_ID___".zz_user_organization_forbiddances
						(
							id,
							action,
							"actionT",
							"transactionId",
							"userId",
							"createdAt",
							"updatedAt",
							"deletedAt",
							"startUtc",
							"endUtc",
							"regionId",
							note,
							"credentialIds"
						)
						VALUES(
							OLD.id,
							3,
							_now,
							txid_current(),
							OLD."userId",
							OLD."createdAt",
							OLD."updatedAt",
							OLD."deletedAt",
							OLD."startUtc",
							OLD."endUtc",
							OLD."regionId",
							OLD.note,
							OLD."credentialIds"
						);       
					END IF;    
					RETURN NULL;
					END;
	$BODY$;
	
	ALTER FUNCTION "___ORGANIZATION_ID___".zz_user_organization_forbiddances()
		OWNER TO ${dbsuperuser};
	
	GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".zz_user_organization_forbiddances() TO ${dbsuperuser};
	
	GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".zz_user_organization_forbiddances() TO PUBLIC;
	
	GRANT EXECUTE ON FUNCTION "___ORGANIZATION_ID___".zz_user_organization_forbiddances() TO ${dbuser};
	
	

	---------------------- notification event history ------------------------------

	CREATE TABLE "___ORGANIZATION_ID___".zz_notification_event
	(
		id uuid NOT NULL,
		action smallint NOT NULL,
		"actionT" timestamp without time zone NOT NULL,
		"transactionId" bigint NOT NULL,
		"createdT" timestamp without time zone NOT NULL,
		"finalizedT" timestamp without time zone,
		"receiverFilterId" uuid NOT NULL,
		"notificationId" uuid,
		"instanceData" jsonb
	) PARTITION BY RANGE ("actionT");

	ALTER TABLE "___ORGANIZATION_ID___".zz_notification_event
	OWNER to ${dbsuperuser};

	GRANT INSERT, DELETE, SELECT, UPDATE ON TABLE "___ORGANIZATION_ID___".zz_notification_event TO ${dbuser};

	GRANT ALL ON TABLE "___ORGANIZATION_ID___".zz_notification_event TO ${dbsuperuser};

	CREATE INDEX bx_zz_notification_event
	ON "___ORGANIZATION_ID___".zz_notification_event USING btree
	(id DESC NULLS LAST);

	CREATE TABLE "___ORGANIZATION_ID___".zz_notification_event_default PARTITION OF "___ORGANIZATION_ID___".zz_notification_event
	   DEFAULT;

	ALTER TABLE "___ORGANIZATION_ID___".zz_notification_event_default
	OWNER to ${dbsuperuser};
	
	CREATE TRIGGER after_insert_zz_notification_event_default
	AFTER INSERT
		ON "___ORGANIZATION_ID___".zz_notification_event_default
	FOR EACH ROW
		EXECUTE FUNCTION public.after_insert_default();

	
	CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".zz_notification_event() RETURNS trigger
	LANGUAGE plpgsql
	AS $$
	DECLARE
		_now timestamp without time zone;
	BEGIN   
		_now := now();
		IF (TG_OP = 'INSERT' AND NOT EXISTS (SELECT id FROM "___ORGANIZATION_ID___".notification_event WHERE id = NEW.id)) THEN
			INSERT INTO "___ORGANIZATION_ID___".zz_notification_event
			(
				id,
				action,
				"actionT",
				"transactionId",
				"createdT",
				"receiverFilterId",
				"notificationId",
				"instanceData",
				"finalizedT"
			)
			VALUES(
				NEW.id,
				1,
				_now,
				txid_current(),
				NEW."createdT",
				NEW."receiverFilterId",
				NEW."notificationId",
				NEW."instanceData",
				NEW."finalizedT"
			);
		ELSIF (TG_OP = 'UPDATE' AND (
			NEW.id IS DISTINCT FROM OLD.id OR
			NEW."createdT" IS DISTINCT FROM OLD."createdT" OR
			NEW."receiverFilterId" IS DISTINCT FROM OLD."receiverFilterId" OR
			NEW."notificationId" IS DISTINCT FROM OLD."notificationId" OR
			NEW."instanceData"::text IS DISTINCT FROM OLD."instanceData"::text
		)) THEN
			INSERT INTO "___ORGANIZATION_ID___".zz_notification_event
			(
				id,
				action,
				"actionT",
				"transactionId",
				"createdT",
				"receiverFilterId",
				"notificationId",
				"instanceData",
				"finalizedT"
			)
			VALUES(
				NEW.id,
				2,
				_now,
				txid_current(),
				NEW."createdT",
				NEW."receiverFilterId",
				NEW."notificationId",
				NEW."instanceData",
				NEW."finalizedT"
			);    
		ELSIF (TG_OP = 'DELETE') THEN
			INSERT INTO "___ORGANIZATION_ID___".zz_notification_event
			(
				id,
				action,
				"actionT",
				"transactionId",
				"createdT",
				"receiverFilterId",
				"notificationId",
				"instanceData",
				"finalizedT"
			)
			VALUES(
				OLD.id,
				3,
				_now,
				txid_current(),
				OLD."createdT",
				OLD."receiverFilterId",
				OLD."notificationId",
				OLD."instanceData",
				OLD."finalizedT"
			);       
		END IF;    
		RETURN NULL;
		END;
		$$;

		ALTER FUNCTION "___ORGANIZATION_ID___".zz_notification_event() OWNER TO ${dbsuperuser};

		GRANT ALL ON FUNCTION "___ORGANIZATION_ID___".zz_notification_event() TO ${dbuser};

		CREATE TRIGGER trg_99_zz_notification_event
			AFTER INSERT OR UPDATE OR DELETE
			ON "___ORGANIZATION_ID___"."notification_event"
			FOR EACH ROW
			EXECUTE FUNCTION "___ORGANIZATION_ID___".zz_notification_event();

	---------------------- schema notification instance history ------------------------------

	CREATE TABLE "___ORGANIZATION_ID___".zz_notification_instance
	(
		id uuid NOT NULL,
		action smallint NOT NULL,
		"actionT" timestamp without time zone NOT NULL,
		"transactionId" bigint NOT NULL,
		"createdT" timestamp without time zone NOT NULL,
		"mediumGroupId" uuid NOT NULL,
		medium SMALLINT NOT NULL,
		"notificationId" uuid NOT NULL,
		"receiverUserId" uuid NOT NULL,
		"content" jsonb,
		"eventId" uuid NOT NULL
	) PARTITION BY RANGE ("actionT");

	ALTER TABLE "___ORGANIZATION_ID___".zz_notification_instance
	OWNER to ${dbsuperuser};

	GRANT INSERT, DELETE, SELECT, UPDATE ON TABLE "___ORGANIZATION_ID___".zz_notification_instance TO ${dbuser};

	GRANT ALL ON TABLE "___ORGANIZATION_ID___".zz_notification_instance TO ${dbsuperuser};

	CREATE INDEX bx_zz_notification_instance
	ON "___ORGANIZATION_ID___".zz_notification_instance USING btree
	(id DESC NULLS LAST);

	CREATE TABLE "___ORGANIZATION_ID___".zz_notification_instance_default PARTITION OF "___ORGANIZATION_ID___".zz_notification_instance
	   DEFAULT;

	ALTER TABLE "___ORGANIZATION_ID___".zz_notification_instance_default
	OWNER to ${dbsuperuser};

	
	CREATE TRIGGER after_insert_zz_notification_instance_default
	AFTER INSERT
	ON "___ORGANIZATION_ID___".zz_notification_instance_default
	FOR EACH ROW
	EXECUTE FUNCTION public.after_insert_default();

	
	CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".zz_notification_instance() RETURNS trigger
	LANGUAGE plpgsql
	AS $$
	DECLARE
		_now timestamp without time zone;
	BEGIN   
		_now := now();
		IF (TG_OP = 'INSERT' AND NOT EXISTS (SELECT id FROM "___ORGANIZATION_ID___".notification_instance WHERE id = NEW.id)) THEN
			INSERT INTO "___ORGANIZATION_ID___".zz_notification_instance
			(
				id,
				action,
				"actionT",
				"transactionId",
				"createdT",
				"mediumGroupId",
				medium,
				"notificationId",
				"receiverUserId",
				content,
				"eventId"
			)
			VALUES(
				NEW.id,
				1,
				_now,
				txid_current(),
				NEW."createdT",
				NEW."mediumGroupId",
				NEW.medium,
				NEW."notificationId",
				NEW."receiverUserId",
				NEW.content,
				NEW."eventId"
			);
		ELSIF (TG_OP = 'UPDATE' AND (
			NEW.id IS DISTINCT FROM OLD.id OR
			NEW."createdT" IS DISTINCT FROM OLD."createdT" OR
			NEW."mediumGroupId" IS DISTINCT FROM OLD."mediumGroupId" OR
			NEW.medium IS DISTINCT FROM OLD.medium OR
			NEW."notificationId" IS DISTINCT FROM OLD."notificationId" OR
			NEW."receiverUserId" IS DISTINCT FROM OLD."receiverUserId" OR
			NEW.content::text IS DISTINCT FROM OLD.content::text OR
			NEW."eventId" IS DISTINCT FROM OLD."eventId"
		)) THEN
			INSERT INTO "___ORGANIZATION_ID___".zz_notification_instance
			(
				id,
				action,
				"actionT",
				"transactionId",
				"createdT",
				"mediumGroupId",
				medium,
				"notificationId",
				"receiverUserId",
				content,
				"eventId"
			)
			VALUES(
				NEW.id,
				2,
				_now,
				txid_current(),
				NEW."createdT",
				NEW."mediumGroupId",
				NEW.medium,
				NEW."notificationId",
				NEW."receiverUserId",
				NEW.content,
				NEW."eventId"
			);    
		ELSIF (TG_OP = 'DELETE') THEN
			INSERT INTO "___ORGANIZATION_ID___".zz_notification_instance
			(
				id,
				action,
				"actionT",
				"transactionId",
				"createdT",
				"mediumGroupId",
				medium,
				"notificationId",
				"receiverUserId",
				content,
				"eventId"
			)
			VALUES(
				OLD.id,
				3,
				_now,
				txid_current(),
				OLD."createdT",
				OLD."mediumGroupId",
				OLD.medium,
				OLD."notificationId",
				OLD."receiverUserId",
				OLD.content,
				OLD."eventId"
			);       
		END IF;    
		RETURN NULL;
		END;
		$$;

		ALTER FUNCTION "___ORGANIZATION_ID___".zz_notification_instance() OWNER TO ${dbsuperuser};

		GRANT ALL ON FUNCTION "___ORGANIZATION_ID___".zz_notification_instance() TO ${dbuser};

		DROP TRIGGER IF EXISTS trg_99_zz_notification_instance ON "___ORGANIZATION_ID___".zz_notification_instance;
		CREATE TRIGGER trg_99_zz_notification_instance
			AFTER INSERT OR UPDATE OR DELETE
			ON "___ORGANIZATION_ID___"."notification_instance"
			FOR EACH ROW
			EXECUTE FUNCTION "___ORGANIZATION_ID___".zz_notification_instance();

			


	------------------ fk from schema.notification_instance to public.notification_instance -------------------

	CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".delete_public_notification_instance() RETURNS trigger
	LANGUAGE plpgsql
	AS $$
	DECLARE
		_now timestamp without time zone;
	BEGIN   
		_now := now();
		IF (TG_OP = 'DELETE') THEN
				DELETE FROM public.notification_instance
				WHERE id = OLD.id;
		END IF;    
		RETURN NULL;
		END;
	$$;

	CREATE TRIGGER trg_delete_public_notification_instance
	AFTER DELETE
		ON "___ORGANIZATION_ID___"."notification_instance"
	FOR EACH ROW
	EXECUTE FUNCTION "___ORGANIZATION_ID___".delete_public_notification_instance();

	-------------- fk from schema.notification to public.scheduled_job ------------------
	CREATE OR REPLACE FUNCTION "___ORGANIZATION_ID___".delete_scheduled_job_associated_with_notification() RETURNS trigger
	LANGUAGE plpgsql
	AS $$
	DECLARE
		_now timestamp without time zone;
	BEGIN   
		_now := now();
		IF (TG_OP = 'DELETE') THEN
				DELETE FROM public.scheduled_job
				WHERE "organizationId" = '___ORGANIZATION_ID___' AND "notificationId" = OLD.id;
		END IF;    
		RETURN NULL;
		END;
	$$;

	CREATE TRIGGER trg_delete_scheduled_job_associated_with_notification
	AFTER DELETE
		ON "___ORGANIZATION_ID___"."notification"
	FOR EACH ROW
	EXECUTE FUNCTION "___ORGANIZATION_ID___".delete_scheduled_job_associated_with_notification();

	--------------------------------- report_scheduled_job fk ----------------------
	ALTER TABLE "___ORGANIZATION_ID___"."report_scheduled_job"
		ADD CONSTRAINT report_scheduled_job_report_template_id_fk_report_templates FOREIGN KEY ("reportTemplateId")
		REFERENCES "___ORGANIZATION_ID___"."report_templates" (id) MATCH SIMPLE
			ON UPDATE CASCADE
			ON DELETE CASCADE;
	

	`;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, query, "___ORGANIZATION_ID___");
    const organizationIds = (await client.query(` SELECT id FROM public."organizationList";`)).rows.map((r) => r.id);
    for (const organizationId of organizationIds) {
        await client.query(`
	--------------------------- if webrtc model not defined properly this fix it ----------------------------------

	UPDATE "${organizationId}".organizations
	SET "settings" = settings - 'webRtc' || 
		jsonb_build_object(
			'webRtc', jsonb_build_object(
				'iceServers', "settings"->'webRtc'->'iceServers',
				'twilio', jsonb_build_object('enabled', false)
			)
		)
	WHERE settings->'webRtc'->'twilio' IS NULL;

	---------------------- notification event finalizedT ------------------------------

	ALTER TABLE "${organizationId}".notification_event
		ADD COLUMN "finalizedT" timestamp without time zone;

	-------------------------- CLEAR DELETED NOTIFICATIONS --------------------------------------

	DELETE FROM "${organizationId}".notification
		WHERE type IN (19, 31, 32) AND id NOT IN (SELECT "notificationId" FROM public.scheduled_job WHERE type IN (19, 31, 32));

	-------------------- DELETE UNUSED notification events ---------------------------------------
	
	
	`);
    }
    await client.query(`
		
	
	-------------- public.notification to public.notification_event trigger update finalizedT ------------------
	
	CREATE OR REPLACE FUNCTION "public"."update_finalizedT_on_notification_event"() RETURNS trigger
	LANGUAGE plpgsql
	AS $$
	DECLARE
		_now timestamp without time zone;
		"_organizationId" uuid;
	BEGIN   
		"_organizationId" := NEW."organizationId";
		_now := now();
		IF (TG_OP = 'INSERT' OR TG_OP = 'UPDATE') THEN
			PERFORM  '
				UPDATE '||quote_ident("_organizationId"::text)||'.notification_event
					SET "finalizedT" = NEW."actionT"
				WHERE id = NEW.id;
			';
			
		END IF;    
		RETURN NULL;
		END;
	$$;
	DROP TRIGGER IF EXISTS "trg_update_finalizedT_on_notification_event" ON public.zz_notification_instance;;
	CREATE TRIGGER "trg_update_finalizedT_on_notification_event"
	AFTER INSERT OR UPDATE 
		ON "public".zz_notification_instance
	FOR EACH ROW
	EXECUTE FUNCTION "public"."update_finalizedT_on_notification_event"();`);
}
exports.up = up;
async function down(client, dbuser, dbsuperuser) {
    const q = `

	
	`;
    await (0, dal_utils_1.queryForAllOrganizationSchemasPg)(client, q, "___ORGANIZATION_ID___");
}
exports.down = down;
